/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.ChartPanner;
import com.jidesoft.chart.event.MouseHandler;
import com.jidesoft.chart.event.PanListener;
import com.jidesoft.range.Range;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MouseDragPanner
implements MouseHandler {
    public static final String PROPERTY_HORIZONTAL_PAN = "Pan Horizontal";
    public static final String PROPERTY_VERTICAL_PAN = "Pan Vertical";
    public static final String PROPERTY_X_LIMITS = "X Limits";
    public static final String PROPERTY_Y_LIMITS = "Y Limits";
    private Chart chart;
    private Point dragStart;
    private boolean handled = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean changeCursorWhileDragging = true;
    private Cursor dragCursor = Cursor.getPredefinedCursor(13);
    private ChartPanner panner;
    private int buttonMask = 16;

    public MouseDragPanner(Chart chart) {
        this(chart, true, true);
    }

    public MouseDragPanner(Chart chart, boolean bl, boolean bl2) {
        this.chart = chart;
        this.panner = new ChartPanner(chart, bl, bl2);
        this.panner.resetSpeeds();
        this.setHorizontalPan(bl);
        this.setVerticalPan(bl2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isHorizontalPan() {
        return this.panner.isHorizontalPan();
    }

    public void setHorizontalPan(boolean bl) {
        boolean bl2 = this.panner.isHorizontalPan();
        this.panner.setHorizontalPan(bl);
        this.support.firePropertyChange(PROPERTY_HORIZONTAL_PAN, bl2, bl);
    }

    public boolean isVerticalPan() {
        return this.panner.isVerticalPan();
    }

    public void setVerticalPan(boolean bl) {
        boolean bl2 = this.panner.isVerticalPan();
        this.panner.setVerticalPan(bl);
        this.support.firePropertyChange(PROPERTY_VERTICAL_PAN, bl2, bl);
    }

    public Cursor getDragCursor() {
        return this.dragCursor;
    }

    public void setDragCursor(Cursor cursor) {
        this.dragCursor = cursor;
    }

    public boolean isChangeCursorWhileDragging() {
        return this.changeCursorWhileDragging;
    }

    public void setChangeCursorWhileDragging(boolean bl) {
        this.changeCursorWhileDragging = bl;
    }

    public boolean isContinuous() {
        return this.panner.isContinuous();
    }

    public void setContinuous(boolean bl) {
        this.panner.setContinuous(bl);
    }

    public double getFrictionCoefficient() {
        return this.panner.getFrictionCoefficient();
    }

    public int getButtonMask() {
        return this.buttonMask;
    }

    public void setButtonMask(int n) {
        this.buttonMask = n;
    }

    public void setFrictionCoefficient(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Friction coefficient must be between 0 and 1");
        }
        this.panner.setFrictionCoefficient(d);
    }

    public Range<?> getXLimits() {
        return this.panner.getXLimits();
    }

    public void setXLimits(Range<?> range) {
        Range<?> range2 = this.panner.getXLimits();
        this.panner.setXLimits(range);
        this.support.firePropertyChange(PROPERTY_X_LIMITS, range2, range);
    }

    public Range<?> getYLimits() {
        return this.panner.getYLimits();
    }

    public void setYLimits(Range<?> range) {
        Range<?> range2 = this.panner.getYLimits();
        this.panner.setYLimits(range);
        this.support.firePropertyChange(PROPERTY_Y_LIMITS, range2, range);
    }

    public void addPanListener(PanListener panListener) {
        this.panner.addPanListener(panListener);
    }

    public void removePanListener(PanListener panListener) {
        this.panner.removePanListener(panListener);
    }

    Point getDragStart() {
        return this.dragStart;
    }

    private boolean buttonPressed(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & this.buttonMask) != 0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.buttonPressed(mouseEvent) || !this.chart.isEnabled()) {
            return;
        }
        this.dragStart = mouseEvent.getPoint();
        this.setHandled(true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.buttonPressed(mouseEvent) || !this.chart.isEnabled()) {
            return;
        }
        this.panner.resetSpeeds();
        if (this.changeCursorWhileDragging) {
            this.chart.setCursor(Cursor.getDefaultCursor());
        }
        this.dragStart = null;
        this.setHandled(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setHandled(!this.chart.isEnabled());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setHandled(!this.chart.isEnabled());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setHandled(!this.chart.isEnabled());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.buttonPressed(mouseEvent) || !this.chart.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (this.changeCursorWhileDragging) {
            this.chart.setCursor(this.dragCursor);
        }
        if (this.dragStart != null) {
            this.panner.drag(this.dragStart, point);
        }
        this.dragStart = point;
        this.setHandled(true);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public boolean isHandled() {
        return this.handled;
    }

    @Override
    public void setHandled(boolean bl) {
        this.handled = bl;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.setHandled(false);
    }
}

