/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.event.ChartCrossHair;
import com.jidesoft.chart.fit.FunctionMap;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartValueReporter
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1727491356080087902L;
    private Chart chart;
    private JLabel label = new JLabel(" ");
    private Point latestCursorPosition = null;
    private String formatString = "x = %.3f, y = %.3f";
    private String noSelectionText = "[No point selected]";
    private Double chartX;
    private Double chartY;
    private transient ChartModel model = null;

    public ChartValueReporter(Chart chart) {
        this.chart = chart;
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
    }

    public ChartValueReporter(final ChartCrossHair chartCrossHair) {
        assert (chartCrossHair != null);
        this.chart = chartCrossHair.getChart();
        assert (this.chart != null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        chartCrossHair.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Position".equals(propertyChangeEvent.getPropertyName())) {
                    Chartable chartable = chartCrossHair.getPosition();
                    if (chartable == null) {
                        ChartValueReporter.this.clearChartValue();
                    } else {
                        ChartValueReporter.this.updateChartValue(chartable.getX().position(), chartable.getY().position());
                    }
                }
            }
        });
    }

    protected void clearChartValue() {
        this.label.setText(this.noSelectionText);
        this.chartX = null;
        this.chartY = null;
        this.latestCursorPosition = null;
    }

    protected void updateChartValue(double d, double d2) {
        this.chartX = d;
        this.chartY = d2;
        Axis axis = this.chart.getXAxis();
        Axis axis2 = this.chart.getYAxis();
        if (axis.getQuantity() == AxisQuantity.TIME) {
            if (axis2.getQuantity() == AxisQuantity.TIME) {
                this.setText(String.format(this.formatString, (long)d, (long)d2));
            } else {
                this.setText(String.format(this.formatString, (long)d, d2));
            }
        } else if (axis2.getQuantity() == AxisQuantity.TIME) {
            this.setText(String.format(this.formatString, d, (long)d2));
        } else {
            this.setText(String.format(this.formatString, d, d2));
        }
    }

    protected void setText(String string) {
        this.label.setText(string);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String string) {
        this.formatString = string;
    }

    public String getNoSelectionText() {
        return this.noSelectionText;
    }

    public void setNoSelectionText(String string) {
        this.noSelectionText = string;
    }

    public Double getChartX() {
        return this.chartX;
    }

    public Double getChartY() {
        return this.chartY;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.clearChartValue();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.latestCursorPosition = mouseEvent.getPoint();
        this.update();
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel chartModel) {
        this.model = chartModel;
    }

    public void update() {
        ChartModel chartModel;
        ChartModel chartModel2 = chartModel = this.model == null ? this.chart.nearestModel(this.latestCursorPosition) : this.model;
        if (this.latestCursorPosition != null && chartModel != null && chartModel.getPointCount() >= 2) {
            try {
                Point2D point2D = this.chart.calculateUserPoint(this.latestCursorPosition);
                if (point2D != null) {
                    double d = FunctionMap.getYApproximately(chartModel, point2D.getX());
                    double d2 = point2D.getX();
                    this.updateChartValue(d2, d);
                }
            }
            catch (ChartException chartException) {
                this.clearChartValue();
            }
        }
    }
}

