/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.PanEvent;
import com.jidesoft.chart.event.PanListener;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class ChartPanner {
    private Chart chart;
    private boolean horizontalPan;
    private boolean verticalPan;
    private boolean continuous = false;
    private double frictionCoefficient = 0.1;
    private Range<?> xLimits;
    private Range<?> yLimits;
    private Point2D[] recentSpeeds = new Point2D[3];
    private Point2D[] recentRealSpeeds = new Point2D[3];
    private Point2D speed;
    private Point2D realSpeed;
    private Timer timer;
    private int timerDelay = 20;
    private List<PanListener> listeners = new CopyOnWriteArrayList<PanListener>();

    public ChartPanner(Chart chart) {
        this(chart, true, true);
    }

    public ChartPanner(Chart chart, boolean bl, boolean bl2) {
        this.chart = chart;
        this.setHorizontalPan(bl);
        this.setVerticalPan(bl2);
    }

    public boolean isHorizontalPan() {
        return this.horizontalPan;
    }

    public void setHorizontalPan(boolean bl) {
        this.horizontalPan = bl;
    }

    public boolean isVerticalPan() {
        return this.verticalPan;
    }

    public void setVerticalPan(boolean bl) {
        this.verticalPan = bl;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public void resetSpeeds() {
        this.resetSpeeds(this.recentSpeeds);
        this.resetSpeeds(this.recentRealSpeeds);
    }

    private void resetSpeeds(Point2D[] point2DArray) {
        for (int i = 0; i < point2DArray.length; ++i) {
            point2DArray[i] = new Point2D.Double(0.0, 0.0);
        }
    }

    private Point2D average(Point2D[] point2DArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (Point2D point2D : point2DArray) {
            d += point2D.getX();
            d2 += point2D.getY();
        }
        return new Point2D.Double(d / (double)point2DArray.length, d2 / (double)point2DArray.length);
    }

    public double getFrictionCoefficient() {
        return this.frictionCoefficient;
    }

    public void setFrictionCoefficient(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Friction coefficient must be between 0 and 1");
        }
        this.frictionCoefficient = d;
    }

    public void addPanListener(PanListener panListener) {
        this.listeners.add(panListener);
    }

    public void removePanListener(PanListener panListener) {
        this.listeners.remove(panListener);
    }

    protected void firePan() {
        this.firePan(new PanEvent(this));
    }

    protected void firePan(int n, int n2) {
        this.firePan(new PanEvent(this, n, n2));
    }

    protected void firePan(PanEvent panEvent) {
        for (PanListener panListener : this.listeners) {
            panListener.panChanged(panEvent);
        }
        this.chart.repaint();
    }

    public Range<?> getXLimits() {
        return this.xLimits;
    }

    public void setXLimits(Range<?> range) {
        this.xLimits = range;
    }

    public Range<?> getYLimits() {
        return this.yLimits;
    }

    public void setYLimits(Range<?> range) {
        this.yLimits = range;
    }

    public void drag(Point point, Point point2) {
        Point2D point2D = this.chart.calculateUserPoint(point);
        Point2D point2D2 = this.chart.calculateUserPoint(point2);
        if (point2D != null && point2D2 != null) {
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            double d = point2D2.getX() - point2D.getX();
            double d2 = point2D2.getY() - point2D.getY();
            this.recentSpeeds[0] = this.recentSpeeds[1];
            this.recentSpeeds[1] = this.recentSpeeds[2];
            this.recentSpeeds[2] = new Point2D.Double(n, n2);
            this.recentRealSpeeds[0] = this.recentRealSpeeds[1];
            this.recentRealSpeeds[1] = this.recentRealSpeeds[2];
            this.recentRealSpeeds[2] = new Point2D.Double(d, d2);
            this.speed = this.average(this.recentSpeeds);
            this.realSpeed = this.average(this.recentRealSpeeds);
            this.pan(n, n2, this.continuous ? this.realSpeed.getX() : d, this.continuous ? this.realSpeed.getY() : d2);
            if (this.continuous) {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        double d = 1.0 - ChartPanner.this.frictionCoefficient;
                        ChartPanner.this.speed = new Point2D.Double(ChartPanner.this.speed.getX() * d, ChartPanner.this.speed.getY() * d);
                        ChartPanner.this.realSpeed = new Point2D.Double(ChartPanner.this.realSpeed.getX() * d, ChartPanner.this.realSpeed.getY() * d);
                        ChartPanner.this.pan(ChartPanner.this.speed.getX(), ChartPanner.this.speed.getY(), ChartPanner.this.realSpeed.getX(), ChartPanner.this.realSpeed.getY());
                        if (Math.abs(ChartPanner.this.speed.getX()) < 1.0 && Math.abs(ChartPanner.this.speed.getY()) < 1.0) {
                            ChartPanner.this.timer.stop();
                            ChartPanner.this.timer = null;
                        }
                    }
                };
                this.timer = new Timer(this.timerDelay, actionListener);
                this.timer.start();
            }
        }
    }

    private void pan(double d, double d2, double d3, double d4) {
        Point2D point2D;
        Point2D.Double double_;
        Point2D.Double double_2;
        double d5;
        double d6;
        InvertibleTransform<Double> invertibleTransform;
        Axis axis = this.chart.getXAxis();
        Axis axis2 = this.chart.getYAxis();
        TimeRange timeRange = axis.getRange();
        TimeRange timeRange2 = axis2.getRange();
        double d7 = timeRange.minimum();
        double d8 = timeRange2.minimum();
        Point2D point2D2 = this.chart.calculatePixelPoint2D(new Point2D.Double(d7, d8));
        double d9 = timeRange.maximum();
        double d10 = timeRange2.maximum();
        Point2D point2D3 = this.chart.calculatePixelPoint2D(new Point2D.Double(d9, d10));
        if (this.horizontalPan) {
            AbstractRange abstractRange;
            if (timeRange instanceof TimeRange) {
                abstractRange = new TimeRange((long)(timeRange.minimum() - d3), (long)(timeRange.maximum() - d3));
            } else if (timeRange instanceof CategoryRange) {
                abstractRange = timeRange;
                invertibleTransform = (CategoryRange)((Object)timeRange);
                if (((CategoryRange)((Object)invertibleTransform)).getCategoryValues().size() == 0) {
                    return;
                }
                d6 = timeRange.minimum() - d3;
                d5 = timeRange.maximum() - d3;
                double_2 = new Point2D.Double(((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).lower()) - 1, axis2.minimum());
                double_ = new Point2D.Double(((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).upper()) + 1, axis2.maximum());
                point2D2 = this.chart.calculatePixelPoint(double_2);
                point2D3 = this.chart.calculatePixelPoint(double_);
                if (d3 < 0.0 && point2D3.getX() > (double)this.chart.getXEnd()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d6);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d5);
                } else if (d3 > 0.0 && point2D2.getX() < (double)this.chart.getXStart()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d6);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d5);
                }
            } else {
                invertibleTransform = axis.getAxisTransform();
                if (invertibleTransform == null || invertibleTransform instanceof IdentityTransform) {
                    abstractRange = new NumericRange(timeRange.minimum() - d3, timeRange.maximum() - d3);
                } else {
                    Point2D point2D4 = this.chart.calculateUserPoint(new Point((int)(point2D2.getX() - d), (int)(point2D2.getY() - d2)));
                    point2D = this.chart.calculateUserPoint(new Point((int)(point2D3.getX() - d), (int)(point2D3.getY() - d2)));
                    abstractRange = new NumericRange(point2D4.getX(), point2D.getX());
                }
            }
            if (this.xLimits != null) {
                if (abstractRange.minimum() >= this.xLimits.minimum() && abstractRange.maximum() <= this.xLimits.maximum()) {
                    axis.setRange(abstractRange);
                } else {
                    d = 0.0;
                }
            } else {
                axis.setRange(abstractRange);
            }
        }
        if (this.verticalPan) {
            AbstractRange abstractRange;
            if (timeRange2 instanceof TimeRange) {
                abstractRange = new TimeRange((long)(timeRange2.minimum() - d4), (long)(timeRange2.maximum() - d4));
            } else if (timeRange2 instanceof CategoryRange) {
                abstractRange = timeRange2;
                invertibleTransform = (CategoryRange)((Object)timeRange2);
                if (((CategoryRange)((Object)invertibleTransform)).getCategoryValues().size() == 0) {
                    return;
                }
                d6 = ((CategoryRange)((Object)invertibleTransform)).minimum() - d4;
                d5 = ((CategoryRange)((Object)invertibleTransform)).maximum() - d4;
                double_2 = new Point2D.Double(axis.minimum(), ((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).lower()) - 1);
                double_ = new Point2D.Double(axis.maximum(), ((CategoryRange)((Object)invertibleTransform)).position((Double)((CategoryRange)((Object)invertibleTransform)).upper()) + 1);
                point2D3 = this.chart.calculatePixelPoint(double_);
                point2D2 = this.chart.calculatePixelPoint(double_2);
                if (d4 > 0.0 && point2D2.getY() > (double)this.chart.getYStart()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d6);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d5);
                } else if (d4 < 0.0 && point2D3.getY() < (double)this.chart.getYEnd()) {
                    ((CategoryRange)((Object)invertibleTransform)).setMinimum(d6);
                    ((CategoryRange)((Object)invertibleTransform)).setMaximum(d5);
                }
            } else {
                invertibleTransform = axis2.getAxisTransform();
                if (invertibleTransform == null || invertibleTransform instanceof IdentityTransform) {
                    abstractRange = new NumericRange(timeRange2.minimum() - d4, timeRange2.maximum() - d4);
                } else {
                    Point2D point2D5 = this.chart.calculateUserPoint(new Point((int)(point2D2.getX() - d), (int)(point2D2.getY() - d2)));
                    point2D = this.chart.calculateUserPoint(new Point((int)(point2D3.getX() - d), (int)(point2D3.getY() - d2)));
                    abstractRange = new NumericRange(point2D5.getY(), point2D.getY());
                }
            }
            if (this.yLimits != null) {
                if (abstractRange.minimum() >= this.yLimits.minimum() && abstractRange.maximum() <= this.yLimits.maximum()) {
                    axis2.setRange(abstractRange);
                } else {
                    d2 = 0.0;
                }
            } else {
                axis2.setRange(abstractRange);
            }
        }
        this.firePan((int)d, (int)d2);
    }
}

