/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class LogarithmicTickCalculator
implements TickCalculator<Double> {
    public static final String PROPERTY_LABEL_FORMAT = "LabelFormatProperty";
    public static final String PROPERTY_NUMBER_FORMAT = "NumberFormat";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private LogarithmicTickLabelFormat labelFormat = LogarithmicTickLabelFormat.DECIMAL_FORM;
    private NumberFormat numberFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.getDefault()));

    public LogarithmicTickCalculator() {
        this.numberFormat.setMaximumFractionDigits(340);
    }

    public LogarithmicTickLabelFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(LogarithmicTickLabelFormat logarithmicTickLabelFormat) {
        LogarithmicTickLabelFormat logarithmicTickLabelFormat2 = this.labelFormat;
        this.labelFormat = logarithmicTickLabelFormat;
        this.support.firePropertyChange(PROPERTY_LABEL_FORMAT, (Object)logarithmicTickLabelFormat2, (Object)logarithmicTickLabelFormat);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = this.numberFormat;
        this.numberFormat = numberFormat;
        this.support.firePropertyChange(PROPERTY_NUMBER_FORMAT, numberFormat2, numberFormat);
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        BigDecimal bigDecimal;
        int n;
        double d = range.minimum();
        double d2 = range.maximum();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return new Tick[0];
        }
        int n2 = (int)Math.floor(Math.log10(d));
        if (n2 == (n = (int)Math.ceil(Math.log10(d2))) && n2 > 0 && Math.pow(10.0, n2) > d) {
            --n2;
        }
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        BigDecimal bigDecimal2 = BigDecimal.ONE.scaleByPowerOfTen(n2);
        do {
            int n3 = this.approxLog(bigDecimal2);
            bigDecimal = this.createIncrement(n3);
            Tick tick = new Tick(bigDecimal2.doubleValue());
            boolean bl = this.isPowerOf10(bigDecimal2);
            tick.setMajor(bl);
            if (bl) {
                tick.setLabel(this.createLabel(bigDecimal2));
            }
            arrayList.add(tick);
        } while ((bigDecimal2 = bigDecimal2.add(bigDecimal)).doubleValue() <= d2);
        return arrayList.toArray(new Tick[0]);
    }

    int approxLog(BigDecimal bigDecimal) {
        return (int)Math.floor(Math.log10(bigDecimal.doubleValue()));
    }

    BigDecimal createIncrement(int n) {
        if (n == 0) {
            return BigDecimal.ONE;
        }
        if (n > 0) {
            return BigDecimal.ONE.movePointRight(n);
        }
        return BigDecimal.ONE.movePointLeft(-n);
    }

    protected String createLabel(BigDecimal bigDecimal) {
        if (this.labelFormat == LogarithmicTickLabelFormat.EXPONENTIAL_FORM) {
            int n = this.approxLog(bigDecimal);
            return "10" + this.createSuperscript(n);
        }
        return this.numberFormat.format(bigDecimal);
    }

    String createSuperscript(int n) {
        if (n < 0) {
            return "\u207b" + this.createSuperscript(-n);
        }
        if (n == 0) {
            return "\u2070";
        }
        if (n == 1) {
            return "\u00b9";
        }
        if (n == 2) {
            return "\u00b2";
        }
        if (n == 3) {
            return "\u00b3";
        }
        if (n <= 9) {
            int n2 = 8304 + n;
            return Character.toString((char)n2);
        }
        int n3 = n % 10;
        return this.createSuperscript(n / 10) + this.createSuperscript(n3);
    }

    private boolean isPowerOf10(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return false;
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) < 0) {
            return this.isPowerOf10(bigDecimal.multiply(BigDecimal.TEN));
        }
        return this.isPowerOf10(bigDecimal.longValue());
    }

    private boolean isPowerOf10(long l) {
        while (l > 1L) {
            if (l % 10L != 0L) {
                return false;
            }
            l /= 10L;
        }
        return l == 1L;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public static enum LogarithmicTickLabelFormat {
        DECIMAL_FORM,
        EXPONENTIAL_FORM;

    }
}

