/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.AbstractTimeTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class DefaultTimeTickCalculator
extends AbstractTimeTickCalculator {
    private static double minIntervals = 4.0;
    private static double maxIntervals = 10.0;
    private static final Logger logger = Logger.getLogger(DefaultTimeTickCalculator.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tick[] calculateTicks(Range<Date> range) {
        double d;
        TimeZone timeZone = this.getDateFormat() != null ? this.getDateFormat().getTimeZone() : this.getTimeZone();
        DateFormat dateFormat = DateFormat.getTimeInstance();
        double d2 = range.maximum();
        double d3 = range.minimum();
        double d4 = range.minimum();
        double d5 = range.maximum();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeZone(timeZone);
        calendar.setTimeInMillis((long)range.minimum());
        calendar2.setTimeInMillis((long)range.maximum());
        Calendar calendar3 = DefaultTimeTickCalculator.min(calendar, calendar2);
        d4 = calendar3.getTimeInMillis();
        double d6 = DefaultTimeTickCalculator.secondsDiff(calendar, calendar2);
        List<Double> list = null;
        if (d6 < 1.0) {
            double d7;
            if (d3 > d2) {
                d3 = d2;
            }
            if ((d6 = d2 - d3) < 1.0E-8) {
                d6 = 1.0E-8;
            }
            double d8 = Math.log10(d6);
            double d9 = Math.ceil(d8 - 1.0);
            d = Math.pow(10.0, d9);
            assert (maxIntervals / minIntervals >= 2.0);
            do {
                if ((d7 = d6 / d) > maxIntervals) {
                    d *= 2.0;
                    continue;
                }
                if (!(d7 < minIntervals)) continue;
                d /= 2.0;
            } while (d7 < minIntervals || d7 > maxIntervals);
        } else if (d6 > 1.0 && d6 <= 180.0) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
            if (d6 < 10.0) {
                d = 1000.0;
            } else if (d6 < 20.0) {
                d = 5000.0;
            } else if (d6 < 40.0) {
                d = 5000.0;
            } else if (d6 <= 120.0) {
                d = 15000.0;
            } else {
                if (!(d6 <= 180.0)) throw new RuntimeException("Unexpected argument");
                d = 30000.0;
            }
        } else if (d6 > 180.0 && d6 <= 3600.0) {
            dateFormat = new SimpleDateFormat("HH:mm");
            if ((d6 /= 60.0) < 10.0) {
                d = 60000.0;
            } else if (d6 < 20.0) {
                d = 300000.0;
            } else if (d6 < 40.0) {
                d = 300000.0;
            } else {
                if (!(d6 <= 60.0)) throw new RuntimeException("Unexpected argument; range = " + d6);
                d = 900000.0;
            }
        } else if (d6 > 3600.0 && d6 <= 14400.0) {
            d = (d6 /= 3600.0) < 2.0 ? 900000.0 : 1800000.0;
        } else if (d6 > 14400.0 && d6 <= 86400.0) {
            dateFormat = new SimpleDateFormat("HH:mm");
            if ((d6 /= 3600.0) < 10.0) {
                d = 3600000.0;
            } else if (d6 <= 24.0) {
                d = 7200000.0;
            } else {
                if (!(d6 > 24.0)) throw new RuntimeException("Unexpected argument; range = " + d6);
                d = 4.32E7;
            }
        } else if (d6 > 86400.0 && d6 <= 259200.0) {
            dateFormat = new SimpleDateFormat("dd-MMM HH:mm");
            d = 4.32E7;
        } else {
            dateFormat = new SimpleDateFormat("dd-MMM");
            if ((d6 /= 86400.0) < 10.0) {
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 1, 6);
                d = 8.64E7;
            } else if (d6 <= 20.0) {
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 2, 6);
                d = 1.728E8;
            } else if (d6 <= 100.0) {
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 7, 6);
                d = 6.048E8;
            } else if (d6 <= 365.25) {
                dateFormat = new SimpleDateFormat("MMM-yy");
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 1, 2);
                d = 2.628288E9;
            } else if (d6 <= 1095.75) {
                dateFormat = new SimpleDateFormat("MMM-yy");
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 3, 2);
                d = 7.884E9;
            } else if (d6 <= 7305.0) {
                dateFormat = new SimpleDateFormat("yy");
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 1, 1);
                d = 3.15576E10;
            } else if (d6 <= 36525.0) {
                dateFormat = new SimpleDateFormat("yyyy");
                list = this.generateTickPositionsUsingLogicalIncrement(d4, d5, d3, 10, 1);
                d = 3.15576E11;
            } else {
                Tick[] tickArray = new Tick[]{new Tick((d4 + d5) / 2.0, "Out of Range")};
                return tickArray;
            }
        }
        if (list == null) {
            list = this.generateTickPositionsUsingFixedIncrement(d4, d5, d3, d);
        }
        if (this.getDateFormat() != null) {
            dateFormat = this.getDateFormat();
            return this.generateTicks(list, dateFormat);
        } else {
            dateFormat.setTimeZone(timeZone);
        }
        return this.generateTicks(list, dateFormat);
    }

    private List<Double> generateTickPositionsUsingLogicalIncrement(double d, double d2, double d3, int n, int n2) {
        assert (n != 0) : "If amount were zero, it would lead to an infinite loop";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis((long)d);
        double d4 = d;
        do {
            if (d4 >= d3) {
                arrayList.add(d4);
            }
            calendar.add(n2, n);
        } while ((d4 = (double)calendar.getTimeInMillis()) <= d2);
        return arrayList;
    }

    private List<Double> generateTickPositionsUsingFixedIncrement(double d, double d2, double d3, double d4) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d5 = null;
        for (double d6 = d; d6 <= d2 && d != d2 && d4 > 0.0; d6 += d4) {
            if (d6 >= d3) {
                arrayList.add(d6);
            }
            if (d5 != null && d6 <= d5) break;
            d5 = d6;
        }
        return arrayList;
    }

    private Tick[] generateTicks(List<Double> list, DateFormat dateFormat) {
        Tick[] tickArray = new Tick[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Double d = list.get(i);
            Date date = new Date(d.longValue());
            tickArray[i] = new Tick((double)d, dateFormat.format(date));
        }
        return tickArray;
    }

    public static Calendar min(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        Calendar calendar4 = calendar.before(calendar2) ? calendar : calendar2;
        calendar3.setTimeZone(calendar4.getTimeZone());
        calendar3.setTimeInMillis(calendar4.getTimeInMillis());
        if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 10.0) {
            int n = calendar.get(1);
            int n2 = (int)(10.0 * Math.floor((double)n / 10.0));
            calendar3.set(1, n2);
            calendar3.set(5, 3);
            calendar3.set(2, 0);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(5, 1);
            calendar3.set(2, 0);
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 10.0) {
            int n = calendar.get(5);
            calendar3.set(5, 15);
            if (n < 15) {
                calendar3.add(2, -1);
            }
            int n3 = calendar.get(2);
            calendar3.set(2, 5);
            if (n3 < 5) {
                calendar3.add(1, -1);
            }
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            int n = calendar3.get(7);
            if (n != 1) {
                int n4 = n - 1;
                calendar3.add(5, -n4);
            }
        } else {
            if (DefaultTimeTickCalculator.daysDiff(calendar, calendar2) > 1.0) {
                calendar3.set(11, 0);
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                return calendar3;
            }
            if (DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) > 1.0) {
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                if (calendar3.get(11) % 2 != 0) {
                    calendar3.add(11, -1);
                }
            } else if (DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) > 1.0) {
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
            } else if (DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) > 1.0) {
                calendar3.set(14, 0);
                calendar3.set(13, 0);
            }
        }
        return calendar3;
    }

    static Calendar max(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        Calendar calendar4 = calendar2.after(calendar) ? calendar2 : calendar;
        calendar3.setTimeZone(calendar4.getTimeZone());
        calendar3.setTimeInMillis(calendar4.getTimeInMillis());
        if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 10.0) {
            int n = calendar.get(1);
            int n2 = (int)(10.0 * Math.ceil((double)n / 10.0));
            calendar3.set(1, n2);
            calendar3.set(2, 5);
            calendar3.set(5, 1);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (DefaultTimeTickCalculator.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(2, 5);
            calendar3.set(5, 1);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(1, 1);
        } else if (DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (DefaultTimeTickCalculator.daysDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) > 1.0) {
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(11, 1);
        } else if (DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) > 1.0) {
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(11, 1);
        } else if (DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(14, 0);
            calendar3.add(13, 1);
        }
        return calendar3;
    }

    public static double yearsDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.weeksDiff(calendar, calendar2) / 52.0;
    }

    public static double weeksDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.daysDiff(calendar, calendar2) / 7.0;
    }

    public static double daysDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.hoursDiff(calendar, calendar2) / 24.0;
    }

    public static double hoursDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.minutesDiff(calendar, calendar2) / 60.0;
    }

    public static double minutesDiff(Calendar calendar, Calendar calendar2) {
        return DefaultTimeTickCalculator.secondsDiff(calendar, calendar2) / 60.0;
    }

    public static double secondsDiff(Calendar calendar, Calendar calendar2) {
        return (double)DefaultTimeTickCalculator.millisDiff(calendar, calendar2) / 1000.0;
    }

    public static long millisDiff(Calendar calendar, Calendar calendar2) {
        long l = calendar.getTimeInMillis();
        long l2 = calendar2.getTimeInMillis();
        return Math.abs(l - l2);
    }
}

