/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.util.Rotation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisComponent
extends JPanel {
    private static final long serialVersionUID = -3138493763021996631L;
    public static final String PROPERTY_AXIS = "Axis";
    public static final String PROPERTY_CHART = "Chart";
    private Axis axis;
    private Chart chart;
    private Orientation orientation = Orientation.vertical;
    private JViewport viewport;
    private Point viewPosition;
    private final ViewportChangeListener changeListener = new ViewportChangeListener();
    private final AxisPropertyChangeListener axisListener = new AxisPropertyChangeListener();
    private Rectangle tickLabelBounds = null;
    private final int DEFAULT_BREADTH = 40;
    private final int DEFAULT_LENGTH = 400;

    public AxisComponent() {
        Dimension dimension = new Dimension(40, 400);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public AxisComponent(Chart chart, Axis axis) {
        this();
        this.setChart(chart);
        this.setAxis(axis);
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        Axis axis2 = this.axis;
        if (axis2 != null) {
            axis2.removePropertyChangeListener(this.axisListener);
        }
        this.axis = axis;
        axis.addPropertyChangeListener(this.axisListener);
        this.firePropertyChange(PROPERTY_AXIS, axis2, axis);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this.changeListener);
        }
        this.chart = chart;
        this.viewport = this.findViewportParent(chart);
        if (this.viewport != null) {
            this.viewport.addChangeListener(this.changeListener);
        }
        this.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    private JViewport findViewportParent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JViewport) {
            return (JViewport)component;
        }
        return this.findViewportParent(component.getParent());
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        if (orientation == Orientation.horizontal) {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width < dimension.height) {
                Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                this.setSize(dimension2);
                this.setPreferredSize(dimension2);
            }
        }
    }

    private Font getTickFont() {
        Font font = this.axis.getTickFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.axis != null) {
            Tick[] tickArray = this.axis.getTicks();
            if (this.getOrientation() == Orientation.vertical) {
                this.paintYAxisTicks(graphics2D, this.axis, tickArray);
            } else {
                this.paintXAxisTicks(graphics2D, this.axis, tickArray);
            }
        }
        graphics2D.dispose();
    }

    private void paintYAxisTicks(Graphics2D graphics2D, Axis axis, Tick[] tickArray) {
        Point2D point2D;
        graphics2D.setClip(null);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Dimension dimension = this.getSize();
        AxisPlacement axisPlacement = axis.getPlacement();
        int n = axisPlacement == AxisPlacement.TRAILING ? 0 : dimension.width - 1;
        int n2 = this.chart.getYEnd();
        axis.render(graphics2D, n, n2, this.chart.getYStart() - this.chart.getYEnd(), Orientation.vertical);
        for (Tick tick : tickArray) {
            String string;
            UserToPixelTransform userToPixelTransform;
            int n3 = tick.isMajor() ? this.chart.getTickLength() : this.chart.getMinorTickLength();
            point2D = new Point2D.Double(0.0, tick.getPosition());
            Point point = this.chart.calculatePixelPoint(point2D, userToPixelTransform = this.chart.getTransformForAxis(axis));
            if (point == null) continue;
            int n4 = point.y;
            if (axis.isTicksVisible() && n4 >= n2) {
                graphics2D.setColor(this.chart.getTickColor());
                int n5 = axisPlacement == AxisPlacement.LEADING ? -1 : 1;
                graphics2D.drawLine(n, n4, n + n3 * n5, n4);
            }
            if ((string = tick.getLabel()) == null) continue;
            graphics2D.setFont(this.getTickFont());
            int n6 = fontMetrics.stringWidth(string);
            graphics2D.setColor(this.chart.getLabelColor());
            if (axisPlacement == AxisPlacement.TRAILING) {
                this.drawStringIfWithinBounds(graphics2D, string, n + n3 + fontMetrics.getDescent(), n4 + fontMetrics.getDescent());
                continue;
            }
            if (axisPlacement == AxisPlacement.LEADING) {
                this.drawStringIfWithinBounds(graphics2D, string, n - n6 - n3 - 1, n4 + fontMetrics.getDescent());
                continue;
            }
            this.drawStringIfWithinBounds(graphics2D, string, n + n3 + fontMetrics.getDescent(), n4 + fontMetrics.getDescent());
        }
        AutoPositionedLabel autoPositionedLabel = axis.getLabel();
        if (autoPositionedLabel != null) {
            int n7 = fontMetrics.getHeight();
            Double d = autoPositionedLabel.getRotation();
            int n8 = (int)Math.ceil((double)n7 / 2.0);
            Point2D.Double double_ = new Point2D.Double(0.0, axis.midPoint());
            point2D = this.chart.calculatePixelPoint((Point2D)double_, axis);
            if (point2D != null) {
                if (axisPlacement == AxisPlacement.LEADING) {
                    double d2 = d == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d.doubleValue();
                    autoPositionedLabel.paint((Graphics)graphics2D, n8 + fontMetrics.getDescent(), ((Point)point2D).y, d2);
                } else {
                    double d3 = d == null ? Rotation.QUARTER_CLOCKWISE.doubleValue() : d.doubleValue();
                    autoPositionedLabel.paint((Graphics)graphics2D, dimension.width - n8 - fontMetrics.getDescent(), ((Point)point2D).y, d3);
                }
            }
        }
    }

    private void paintXAxisTicks(Graphics2D graphics2D, Axis axis, Tick[] tickArray) {
        Shape shape = graphics2D.getClip();
        assert (axis != null);
        Font font = axis.getTickFont();
        FontMetrics fontMetrics = font == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font);
        int n = axis.getTickLength();
        graphics2D.setClip(0, 0, this.getWidth(), this.getHeight());
        int n2 = this.viewPosition == null ? 0 : this.viewPosition.x;
        int n3 = this.getHeight() - 1;
        AxisPlacement axisPlacement = axis.getPlacement();
        axis.render(graphics2D, this.chart.getXStart(), axisPlacement == AxisPlacement.TRAILING ? n3 : 0, this.chart.getXEnd() - this.chart.getXStart(), Orientation.horizontal);
        for (Tick tick : tickArray) {
            int n4;
            Point2D.Double double_ = new Point2D.Double(tick.getPosition(), 0.0);
            UserToPixelTransform userToPixelTransform = this.chart.getUserToPixelTransform();
            Point point = this.chart.calculatePixelPoint((Point2D)double_, userToPixelTransform);
            int n5 = n4 = tick.isMajor() ? axis.getTickLength() : axis.getMinorTickLength();
            if (point == null) continue;
            Point point2 = SwingUtilities.convertPoint(this.chart, point, this);
            int n6 = point2.x - n2;
            String string = tick.getLabel();
            graphics2D.setColor(this.chart.getTickColor());
            AxisRenderer axisRenderer = axis.getAxisRenderer();
            int n7 = axisRenderer == null ? 0 : axisRenderer.getBreadth();
            int n8 = this.chart.getXStart();
            Color color = this.chart.getLabelColor();
            int n9 = axis.getTickLabelOffset();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                graphics2D.drawLine(n6, 0, n6, n4);
                graphics2D.setColor(color);
                this.chart.drawXAxisTickLabel(graphics2D, axis, string, n6, 0 + n4 + n7);
                continue;
            }
            if (n4 > 0) {
                graphics2D.drawLine(n6, n3, n6, n3 - n4);
            }
            graphics2D.setColor(color);
            this.chart.drawXAxisTickLabel(graphics2D, axis, string, n6, n3 - fontMetrics.getDescent() - n9 - n7);
        }
        graphics2D.setClip(shape);
    }

    protected void drawStringIfWithinBounds(Graphics graphics, String string, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string == null) {
            return;
        }
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getAscent();
        if (rectangle == null || n >= 0 && n + n3 <= rectangle.width && n2 - n4 >= 0 && n2 <= rectangle.height) {
            Rectangle rectangle2 = new Rectangle(n - 1 - 3, n2 - n4 + 1 - 1, n3 + 6, n4 + 2);
            if (this.tickLabelBounds == null || !this.tickLabelBounds.intersects(rectangle2)) {
                graphics.drawString(string, n, n2);
                this.tickLabelBounds = rectangle2;
            }
        }
    }

    private class AxisPropertyChangeListener
    implements PropertyChangeListener {
        private AxisPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Point point = AxisComponent.this.viewPosition;
            AxisComponent.this.viewPosition = AxisComponent.this.viewport == null ? null : AxisComponent.this.viewport.getViewPosition();
            if (AxisComponent.this.viewPosition != null && (point == null || ((AxisComponent)AxisComponent.this).viewPosition.x != point.x || ((AxisComponent)AxisComponent.this).viewPosition.y != point.y)) {
                AxisComponent.this.chart.update();
            }
        }
    }

    private class ViewportChangeListener
    implements ChangeListener {
        private ViewportChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Point point = AxisComponent.this.viewPosition;
            AxisComponent.this.viewPosition = AxisComponent.this.viewport == null ? null : AxisComponent.this.viewport.getViewPosition();
            if (AxisComponent.this.viewPosition != null && (point == null || ((AxisComponent)AxisComponent.this).viewPosition.x != point.x || ((AxisComponent)AxisComponent.this).viewPosition.y != point.y)) {
                AxisComponent.this.chart.update();
            }
        }
    }
}

