/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.DefaultAxisRenderer;
import com.jidesoft.chart.xml.XmlColorAdapter;
import com.jidesoft.chart.xml.XmlFontAdapter;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Axis
implements PropertyChangeListener {
    private static final AxisPlacement defaultPlacement = AxisPlacement.LEADING;
    public static final double MIN_RESOLUTION = 1.0E-10;
    public static final String PROPERTY_TICKS = "ticks";
    public static final String PROPERTY_TICK_FONT = "tickFont";
    public static final String PROPERTY_TICK_LENGTH = "tickLength";
    public static final String PROPERTY_MINOR_TICK_LENGTH = "minorTickLength";
    public static final String PROPERTY_RANGE = "range";
    public static final String PROPERTY_UPDATE_OTHER_AXES = "updateOtherAxes";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_TICK_LABEL_COLOR = "tickLabelColor";
    public static final String PROPERTY_TICK_CALCULATOR = "tickCalculator";
    public static final String PROPERTY_AXIS_COLOR = "axisColor";
    public static final String PROPERTY_TICK_COLOR = "tickColor";
    public static final String PROPERTY_MINOR_TICK_COLOR = "minorTickColor";
    public static final String PROPERTY_STROKE = "axisStroke";
    private Range<?> range = new NumericRange(0.0, 1.0);
    private Range<?> inputRange = this.range;
    private TickCalculator tickCalculator = new DefaultNumericTickCalculator();
    private AutoPositionedLabel label = null;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private AxisPlacement placement;
    private boolean ticksVisible = true;
    private Font tickFont = null;
    private AxisRenderer axisRenderer = new DefaultAxisRenderer();
    private Tick[] ticks;
    private boolean visible = true;
    private boolean labelVisible = true;
    private Integer labelWidth = null;
    private int tickLength = 4;
    private int minorTickLength = 2;
    private double tickLabelRotation = 0.0;
    private int tickLabelOffset = 2;
    private Color axisColor = Color.darkGray;
    private Color tickColor = null;
    private Color minorTickColor = null;
    private Color tickLabelColor = null;
    private Stroke axisStroke;
    private Range<Double> domain = null;
    private boolean flipped = false;
    private double floatingPosition;
    private InvertibleTransform<Double> axisTransform = new IdentityTransform<Double>();

    public Axis() {
        this.setPlacement(defaultPlacement);
    }

    public Axis(String string) {
        this(new AutoPositionedLabel(string));
    }

    public Axis(AutoPositionedLabel autoPositionedLabel) {
        this();
        this.setLabel(autoPositionedLabel);
    }

    public Axis(double d, double d2) {
        this(new NumericRange(d, d2));
    }

    public Axis(Range<?> range) {
        if (range == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        this.setRange(range);
        this.setPlacement(defaultPlacement);
    }

    public Axis(Range<?> range, String string) {
        if (range == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        this.setRange(range);
        this.setLabel(new AutoPositionedLabel(string));
        this.setPlacement(defaultPlacement);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @XmlTransient
    public TickCalculator getTickCalculator() {
        return this.tickCalculator;
    }

    public void setTickCalculator(TickCalculator tickCalculator) {
        TickCalculator tickCalculator2 = this.tickCalculator;
        if (tickCalculator2 != null) {
            tickCalculator2.removePropertyChangeListener(this);
        }
        this.tickCalculator = tickCalculator;
        if (tickCalculator != null) {
            tickCalculator.addPropertyChangeListener(this);
        }
        this.ticks = null;
        this.support.firePropertyChange(PROPERTY_TICK_CALCULATOR, tickCalculator2, tickCalculator);
    }

    @XmlTransient
    public AxisRenderer getAxisRenderer() {
        return this.axisRenderer;
    }

    public double getTickLabelRotation() {
        return this.tickLabelRotation;
    }

    public void setTickLabelRotation(double d) {
        this.tickLabelRotation = d;
    }

    public int getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(int n) {
        this.tickLabelOffset = n;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int n) {
        int n2 = this.tickLength;
        this.tickLength = n;
        this.support.firePropertyChange(PROPERTY_TICK_LENGTH, n2, n);
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    public void setMinorTickLength(int n) {
        int n2 = this.minorTickLength;
        this.minorTickLength = n;
        this.support.firePropertyChange(PROPERTY_MINOR_TICK_LENGTH, n2, n);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color color) {
        Color color2 = this.tickColor;
        this.tickColor = color;
        this.support.firePropertyChange(PROPERTY_TICK_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getMinorTickColor() {
        return this.minorTickColor;
    }

    public void setMinorTickColor(Color color) {
        Color color2 = this.minorTickColor;
        this.minorTickColor = color;
        this.support.firePropertyChange(PROPERTY_MINOR_TICK_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getTickLabelColor() {
        return this.tickLabelColor;
    }

    public void setTickLabelColor(Color color) {
        Color color2 = this.tickLabelColor;
        this.tickLabelColor = color;
        this.support.firePropertyChange(PROPERTY_TICK_LABEL_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    public Font getTickFont() {
        return this.tickFont;
    }

    public void setTickFont(Font font) {
        Font font2 = this.tickFont;
        this.tickFont = font;
        this.support.firePropertyChange(PROPERTY_TICK_FONT, font2, font);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public Integer getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(Integer n) {
        this.labelWidth = n;
    }

    public int labelWidth(Graphics graphics, Font font, Orientation orientation, Tick[] tickArray) {
        Font font2;
        int n;
        int n2 = n = this.isVisible() && this.isTicksVisible() ? this.getTickLabelOffset() : 0;
        if (this.labelWidth != null) {
            return this.labelWidth;
        }
        if (graphics == null) {
            throw new IllegalArgumentException("Graphics instance cannot be null");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font == null ? graphics.getFont() : font);
        Font font3 = font2 = this.label == null ? graphics.getFont() : this.label.getFont();
        if (font2 == null) {
            font2 = graphics.getFont();
        }
        if (orientation == Orientation.vertical) {
            int n3 = 0;
            for (Tick tick : tickArray) {
                int n4;
                assert (tick != null) : "Ticks cannot be null!";
                String string = tick.getLabel();
                int n5 = n4 = string == null ? 0 : fontMetrics.stringWidth(string);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            int n6 = this.getLabel() == null ? 0 : this.getLabel().size((Graphics)graphics, (Font)font2).height;
            double d = this.getTickLabelRotation();
            int n7 = n + fontMetrics.getDescent() + (int)Math.ceil(Math.abs((double)(n3 + 1) * Math.cos(d)) + Math.abs((double)fontMetrics.getHeight() * Math.sin(d))) + n6;
            if (n7 < 2 * fontMetrics.getHeight()) {
                return 2 * fontMetrics.getHeight();
            }
            return n7;
        }
        if (orientation == Orientation.horizontal) {
            int n8 = this.getLabel() == null ? 0 : this.getLabel().size((Graphics)graphics, (Font)font2).height;
            double d = this.getTickLabelRotation();
            if (d == 0.0) {
                int n9 = fontMetrics.getHeight();
                return n + fontMetrics.getDescent() + n9 + n8;
            }
            int n10 = 0;
            for (Tick tick : tickArray) {
                int n11;
                String string = tick.getLabel();
                int n12 = n11 = string == null ? 0 : fontMetrics.stringWidth(string);
                if (n11 <= n10) continue;
                n10 = n11;
            }
            return n + fontMetrics.getDescent() + (int)Math.ceil(Math.abs((double)(n10 + 1) * Math.sin(d)) + Math.abs((double)fontMetrics.getHeight() * Math.cos(d))) + n8;
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)orientation));
    }

    public int labelWidth(Graphics graphics, Font font, Orientation orientation) {
        if (!this.visible) {
            return 0;
        }
        return this.labelWidth(graphics, font, orientation, this.getTicks());
    }

    public void setAxisRenderer(AxisRenderer axisRenderer) {
        AxisRenderer axisRenderer2 = this.axisRenderer;
        this.axisRenderer = axisRenderer;
        this.support.firePropertyChange("axisRenderer", axisRenderer2, axisRenderer);
    }

    public void setRange(double d, double d2) {
        if (d <= d2) {
            this.setRange(new NumericRange(d, d2));
        } else {
            this.setRange(new NumericRange(d2, d));
        }
    }

    public void setRange(Range<?> range) {
        this.setRange(range, true);
    }

    public void setRange(Range<?> range, boolean bl) {
        this.setRange(range, bl, true);
    }

    public void setRange(Range<?> numericRange, boolean bl, boolean bl2) {
        double d;
        double d2;
        if (numericRange == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        if (((Object)numericRange).equals(this.range)) {
            return;
        }
        if (this.range != null) {
            this.range.removePropertyChangeListener(this);
        }
        if (this.axisTransform == null) {
            d2 = numericRange.minimum();
            d = numericRange.maximum();
        } else {
            d2 = this.axisTransform.inverseTransform(numericRange.minimum());
            d = this.axisTransform.inverseTransform(numericRange.maximum());
            this.inputRange = new NumericRange(Math.min(d2, d), Math.max(d2, d));
        }
        if (this.domain != null) {
            double d3 = d2 < this.domain.minimum() ? this.domain.minimum() : d2;
            double d4 = d > this.domain.maximum() ? this.domain.maximum() : d;
            numericRange = new NumericRange(d3, d4);
        }
        Range<?> range = this.range;
        this.range = numericRange;
        this.ticks = null;
        this.range.addPropertyChangeListener(this);
        if (bl2) {
            this.support.firePropertyChange(PROPERTY_RANGE, range, numericRange);
        }
        if (bl) {
            this.support.firePropertyChange(PROPERTY_UPDATE_OTHER_AXES, range, numericRange);
        }
    }

    @XmlTransient
    public Range<Double> getDomain() {
        return this.domain;
    }

    public void setDomain(Range<Double> range) {
        this.domain = range;
    }

    public AxisQuantity getQuantity() {
        return AxisQuantity.NUMBER;
    }

    @XmlTransient
    public Range<?> getRange() {
        return this.range;
    }

    public Range<?> getOutputRange() {
        if (this.axisTransform == null || this.axisTransform instanceof IdentityTransform) {
            return this.range;
        }
        double d = this.axisTransform.transform(this.minimum());
        double d2 = this.axisTransform.transform(this.maximum());
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        if (this.getQuantity() == AxisQuantity.TIME) {
            return new TimeRange((long)d3, (long)d4);
        }
        if (this.getQuantity() == AxisQuantity.CATEGORY) {
            return new CategoryRange<Object>(d3, d4);
        }
        return new NumericRange(d3, d4);
    }

    @XmlTransient
    public InvertibleTransform<Double> getAxisTransform() {
        return this.axisTransform;
    }

    public void setAxisTransform(InvertibleTransform<Double> invertibleTransform) {
        this.axisTransform = invertibleTransform;
    }

    @XmlTransient
    public AutoPositionedLabel getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (string == null) {
            this.setLabel((AutoPositionedLabel)null);
        } else {
            AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
            this.setLabel(autoPositionedLabel);
        }
    }

    public void setLabel(AutoPositionedLabel autoPositionedLabel) {
        AutoPositionedLabel autoPositionedLabel2 = this.label;
        this.label = autoPositionedLabel;
        this.support.firePropertyChange(PROPERTY_LABEL, autoPositionedLabel2, autoPositionedLabel);
    }

    public double maximum() {
        return this.range.maximum();
    }

    public double minimum() {
        return this.range.minimum();
    }

    public double midPoint() {
        return (this.range.maximum() + this.range.minimum()) / 2.0;
    }

    public AxisPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(AxisPlacement axisPlacement) {
        this.placement = axisPlacement;
    }

    public double getFloatingPosition() {
        return this.floatingPosition;
    }

    public void setFloatingPosition(double d) {
        this.floatingPosition = d;
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.axisColor;
        this.axisColor = color;
        this.support.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    @XmlTransient
    public Stroke getStroke() {
        return this.axisStroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.axisStroke;
        this.axisStroke = stroke;
        this.support.firePropertyChange(PROPERTY_STROKE, stroke2, this.axisStroke);
    }

    @XmlTransient
    public Tick[] getTicks() {
        if (this.ticks == null) {
            this.updateTicks();
        }
        return this.ticks;
    }

    protected void updateTicks() {
        Tick[] tickArray = this.ticks;
        this.ticks = this.tickCalculator.calculateTicks(this.getRange());
        this.support.firePropertyChange(PROPERTY_TICKS, tickArray, this.ticks);
    }

    public boolean isTicksVisible() {
        return this.ticksVisible;
    }

    public void setTicksVisible(boolean bl) {
        this.ticksVisible = bl;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean bl) {
        this.flipped = bl;
    }

    public static Range<?> zoom(Axis axis, double d) {
        AbstractRange abstractRange;
        TimeRange timeRange = axis.getOutputRange();
        double d2 = (timeRange.minimum() + timeRange.maximum()) / 2.0;
        double d3 = timeRange.maximum() - timeRange.minimum();
        double d4 = d3 * d;
        if (axis.getQuantity() == AxisQuantity.TIME) {
            long l = (long)(d2 - d4 / 2.0);
            long l2 = (long)(d2 + d4 / 2.0);
            if (Axis.isMinimumResolution(l, l2) && d > 1.0) {
                --l;
                ++l2;
            }
            abstractRange = new TimeRange(l, l2);
        } else if (axis.getQuantity() == AxisQuantity.CATEGORY) {
            abstractRange = timeRange;
            double d5 = d4 / 2.0;
            double d6 = d2 - d5;
            double d7 = d2 + d5;
            if (Axis.isMinimumResolution(d6, d7) && d > 1.0) {
                d6 -= 1.0E-10;
                d7 += 1.0E-10;
            }
            ((CategoryRange)abstractRange).setMinimum(d6);
            ((CategoryRange)abstractRange).setMaximum(d7);
        } else {
            InvertibleTransform<Double> invertibleTransform = axis.getAxisTransform();
            double d8 = d2 - d4 / 2.0;
            double d9 = d2 + d4 / 2.0;
            if (Axis.isMinimumResolution(d8, d9) && d > 1.0) {
                d8 -= 1.0E-10;
                d9 += 1.0E-10;
            }
            abstractRange = invertibleTransform == null || invertibleTransform instanceof IdentityTransform ? new NumericRange(d8, d9) : new NumericRange(invertibleTransform.inverseTransform(d8), invertibleTransform.inverseTransform(d9));
        }
        return abstractRange;
    }

    private static boolean isMinimumResolution(double d, double d2) {
        return Math.abs(d2 - d) < 1.0E-10;
    }

    public static Range<?> zoomFromPosition(Axis axis, double d, double d2) {
        AbstractRange abstractRange;
        TimeRange timeRange = axis.getOutputRange();
        double d3 = axis.minimum();
        double d4 = axis.maximum();
        if (axis.getQuantity() == AxisQuantity.TIME) {
            long l = (long)(d2 - d * (d2 - d3));
            long l2 = (long)(d2 + d * (d4 - d2));
            if (Axis.isMinimumResolution(l, l2) && d > 1.0) {
                --l;
                ++l2;
            }
            abstractRange = new TimeRange(l, l2);
        } else if (axis.getQuantity() == AxisQuantity.CATEGORY) {
            abstractRange = timeRange;
            double d5 = d2 - d * (d2 - d3);
            double d6 = d2 + d * (d4 - d2);
            if (Axis.isMinimumResolution(d5, d6) && d > 1.0) {
                d5 -= 1.0E-10;
                d6 += 1.0E-10;
            }
            ((CategoryRange)abstractRange).setMinimum(d5);
            ((CategoryRange)abstractRange).setMaximum(d6);
        } else {
            InvertibleTransform<Double> invertibleTransform;
            double d7 = d2 - d * (d2 - d3);
            double d8 = d2 + d * (d4 - d2);
            if (Axis.isMinimumResolution(d7, d8) && d > 1.0) {
                d7 -= 1.0E-10;
                d8 += 1.0E-10;
            }
            abstractRange = (invertibleTransform = axis.getAxisTransform()) == null || invertibleTransform instanceof IdentityTransform ? new NumericRange(d7, d8) : new NumericRange(invertibleTransform.inverseTransform(d7), invertibleTransform.inverseTransform(d8));
        }
        return abstractRange;
    }

    public void render(Graphics graphics, int n, int n2, int n3, Orientation orientation) {
        AxisRenderer axisRenderer;
        if (n3 <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.axisColor);
        Stroke stroke = graphics2D.getStroke();
        if (this.axisStroke != null) {
            graphics2D.setStroke(this.axisStroke);
        }
        if ((axisRenderer = this.getAxisRenderer()) != null) {
            axisRenderer.renderAxis(graphics2D, n, n2, n3, orientation);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public String toString() {
        return String.format("#<Axis label='%s' range=%s>", this.getLabel(), this.getRange());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.ticks = null;
        this.support.firePropertyChange(propertyChangeEvent);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

