/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.model.Transform;
import com.jidesoft.chart.util.Point2DPool;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.logging.Logger;

public class UserToPixelTransform {
    private static final Logger logger = Logger.getLogger(UserToPixelTransform.class.getName());
    private static final Point2DPool pointPool = Point2DPool.instance();
    private Point2D.Double translation = null;
    private AffineTransform affineTransform = null;
    private AffineTransform inverseTransform = null;
    private InvertibleTransform<Double> xTransform;
    private InvertibleTransform<Double> yTransform;

    public UserToPixelTransform() {
    }

    public UserToPixelTransform(AffineTransform affineTransform) {
        this.setAffineTransform(affineTransform);
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
        this.inverseTransform = null;
    }

    public AffineTransform getAffineTransformWithTranslation() {
        AffineTransform affineTransform = new AffineTransform(this.affineTransform);
        double d = this.translation == null ? 0.0 : this.translation.getX();
        double d2 = this.translation == null ? 0.0 : this.translation.getY();
        affineTransform.translate(d, d2);
        return affineTransform;
    }

    public void setTranslation(Double d, Double d2) {
        this.translation = new Point2D.Double(d, d2);
    }

    public Point2D getTranslation() {
        return this.translation;
    }

    public Transform<Double> getXTransform() {
        if (this.xTransform == null) {
            this.xTransform = new IdentityTransform<Double>();
        }
        return this.xTransform;
    }

    public void setXTransform(InvertibleTransform<Double> invertibleTransform) {
        this.xTransform = invertibleTransform;
    }

    public Transform<Double> getYTransform() {
        if (this.yTransform == null) {
            this.yTransform = new IdentityTransform<Double>();
        }
        return this.yTransform;
    }

    public void setYTransform(InvertibleTransform<Double> invertibleTransform) {
        this.yTransform = invertibleTransform;
    }

    private double transformX(double d) {
        Transform<Double> transform = this.getXTransform();
        assert (transform != null);
        double d2 = transform.transform(d);
        double d3 = this.translation == null ? 0.0 : this.translation.getX();
        return d2 + d3;
    }

    private double transformY(double d) {
        Transform<Double> transform = this.getYTransform();
        assert (transform != null);
        double d2 = transform.transform(d);
        double d3 = this.translation == null ? 0.0 : this.translation.getY();
        return d2 + d3;
    }

    public Point2D transform(Point2D point2D) {
        assert (point2D != null);
        Point2D point2D2 = pointPool.borrow(this.transformX(point2D.getX()), this.transformY(point2D.getY()));
        Point2D point2D3 = this.affineTransform.transform(point2D2, null);
        pointPool.replace(point2D2);
        return point2D3;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        assert (point2D != null);
        Point2D point2D3 = pointPool.borrow(this.transformX(point2D.getX()), this.transformY(point2D.getY()));
        Point2D point2D4 = this.affineTransform.transform(point2D3, null);
        pointPool.replace(point2D3);
        point2D2.setLocation(point2D4.getX(), point2D4.getY());
        return point2D2;
    }

    public Point2D inverseTransform(Point2D point2D) throws NoninvertibleTransformException {
        if (this.inverseTransform == null) {
            this.inverseTransform = this.affineTransform.createInverse();
        }
        Point2D point2D2 = this.inverseTransform.transform(point2D, null);
        double d = this.translation == null ? 0.0 : this.translation.getX();
        double d2 = this.translation == null ? 0.0 : this.translation.getY();
        Point2D point2D3 = pointPool.borrow(point2D2.getX() - d, point2D2.getY() - d2);
        assert (point2D3 != null);
        double d3 = this.xTransform == null ? point2D3.getX() : this.xTransform.inverseTransform(point2D3.getX()).doubleValue();
        double d4 = this.yTransform == null ? point2D3.getY() : this.yTransform.inverseTransform(point2D3.getY()).doubleValue();
        pointPool.replace(point2D3);
        return new Point2D.Double(d3, d4);
    }
}

