/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.range.NumericRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.Map;

public class RectangularRegionMarker
implements Drawable,
Frontable,
ZOrder {
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_PAINT = "Paint";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_X_INTERVAL = "X Interval";
    public static final String PROPERTY_Y_INTERVAL = "Y Interval";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chart chart;
    private Paint paint = new Color(255, 0, 0, 128);
    private NumericRange xInterval;
    private NumericRange yInterval;
    private boolean visible = true;
    private boolean atFront = false;
    private String label;
    private LabelPlacement labelPlacement;
    private Color labelColor;
    private Font labelFont;
    private Color outlineColor;
    private Stroke outlineStroke = new BasicStroke(1.0f);
    private static final int distanceFromEdge = 4;
    private int zOrder = 100;
    private RenderingHints renderingHints = null;

    public RectangularRegionMarker() {
    }

    public RectangularRegionMarker(Chart chart) {
        this.chart = chart;
    }

    public RectangularRegionMarker(Chart chart, double d, double d2, double d3, double d4, Paint paint) {
        this.chart = chart;
        this.paint = paint;
        assert (d2 >= d);
        this.setXInterval(d, d2);
        assert (d4 >= d3);
        this.setYInterval(d3, d4);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        this.chart = chart;
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.renderingHints == null) {
            this.renderingHints = new RenderingHints(key, object);
        } else {
            this.renderingHints.put(key, object);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return null;
    }

    public void setColor(Color color) {
        Paint paint = this.paint;
        this.paint = color;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, paint, color);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.paint;
        this.paint = paint;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_PAINT, paint2, paint);
    }

    public NumericRange getXInterval() {
        return this.xInterval;
    }

    public NumericRange getYInterval() {
        return this.yInterval;
    }

    public void setXInterval(double d, double d2) {
        NumericRange numericRange = this.xInterval;
        this.xInterval = new NumericRange(d, d2);
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_X_INTERVAL, numericRange, this.xInterval);
    }

    public void setYInterval(double d, double d2) {
        NumericRange numericRange = this.yInterval;
        this.yInterval = new NumericRange(d, d2);
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_Y_INTERVAL, numericRange, this.yInterval);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.labelPlacement;
        this.labelPlacement = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.labelColor;
        this.labelColor = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.labelFont;
        this.labelFont = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.outlineColor;
        this.outlineColor = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    private float getOutlineWidth() {
        if (this.outlineStroke == null) {
            return 0.0f;
        }
        if (this.outlineStroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.outlineStroke;
            return basicStroke.getLineWidth();
        }
        return 0.0f;
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.outlineStroke;
        this.outlineStroke = stroke;
        this.support.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.chart == null || this.xInterval == null || this.yInterval == null) {
            return;
        }
        if (this.visible) {
            if (this.renderingHints != null) {
                for (Map.Entry object2 : this.renderingHints.entrySet()) {
                    RenderingHints.Key d = (RenderingHints.Key)object2.getKey();
                    graphics2D.setRenderingHint(d, object2.getValue());
                }
            }
            Axis axis = this.chart.getXAxis();
            Axis axis2 = this.chart.getYAxis();
            double d = axis.isFlipped() ? this.xInterval.getMax() : this.xInterval.getMin();
            double d2 = axis.isFlipped() ? this.xInterval.getMin() : this.xInterval.getMax();
            double d3 = axis2.isFlipped() ? this.yInterval.getMax() : this.yInterval.getMin();
            double d4 = axis2.isFlipped() ? this.yInterval.getMin() : this.yInterval.getMax();
            Point point = this.chart.calculatePixelPoint(new Point2D.Double(d, d3));
            Point point2 = this.chart.calculatePixelPoint(new Point2D.Double(d2, d4));
            graphics2D.setPaint(this.paint);
            assert (point2.x >= point.x);
            BigDecimal bigDecimal = new BigDecimal(point2.x).subtract(new BigDecimal(point.x));
            BigDecimal bigDecimal2 = new BigDecimal(point.y).subtract(new BigDecimal(point2.y));
            Rectangle2D.Double double_ = new Rectangle2D.Double(point.x, point2.y, bigDecimal.doubleValue(), bigDecimal2.doubleValue());
            Shape shape = graphics2D.getClip();
            Rectangle rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
            float f = this.getOutlineWidth();
            double d5 = Math.max((double)((float)rectangle.x - f), double_.getMinX());
            double d6 = rectangle.getMaxY() + (double)f;
            double d7 = double_.getMaxY();
            double d8 = Math.min(d6, d7);
            double d9 = Math.min(rectangle.getMaxX() + (double)f, double_.getMaxX());
            double d10 = Math.max(rectangle.getMinY() - (double)f, double_.getMinY());
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d5, d10, d9 - d5, d8 - d10);
            graphics2D.fill(double_2);
            if (this.outlineColor != null && this.outlineStroke != null) {
                graphics2D.setColor(this.outlineColor);
                graphics2D.setStroke(this.outlineStroke);
                graphics2D.draw(double_2);
            }
            if (this.label != null) {
                this.paintLabel(graphics2D, this.label, point.x, point2.y, point2.x - point.x, point.y - point2.y);
            }
        }
        graphics2D.dispose();
    }

    private void paintLabel(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        if (this.labelFont != null) {
            graphics2D.setFont(this.labelFont);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.getAscent();
        int n8 = n + n3;
        int n9 = n2 + n4;
        int n10 = this.labelPlacement == LabelPlacement.WEST || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.SOUTH_WEST ? n + 4 : (this.labelPlacement == LabelPlacement.EAST || this.labelPlacement == LabelPlacement.NORTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_EAST ? n8 - n5 - 4 : n + n3 / 2 - n5 / 2);
        int n11 = this.labelPlacement == LabelPlacement.NORTH || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.NORTH_EAST ? n2 + n6 : (this.labelPlacement == LabelPlacement.SOUTH || this.labelPlacement == LabelPlacement.SOUTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_WEST ? n2 + n4 - 4 : (n2 + n9) / 2 + n7 / 2);
        if (this.labelColor == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.labelColor);
        }
        graphics2D.drawString(string, n10, n11);
    }

    @Override
    public boolean isAtFront() {
        return this.atFront;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.atFront;
        this.atFront = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }
}

