/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.util.ShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public enum PointShape {
    CIRCLE,
    DISC,
    SQUARE,
    BOX,
    DIAMOND,
    DOWN_TRIANGLE,
    UP_TRIANGLE,
    HORIZONTAL_LINE,
    VERTICAL_LINE,
    UPRIGHT_CROSS,
    DIAGONAL_CROSS;

    private static final int LINE_WIDTH = 1;

    public Shape paint(Graphics graphics, double d, double d2, double d3, Paint paint, boolean bl, Color color, float f) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(paint);
        try {
            switch (this) {
                case CIRCLE: {
                    Shape shape = this.paintCircle(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case DISC: {
                    Shape shape = this.paintDisc(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case SQUARE: {
                    Shape shape = this.paintSquare(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case BOX: {
                    Shape shape = this.paintBox(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case DIAMOND: {
                    Shape shape = this.paintDiamond(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case DOWN_TRIANGLE: {
                    Shape shape = this.paintDownTriangle(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case UP_TRIANGLE: {
                    Shape shape = this.paintUpTriangle(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case HORIZONTAL_LINE: {
                    Shape shape = this.paintHorizontalLine(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case VERTICAL_LINE: {
                    Shape shape = this.paintVerticalLine(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case UPRIGHT_CROSS: {
                    Shape shape = this.paintUprightCross(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
                case DIAGONAL_CROSS: {
                    Shape shape = this.paintDiagonalCross(graphics2D, d, d2, d3, bl, color, f);
                    return shape;
                }
            }
            throw new IllegalArgumentException("Unexpected shape");
        }
        finally {
            graphics2D.dispose();
        }
    }

    private Shape paintSquare(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        double d4 = d - d3 / 2.0;
        double d5 = d2 - d3 / 2.0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d3, d3);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 - (double)f / 2.0, d5 - (double)f / 2.0, d3 + 1.0 + (double)f, d3 + 1.0 + (double)f);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintCircle(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d4 = d - (d3 - 1.0) / 2.0;
        double d5 = d2 - (d3 - 1.0) / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d4, d5, d3, d3);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d4 - (double)(f + 1.0f) / 2.0 - 0.5, d5 - (double)(f + 1.0f) / 2.0 - 0.5, d3 + 1.5 + (double)f, d3 + 1.5 + (double)f);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintDisc(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d4 = d - d3 / 2.0;
        double d5 = d2 - d3 / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d4, d5, d3, d3);
        graphics2D.fill(double_);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d4 - (double)f / 2.0, d5 - (double)f / 2.0, d3 + (double)f, d3 + (double)f);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintBox(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        double d4 = d - (d3 - 1.0) / 2.0;
        double d5 = d2 - (d3 - 1.0) / 2.0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d3, d3);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 - (double)f / 2.0, d5 - (double)f / 2.0, d3 - 1.0 + (double)f / 2.0, d3 - 1.0 + (double)f / 2.0);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintDiamond(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        Shape shape = ShapeFactory.createDiamond2D(d, d2, d3);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Shape shape2 = ShapeFactory.createDiamond2D(d, d2, d3 + (double)f - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape paintDownTriangle(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        Shape shape = ShapeFactory.createDownTriangle2D(d, d2, d3);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Shape shape2 = ShapeFactory.createDownTriangle2D(d, d2, d3 + (double)((int)f) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape paintUpTriangle(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        Shape shape = ShapeFactory.createUpTriangle2D(d, d2, d3);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Shape shape2 = ShapeFactory.createUpTriangle2D(d, d2, d3 + (double)((int)f) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape paintHorizontalLine(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d4 = d - (d3 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d2 + 1.0 - 0.5, d3, 1.0);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 - (double)(f / 2.0f), d2 + 1.0 - 0.5 - (double)(f + 1.0f) / 2.0, d3 - 1.0 + (double)f, 1.0f + f);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintVerticalLine(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d4 = d2 - (d3 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d + 1.0 - 0.5, d4, 1.0, d3);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d + 1.0 - 0.5 - (double)(f + 1.0f) / 2.0, d4 - (double)(f / 2.0f), 1.0f + f, d3 - 1.0 + (double)f);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape paintUprightCross(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d4 = d - (d3 - 1.0) / 2.0;
        double d5 = d2 - (d3 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d2 + 1.0 - 0.5, d3, 1.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d + 1.0 - 0.5, d5, 1.0, d3);
        graphics2D.fill(double_);
        graphics2D.fill(double_2);
        double_.add(double_2);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_3 = new Rectangle2D.Double(d4 - (double)f / 2.0, d5 - (double)(f / 2.0f), d3 - 1.0 + (double)f, d3 - 1.0 + (double)f);
            graphics2D.draw(double_3);
        }
        return double_;
    }

    private Shape paintDiagonalCross(Graphics2D graphics2D, double d, double d2, double d3, boolean bl, Color color, float f) {
        double d4 = 2.0 * Math.sqrt(2.0);
        double d5 = (d3 - 1.0) / 2.0;
        double d6 = d - d5;
        double d7 = d2 - d5;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d + 0.5 - d5 + 1.0 / d4, d2 + 0.5 - d5 - 1.0 / d4);
        generalPath.lineTo(d + 0.5 + d5 + 1.0 / d4, d2 + 0.5 + d5 - 1.0 / d4);
        generalPath.lineTo(d + 0.5 + d5 - 1.0 / d4, d2 + 0.5 + d5 + 1.0 / d4);
        generalPath.lineTo(d + 0.5 - d5 - 1.0 / d4, d2 + 0.5 - d5 + 1.0 / d4);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(d + 0.5 + d5 - 1.0 / d4, d2 + 0.5 - d5 - 1.0 / d4);
        generalPath2.lineTo(d + 0.5 - d5 - 1.0 / d4, d2 + 0.5 + d5 - 1.0 / d4);
        generalPath2.lineTo(d + 0.5 - d5 + 1.0 / d4, d2 + 0.5 + d5 + 1.0 / d4);
        generalPath2.lineTo(d + 0.5 + d5 - 1.0 / d4, d2 + 0.5 - d5 + 1.0 / d4);
        generalPath2.closePath();
        generalPath.append(generalPath2, false);
        graphics2D.fill(generalPath);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f));
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6 - (double)f / 2.0, d7 - (double)(f / 2.0f), d3 - 1.0 + (double)f, d3 - 1.0 + (double)f);
            graphics2D.draw(double_);
        }
        return generalPath;
    }

    public static PointShape fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PointShape from null");
        }
        String string2 = string.trim().toUpperCase();
        return PointShape.valueOf(string2);
    }
}

