/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartPainter;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

class PointPainter
implements ChartPainter {
    private final Map<PointDescriptor, Shape> pointShapes = Collections.synchronizedMap(new HashMap());

    PointPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor containingPoint(Point point) {
        Map<PointDescriptor, Shape> map = this.pointShapes;
        synchronized (map) {
            for (Map.Entry<PointDescriptor, Shape> entry : this.pointShapes.entrySet()) {
                Shape shape = entry.getValue();
                if (!shape.contains(point)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PointDescriptor> containingPoints(Point point) {
        ArrayList<PointDescriptor> arrayList = new ArrayList<PointDescriptor>();
        Map<PointDescriptor, Shape> map = this.pointShapes;
        synchronized (map) {
            for (Map.Entry<PointDescriptor, Shape> entry : this.pointShapes.entrySet()) {
                Shape shape = entry.getValue();
                if (!shape.contains(point)) continue;
                arrayList.add(entry.getKey());
            }
        }
        return arrayList;
    }

    public void clearShapes() {
        this.pointShapes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor rendered(Chartable chartable) {
        Map<PointDescriptor, Shape> map = this.pointShapes;
        synchronized (map) {
            for (Map.Entry<PointDescriptor, Shape> entry : this.pointShapes.entrySet()) {
                PointDescriptor pointDescriptor = entry.getKey();
                if (!chartable.equals(pointDescriptor.getChartable())) continue;
                return pointDescriptor;
            }
        }
        return null;
    }

    private boolean checkingBounds() {
        return UIManager.getBoolean("Chart.checkPointBounds");
    }

    @Override
    public void drawChart(Graphics graphics, Chart chart, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl2 = this.checkingBounds();
        ChartStyle chartStyle = chart.getStyle(chartModel);
        double d = chart.getAnimationPosition();
        if (chartStyle == null || chartStyle.isPointsVisible()) {
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                int n2;
                Double d2;
                Double d3;
                Object object;
                Object object2;
                if (bl && i % 100 == 0 && Thread.interrupted()) {
                    return;
                }
                Point point = null;
                Chartable chartable = null;
                if (chartModel instanceof LeanChartModel) {
                    object2 = (LeanChartModel)chartModel;
                    object = object2.getPointPositions(i);
                    d3 = object[0];
                    d2 = object[1];
                    point = chart.calculatePixelPoint((Point2D)new Point2D.Double(d3, d2), userToPixelTransform);
                } else {
                    chartable = chartModel.getPoint(i);
                    object2 = chartable == null ? null : chartable.getX();
                    object = chartable == null ? null : chartable.getY();
                    if (object2 != null && object != null) {
                        d3 = object2.position();
                        d2 = object.position();
                        point = chart.calculatePixelPoint((Point2D)new Point2D.Double(object2.position(), object.position()), userToPixelTransform);
                    }
                }
                if (point == null) continue;
                int n3 = d == 1.0 ? point.x : chart.interpolateXForAnimation(point.x, chartModel);
                int n4 = n2 = d == 1.0 ? point.y : chart.interpolateYForAnimation(point.y, chartModel);
                if (bl2 && (n3 < chart.getXStart() || n3 > chart.getXEnd() || n2 < chart.getYEnd() || n2 > chart.getYStart())) continue;
                ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
                boolean bl3 = false;
                if (listSelectionModel != null) {
                    bl3 = listSelectionModel.isSelectedIndex(i);
                }
                Chartable chartable2 = chart.getCurrentChartPoint();
                boolean bl4 = chart.isRolloverEnabled() && chartable2 != null && chartable2.equals(chartModel.getPoint(i));
                Paint paint = graphics2D.getPaint();
                PointRenderer pointRenderer = chart.getPointRenderer(chartModel);
                Shape shape = pointRenderer.renderPoint(graphics2D, chart, chartModel, chartable, bl3, bl4, false, n3, n2);
                if (shape != null && chart.isRecordingShapes()) {
                    PointDescriptor pointDescriptor = new PointDescriptor(chartable, i, chartModel);
                    pointDescriptor.setShape(shape);
                    this.pointShapes.put(pointDescriptor, shape);
                }
                graphics2D.setPaint(paint);
            }
        }
    }
}

