/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Named;
import com.jidesoft.range.Category;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class PointLegendItem
extends JComponent
implements LegendItem<Chartable, ChartModel> {
    private static final long serialVersionUID = 2720860066814394586L;
    private transient Chartable chartable;
    private transient ChartModel model;
    private Chart chart;
    private String label;
    private LabelSource labelSource = null;

    public PointLegendItem(Chartable chartable, ChartModel chartModel, Chart chart) {
        this.setOpaque(false);
        this.chartable = chartable;
        this.model = chartModel;
        this.chart = chart;
        Dimension dimension = new Dimension(30, 20);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public LabelSource getLabelSource() {
        return this.labelSource;
    }

    public void setLabelSource(LabelSource labelSource) {
        this.labelSource = labelSource;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            if (this.chartable == null) {
                return "";
            }
            Positionable positionable = this.chartable.getX();
            Positionable positionable2 = this.chartable.getY();
            if (this.labelSource == null) {
                String string;
                this.label = Double.toString(positionable.position());
                if (positionable instanceof Category) {
                    this.label = this.getLabelFromPosition(positionable);
                } else if (this.chartable instanceof Named && (string = this.getLabelFromNamedPoint(this.chartable)) != null) {
                    this.label = string;
                }
            } else {
                switch (this.labelSource) {
                    case X_POS: {
                        this.label = this.getLabelFromPosition(positionable);
                        break;
                    }
                    case Y_POS: {
                        this.label = this.getLabelFromPosition(positionable2);
                        break;
                    }
                    case NAME: {
                        this.label = this.getLabelFromNamedPoint(this.chartable);
                    }
                }
            }
        }
        return this.label;
    }

    private String getLabelFromPosition(Positionable positionable) {
        if (positionable instanceof Category) {
            Category category = (Category)positionable;
            return category.getName();
        }
        return Double.toString(positionable.position());
    }

    private String getLabelFromNamedPoint(Chartable chartable) {
        if (chartable instanceof Named) {
            Named named = (Named)((Object)chartable);
            return named.getName();
        }
        throw new IllegalStateException("Cannot retrieve name from unnamed point " + chartable);
    }

    public Chartable getChartable() {
        return this.chartable;
    }

    public void setChartable(Chartable chartable) {
        this.chartable = chartable;
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel chartModel) {
        this.model = chartModel;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Chartable getItem() {
        return this.chartable;
    }

    @Override
    public ChartModel getSource() {
        return this.model;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        Highlight highlight;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = graphics.getFontMetrics().getHeight();
        graphics2D.setClip(0, n / 2 - n2 / 2, 30, n2);
        ChartStyle chartStyle = this.chart.getStyle(this.model);
        if (this.chartable instanceof Highlightable && (highlight = (object = (Highlightable)((Object)this.chartable)).getHighlight()) != null) {
            chartStyle = this.chart.getHighlightStyle(highlight);
        }
        if (chartStyle == null) {
            chartStyle = ChartStyle.DEFAULT_STYLE;
            chartStyle.setBarPaint(Color.black);
        }
        object = chartStyle.getBarPaint();
        graphics2D.setPaint((Paint)object);
        graphics2D.fillRect(5, 0, 20, 20);
        graphics2D.dispose();
    }

    public static enum LabelSource {
        X_POS,
        Y_POS,
        NAME;

    }
}

