/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.BackgroundPlotterTask;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.LazyRenderer;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.chart.util.SwingExecutor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MultiImageLazyChartRenderer
implements LazyRenderer<ChartModel> {
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Map<String, SoftReference<Image>> images = new ConcurrentHashMap<String, SoftReference<Image>>();
    private Map<String, ChartStyle> styles = new ConcurrentHashMap<String, ChartStyle>();
    private List<BackgroundPlotterTask> pending = new CopyOnWriteArrayList<BackgroundPlotterTask>();
    private Point2D topLeft;
    private Point2D bottomRight;
    private int width;
    private int height;
    private Image compoundImage;
    private Chart chart;
    private List<ImageChangeListener> listeners = new CopyOnWriteArrayList<ImageChangeListener>();

    public MultiImageLazyChartRenderer(Chart chart) {
        this.chart = chart;
    }

    @Override
    public void addImageChangeListener(ImageChangeListener imageChangeListener) {
        this.listeners.add(imageChangeListener);
    }

    @Override
    public void removeImageChangeListener(ImageChangeListener imageChangeListener) {
        this.listeners.remove(imageChangeListener);
    }

    protected void fireImageChange() {
        ImageChangeEvent imageChangeEvent = new ImageChangeEvent(this);
        for (ImageChangeListener imageChangeListener : this.listeners) {
            imageChangeListener.imageChanged(imageChangeEvent);
        }
    }

    @Override
    public void updateCharts(boolean bl) {
        Pair<Point2D, Point2D> pair = this.chartCorners();
        Point2D point2D = pair.getFirst();
        Point2D point2D2 = pair.getSecond();
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.chart.getModels());
        if (bl) {
            this.images.clear();
            this.styles.clear();
        }
        this.cancelDrawing();
        if (arrayList.size() == 0) {
            this.createImage(point2D, point2D2);
            this.fireImageChange();
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                ChartModel chartModel = (ChartModel)arrayList.get(i);
                this.updateImage(chartModel, i, false, point2D, point2D2);
            }
        }
    }

    @Override
    public void cancelDrawing() {
        for (BackgroundPlotterTask backgroundPlotterTask : this.pending) {
            if (backgroundPlotterTask.isCancelled()) continue;
            backgroundPlotterTask.cancel(true);
        }
    }

    @Override
    public void updateImage(ChartModel chartModel, boolean bl) {
        List<ChartModel> list = this.chart.getModels();
        int n = list.indexOf(chartModel);
        Pair<Point2D, Point2D> pair = this.chartCorners();
        this.updateImage(chartModel, n, bl, pair.getFirst(), pair.getSecond());
    }

    @Override
    public void removeImage(String string) {
        if (string != null) {
            this.images.remove(string);
            this.styles.remove(string);
        }
    }

    @Override
    public void removeImage(ChartModel chartModel) {
        String string = chartModel.getName();
        this.removeImage(string);
    }

    private void updateImage(final ChartModel chartModel, int n, boolean bl, final Point2D point2D, final Point2D point2D2) {
        boolean bl2;
        final String string = chartModel.getName();
        final ChartStyle chartStyle = this.chart.getStyle(chartModel);
        ChartStyle chartStyle2 = this.styles.get(string);
        boolean bl3 = bl2 = chartStyle != null && !chartStyle.isPointsVisible() && !chartStyle.isLinesVisible() && !chartStyle.isBarsVisible();
        if (bl2 && bl) {
            this.createImage(point2D, point2D2);
            this.fireImageChange();
        } else if (bl && chartStyle2 != null && chartStyle2.equals(chartStyle) && this.getCachedImage(chartModel) != null) {
            this.createImage(point2D, point2D2);
            this.fireImageChange();
        } else {
            BackgroundPlotterTask backgroundPlotterTask = new BackgroundPlotterTask(this.chart, chartModel, n, this.width, this.height){

                @Override
                protected void onCompletion(Image image, Throwable throwable, boolean bl) {
                    if (!bl) {
                        if (image != null) {
                            if (MultiImageLazyChartRenderer.this.chart.containsModel(chartModel)) {
                                ChartStyle chartStyle2 = new ChartStyle(chartStyle);
                                MultiImageLazyChartRenderer.this.images.put(string, new SoftReference<Image>(image));
                                MultiImageLazyChartRenderer.this.styles.put(string, chartStyle2);
                            }
                            for (BackgroundPlotterTask backgroundPlotterTask : MultiImageLazyChartRenderer.this.pending) {
                                if (backgroundPlotterTask.isDone()) continue;
                                return;
                            }
                        }
                        MultiImageLazyChartRenderer.this.createImage(point2D, point2D2);
                        MultiImageLazyChartRenderer.this.fireImageChange();
                    }
                }
            };
            this.pending.add(backgroundPlotterTask);
            executorService.execute(backgroundPlotterTask);
        }
    }

    private Pair<Point2D, Point2D> chartCorners() {
        int n = this.chart.getXStart();
        int n2 = this.chart.getYEnd();
        int n3 = this.chart.getXEnd();
        int n4 = this.chart.getYStart();
        this.width = n3 - n;
        this.height = n4 - n2;
        Point point = new Point(n, n2);
        Point point2 = new Point(n3, n4);
        Point2D point2D = this.chart.calculateUserPoint(point);
        Point2D point2D2 = this.chart.calculateUserPoint(point2);
        return new Pair<Point2D, Point2D>(point2D, point2D2);
    }

    private Image getCachedImage(ChartModel chartModel) {
        String string = chartModel.getName();
        SoftReference<Image> softReference = this.images.get(string);
        Image image = softReference == null ? null : softReference.get();
        return image;
    }

    private void createImage(final Point2D point2D, final Point2D point2D2) {
        SwingExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (MultiImageLazyChartRenderer.this.width <= 0 || MultiImageLazyChartRenderer.this.height <= 0) {
                    return;
                }
                MultiImageLazyChartRenderer.this.pending.clear();
                MultiImageLazyChartRenderer.this.compoundImage = new BufferedImage(MultiImageLazyChartRenderer.this.width, MultiImageLazyChartRenderer.this.height, 2);
                MultiImageLazyChartRenderer.this.topLeft = point2D;
                MultiImageLazyChartRenderer.this.bottomRight = point2D2;
                Graphics2D graphics2D = (Graphics2D)MultiImageLazyChartRenderer.this.compoundImage.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (ChartModel chartModel : MultiImageLazyChartRenderer.this.chart.getModels()) {
                    ChartStyle chartStyle = MultiImageLazyChartRenderer.this.chart.getStyle(chartModel);
                    Image image = MultiImageLazyChartRenderer.this.getCachedImage(chartModel);
                    if (image == null || !MultiImageLazyChartRenderer.this.isVisible(chartStyle)) continue;
                    graphics2D.drawImage(image, 0, 0, MultiImageLazyChartRenderer.this.width, MultiImageLazyChartRenderer.this.height, null);
                }
            }
        });
    }

    private boolean isVisible(ChartStyle chartStyle) {
        return chartStyle == null || chartStyle.isPointsVisible() || chartStyle.isLinesVisible() || chartStyle.isBarsVisible();
    }

    @Override
    public void draw(Graphics graphics) {
        if (!this.chart.isLazyRendering()) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.compoundImage == null) {
            return;
        }
        if (this.topLeft != null && this.bottomRight != null) {
            Point point = this.chart.calculatePixelPoint(this.topLeft);
            Point point2 = this.chart.calculatePixelPoint(this.bottomRight);
            int n = point.x;
            int n2 = point.y;
            int n3 = point2.x;
            int n4 = point2.y;
            int n5 = n3 - n;
            int n6 = Math.abs(n4 - n2);
            assert (n6 >= 0);
            graphics.drawImage(this.compoundImage, n, n2, n5, n6, this.chart);
        }
    }
}

