/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.utils.ColorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Meter
extends JComponent {
    private static final Logger logger = Logger.getLogger(Meter.class.getName());
    private ShadowFactory shadowRenderer = new ShadowFactory();
    private double min = 0.0;
    private double max = 100.0;
    private double value;
    private double pointerValue = this.value = this.min;
    private double velocity;
    private double needleSpeed = 3.0;
    private Color needleColor = new Color(92, 92, 92);
    private Color faceColor = new Color(150, 150, 160);
    private Color tickColor = new Color(250, 250, 255, 150);
    private BufferedImage dialImage = null;
    private Timer timer;
    private int timerPeriod = 150;

    public Meter() {
        this.setPreferredSize(new Dimension(300, 300));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Meter.this.dialImage = null;
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Meter.this.updatePointer();
            }
        };
        this.timer = new Timer(this.timerPeriod, actionListener);
        this.timer.start();
    }

    private void updatePointer() {
        double d = this.value - this.pointerValue;
        this.velocity = Math.signum(d) + this.needleSpeed * (double)this.timerPeriod / 1000.0 * d;
        this.pointerValue = Math.abs(this.pointerValue - this.value) <= 1.0 ? this.value : (this.pointerValue += this.velocity);
        this.repaint();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        double d2 = this.value;
        if (d < this.min) {
            d = this.min;
        } else if (d > this.max) {
            d = this.max;
        }
        this.value = d;
        this.firePropertyChange("value", d2, d);
        this.repaint();
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public void setNeedleColor(Color color) {
        this.needleColor = color;
    }

    public Color getFaceColor() {
        return this.faceColor;
    }

    public void setFaceColor(Color color) {
        this.faceColor = color;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
    }

    private int getAngle() {
        return (int)(135.0 + 270.0 * (this.pointerValue - this.min) / (this.max - this.min));
    }

    private Image createDialImage() {
        Object object;
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        this.dialImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = (Graphics2D)this.dialImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = Math.min(n2, n3);
        int n5 = n4 / 2;
        float f = (float)n2 / 2.0f;
        float f2 = (float)n3 / 2.0f;
        Ellipse2D.Double double_ = new Ellipse2D.Double(f - (float)n5, f2 - (float)n5, n4, n4);
        Color color = ColorUtils.getDerivedColor(this.faceColor, 0.7f);
        Color color2 = ColorUtils.getDerivedColor(this.faceColor, 0.2f);
        if (n5 > 0) {
            Paint paint = JideSwingUtilities.getRadialGradientPaint(f, f2, n5, new float[]{0.85f, 0.9f, 0.95f, 1.0f}, new Color[]{this.faceColor, color2, color, color2});
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
        if ((n = (int)(0.85 * (double)n5)) > 0) {
            object = new Ellipse2D.Double(f - (float)n, f2 - (float)n, 2 * n, 2 * n);
            Paint paint = JideSwingUtilities.getRadialGradientPaint(f - 0.2f * (float)n, f2 - 0.2f * (float)n, n, new float[]{0.2f, 1.0f}, new Color[]{color, this.faceColor});
            graphics2D.setPaint(paint);
            graphics2D.fill((Shape)object);
        }
        graphics2D.setColor(this.tickColor);
        object = new BasicStroke(4.0f, 1, 1);
        graphics2D.setStroke((Stroke)object);
        double d = 0.0;
        for (int i = 0; i <= 10; ++i) {
            this.paintTick(graphics2D, (int)f, (int)f2, d + 135.0, n5);
            d += 27.0;
        }
        graphics2D.dispose();
        return this.dialImage;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.dialImage == null) {
            this.createDialImage();
        }
        graphics2D.drawImage((Image)this.dialImage, 0, 0, this);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        float f = (float)n2 / 2.0f;
        float f2 = (float)n3 / 2.0f;
        int n4 = Math.min(n2, n3);
        int n5 = n4 / 2;
        graphics2D.setColor(this.tickColor);
        String string = String.format("%2.0f%%", this.value);
        int n6 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, f - (float)n6 / 2.0f, f2 + (float)(2 * n5) / 3.0f - (float)n / 2.0f);
        graphics2D.setStroke(new BasicStroke(1.0f));
        int n7 = this.getAngle();
        this.paintPointer(graphics2D, (int)f, (int)f2, n7, n5);
    }

    private void paintPointer(Graphics2D graphics2D, int n, int n2, double d, int n3) {
        Object object;
        double d2 = 0.05;
        double d3 = 0.8;
        int n4 = (int)(d2 * (double)n3);
        graphics2D.setColor(this.faceColor);
        Color color = ColorUtils.getDerivedColor(this.faceColor, 0.7f);
        Color color2 = ColorUtils.getDerivedColor(this.faceColor, 0.2f);
        int n5 = (int)Math.max(1.0, 3.5 * d2 * (double)n3 - 1.0);
        graphics2D.setPaint(JideSwingUtilities.getRadialGradientPaint(n, n2, n5, new float[]{0.7f, 0.8f, 1.0f}, new Color[]{this.faceColor, color2, color}));
        Ellipse2D.Double double_ = new Ellipse2D.Double(n - n5, n2 - n5, 2 * n5, 2 * n5);
        graphics2D.fill(double_);
        graphics2D.setColor(this.needleColor);
        Polygon polygon = new Polygon();
        int n6 = n - (int)Math.round(0.5 * (double)n4 * Math.sin(this.radians(d)));
        int n7 = n2 + (int)Math.round(0.5 * (double)n4 * Math.cos(this.radians(d)));
        polygon.addPoint(n6, n7);
        int n8 = n + (int)Math.round(0.5 * (double)n4 * Math.sin(this.radians(d)));
        int n9 = n2 - (int)Math.round(0.5 * (double)n4 * Math.cos(this.radians(d)));
        polygon.addPoint(n8, n9);
        int n10 = n + (int)(d3 * (double)n3 * Math.cos(this.radians(d)));
        int n11 = n2 + (int)(d3 * (double)n3 * Math.sin(this.radians(d)));
        polygon.addPoint(n10, n11);
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            object = (Graphics2D)bufferedImage.getGraphics();
            ((Graphics2D)object).translate(-rectangle.x, -rectangle.y);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)object).setPaint(JideSwingUtilities.getRadialGradientPaint(n, n2, n3, new float[]{0.0f, 0.33f}, new Color[]{this.needleColor.darker(), this.needleColor}));
            ((Graphics2D)object).draw(polygon);
            ((Graphics2D)object).fill(polygon);
            ((Graphics)object).dispose();
            BufferedImage bufferedImage2 = this.shadowRenderer.createShadow(bufferedImage);
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        int n12 = (int)Math.max(1.0, 2.0 * d2 * (double)n3 - 1.0);
        graphics2D.setPaint(JideSwingUtilities.getRadialGradientPaint((float)((double)n - 0.15 * (double)n12), (float)((double)n2 - 0.15 * (double)n12), n12, new float[]{0.4f, 0.9f}, new Color[]{this.needleColor, this.needleColor.darker()}));
        object = new Ellipse2D.Double(n - n12, n2 - n12, 2 * n12, 2 * n12);
        graphics2D.fill((Shape)object);
    }

    private void paintTick(Graphics2D graphics2D, int n, int n2, double d, int n3) {
        int n4 = n + (int)(0.75 * (double)n3 * Math.cos(this.radians(d)));
        int n5 = n2 + (int)(0.75 * (double)n3 * Math.sin(this.radians(d)));
        int n6 = n + (int)(0.85 * (double)n3 * Math.cos(this.radians(d)));
        int n7 = n2 + (int)(0.85 * (double)n3 * Math.sin(this.radians(d)));
        graphics2D.drawLine(n4, n5, n6, n7);
    }

    private double radians(double d) {
        return Math.PI * d / 180.0;
    }
}

