/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.Orientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JViewport;

public class LineMarker
implements Drawable,
Frontable {
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_ORIENTATION = "Orientation";
    public static final String PROPERTY_POSITION = "Position";
    public static final String PROPERTY_STROKE = "Stroke";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_AT_FRONT = "At Front";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Stroke stroke = new BasicStroke(1.0f);
    private Chart chart;
    private Color color = new Color(255, 0, 0, 128);
    private double position;
    private Orientation orientation = Orientation.vertical;
    private boolean visible = true;
    private boolean atFront = false;
    private String label;
    private LabelPlacement labelPlacement;
    private Color labelColor;
    private Font labelFont;
    private static final int distanceFromEdge = 4;
    private RenderingHints renderingHints = null;

    public LineMarker() {
    }

    public LineMarker(Chart chart) {
        this.chart = chart;
    }

    public LineMarker(Chart chart, Orientation orientation, double d, Color color) {
        this.chart = chart;
        this.setOrientation(orientation);
        this.setPosition(d);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.labelPlacement;
        this.labelPlacement = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.labelColor;
        this.labelColor = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.labelFont;
        this.labelFont = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        this.chart = chart;
        if (chart != null) {
            chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.renderingHints == null) {
            this.renderingHints = new RenderingHints(key, object);
        } else {
            this.renderingHints.put(key, object);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        this.color = color;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_STROKE, stroke2, stroke);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        Orientation orientation2 = this.orientation;
        this.orientation = orientation;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_ORIENTATION, (Object)orientation2, (Object)orientation);
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        double d2 = this.position;
        this.position = d;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_POSITION, d2, d);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.visible) {
            Object object;
            Object object2;
            if (this.renderingHints != null) {
                object2 = this.renderingHints.entrySet().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    RenderingHints.Key key = (RenderingHints.Key)object.getKey();
                    graphics2D.setRenderingHint(key, object.getValue());
                }
            }
            graphics2D.setStroke(this.stroke);
            if (this.orientation == Orientation.vertical) {
                object2 = this.chart.calculatePixelPoint(new Point2D.Double(this.position, 0.0));
                if (object2 != null) {
                    ((Point)object2).y = this.chart.getYStart();
                    object = new Point(((Point)object2).x, this.chart.getYEnd());
                    graphics2D.setColor(this.color);
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                    if (this.label != null) {
                        this.paintLabel(graphics2D, this.label, ((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                    }
                }
            } else if (this.orientation == Orientation.horizontal && (object2 = this.chart.calculatePixelPoint(new Point2D.Double(0.0, this.position))) != null) {
                ((Point)object2).x = this.chart.getXStart();
                object = new Point(this.chart.getXEnd(), ((Point)object2).y);
                graphics2D.setColor(this.color);
                graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                if (this.label != null) {
                    this.paintLabel(graphics2D, this.label, ((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                }
            }
        }
        graphics2D.dispose();
    }

    private void paintLabel(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.labelFont != null) {
            graphics2D.setFont(this.labelFont);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n7 = fontMetrics.stringWidth(string);
        int n8 = fontMetrics.getHeight();
        int n9 = Math.min(n, n3);
        int n10 = Math.max(n, n3);
        int n11 = Math.max(n2, n4);
        int n12 = Math.min(n2, n4);
        Rectangle rectangle = null;
        Container container = this.chart.getParent();
        if (container != null && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            rectangle = jViewport.getViewRect();
        }
        if (this.orientation == Orientation.vertical) {
            n6 = n9;
            if (this.labelPlacement == LabelPlacement.WEST || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
                n6 -= n7 + 4;
                if (rectangle != null) {
                    n6 += rectangle.x;
                }
            } else if (this.labelPlacement == LabelPlacement.EAST || this.labelPlacement == LabelPlacement.NORTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_EAST) {
                n6 += 4;
                if (rectangle != null) {
                    n6 = n6 - this.chart.getChartWidth() + rectangle.x + rectangle.width;
                }
            } else {
                n6 -= n7 / 2;
                if (rectangle != null) {
                    n6 += rectangle.x;
                }
            }
            if (this.labelPlacement == LabelPlacement.NORTH || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.NORTH_EAST) {
                n5 = n12 + n8;
                if (rectangle != null) {
                    n5 += rectangle.y;
                }
            } else if (this.labelPlacement == LabelPlacement.SOUTH || this.labelPlacement == LabelPlacement.SOUTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
                n5 = n11 - 4;
                if (rectangle != null) {
                    n5 = n5 + this.chart.getChartHeight() + rectangle.y + rectangle.height;
                }
            } else {
                n5 = (n11 + n12) / 2 + n8 / 2;
                if (rectangle != null) {
                    n5 += rectangle.y;
                }
            }
        } else {
            if (this.labelPlacement == LabelPlacement.WEST || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
                n6 = n9 + 4;
                if (rectangle != null) {
                    n6 += rectangle.x;
                }
            } else if (this.labelPlacement == LabelPlacement.EAST || this.labelPlacement == LabelPlacement.NORTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_EAST) {
                n6 = n10 - n7 - 4;
                if (rectangle != null) {
                    n6 = n6 - this.chart.getChartWidth() + rectangle.x + rectangle.width;
                }
            } else {
                n6 = (n9 + n10) / 2 - n7 / 2;
                if (rectangle != null) {
                    n6 += rectangle.x;
                }
            }
            if (this.labelPlacement == LabelPlacement.NORTH || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.NORTH_EAST) {
                n5 = n11 - 4;
                if (rectangle != null) {
                    n5 += rectangle.y;
                }
            } else if (this.labelPlacement == LabelPlacement.SOUTH || this.labelPlacement == LabelPlacement.SOUTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
                n5 = n11 + n8;
                if (rectangle != null) {
                    n5 = n5 + this.chart.getChartHeight() + rectangle.y + rectangle.height;
                }
            } else {
                n5 = n11 + fontMetrics.getAscent() / 2 - 1;
                if (rectangle != null) {
                    n5 += rectangle.y;
                }
            }
        }
        if (this.labelColor != null) {
            graphics2D.setColor(this.labelColor);
        }
        graphics2D.drawString(string, n6, n5);
    }

    @Override
    public boolean isAtFront() {
        return this.atFront;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.atFront;
        this.atFront = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }
}

