/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.LineSmoother;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class DifferenceMarker
implements Drawable,
Frontable,
Shadowable {
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_MODEL1 = "Model1";
    public static final String PROPERTY_MODEL2 = "Model2";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_MODEL1_DOMINANT_FILL = "Model1 Dominant Fill";
    public static final String PROPERTY_MODEL2_DOMINANT_FILL = "Model2 Dominant Fill";
    private static final Color defaultFill = new Color(0, 0, 0, 50);
    private Chart chart;
    private ChartModel model1;
    private ChartModel model2;
    private Polygon polygon;
    private Polygon model1Polygon;
    private Polygon model2Polygon;
    private boolean smooth = false;
    private double smoothness = 0.5;
    private Shape model1Shape;
    private Shape model2Shape;
    private Shape differenceShape;
    private ComponentListener componentListener;
    private ChartModelListener dirtyNoticer;
    private boolean atFront = false;
    private boolean shadowVisible = false;
    private Paint model1DominantFill = defaultFill;
    private Paint model2DominantFill = defaultFill;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public DifferenceMarker() {
        this.polygon = new Polygon();
        this.model1Polygon = new Polygon();
        this.model2Polygon = new Polygon();
        this.dirtyNoticer = new ChartModelListener(){

            @Override
            public void chartModelChanged() {
                DifferenceMarker.this.update();
            }
        };
    }

    public DifferenceMarker(Chart chart) {
        this();
        this.setChart(chart);
    }

    public DifferenceMarker(Chart chart, ChartModel chartModel, ChartModel chartModel2) {
        this();
        this.setChart(chart);
        this.setModel1(chartModel);
        this.setModel2(chartModel2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        if (chart2 != null) {
            chart2.removeComponentListener(this.componentListener);
        }
        this.chart = chart;
        chart.addComponentListener(this.componentListener);
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public ChartModel getModel1() {
        return this.model1;
    }

    public void setModel1(ChartModel chartModel) {
        ChartModel chartModel2 = this.model1;
        if (chartModel2 != null) {
            chartModel2.removeChartModelListener(this.dirtyNoticer);
        }
        this.model1 = chartModel;
        chartModel.addChartModelListener(this.dirtyNoticer);
        this.support.firePropertyChange(PROPERTY_MODEL1, chartModel2, chartModel);
    }

    public ChartModel getModel2() {
        return this.model2;
    }

    public void setModel2(ChartModel chartModel) {
        ChartModel chartModel2 = this.model2;
        if (chartModel2 != null) {
            chartModel2.removeChartModelListener(this.dirtyNoticer);
        }
        this.model2 = chartModel;
        chartModel.addChartModelListener(this.dirtyNoticer);
        this.support.firePropertyChange(PROPERTY_MODEL2, chartModel2, chartModel);
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean bl) {
        this.smooth = bl;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double d) {
        this.smoothness = d;
    }

    public Shape getDifferenceShape() {
        return this.differenceShape;
    }

    public Paint getModel1DominantFill() {
        return this.model1DominantFill;
    }

    public void setModel1DominantFill(Paint paint) {
        Paint paint2 = this.model1DominantFill;
        this.model1DominantFill = paint;
        this.support.firePropertyChange(PROPERTY_MODEL1_DOMINANT_FILL, paint2, paint);
    }

    public Paint getModel2DominantFill() {
        return this.model2DominantFill;
    }

    public void setModel2DominantFill(Paint paint) {
        Paint paint2 = this.model2DominantFill;
        this.model2DominantFill = paint;
        this.support.firePropertyChange(PROPERTY_MODEL2_DOMINANT_FILL, paint2, paint);
    }

    public void setFill(Paint paint) {
        this.setModel1DominantFill(paint);
        this.setModel2DominantFill(paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        this.polygon.reset();
        this.model1Polygon.reset();
        this.model2Polygon.reset();
        if (this.chart != null) {
            if (this.smooth) {
                GeneralPath generalPath = new GeneralPath();
                GeneralPath generalPath2 = new GeneralPath();
                generalPath.moveTo(this.chart.getXStart(), this.chart.getYStart());
                generalPath2.moveTo(this.chart.getXEnd(), this.chart.getYStart());
                GeneralPath generalPath3 = LineSmoother.preparePath(this.chart, this.model1, this.smoothness);
                generalPath.append(generalPath3, true);
                generalPath.lineTo(this.chart.getXEnd(), this.chart.getYStart());
                generalPath.closePath();
                GeneralPath generalPath4 = LineSmoother.preparePath(this.chart, this.model2, this.smoothness, true);
                generalPath2.append(generalPath4, true);
                generalPath2.lineTo(this.chart.getXStart(), this.chart.getYStart());
                generalPath2.closePath();
                GeneralPath generalPath5 = new GeneralPath();
                generalPath5.append(generalPath3, true);
                generalPath5.append(generalPath4, true);
                generalPath5.closePath();
                this.model1Shape = generalPath;
                this.model2Shape = generalPath2;
                this.differenceShape = generalPath5;
            } else {
                int n;
                Point2D point2D;
                Object object;
                this.model1Polygon.addPoint(this.chart.getXStart(), this.chart.getYStart());
                this.model2Polygon.addPoint(this.chart.getXEnd(), this.chart.getYStart());
                Axis axis = this.chart.getAxisForModel(this.model1);
                Axis axis2 = this.chart.getAxisForModel(this.model2);
                assert (axis != null);
                ChartModel chartModel = this.model1;
                synchronized (chartModel) {
                    for (Chartable chartable : this.model1) {
                        object = new Point2D.Double(chartable.getX().position(), chartable.getY().position());
                        point2D = this.chart.calculatePixelPoint((Point2D)object, axis);
                        if (point2D == null) continue;
                        int n2 = this.chart.interpolateXForAnimation(point2D.x, this.model1);
                        n = this.chart.interpolateYForAnimation(point2D.y, this.model1);
                        this.polygon.addPoint(n2, n);
                        this.model1Polygon.addPoint(n2, n);
                    }
                }
                this.model1Polygon.addPoint(this.chart.getXEnd(), this.chart.getYStart());
                chartModel = this.model2;
                synchronized (chartModel) {
                    int n3 = this.model2.getPointCount();
                    for (int i = n3 - 1; i >= 0; --i) {
                        object = this.model2.getPoint(i);
                        point2D = new Point2D.Double(object.getX().position(), object.getY().position());
                        Point point = this.chart.calculatePixelPoint(point2D, axis2);
                        if (point == null) continue;
                        n = this.chart.interpolateXForAnimation(point.x, this.model2);
                        int n4 = this.chart.interpolateYForAnimation(point.y, this.model2);
                        this.polygon.addPoint(n, n4);
                        this.model2Polygon.addPoint(n, n4);
                    }
                }
                this.model2Polygon.addPoint(this.chart.getXStart(), this.chart.getYStart());
                this.model1Shape = this.model1Polygon;
                this.model2Shape = this.model2Polygon;
                this.differenceShape = this.polygon;
            }
        }
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.update();
        if (this.differenceShape != null) {
            Area area;
            Area area2;
            if (this.model1DominantFill != null) {
                graphics2D.setPaint(this.model1DominantFill);
                area2 = new Area(this.differenceShape);
                Area area3 = area = rectangle == null ? null : new Area(rectangle);
                if (area != null) {
                    area2.intersect(area);
                }
                graphics2D.setClip(this.model1Shape);
                graphics2D.fill(area2);
            }
            if (this.model2DominantFill != null) {
                graphics2D.setPaint(this.model2DominantFill);
                area2 = new Area(this.differenceShape);
                Area area4 = area = rectangle == null ? null : new Area(rectangle);
                if (area != null) {
                    area2.intersect(area);
                }
                graphics2D.setClip(this.model2Shape);
                graphics2D.fill(area2);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public boolean isAtFront() {
        return this.atFront;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.atFront;
        this.atFront = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    @Override
    public void setShadowVisible(boolean bl) {
        this.shadowVisible = bl;
    }
}

