/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.BarResizePolicy;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartPainter;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.AxisExtent;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Chartable3D;
import com.jidesoft.chart.model.CopiedChartModel;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.model.SortedChartModel;
import com.jidesoft.chart.model.SummingChartModel;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.range.AggregatedRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class BarPainter
implements ChartPainter {
    private static final Logger logger = Logger.getLogger(BarPainter.class.getName());
    private int barGap;
    private int maxBarWidth = -1;
    private int groupGap;
    private Double groupGapProportion = null;
    private boolean grouped;
    private BarResizePolicy resizePolicy = BarResizePolicy.RESIZE_ALL;
    private final Map<Shape, PointDescriptor> barShapes = Collections.synchronizedMap(new HashMap());
    private Map<Positionable, Double> stackedUpPositions = new HashMap<Positionable, Double>();
    private Map<Positionable, Double> stackedDownPositions = new HashMap<Positionable, Double>();

    BarPainter() {
    }

    public void clearShapes() {
        this.barShapes.clear();
        this.stackedUpPositions.clear();
        this.stackedDownPositions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor containingBar(Point point) {
        Shape shape = null;
        Map<Shape, PointDescriptor> map = this.barShapes;
        synchronized (map) {
            for (Shape shape2 : this.barShapes.keySet()) {
                if (shape2 == null || !shape2.contains(point)) continue;
                if (shape == null) {
                    shape = shape2;
                    continue;
                }
                Rectangle rectangle = shape2.getBounds();
                Rectangle rectangle2 = shape.getBounds();
                if (rectangle.width * rectangle.height >= rectangle2.width * rectangle2.height) continue;
                shape = shape2;
            }
        }
        if (shape == null) {
            return null;
        }
        return this.barShapes.get(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PointDescriptor> containingBars(Point point) {
        ArrayList<PointDescriptor> arrayList = new ArrayList<PointDescriptor>();
        Map<Shape, PointDescriptor> map = this.barShapes;
        synchronized (map) {
            for (Map.Entry<Shape, PointDescriptor> entry : this.barShapes.entrySet()) {
                Shape shape = entry.getKey();
                if (shape == null || !shape.contains(point)) continue;
                PointDescriptor pointDescriptor = entry.getValue();
                arrayList.add(pointDescriptor);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor rendered(Chartable chartable) {
        if (chartable == null) {
            return null;
        }
        Map<Shape, PointDescriptor> map = this.barShapes;
        synchronized (map) {
            for (PointDescriptor pointDescriptor : this.barShapes.values()) {
                PointDescriptor pointDescriptor2;
                if (chartable.equals(pointDescriptor.getChartable())) {
                    return pointDescriptor;
                }
                if (pointDescriptor.getSubPoint() == null || !chartable.equals((pointDescriptor2 = pointDescriptor.getSubPoint()).getChartable())) continue;
                return pointDescriptor2;
            }
        }
        return null;
    }

    public int getBarGap() {
        return this.barGap;
    }

    public void setBarGap(int n) {
        this.barGap = n;
    }

    public int getMaxBarWidth() {
        return this.maxBarWidth;
    }

    public void setMaxBarWidth(int n) {
        this.maxBarWidth = n;
    }

    public int getGroupGap() {
        return this.groupGap;
    }

    public void setGroupGap(int n) {
        this.groupGap = n;
    }

    public Double getGroupGapProportion() {
        return this.groupGapProportion;
    }

    public void setGroupGapProportion(Double d) {
        this.groupGapProportion = d;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean bl) {
        this.grouped = bl;
    }

    public BarResizePolicy getResizePolicy() {
        return this.resizePolicy;
    }

    public void setBarResizePolicy(BarResizePolicy barResizePolicy) {
        this.resizePolicy = barResizePolicy;
    }

    @Override
    public void drawChart(Graphics graphics, Chart chart, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform, boolean bl) {
        Rectangle rectangle = graphics.getClipBounds();
        double d = chart.getAnimationPosition();
        int n2 = BarPainter.barModelCount(chart);
        ChartStyle chartStyle = chart.getStyle(chartModel);
        if (chartStyle != null && chartStyle.isBarsVisible()) {
            Orientation orientation = chartStyle.getBarOrientation();
            CopiedChartModel copiedChartModel = new CopiedChartModel(chartModel);
            SortedChartModel sortedChartModel = new SortedChartModel((ChartModel)copiedChartModel, orientation);
            double d2 = this.getXZero(chart);
            double d3 = this.getYZero(chart);
            Double d4 = this.computeBarWidth(chartStyle);
            int n3 = this.barGap;
            Dimension dimension = chart.getPreferredSize();
            Dimension dimension2 = this.calculatePreferredSize(chart, orientation, d4);
            if (dimension2 != null && !dimension2.equals(dimension)) {
                chart.setPreferredSize(dimension2);
                chart.update();
            }
            Point2D point2D = chart.calculatePixelPoint2D((Point2D)new Point2D.Double(d2, d3), userToPixelTransform);
            List<ChartModel> list = BarPainter.barModels(chart);
            int n4 = list.indexOf(chartModel);
            List<AxisExtent> list2 = BarPainter.calculateBasePositions(chart, sortedChartModel, n4, n2, n3, this.groupGap, this.groupGapProportion, true, this.resizePolicy, chartStyle, userToPixelTransform);
            Axis axis = orientation == null || orientation == Orientation.vertical ? chart.getXAxis() : chart.getYAxis();
            Range<?> range = axis.getRange();
            boolean bl2 = range instanceof CategoryRange;
            int n5 = list2.size();
            CategoryPositionMap categoryPositionMap = bl2 ? new CategoryPositionMap(sortedChartModel, orientation) : null;
            int n6 = -1;
            for (int i = 0; i < n5; ++i) {
                boolean bl3;
                Number number;
                boolean bl4;
                Object object;
                double d5;
                Chartable chartable;
                Object object2;
                Comparable<Range> comparable;
                AxisExtent axisExtent = list2.get(i);
                double d6 = axisExtent.getMax() - axisExtent.getMin();
                if (d4 == null) {
                    d4 = d6;
                }
                if (this.maxBarWidth >= 0 && d6 > (double)this.maxBarWidth) {
                    double d7 = (axisExtent.getMax() + axisExtent.getMin()) / 2.0;
                    double d8 = d7 - (double)this.maxBarWidth / 2.0;
                    double d9 = d7 + (double)this.maxBarWidth / 2.0;
                    axisExtent = new AxisExtent(d8, d9);
                    d4 = this.maxBarWidth;
                }
                if (bl2) {
                    comparable = (CategoryRange)range;
                    List list3 = ((CategoryRange)comparable).getCategoryValues();
                    object2 = list3.get(i);
                    chartable = categoryPositionMap.findPosition((Positionable)object2);
                    if (chartable == null) {
                        Positionable positionable;
                        Positionable positionable2;
                        if (orientation == Orientation.vertical) {
                            positionable2 = object2;
                            positionable = new RealPosition(Double.NaN);
                        } else {
                            positionable2 = new RealPosition(Double.NaN);
                            positionable = object2;
                        }
                        chartable = new ChartPoint(positionable2, positionable);
                    } else {
                        ++n6;
                    }
                } else {
                    ++n6;
                    chartable = sortedChartModel.getPoint(i);
                }
                if (bl && i % 100 == 0 && Thread.interrupted()) {
                    return;
                }
                if (chartable == null) continue;
                comparable = chartable.getX();
                Positionable positionable = chartable.getY();
                if (comparable == null || positionable == null || Double.isNaN(comparable.position()) || Double.isNaN(positionable.position())) continue;
                object2 = chart.calculatePixelPoint2D((Point2D)new Point2D.Double(comparable == null ? 0.0 : comparable.position(), positionable == null ? 0.0 : positionable.position()), userToPixelTransform);
                double d10 = orientation == Orientation.vertical ? axisExtent.getMin() : point2D.getX();
                double d11 = this.computeBarLength(chart, chartModel, orientation, chartable, userToPixelTransform);
                double d12 = orientation == Orientation.vertical ? d4 : d * d11;
                double d13 = d5 = orientation == Orientation.vertical ? d * d11 : d4;
                double d14 = orientation == Orientation.vertical ? (object2 == null ? 0.0 : (positionable.position() >= 0.0 ? ((Point2D)object2).getY() + d11 - d5 : ((Point2D)object2).getY() - d11)) : axisExtent.getMax() + 1.0 - d6;
                if (!this.grouped) {
                    object = orientation == Orientation.vertical ? comparable : positionable;
                    bl4 = d11 >= 0.0;
                    Number number2 = number = bl4 ? this.stackedUpPositions.get(object) : this.stackedDownPositions.get(object);
                    if (number == null) {
                        number = 0.0;
                    }
                    if (bl4) {
                        this.stackedUpPositions.put((Positionable)object, (Double)number + d11);
                    } else {
                        this.stackedDownPositions.put((Positionable)object, (Double)number + d11);
                    }
                    if (orientation == Orientation.vertical) {
                        d14 -= ((Double)number).doubleValue();
                    } else {
                        d10 += ((Double)number).doubleValue();
                    }
                }
                object = chart.getSelectionsForModel(chartModel);
                bl4 = false;
                if (object != null) {
                    number = sortedChartModel.getDelegateIndex(n6);
                    bl4 = object.isSelectedIndex((Integer)number);
                }
                boolean bl5 = bl3 = chart.isRolloverEnabled() && chartable.equals(chart.getCurrentChartPoint());
                if (this.skipCurrentBar(chart, chartable)) continue;
                if (rectangle == null || d10 + d12 > (double)rectangle.x || d10 < (double)(rectangle.x + rectangle.width)) {
                    Object object3;
                    Object object4;
                    if (d5 < 0.0) {
                        d14 += d5;
                        d5 = -d5;
                    }
                    if (d12 < 0.0) {
                        d10 += d12;
                        d12 = -d12;
                    }
                    if (chartModel instanceof SummingChartModel) {
                        int n7;
                        double d15;
                        Chartable chartable2;
                        object4 = (SummingChartModel)chartModel;
                        object3 = sortedChartModel.getDelegateIndex(i);
                        Chartable chartable3 = chartable2 = (Integer)object3 < 0 ? null : ((SummingChartModel)object4).getPoint((Integer)object3);
                        if (chartable2 == null) continue;
                        AggregatedRange aggregatedRange = ((SummingChartModel)object4).getXRange(chartable2.getY());
                        AggregatedRange aggregatedRange2 = ((SummingChartModel)object4).getYRange(chartable2.getX());
                        double d16 = aggregatedRange2 == null ? chartable2.getY().position() : aggregatedRange2.getNegativeSum();
                        double d17 = aggregatedRange == null ? chartable2.getX().position() : aggregatedRange.getNegativeSum();
                        double d18 = aggregatedRange == null ? chartable2.getX().position() : aggregatedRange.getPositiveSum();
                        Point2D.Double double_ = new Point2D.Double(d17, d16);
                        Point point = chart.calculatePixelPoint(double_);
                        double d19 = aggregatedRange2 == null ? chartable2.getY().position() : aggregatedRange2.getPositiveSum();
                        Point2D.Double double_2 = new Point2D.Double(d18, d19);
                        Point point2 = chart.calculatePixelPoint(double_2);
                        Point point3 = chart.calculatePixelPoint(new Point2D.Double(0.0, 0.0));
                        if (orientation == Orientation.vertical) {
                            d5 = Math.abs(((Point2D)point2).getY() - ((Point2D)point).getY());
                            d15 = d * d5;
                            d14 = ((Point2D)point2).getY();
                        } else {
                            d12 = Math.abs(((Point2D)point2).getX() - ((Point2D)point).getX());
                            d15 = d * d12;
                            d10 = ((Point2D)point).getX();
                        }
                        AnnotatedChartModel[] annotatedChartModelArray = ((AbstractDelegatingChartModel)object4).getDelegates();
                        CategoryPositionMap[] categoryPositionMapArray = new CategoryPositionMap[annotatedChartModelArray.length];
                        for (n7 = 0; n7 < categoryPositionMapArray.length; ++n7) {
                            categoryPositionMapArray[n7] = new CategoryPositionMap(annotatedChartModelArray[n7], orientation);
                        }
                        double d20 = orientation == Orientation.vertical ? ((Point2D)point3).getY() : ((Point2D)point3).getX();
                        double d21 = orientation == Orientation.vertical ? ((Point2D)point3).getY() + d * (((Point2D)point).getY() - ((Point2D)point3).getY()) : ((Point2D)point3).getX() - d * (((Point2D)point3).getX() - ((Point2D)point).getX());
                        for (int j = 1; j <= 2; ++j) {
                            for (n7 = 0; n7 < annotatedChartModelArray.length; ++n7) {
                                Rectangle2D.Double double_3;
                                double d22;
                                double d23;
                                Chartable chartable4;
                                AnnotatedChartModel annotatedChartModel = annotatedChartModelArray[n7];
                                object = chart.getSelectionsForModel(annotatedChartModel);
                                bl4 = false;
                                if (object != null) {
                                    bl4 = object.isSelectedIndex(i);
                                }
                                Chartable chartable5 = chartable4 = orientation == Orientation.vertical ? categoryPositionMapArray[n7].findPosition(chartable.getX()) : categoryPositionMapArray[n7].findPosition(chartable.getY());
                                if (chartable4 == null) {
                                    d23 = 0.0;
                                } else if (orientation == Orientation.vertical) {
                                    Positionable positionable3 = chartable4.getY();
                                    d23 = positionable3 == null ? 0.0 : positionable3.position();
                                } else {
                                    Positionable positionable4 = chartable4.getX();
                                    double d24 = d23 = positionable4 == null ? 0.0 : positionable4.position();
                                }
                                if (j == 1 && d23 >= 0.0 || j == 2 && d23 < 0.0) continue;
                                double d25 = orientation == Orientation.vertical ? (aggregatedRange2 == null ? 0.0 : Math.abs(aggregatedRange2.getNegativeSum()) + aggregatedRange2.getPositiveSum()) : (aggregatedRange == null ? 0.0 : Math.abs(aggregatedRange.getNegativeSum()) + aggregatedRange.getPositiveSum());
                                double d26 = d25 == 0.0 ? 0.0 : Math.abs(d23) / d25;
                                double d27 = d4;
                                if (chartStyle.getBarWidthProportion() != null) {
                                    d27 = d4 * chartStyle.getBarWidthProportion();
                                }
                                double d28 = orientation == Orientation.vertical ? d26 * d15 : d27;
                                double d29 = d22 = orientation == Orientation.vertical ? d27 : d26 * d15;
                                if (orientation == Orientation.vertical) {
                                    if (d23 >= 0.0) {
                                        double_3 = new Rectangle2D.Double(d10, d20 -= d28, d12, d28);
                                    } else {
                                        double_3 = new Rectangle2D.Double(d10, d21 - d28, d12, d28);
                                        d21 -= d28;
                                    }
                                } else if (d23 >= 0.0) {
                                    double_3 = new Rectangle2D.Double(d20, d14, d22, d5);
                                    d20 += d22;
                                } else {
                                    double_3 = new Rectangle2D.Double((d21 += d22) - d22, d14, d22, d5);
                                }
                                boolean bl6 = bl3 = chart.isRolloverEnabled() && chartable4 != null && chartable4.equals(chart.getCurrentChartPoint());
                                if (!(((RectangularShape)double_3).getHeight() >= 0.0) || !(((RectangularShape)double_3).getWidth() >= 0.0)) continue;
                                Shape shape = this.renderBar(graphics, chart, annotatedChartModel, chartable4, bl4, bl3, false, ((RectangularShape)double_3).getX(), ((RectangularShape)double_3).getY(), ((RectangularShape)double_3).getWidth(), ((RectangularShape)double_3).getHeight());
                                if (!chart.isRecordingShapes() || chartable4 == null) continue;
                                PointDescriptor pointDescriptor = new PointDescriptor(chartable4, i, annotatedChartModel);
                                pointDescriptor.setShape(shape);
                                this.barShapes.put(shape, pointDescriptor);
                            }
                        }
                        continue;
                    }
                    if (!(d12 > 0.0) || !(d5 >= 0.0)) continue;
                    object4 = this.renderBar(graphics, chart, sortedChartModel.getDelegate(), chartable, bl4, bl3, false, d10, d14, d12, d5);
                    if (!chart.isRecordingShapes()) continue;
                    object3 = new PointDescriptor(chartable, n6, chartModel);
                    ((PointDescriptor)object3).setShape((Shape)object4);
                    this.barShapes.put((Shape)object4, (PointDescriptor)object3);
                    continue;
                }
                if (orientation == Orientation.horizontal && d10 > (double)(rectangle.x + rectangle.width)) break;
            }
            sortedChartModel.setDelegate(null);
        }
    }

    private Pair<Chartable, Double> findYForX(ChartModel chartModel, Chartable chartable) {
        double d = 0.0;
        Chartable chartable2 = null;
        Positionable positionable = chartable.getX();
        for (int i = 0; i < chartModel.getPointCount(); ++i) {
            chartable2 = chartModel.getPoint(i);
            Positionable positionable2 = chartable2.getX();
            if (positionable == null || positionable2 == null || positionable.position() != positionable2.position() && !positionable.equals(positionable2)) continue;
            d = chartable2.getY().position();
            if (!Double.isNaN(d)) break;
            d = 0.0;
            break;
        }
        return new Pair<Chartable, Double>(chartable2, d);
    }

    private Pair<Chartable, Double> findXForY(ChartModel chartModel, Chartable chartable) {
        double d = 0.0;
        Chartable chartable2 = null;
        Positionable positionable = chartable.getY();
        for (int i = 0; i < chartModel.getPointCount(); ++i) {
            chartable2 = chartModel.getPoint(i);
            Positionable positionable2 = chartable2.getY();
            if (positionable == null || positionable2 == null || positionable.position() != positionable2.position() && !positionable.equals(positionable2)) continue;
            d = chartable2.getX().position();
            if (!Double.isNaN(d)) break;
            d = 0.0;
            break;
        }
        return new Pair<Chartable, Double>(chartable2, d);
    }

    private double getXZero(Chart chart) {
        Axis axis = chart.getXAxis();
        Axis axis2 = chart.getYAxis();
        double d = axis.maximum() >= 0.0 ? Math.max(0.0, axis.minimum()) : Math.min(0.0, axis.maximum());
        if (axis.getAxisTransform() != null) {
            d = axis.getAxisTransform().inverseTransform(d);
        }
        if (axis2.getPlacement() == AxisPlacement.FLOATING) {
            d = chart.getYAxis().getFloatingPosition();
        }
        return d;
    }

    private double getYZero(Chart chart) {
        Axis axis = chart.getXAxis();
        Axis axis2 = chart.getYAxis();
        double d = axis2.maximum() >= 0.0 ? Math.max(0.0, axis2.minimum()) : Math.min(0.0, axis2.maximum());
        if (axis2.getAxisTransform() != null) {
            d = axis2.getAxisTransform().inverseTransform(d);
        }
        if (axis.getPlacement() == AxisPlacement.FLOATING) {
            d = chart.getXAxis().getFloatingPosition();
        }
        return d;
    }

    private Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3, double d4) {
        BarRenderer barRenderer = chart.getBarRenderer(chartModel);
        if (barRenderer instanceof BarRenderer2D) {
            BarRenderer2D barRenderer2D = (BarRenderer2D)barRenderer;
            return barRenderer2D.renderBar((Graphics2D)graphics, chart, chartModel, chartable, bl, bl2, false, d, d2, d3, d4);
        }
        return barRenderer.renderBar(graphics, chart, chartModel, chartable, bl, bl2, false, (int)Math.round(d), (int)d2, (int)Math.round(d3), (int)d4);
    }

    double computeBarLength(Chart chart, ChartModel chartModel, Orientation orientation, Chartable chartable, UserToPixelTransform userToPixelTransform) {
        double d;
        double d2;
        double d3;
        Object object;
        Object object2;
        if (chartable == null) {
            return 0.0;
        }
        Positionable positionable = chartable.getX();
        Positionable positionable2 = chartable.getY();
        if (positionable == null || positionable2 == null) {
            return 0.0;
        }
        Axis axis = chart.getAxisForModel(chartModel);
        double d4 = chart.convertYToPrimary(positionable2.position(), axis);
        if (chartable instanceof Chartable3D) {
            object2 = (Chartable3D)chartable;
            object = object2.getZ();
            d3 = object == null ? 0.0 : object.position();
            d2 = Math.min(positionable2.position(), d4 -= d3);
            d = Math.max(positionable2.position(), d4);
        } else {
            double d5 = this.getYZero(chart);
            d2 = Math.min(d4, d5);
            d = Math.max(d4, d5);
        }
        object2 = chart.calculatePixelPoint2D(new Point2D.Double(this.getXZero(chart), d2));
        object = chart.calculatePixelPoint2D(new Point2D.Double(positionable.position(), d));
        d3 = orientation == Orientation.vertical ? (object2 == null || object == null || Double.isNaN(positionable2.position()) ? 0.0 : ((Point2D)object2).getY() - ((Point2D)object).getY()) : (object2 == null || object == null || Double.isNaN(positionable.position()) ? 0.0 : ((Point2D)object).getX() - ((Point2D)object2).getX());
        return d3;
    }

    private Double computeBarWidth(ChartStyle chartStyle) {
        Double d;
        if (!chartStyle.isBarsVisible()) {
            return 0.0;
        }
        Double d2 = d = chartStyle.getBarWidth() == null ? null : Double.valueOf(chartStyle.getBarWidth().doubleValue());
        if (d != null && this.maxBarWidth >= 0 && d > (double)this.maxBarWidth) {
            d = this.maxBarWidth;
        }
        return d;
    }

    private int calculateBaseBreadth(Chart chart, Orientation orientation, double d) {
        int n;
        double d2;
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(chart.getModels());
        double d3 = 0.0;
        if (this.isCategorical(chart, orientation)) {
            Axis axis = orientation == Orientation.vertical ? chart.getXAxis() : chart.getYAxis();
            ChartModel chartModel = axis == null ? null : (CategoryRange)axis.getRange();
            d2 = chartModel == null ? 1.0 : ((CategoryRange)((Object)chartModel)).size();
        } else {
            for (ChartModel chartModel : arrayList) {
                ChartStyle chartStyle = chart.getStyle(chartModel);
                if (!chartStyle.isBarsVisible() || !((double)chartModel.getPointCount() > d3)) continue;
                d3 = chartModel.getPointCount();
            }
            d2 = d3 + 1.0;
        }
        boolean bl = chart.isBarsGrouped();
        int n2 = chart.getBarGap();
        int n3 = chart.getBarGroupGap();
        if (bl) {
            double d4 = 0.0;
            for (ChartModel chartModel : arrayList) {
                Double d5;
                ChartStyle chartStyle = chart.getStyle(chartModel);
                if (chartStyle == null) {
                    chartStyle = new ChartStyle();
                }
                d4 += (d5 = this.computeBarWidth(chartStyle)) == null ? 0.0 : d5 + (double)n2;
            }
            n = (int)(d2 * (d4 + (double)n3));
        } else {
            n = (int)(d2 * (d + (double)n2));
        }
        return n;
    }

    public Dimension calculatePreferredSize(Chart chart, Orientation orientation, Double d) {
        BarResizePolicy barResizePolicy = chart.getBarResizePolicy();
        if (d != null && barResizePolicy == BarResizePolicy.RESIZE_OFF) {
            Dimension dimension = chart.getPreferredSize();
            int n = this.calculateBaseBreadth(chart, orientation, d);
            if (orientation == Orientation.vertical) {
                int n2 = 0;
                int n3 = chart.getYAxisCount();
                for (int i = 0; i < n3; ++i) {
                    Axis axis = chart.getYAxis(i);
                    n2 += chart.axisWidth(axis);
                }
                return new Dimension(n2 + n, dimension.height);
            }
            if (orientation == Orientation.horizontal) {
                int n4 = chart.axisWidth(chart.getXAxis());
                return new Dimension(dimension.width, n4 + n);
            }
        }
        return null;
    }

    public Dimension calculatePreferredChartAreaSize(Chart chart, Orientation orientation, Double d) {
        BarResizePolicy barResizePolicy = chart.getBarResizePolicy();
        if (d != null && barResizePolicy == BarResizePolicy.RESIZE_OFF) {
            Dimension dimension = chart.getPreferredSize();
            int n = this.calculateBaseBreadth(chart, orientation, d);
            if (orientation == Orientation.vertical) {
                return new Dimension(n, dimension.height);
            }
            if (orientation == Orientation.horizontal) {
                return new Dimension(dimension.width, n);
            }
        }
        return null;
    }

    private boolean skipCurrentBar(Chart chart, Chartable chartable) {
        ChartStyle chartStyle;
        Highlightable highlightable;
        Highlight highlight;
        return chartable instanceof Highlightable && (highlight = (highlightable = (Highlightable)((Object)chartable)).getHighlight()) != null && (chartStyle = chart.getHighlightStyle(highlight)) != null && !chartStyle.isBarsVisible();
    }

    public int computeAxisBreadth(Chart chart) {
        List<ChartModel> list = BarPainter.barModels(chart);
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (ChartModel chartModel : list) {
            UserToPixelTransform userToPixelTransform = chart.getTransformForModel(chartModel);
            ChartStyle chartStyle = chart.getStyle(chartModel);
            if (chartStyle == null || !chartStyle.isBarsVisible()) continue;
            Orientation orientation = chartStyle.getBarOrientation();
            CopiedChartModel copiedChartModel = new CopiedChartModel(chartModel);
            SortedChartModel sortedChartModel = new SortedChartModel((ChartModel)copiedChartModel, orientation);
            List<AxisExtent> list2 = BarPainter.calculateBasePositions(chart, chartModel, n4, n, this.barGap, this.groupGap, this.groupGapProportion, false, this.resizePolicy, chartStyle, userToPixelTransform);
            for (AxisExtent axisExtent : list2) {
                double d = axisExtent.getMax() - axisExtent.getMin();
                double d2 = this.grouped ? d / (double)n : d;
                n2 = (int)((double)n2 + d2);
            }
            ++n4;
            n3 += chartModel.getPointCount();
            sortedChartModel.setDelegate(null);
        }
        int n5 = n3 == 0 ? 0 : n2 / n3;
        return (int)(0.4 * (double)n5);
    }

    private static int barModelCount(Chart chart) {
        return BarPainter.barModels(chart).size();
    }

    private static List<ChartModel> barModels(Chart chart) {
        List<ChartModel> list = chart.getModels();
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>();
        for (ChartModel chartModel : list) {
            ChartStyle chartStyle = chart.getStyle(chartModel);
            if (chartStyle == null || !chartStyle.isBarsVisible()) continue;
            arrayList.add(chartModel);
        }
        return arrayList;
    }

    private boolean isCategorical(Chart chart, Orientation orientation) {
        Axis axis = orientation == null || orientation == Orientation.vertical ? chart.getXAxis() : chart.getYAxis();
        Range<?> range = axis.getRange();
        return range instanceof CategoryRange;
    }

    static List<AxisExtent> calculateBasePositions(Chart chart, ChartModel chartModel, int n, int n2, int n3, int n4, Double d, boolean bl, BarResizePolicy barResizePolicy, ChartStyle chartStyle, UserToPixelTransform userToPixelTransform) {
        assert (chartModel != null);
        Dimension dimension = chart.getSize();
        if (dimension != null && (dimension.width == 0 || dimension.height == 0)) {
            return new ArrayList<AxisExtent>();
        }
        if (n < 0) {
            n = 0;
        }
        int n5 = chartModel.getPointCount();
        ArrayList<AxisExtent> arrayList = new ArrayList<AxisExtent>(n5);
        Point2D point2D = null;
        Point2D point2D2 = null;
        double d2 = 0.0;
        if (chartStyle != null && chartStyle.isBarsVisible()) {
            boolean bl2;
            Double d3 = chartStyle.getBarWidth() == null ? null : Double.valueOf(chartStyle.getBarWidth().intValue());
            Orientation orientation = chartStyle.getBarOrientation();
            Axis axis = orientation == null || orientation == Orientation.vertical ? chart.getXAxis() : chart.getYAxis();
            Range<?> range = axis.getRange();
            boolean bl3 = range instanceof CategoryRange;
            if (bl3) {
                return BarPainter.calculateCategoryBasePositions(chart, chartModel, n, n2, n3, n4, d, bl, barResizePolicy, chartStyle, userToPixelTransform);
            }
            boolean bl4 = bl2 = d3 != null;
            if (barResizePolicy == BarResizePolicy.RESIZE_ALL || d3 == null) {
                int n6;
                int n7 = n6 = orientation == Orientation.horizontal ? chart.getChartHeight() : chart.getChartWidth();
                assert (n6 >= 0);
                if (!bl2 || bl2 && (double)(n5 + 1) * d3 > (double)n6) {
                    d3 = (double)n6 / ((double)n5 + 1.0);
                }
            }
            AxisExtent axisExtent = null;
            for (int i = 0; i < n5; ++i) {
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                AxisExtent axisExtent2;
                Point2D point2D3;
                Object object;
                Positionable positionable;
                Chartable chartable = chartModel.getPoint(i);
                boolean bl5 = i == 0;
                boolean bl6 = i == n5 - 1;
                Positionable positionable2 = chartable == null ? null : chartable.getX();
                Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
                if (bl5) {
                    object = positionable2 == null || positionable == null ? null : new Point2D.Double(positionable2.position(), positionable.position());
                    point2D2 = object == null ? null : chart.calculatePixelPoint2D((Point2D)object, userToPixelTransform);
                }
                Chartable chartable2 = i + 1 < n5 ? chartModel.getPoint(i + 1) : null;
                object = chartable2 == null ? null : chartable2.getX();
                Positionable positionable4 = chartable2 == null ? null : chartable2.getY();
                Point2D.Double double_ = object == null || positionable4 == null ? null : new Point2D.Double(object.position(), positionable4.position());
                Point2D point2D4 = point2D3 = double_ == null ? null : chart.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                if (point2D2 == null || Double.isInfinite(point2D2.getX()) || Double.isInfinite(point2D2.getY())) {
                    axisExtent2 = new AxisExtent(0, 0);
                } else {
                    if (bl5 && bl6 || bl2 && barResizePolicy == BarResizePolicy.RESIZE_OFF) {
                        point2D3 = orientation == Orientation.vertical ? new Point2D.Double(point2D2.getX() + d3 + (double)n3, point2D2.getY()) : new Point2D.Double(point2D2.getX(), point2D2.getY() - d3 - (double)n3);
                    }
                    axisExtent2 = orientation == Orientation.vertical ? BarPainter.determineVBarDimensions(bl5, bl6, point2D, point2D2, point2D3, d2) : BarPainter.determineHBarDimensions(bl5, bl6, point2D, point2D2, point2D3, d2);
                }
                d2 = orientation == Orientation.vertical ? axisExtent2.getMax() : axisExtent2.getMin();
                axisExtent2 = BarPainter.allowForGroupGap(axisExtent2, d, n4);
                if (bl && chart.isBarsGrouped()) {
                    if (orientation == Orientation.vertical) {
                        d8 = axisExtent2.size();
                        d7 = (double)n * d8 / (double)n2;
                        d6 = (double)(n + 1) * d8 / (double)n2;
                        axisExtent2 = new AxisExtent(axisExtent2.getMin() + d7, axisExtent2.getMin() + d6);
                    } else {
                        double d9 = axisExtent2.size();
                        int n8 = n2 - n - 1;
                        d5 = (double)n8 * d9 / (double)n2;
                        d4 = (double)(n8 + 1) * d9 / (double)n2;
                        axisExtent2 = new AxisExtent(axisExtent2.getMin() + d5, axisExtent2.getMin() + d4);
                    }
                }
                if (bl2 && axisExtent2.size() - (double)n3 < d3) {
                    double d10;
                    double d11;
                    d8 = axisExtent2.size();
                    d6 = d8 / (d3 + (double)n3);
                    if (barResizePolicy == BarResizePolicy.RESIZE_ALL) {
                        d7 = d6 * d3;
                        d11 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d10 = d11 - d7 / 2.0;
                        axisExtent2 = new AxisExtent(d10, d10 + d7);
                    } else {
                        d7 = d3;
                        if (axisExtent != null) {
                            d11 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                            d10 = d11 - d7 / 2.0;
                            if (orientation == Orientation.vertical) {
                                if (d10 < axisExtent.getMax()) {
                                    d10 = axisExtent.getMax();
                                }
                                axisExtent2 = new AxisExtent(d10, d10 + d7);
                            } else {
                                if (d10 < axisExtent.getMin()) {
                                    d10 = axisExtent.getMin();
                                }
                                axisExtent2 = new AxisExtent(d10 - d7, d10);
                            }
                        }
                    }
                } else {
                    double d12;
                    Double d13 = chartStyle.getBarWidthProportion();
                    if (d13 != null) {
                        d12 = axisExtent2.size() * d13;
                        d5 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d4 = d5 - d12 / 2.0;
                        axisExtent2 = new AxisExtent(d4, d4 + d12);
                    }
                    if (n3 != 0) {
                        d12 = axisExtent2.size() - (double)n3;
                        if (d12 <= 0.0) {
                            d12 = 0.0;
                        }
                        d5 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d4 = d5 - d12 / 2.0;
                        axisExtent2 = new AxisExtent(d4, d4 + d12);
                    }
                    if (bl2) {
                        d12 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d5 = d12 - d3 / 2.0;
                        axisExtent2 = new AxisExtent(d5, d5 + d3);
                    }
                }
                arrayList.add(axisExtent2);
                point2D = point2D2;
                point2D2 = point2D3;
                axisExtent = axisExtent2;
            }
        }
        return arrayList;
    }

    private static Chartable chartableAtPosition(Positionable positionable, Orientation orientation) {
        Positionable positionable2;
        Positionable positionable3;
        if (orientation == Orientation.vertical) {
            positionable3 = positionable;
            positionable2 = new RealPosition(Double.NaN);
        } else {
            positionable3 = new RealPosition(Double.NaN);
            positionable2 = positionable;
        }
        return new ChartPoint(positionable3, positionable2);
    }

    private static AxisExtent allowForGroupGap(AxisExtent axisExtent, Double d, int n) {
        if (d != null && d >= 0.0) {
            n = (int)(d * axisExtent.size());
        }
        if (n != 0) {
            double d2 = axisExtent.size() - (double)n;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            double d3 = (axisExtent.getMin() + axisExtent.getMax()) / 2.0;
            double d4 = d3 - d2 / 2.0;
            axisExtent = new AxisExtent(d4, d4 + d2);
        }
        return axisExtent;
    }

    static List<AxisExtent> calculateCategoryBasePositions(Chart chart, ChartModel chartModel, int n, int n2, int n3, int n4, Double d, boolean bl, BarResizePolicy barResizePolicy, ChartStyle chartStyle, UserToPixelTransform userToPixelTransform) {
        Orientation orientation;
        assert (chartModel != null);
        assert (chartStyle != null);
        if (n < 0) {
            n = 0;
        }
        Axis axis = (orientation = chartStyle.getBarOrientation()) == null || orientation == Orientation.vertical ? chart.getXAxis() : chart.getYAxis();
        CategoryRange categoryRange = (CategoryRange)axis.getRange();
        List list = categoryRange.getCategoryValues();
        int n5 = list.size();
        ArrayList<AxisExtent> arrayList = new ArrayList<AxisExtent>(n5);
        Point2D point2D = null;
        Point2D point2D2 = null;
        double d2 = 0.0;
        if (chartStyle != null && chartStyle.isBarsVisible()) {
            boolean bl2;
            Double d3 = chartStyle.getBarWidth() == null ? null : Double.valueOf(chartStyle.getBarWidth().doubleValue());
            boolean bl3 = bl2 = d3 != null;
            if (barResizePolicy == BarResizePolicy.RESIZE_ALL || d3 == null) {
                int n6;
                int n7 = n6 = orientation == Orientation.horizontal ? chart.getChartHeight() : chart.getChartWidth();
                assert (n6 >= 0);
                if (!bl2 || bl2 && (double)(n5 + 1) * d3 > (double)n6) {
                    d3 = (double)n6 / ((double)n5 + 1.0);
                }
            }
            AxisExtent axisExtent = null;
            CategoryPositionMap categoryPositionMap = new CategoryPositionMap(new CopiedChartModel(chartModel), orientation);
            for (int i = 0; i < n5; ++i) {
                double d4;
                double d5;
                double d6;
                double d7;
                AxisExtent axisExtent2;
                Point2D point2D3;
                Chartable chartable;
                Point2D.Double double_;
                Positionable positionable;
                boolean bl4;
                Positionable positionable2 = list.get(i);
                Chartable chartable2 = categoryPositionMap.findPosition(positionable2);
                if (chartable2 == null) {
                    chartable2 = BarPainter.chartableAtPosition(positionable2, orientation);
                }
                boolean bl5 = i == 0;
                boolean bl6 = bl4 = i == n5 - 1;
                assert (chartable2 != null);
                Positionable positionable3 = orientation == Orientation.vertical ? positionable2 : chartable2.getX();
                Positionable positionable4 = positionable = orientation == Orientation.horizontal ? positionable2 : chartable2.getY();
                if (bl5) {
                    double_ = positionable3 == null || positionable == null ? null : new Point2D.Double(positionable3.position(), positionable.position());
                    point2D2 = double_ == null ? null : chart.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                }
                double_ = i + 1 < n5 ? (Positionable)list.get(i + 1) : null;
                Chartable chartable3 = chartable = double_ == null ? null : categoryPositionMap.findPosition((Positionable)((Object)double_));
                if (chartable == null) {
                    chartable = BarPainter.chartableAtPosition((Positionable)((Object)double_), orientation);
                }
                Positionable positionable5 = chartable.getX();
                Positionable positionable6 = chartable.getY();
                Point2D.Double double_2 = positionable5 == null || positionable6 == null ? null : new Point2D.Double(positionable5.position(), positionable6.position());
                Point2D point2D4 = point2D3 = double_2 == null ? null : chart.calculatePixelPoint2D((Point2D)double_2, userToPixelTransform);
                if (point2D2 == null || Double.isInfinite(point2D2.getX()) || Double.isInfinite(point2D2.getY())) {
                    axisExtent2 = new AxisExtent(0, 0);
                } else {
                    if (bl2 && barResizePolicy == BarResizePolicy.RESIZE_OFF) {
                        int n8;
                        int n9 = n8 = chart.isBarsGrouped() ? n2 : 1;
                        point2D3 = orientation == Orientation.vertical ? new Point2D.Double(point2D2.getX() + (double)n8 * (d3 + (double)n3) + (double)n4, point2D2.getY()) : new Point2D.Double(point2D2.getX(), point2D2.getY() - (double)n8 * (d3 + (double)n3) - (double)n4);
                    } else if (bl5 && bl4) {
                        point2D3 = orientation == Orientation.vertical ? new Point2D.Double(point2D2.getX() + (d3 + (double)n3), point2D2.getY()) : new Point2D.Double(point2D2.getX(), point2D2.getY() - (d3 + (double)n3));
                    }
                    axisExtent2 = orientation == Orientation.vertical ? BarPainter.determineVBarDimensions(bl5, bl4, point2D, point2D2, point2D3, d2) : BarPainter.determineHBarDimensions(bl5, bl4, point2D, point2D2, point2D3, d2);
                }
                d2 = orientation == Orientation.vertical ? axisExtent2.getMax() : axisExtent2.getMin();
                axisExtent2 = BarPainter.allowForGroupGap(axisExtent2, d, n4);
                if (bl && chart.isBarsGrouped()) {
                    if (orientation == Orientation.vertical) {
                        double d8 = axisExtent2.size();
                        d7 = (double)n * d8 / (double)n2;
                        d6 = (double)(n + 1) * d8 / (double)n2;
                        axisExtent2 = new AxisExtent(axisExtent2.getMin() + d7, axisExtent2.getMin() + d6);
                    } else {
                        double d9 = axisExtent2.size();
                        int n10 = n2 - n - 1;
                        d5 = (double)n10 * d9 / (double)n2;
                        d4 = (double)(n10 + 1) * d9 / (double)n2;
                        axisExtent2 = new AxisExtent(axisExtent2.getMin() + d5, axisExtent2.getMin() + d4);
                    }
                }
                if (bl2 && axisExtent2.size() - (double)n3 < d3) {
                    double d10;
                    double d11;
                    double d12 = axisExtent2.size();
                    d6 = d12 / (d3 + (double)n3);
                    if (barResizePolicy == BarResizePolicy.RESIZE_ALL) {
                        d7 = d6 * d3;
                        d11 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d10 = d11 - d7 / 2.0;
                        axisExtent2 = new AxisExtent(d10, d10 + d7);
                    } else {
                        d7 = d3;
                        if (axisExtent != null) {
                            d11 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                            d10 = d11 - d7 / 2.0;
                            if (orientation == Orientation.vertical) {
                                if (d10 < axisExtent.getMax()) {
                                    d10 = axisExtent.getMax();
                                }
                                axisExtent2 = new AxisExtent(d10, d10 + d7);
                            } else {
                                if (d10 < axisExtent.getMin()) {
                                    d10 = axisExtent.getMin();
                                }
                                axisExtent2 = new AxisExtent(d10 - d7, d10);
                            }
                        }
                    }
                } else {
                    double d13;
                    Double d14 = chartStyle.getBarWidthProportion();
                    if (d14 != null) {
                        d13 = axisExtent2.size() * d14;
                        d5 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d4 = d5 - d13 / 2.0;
                        axisExtent2 = new AxisExtent(d4, d4 + d13);
                    }
                    if (n3 != 0) {
                        d13 = axisExtent2.size() - (double)n3;
                        if (d13 <= 0.0) {
                            d13 = 0.0;
                        }
                        d5 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d4 = d5 - d13 / 2.0;
                        axisExtent2 = new AxisExtent(d4, d4 + d13);
                    }
                    if (bl2) {
                        d13 = (axisExtent2.getMin() + axisExtent2.getMax()) / 2.0;
                        d5 = d13 - d3 / 2.0;
                        axisExtent2 = new AxisExtent(d5, d5 + d3);
                    }
                }
                arrayList.add(axisExtent2);
                point2D = point2D2;
                point2D2 = point2D3;
                axisExtent = axisExtent2;
            }
        }
        return arrayList;
    }

    private static AxisExtent determineHBarDimensions(boolean bl, boolean bl2, Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        double d2 = point2D == null ? 0.0 : point2D.getY();
        double d3 = point2D3 == null ? point2D2.getY() - (d2 + point2D2.getY()) / 2.0 : (point2D2.getY() + point2D3.getY()) / 2.0;
        double d4 = bl ? (point2D3 == null ? point2D2.getY() - (d2 - point2D2.getY()) / 2.0 : point2D2.getY() - (point2D3.getY() - point2D2.getY()) / 2.0) : d;
        double d5 = Math.abs(d3 - d4);
        if (bl) {
            if (point2D3 != null) {
                d5 = Math.abs(point2D3.getY() - point2D2.getY());
            } else {
                d4 += d5;
            }
        } else if (bl2 && point2D != null) {
            d5 = Math.abs(point2D2.getY() - point2D.getY());
        }
        double d6 = d4;
        double d7 = d4 + d5;
        double d8 = Math.min(Math.abs(d6 - point2D2.getY()), Math.abs(d7 - point2D2.getY()));
        return new AxisExtent(point2D2.getY() - d8, point2D2.getY() + d8);
    }

    private static AxisExtent determineVBarDimensions(boolean bl, boolean bl2, Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        double d2;
        double d3 = point2D == null ? 0.0 : point2D.getX();
        double d4 = d2 = point2D3 == null ? point2D2.getX() + (point2D2.getX() - d3) / 2.0 : (point2D3.getX() + point2D2.getX()) / 2.0;
        double d5 = bl ? (point2D3 == null ? point2D2.getX() - (point2D2.getX() - d3) / 2.0 : point2D2.getX() - (point2D3.getX() - point2D2.getX()) / 2.0) : d;
        double d6 = Math.abs(d2 - d5);
        if (bl && !bl2) {
            if (point2D3 != null) {
                d6 = Math.abs(point2D3.getX() - point2D2.getX());
            }
        } else if (bl2 && point2D != null) {
            d6 = Math.abs(point2D2.getX() - point2D.getX());
        }
        double d7 = d5;
        double d8 = d5 + d6;
        double d9 = point2D2.getX();
        double d10 = Math.min(Math.abs(d9 - d7), Math.abs(d8 - d9));
        return new AxisExtent(d9 - d10, d9 + d10);
    }

    static class CategoryPositionMap {
        private Orientation orientation;
        private Map<Positionable, Chartable> positionMap;
        private Map<String, Chartable> stringMap;

        public CategoryPositionMap(ChartModel chartModel, Orientation orientation) {
            this.orientation = orientation;
            this.positionMap = new HashMap<Positionable, Chartable>(chartModel.getPointCount());
            this.stringMap = new HashMap<String, Chartable>(chartModel.getPointCount());
            this.init(chartModel);
        }

        protected void init(ChartModel chartModel) {
            for (Chartable chartable : chartModel) {
                Positionable positionable;
                if (chartable == null || (positionable = this.orientation == Orientation.vertical ? chartable.getX() : chartable.getY()) == null) continue;
                this.positionMap.put(positionable, chartable);
                double d = positionable.position();
                this.stringMap.put(Double.toString(d), chartable);
            }
        }

        public Chartable findPosition(Positionable positionable) {
            Chartable chartable = this.positionMap.get(positionable);
            if (chartable == null) {
                double d = positionable.position();
                chartable = this.stringMap.get(Double.toString(d));
            }
            return chartable;
        }
    }
}

