/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.util.SwingExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class AbstractBackgroundTask<V>
implements Runnable,
Future<V> {
    private final FutureTask<V> computation = new Computation();

    AbstractBackgroundTask() {
    }

    protected void setProgress(final int n, final int n2) {
        SwingExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                AbstractBackgroundTask.this.onProgress(n, n2);
            }
        });
    }

    protected abstract V compute() throws Exception;

    protected void onCompletion(V v, Throwable throwable, boolean bl) {
    }

    protected void onProgress(int n, int n2) {
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.computation.cancel(bl);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.computation.get();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.computation.get(l, timeUnit);
    }

    @Override
    public boolean isCancelled() {
        return this.computation.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.computation.isDone();
    }

    @Override
    public void run() {
        this.computation.run();
    }

    private class Computation
    extends FutureTask<V> {
        public Computation() {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return AbstractBackgroundTask.this.compute();
                }
            });
        }

        @Override
        protected final void done() {
            SwingExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    Object v = null;
                    Throwable throwable = null;
                    boolean bl = false;
                    try {
                        v = Computation.this.get();
                    }
                    catch (ExecutionException executionException) {
                        throwable = executionException.getCause();
                    }
                    catch (CancellationException cancellationException) {
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    finally {
                        AbstractBackgroundTask.this.onCompletion(v, throwable, bl);
                    }
                }
            });
        }
    }
}

