/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.animation;

import com.jidesoft.animation.Function;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.event.EventListenerList;

public class CustomAnimation
implements Serializable,
Cloneable {
    public static final int TYPE_ENTRANCE = 0;
    public static final int TYPE_EXIT = 1;
    private int _type;
    public static final int EFFECT_FLY = 100;
    public static final int EFFECT_ZOOM = 101;
    public static final int EFFECT_FADE = 201;
    private int _effect = 100;
    int _initDelay = 0;
    public static final int SMOOTHNESS_VERY_SMOOTH = 100;
    public static final int SMOOTHNESS_SMOOTH = 50;
    public static final int SMOOTHNESS_MEDIUM = 20;
    public static final int SMOOTHNESS_ROUGH = 10;
    public static final int SMOOTHNESS_VERY_ROUGH = 5;
    private int _smoothness = 20;
    public static final int SPEED_VERY_SLOW = 200;
    public static final int SPEED_SLOW = 100;
    public static final int SPEED_MEDIUM = 50;
    public static final int SPEED_FAST = 25;
    public static final int SPEED_VERY_FAST = 10;
    private int _speed = 50;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CENTER = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM_LEFT = 5;
    public static final int BOTTOM_RIGHT = 6;
    public static final int TOP_LEFT = 7;
    public static final int TOP_RIGHT = 8;
    public static final int LEFT_DOWN = 0;
    public static final int LEFT_UP = 1;
    public static final int RIGHT_DOWN = 2;
    public static final int RIGHT_UP = 3;
    private int _direction = 1;
    private int _secondaryDirection;
    private Point _startLocation;
    private Point _endLocation;
    private Rectangle _visibleBounds;
    private Animator _animator;
    private Image _screenImage;
    private Callback _callback;
    private Function _functionX;
    private Function _functionY;
    private Function _functionZoom;
    private Function _functionFade;
    public static Function FUNC_LINEAR = new Function(){

        @Override
        public double calculate(int n, int n2) {
            return (double)n / (double)n2;
        }
    };
    public static Function FUNC_POW_HALF = new Function(){

        @Override
        public double calculate(int n, int n2) {
            return Math.pow((double)n / (double)n2, 0.5);
        }
    };
    public static Function FUNC_POW2 = new Function(){

        @Override
        public double calculate(int n, int n2) {
            return Math.pow((double)n / (double)n2, 2.0);
        }
    };
    public static Function FUNC_POW3 = new Function(){

        @Override
        public double calculate(int n, int n2) {
            return Math.pow((double)n / (double)n2, 3.0);
        }
    };
    public static Function FUNC_LOG = new Function(){

        @Override
        public double calculate(int n, int n2) {
            return Math.log((double)n / (double)n2);
        }
    };
    public static Function FUNC_BOUNCE = new Function(){

        @Override
        public double calculate(int n, int n2) {
            double d = (double)n / (double)n2;
            if (d == 0.0) {
                return 0.0;
            }
            return 1.0 - Math.abs(Math.sin(d * 9.4) / (d * 10.0));
        }
    };
    public static Function FUNC_VIBRATE = new Function(){

        @Override
        public double calculate(int n, int n2) {
            double d = (double)n / (double)n2;
            if (d == 0.0) {
                return 0.0;
            }
            return 1.0 - Math.sin(d * 9.4) / (d * 10.0);
        }
    };
    private AnimatorListener _animatorListener;
    private EventListenerList _listenerList = new EventListenerList();

    public CustomAnimation() {
    }

    public CustomAnimation(int n, int n2, int n3, int n4) {
        this._type = n;
        this._effect = n2;
        this._smoothness = n3;
        this._speed = n4;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public int getEffect() {
        return this._effect;
    }

    public void setEffect(int n) {
        this._effect = n;
    }

    public int getInitDelay() {
        return this._initDelay;
    }

    public void setInitDelay(int n) {
        this._initDelay = n;
    }

    public int getSmoothness() {
        return this._smoothness;
    }

    public void setSmoothness(int n) {
        this._smoothness = n;
    }

    public int getSpeed() {
        return this._speed;
    }

    public void setSpeed(int n) {
        this._speed = n;
    }

    public int getDirection() {
        return this._direction;
    }

    public void setDirection(int n) {
        this._direction = n;
    }

    public int getSecondaryDirection() {
        return this._secondaryDirection;
    }

    public void setSecondaryDirection(int n) {
        this._secondaryDirection = n;
    }

    public Point getStartLocation() {
        return this._startLocation;
    }

    public void setStartLocation(Point point) {
        this._startLocation = point;
    }

    public Point getEndLocation() {
        return this._endLocation;
    }

    public void setEndLocation(Point point) {
        this._endLocation = point;
    }

    public Rectangle getVisibleBounds() {
        if (this._visibleBounds == null) {
            return PortingUtils.getLocalScreenBounds();
        }
        return this._visibleBounds;
    }

    public void setVisibleBounds(Rectangle rectangle) {
        this._visibleBounds = rectangle;
    }

    public void start(Component component) {
        if (this._animator != null) {
            this._animator.stop();
            this._animator = null;
        }
        this._animator = new Animator(component, this.getInitDelay(), this.getSpeed(), this.getSmoothness());
        this.customizeAnimator(this._animator);
        if (this._listenerList != null) {
            AnimatorListener[] animatorListenerArray;
            for (AnimatorListener animatorListener : animatorListenerArray = this.getAnimatorListeners()) {
                this._animator.addAnimatorListener(animatorListener);
            }
        }
        this._animator.start();
    }

    public AnimatorListener getAnimatorListener() {
        return this._animatorListener;
    }

    public void setAnimatorListener(AnimatorListener animatorListener) {
        this._animatorListener = animatorListener;
    }

    public void addAnimatorListener(AnimatorListener animatorListener) {
        this._listenerList.add(AnimatorListener.class, animatorListener);
    }

    public void removeAnimatorListener(AnimatorListener animatorListener) {
        this._listenerList.remove(AnimatorListener.class, animatorListener);
    }

    public AnimatorListener[] getAnimatorListeners() {
        return (AnimatorListener[])this._listenerList.getListeners(AnimatorListener.class);
    }

    protected void customizeAnimator(Animator animator) {
        AnimatorListener animatorListener = this.getAnimatorListener();
        if (animatorListener != null) {
            animator.addAnimatorListener(animatorListener);
        } else {
            block0 : switch (this.getEffect()) {
                case 201: {
                    switch (this.getType()) {
                        case 0: {
                            this.setupAnimatorForFadeEntrance(animator);
                            break;
                        }
                        case 1: {
                            this.setupAnimatorForFadeExit(animator);
                        }
                    }
                    break;
                }
                case 101: {
                    switch (this.getType()) {
                        case 0: {
                            this.setupAnimatorForZoomEntrance(animator);
                            break;
                        }
                        case 1: {
                            this.setupAnimatorForZoomExit(animator);
                        }
                    }
                    break;
                }
                case 100: {
                    switch (this.getType()) {
                        case 0: {
                            this.setupAnimatorForFlyEntrance(animator);
                            break block0;
                        }
                        case 1: {
                            this.setupAnimatorForFlyExit(animator);
                        }
                    }
                }
            }
        }
    }

    public void stop() {
        if (this._animator != null) {
            this._animator.stop();
            this._animator = null;
        }
    }

    protected double getPercentX(int n, int n2) {
        if (this.getFunctionX() == null) {
            return FUNC_LINEAR.calculate(n, n2);
        }
        return this.getFunctionX().calculate(n, n2);
    }

    protected double getPercentY(int n, int n2) {
        if (this.getFunctionY() == null) {
            return FUNC_LINEAR.calculate(n, n2);
        }
        return this.getFunctionY().calculate(n, n2);
    }

    protected double getPercentFade(int n, int n2) {
        if (this.getFunctionFade() == null) {
            return FUNC_LINEAR.calculate(n, n2);
        }
        return this.getFunctionFade().calculate(n, n2);
    }

    protected double getPercentZoom(int n, int n2) {
        if (this.getFunctionZoom() == null) {
            return FUNC_LINEAR.calculate(n, n2);
        }
        return this.getFunctionZoom().calculate(n, n2);
    }

    public Image getScreenImage() {
        return this._screenImage;
    }

    public void setScreenImage(Image image) {
        this._screenImage = image;
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void setCallback(Callback callback) {
        this._callback = callback;
    }

    private void setupAnimatorForZoomEntrance(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point _el;
            private Point _sl;
            private int _deltaX;
            private int _deltaY;
            private Dimension _ss;
            private Dimension _es;
            private int _deltaW;
            private int _deltaH;

            @Override
            public void animationStarts(Component component) {
                this._el = CustomAnimation.this.getEndLocation() != null ? CustomAnimation.this.getEndLocation() : component.getLocation();
                Dimension dimension = component.getSize();
                if (CustomAnimation.this.getStartLocation() != null) {
                    this._sl = CustomAnimation.this.getStartLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this._sl = new Point(this._el.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this._sl = new Point(this._el.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this._el.y);
                            break;
                        }
                        case 2: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this._el.y);
                        }
                    }
                }
                this._deltaX = this._el.x - this._sl.x;
                this._deltaY = this._el.y - this._sl.y;
                component.setLocation(this._sl);
                this._ss = new Dimension(0, 0);
                this._es = dimension;
                this._deltaW = this._es.width - this._ss.width;
                this._deltaH = this._es.height - this._ss.height;
                component.setSize(this._ss);
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                component.setLocation(this._el.x - (int)((double)this._deltaX * (1.0 - CustomAnimation.this.getPercentX(n2, n))), this._el.y - (int)((double)this._deltaY * (1.0 - CustomAnimation.this.getPercentY(n2, n))));
                component.setSize((int)((double)this._deltaW * CustomAnimation.this.getPercentZoom(n2, n)), (int)((double)this._deltaH * CustomAnimation.this.getPercentZoom(n2, n)));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this._el);
                component.setSize(this._es);
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void setupAnimatorForZoomExit(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point _el;
            private Point _sl;
            private int _deltaX;
            private int _deltaY;
            private Dimension _ss;
            private Dimension _es;
            private int _deltaW;
            private int _deltaH;

            @Override
            public void animationStarts(Component component) {
                Dimension dimension = component.getSize();
                Point point = this._sl = CustomAnimation.this.getStartLocation() == null ? component.getLocation() : CustomAnimation.this.getStartLocation();
                if (CustomAnimation.this.getEndLocation() != null) {
                    this._el = CustomAnimation.this.getEndLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this._el = new Point(this._sl.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this._el = new Point(this._sl.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this._sl.y);
                            break;
                        }
                        case 2: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this._sl.y);
                        }
                    }
                }
                this._deltaX = this._el.x - this._sl.x;
                this._deltaY = this._el.y - this._sl.y;
                this._ss = new Dimension(0, 0);
                this._es = dimension;
                this._deltaW = this._es.width - this._ss.width;
                this._deltaH = this._es.height - this._ss.height;
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                component.setLocation(this._el.x - (int)((double)this._deltaX * (1.0 - CustomAnimation.this.getPercentX(n2, n))), this._el.y - (int)((double)this._deltaY * (1.0 - CustomAnimation.this.getPercentY(n2, n))));
                int n3 = (int)((double)this._deltaW * (1.0 - CustomAnimation.this.getPercentZoom(n2, n)));
                int n4 = (int)((double)this._deltaH * (1.0 - CustomAnimation.this.getPercentZoom(n2, n)));
                component.setSize(Math.max(1, n3), Math.max(1, n4));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this._el);
                component.setSize(this._es);
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void setupAnimatorForFlyEntrance(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point _el;
            private Point _sl;
            private int _deltaX;
            private int _deltaY;

            @Override
            public void animationStarts(Component component) {
                this._el = CustomAnimation.this.getEndLocation() != null ? CustomAnimation.this.getEndLocation() : component.getLocation();
                Dimension dimension = component.getSize();
                if (CustomAnimation.this.getStartLocation() != null) {
                    this._sl = CustomAnimation.this.getStartLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this._sl = new Point(this._el.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this._sl = new Point(this._el.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this._el.y);
                            break;
                        }
                        case 2: {
                            this._sl = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this._el.y);
                        }
                    }
                }
                this._deltaX = this._el.x - this._sl.x;
                this._deltaY = this._el.y - this._sl.y;
                component.setLocation(this._sl);
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                component.setLocation(this._el.x - (int)((double)this._deltaX * (1.0 - CustomAnimation.this.getPercentX(n2, n))), this._el.y - (int)((double)this._deltaY * (1.0 - CustomAnimation.this.getPercentY(n2, n))));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this._el);
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void setupAnimatorForFlyExit(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point _el;
            private Point _sl;
            private int _deltaX;
            private int _deltaY;

            @Override
            public void animationStarts(Component component) {
                Dimension dimension = component.getSize();
                Point point = this._sl = CustomAnimation.this.getStartLocation() == null ? component.getLocation() : CustomAnimation.this.getStartLocation();
                if (CustomAnimation.this.getEndLocation() != null) {
                    this._el = CustomAnimation.this.getEndLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this._el = new Point(this._sl.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this._el = new Point(this._sl.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this._sl.y);
                            break;
                        }
                        case 2: {
                            this._el = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this._sl.y);
                        }
                    }
                }
                this._deltaX = this._el.x - this._sl.x;
                this._deltaY = this._el.y - this._sl.y;
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                component.setLocation(this._el.x - (int)((double)this._deltaX * (1.0 - CustomAnimation.this.getPercentX(n2, n))), this._el.y - (int)((double)this._deltaY * (1.0 - CustomAnimation.this.getPercentY(n2, n))));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this._el);
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void setupAnimatorForFadeEntrance(final Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private BackgroundPanel _panel;
            private Window _window;

            @Override
            public void animationStarts(final Component component) {
                Rectangle rectangle = new Rectangle();
                Point point = CustomAnimation.this.getEndLocation();
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = component.getWidth();
                rectangle.height = component.getHeight();
                if (!SecurityUtils.isTranslucentWindowFeatureDisabled() && component instanceof Window) {
                    this._window = (Window)component;
                    JideSwingUtilities.setWindowOpacity(this._window, 0.0f);
                    ((RootPaneContainer)((Object)this._window)).getContentPane().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            JideSwingUtilities.setWindowOpacity(_window, 1.0f);
                        }
                    });
                } else if (component instanceof RootPaneContainer) {
                    this._panel = new BackgroundPanel();
                    this._panel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            ((RootPaneContainer)((Object)component)).getLayeredPane().remove(_panel);
                            _panel = null;
                            component.repaint();
                        }
                    });
                    Image image = component.isDisplayable() ? component.createImage(rectangle.width, rectangle.height) : new BufferedImage(rectangle.width, rectangle.height, 2);
                    Graphics graphics = image.getGraphics();
                    if (CustomAnimation.this.getScreenImage() != null) {
                        graphics.drawImage(CustomAnimation.this.getScreenImage(), 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
                    }
                    this._panel.setImage(image);
                    this._panel.setPercent(1.0);
                    ((RootPaneContainer)((Object)component)).getLayeredPane().add((Component)this._panel, JLayeredPane.POPUP_LAYER);
                    this._panel.setBounds(0, 0, rectangle.width, rectangle.height);
                }
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                double d = CustomAnimation.this.getPercentFade(n2, n);
                if (this._window != null) {
                    JideSwingUtilities.setWindowOpacity(this._window, (float)d);
                } else if (this._panel != null) {
                    this._panel.setPercent(1.0 - d);
                    this._panel.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void setupAnimatorForFadeExit(final Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private BackgroundPanel _panel;
            private Window _window;

            @Override
            public void animationStarts(final Component component) {
                Rectangle rectangle = new Rectangle();
                Point point = CustomAnimation.this.getStartLocation();
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = component.getWidth();
                rectangle.height = component.getHeight();
                if (!SecurityUtils.isTranslucentWindowFeatureDisabled() && component instanceof Window) {
                    this._window = (Window)component;
                    ((RootPaneContainer)((Object)this._window)).getContentPane().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            JideSwingUtilities.setWindowOpacity(_window, 1.0f);
                        }
                    });
                } else if (component instanceof RootPaneContainer) {
                    this._panel = new BackgroundPanel();
                    this._panel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            ((RootPaneContainer)((Object)component)).getLayeredPane().remove(_panel);
                            _panel = null;
                            component.repaint();
                        }
                    });
                    Image image = component.isDisplayable() ? component.createImage(rectangle.width, rectangle.height) : new BufferedImage(rectangle.width, rectangle.height, 2);
                    Graphics graphics = image.getGraphics();
                    if (CustomAnimation.this.getScreenImage() != null) {
                        graphics.drawImage(CustomAnimation.this.getScreenImage(), 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
                    }
                    this._panel.setImage(image);
                    this._panel.setPercent(0.0);
                    ((RootPaneContainer)((Object)component)).getLayeredPane().add((Component)this._panel, JLayeredPane.POPUP_LAYER);
                    this._panel.setBounds(0, 0, rectangle.width, rectangle.height);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                double d = CustomAnimation.this.getPercentFade(n2, n);
                if (this._window != null) {
                    JideSwingUtilities.setWindowOpacity(this._window, 1.0f - (float)d);
                } else if (this._panel != null) {
                    this._panel.setPercent(d);
                    this._panel.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    public Function getFunctionX() {
        return this._functionX;
    }

    public void setFunctionX(Function function) {
        this._functionX = function;
    }

    public Function getFunctionY() {
        return this._functionY;
    }

    public void setFunctionY(Function function) {
        this._functionY = function;
    }

    public Function getFunctionFade() {
        return this._functionFade;
    }

    public void setFunctionFade(Function function) {
        this._functionFade = function;
    }

    public Function getFunctionZoom() {
        return this._functionZoom;
    }

    public void setFunctionZoom(Function function) {
        this._functionZoom = function;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isRunning() {
        return this._animator != null && this._animator.isRunning();
    }

    class BackgroundPanel
    extends JPanel {
        double _percent;
        Image _image;

        public BackgroundPanel() {
            this.setOpaque(false);
        }

        public void setPercent(double d) {
            this._percent = d;
        }

        public void setImage(Image image) {
            this._image = image;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this._percent != 0.0) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this._percent));
                graphics2D.drawImage(this._image, 0, 0, this.getWidth(), this.getHeight(), this);
                graphics2D.setComposite(composite);
            }
        }
    }

    public static interface Callback {
        public void performed();
    }
}

