/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.ContentContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;

class DockableBarUtils {
    DockableBarUtils() {
    }

    public static int sideOfComponent(Component component, int n, int n2) {
        int n3 = Math.min(20, component.getWidth() / 3);
        int n4 = Math.min(20, component.getHeight() / 3);
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < component.getHeight()) {
            return 7;
        }
        if (n >= component.getWidth() - n3 && n < component.getWidth() && n2 >= 0 && n2 <= component.getHeight()) {
            return 3;
        }
        if (n2 >= 0 && n2 < n4 && n >= 0 && n < component.getWidth()) {
            return 1;
        }
        if (n2 >= component.getHeight() - n4 && n2 < component.getHeight() && n >= 0 && n <= component.getWidth()) {
            return 5;
        }
        return 0;
    }

    static void saveClosePreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getClosePreviousState());
        dockableBar.getContext().setClosePreviousState(PreviousState.createPreviousState(dockableBar));
    }

    static void saveHiddenPreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getHiddenPreviousState());
        dockableBar.getContext().setHiddenPreviousState(PreviousState.createPreviousState(dockableBar));
    }

    static void saveFloatPreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getFloatPreviousState());
        dockableBar.getContext().setFloatPreviousState(PreviousState.createPreviousState(dockableBar));
    }

    static void saveDockPreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getDockPreviousState());
        dockableBar.getContext().setDockPreviousState(PreviousState.createPreviousState(dockableBar));
    }

    public static Container getDockableBarContainer(DockableBarManager dockableBarManager, Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof DockableBarContainer && ((DockableBarContainer)component).getDockableBarManager() == dockableBarManager) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container container = (Container)component; container != null; container = container.getParent()) {
            if (!(container instanceof DockableBarContainer) || ((DockableBarContainer)container).getDockableBarManager() != dockableBarManager) continue;
            return container;
        }
        return null;
    }

    public static Container getDockableBarOrContainer(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof DockableBarContainer) {
            return (Container)component;
        }
        if (component instanceof DockableBar) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container container = (Container)component; container != null; container = container.getParent()) {
            if (container instanceof DockableBarContainer) {
                return container;
            }
            if (!(container instanceof DockableBar)) continue;
            return container;
        }
        return null;
    }

    public static Container findNearbyDockableBarContainerAt(DockableBarManager dockableBarManager, Container container, Point point, int n) {
        Container container2 = DockableBarUtils.findDockableBarContainerAt(dockableBarManager, container, point);
        if (container2 != null) {
            return container2;
        }
        Point[] pointArray = new Point[]{new Point(point.x, point.y - n), new Point(point.x - n, point.y), new Point(point.x, point.y + n), new Point(point.x + n, point.y)};
        for (int i = 0; i < pointArray.length && (container2 = DockableBarUtils.findDockableBarContainerAt(dockableBarManager, container, pointArray[i])) == null; ++i) {
        }
        return container2;
    }

    public static Container findDockableBarContainerAt(DockableBarManager dockableBarManager, Container container, Point point) {
        Component component = container.findComponentAt(point);
        return DockableBarUtils.getDockableBarContainer(dockableBarManager, component);
    }

    private static Container findContentContainer(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof ContentContainer) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container container = (Container)component; container != null; container = container.getParent()) {
            if (!(container instanceof ContentContainer)) continue;
            return container;
        }
        return null;
    }

    public static Container findContentContainerAt(Container container, Point point) {
        Component component = container.findComponentAt(point);
        return DockableBarUtils.findContentContainer(component);
    }

    public static int convertSideToDockSide(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 8;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException(n + " is not a valid side in SwingConstants.");
    }

    public static int convertDockSideToSide(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 3;
            }
        }
        throw new IllegalArgumentException(n + " is not a valid DOCK_SIDE.");
    }

    static void saveAvailablePreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getAvailablePreviousState());
        dockableBar.getContext().setAvailablePreviousState(PreviousState.createPreviousState(dockableBar));
    }
}

