/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.PortingUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockableBarPersistenceUtils {
    private static final String NODE_CONTEXT = "DockableBarContext";
    private static final String NODE_PREVIOUS_STATE = "DockableBarPreviousState";
    private static final String NODE_CHILD = "DockableBarChild";
    private static final String NODE_PARENT_STATE = "DockableBarParentState";
    private static final String NODE_DOCKABLE_BAR_CONTAINER = "DockableBarContainer";
    private static final String NODE_FLOATING_BAR_CONTAINER = "FloatingBarContainer";
    private static final String NODE_DOCKABLE_BAR_LIST = "DockableBarList";
    private static final String NODE_DOCKABLE_BAR_ITEM = "DockableBarItem";
    private static final String NODE_DOCKABLE_BAR = "DockableBar";
    private static final String NODE_UNDOCKED_BOUNDS = "UndockedBounds";
    private static final String NODE_BOUNDS = "Bounds";
    private static final String ATTRIBUTE_FRAME_STATE = "frameState";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_DOCK_ID = "dockId";
    private static final String ATTRIBUTE_INIT_SIDE = "initSide";
    private static final String ATTRIBUTE_INIT_INDEX = "initIndex";
    private static final String ATTRIBUTE_INIT_POSITION = "initPosition";
    private static final String ATTRIBUTE_INIT_MODE = "initMode";
    private static final String ATTRIBUTE_CURRENT_MODE = "currentMode";
    private static final String ATTRIBUTE_CURRENT_DOCK_SIDE = "currentDockSide";
    private static final String ATTRIBUTE_DOCKED_WIDTH = "dockedWidth";
    private static final String ATTRIBUTE_DOCKED_HEIGHT = "dockedHeight";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_SIDE = "side";
    private static final String ATTRIBUTE_FC_ID = "fcId";
    private static final String ATTRIBUTE_START = "start";
    private static final String ATTRIBUTE_ROW = "row";
    private static final String ATTRIBUTE_NEW_ROW = "newRow";
    private static final String ATTRIBUTE_CC_ID = "ccId";
    private static final String ATTRIBUTE_ORIENTATION = "orientation";
    private static final String ATTRIBUTE_PREFERRED_ROW_COUNT = "preferredRowCount";
    private static final String ATTRIBUTE_X = "x";
    private static final String ATTRIBUTE_Y = "y";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String PREVIOUS_STATE_HIDDEN = "hidden";
    private static final String PREVIOUS_STATE_DOCK = "dock";
    private static final String PREVIOUS_STATE_CLOSE = "close";
    private static final String PREVIOUS_STATE_FLOAT = "float";
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    public static void save(DefaultDockableBarManager defaultDockableBarManager, String string) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(defaultDockableBarManager, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockableBarManager defaultDockableBarManager, String string, String string2) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(defaultDockableBarManager, string, string2, null);
    }

    public static void save(final DefaultDockableBarManager defaultDockableBarManager, final String string, final String string2, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockableBarPersistenceUtils.save(defaultDockableBarManager, save);
            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DockableBarPersistenceUtils.save(defaultDockableBarManager, save);
                            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(DefaultDockableBarManager defaultDockableBarManager, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(defaultDockableBarManager, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockableBarManager defaultDockableBarManager, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(defaultDockableBarManager, outputStream, string, null);
    }

    public static void save(final DefaultDockableBarManager defaultDockableBarManager, final OutputStream outputStream, final String string, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockableBarPersistenceUtils.save(defaultDockableBarManager, save);
            PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document document = DockableBarPersistenceUtils.save(defaultDockableBarManager, save);
                        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
    }

    public static Document save(DefaultDockableBarManager defaultDockableBarManager, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DockableBarPersistenceUtils.saveToDocument(defaultDockableBarManager, document, save);
        return document;
    }

    static void saveToDocument(DefaultDockableBarManager defaultDockableBarManager, Document document, PersistenceUtilsCallback.Save save) {
        Object object;
        Object object2;
        Rectangle rectangle;
        if (defaultDockableBarManager == null || defaultDockableBarManager.isLoadingLayoutData()) {
            return;
        }
        defaultDockableBarManager.removeExtraFloatingDockableBars();
        defaultDockableBarManager.saveCurrentContext();
        Node node = document.getElementsByTagName("LayoutPersistence").item(0);
        if (node == null) {
            node = document.createElement("LayoutPersistence");
            document.appendChild(node);
        }
        Element element = document.createElement("DockableBarManager");
        node.appendChild(element);
        element.setAttribute("version", "" + defaultDockableBarManager.getVersion());
        if (defaultDockableBarManager.getLayoutPersistenceName() != null) {
            element.setAttribute("persistenceName", defaultDockableBarManager.getLayoutPersistenceName());
        }
        if ((rectangle = defaultDockableBarManager.getUnmaximizedBounds()) != null) {
            object2 = document.createElement(NODE_UNDOCKED_BOUNDS);
            element.appendChild((Node)object2);
            object2.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            object2.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            object2.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            object2.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        if (defaultDockableBarManager.getRootPaneContainer() instanceof Frame) {
            element.setAttribute(ATTRIBUTE_FRAME_STATE, "" + PortingUtils.getFrameState((Frame)((Object)defaultDockableBarManager.getRootPaneContainer())));
        }
        DockableBarPersistenceUtils.writeAllContexts(document, element, defaultDockableBarManager, save);
        object2 = defaultDockableBarManager.getDockableBarContainer(3);
        if (object2 != null && ((DockableBarContainer)object2).getDockableBarList() != null && ((DockableBarContainer)object2).getDockableBarList().size() > 0) {
            object = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            element.appendChild((Node)object);
            object.setAttribute(ATTRIBUTE_SIDE, "3");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, (Element)object, (DockableBarContainer)object2, save);
        }
        if ((object2 = defaultDockableBarManager.getDockableBarContainer(5)) != null && ((DockableBarContainer)object2).getDockableBarList() != null && ((DockableBarContainer)object2).getDockableBarList().size() > 0) {
            object = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            element.appendChild((Node)object);
            object.setAttribute(ATTRIBUTE_SIDE, "5");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, (Element)object, (DockableBarContainer)object2, save);
        }
        if ((object2 = defaultDockableBarManager.getDockableBarContainer(7)) != null && ((DockableBarContainer)object2).getDockableBarList() != null && ((DockableBarContainer)object2).getDockableBarList().size() > 0) {
            object = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            element.appendChild((Node)object);
            object.setAttribute(ATTRIBUTE_SIDE, "7");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, (Element)object, (DockableBarContainer)object2, save);
        }
        if ((object2 = defaultDockableBarManager.getDockableBarContainer(1)) != null && ((DockableBarContainer)object2).getDockableBarList() != null && ((DockableBarContainer)object2).getDockableBarList().size() > 0) {
            object = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            element.appendChild((Node)object);
            object.setAttribute(ATTRIBUTE_SIDE, "1");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, (Element)object, (DockableBarContainer)object2, save);
        }
        if ((object = defaultDockableBarManager._floatingDockableBars) != null && ((ArrayList)object).size() > 0) {
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                FloatingDockableBarContainer floatingDockableBarContainer = (FloatingDockableBarContainer)iterator.next();
                Element element2 = document.createElement(NODE_FLOATING_BAR_CONTAINER);
                element.appendChild(element2);
                DockableBarPersistenceUtils.writeFloatingContainer(document, element2, floatingDockableBarContainer, save);
            }
        }
        if (save != null) {
            save.save(document, element, defaultDockableBarManager);
        }
    }

    private static void writeFloatingContainer(Document document, Element element, FloatingDockableBarContainer floatingDockableBarContainer, PersistenceUtilsCallback.Save save) {
        boolean bl;
        Rectangle rectangle = floatingDockableBarContainer.getBounds();
        int n = rectangle.y;
        boolean bl2 = bl = n >= -5000;
        if (!bl) {
            rectangle.y += 10000;
        }
        Element element2 = document.createElement(NODE_BOUNDS);
        element.appendChild(element2);
        element2.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
        element2.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
        element2.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
        element2.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        for (int i = 0; i < floatingDockableBarContainer.getContentPane().getComponentCount(); ++i) {
            Component component = floatingDockableBarContainer.getContentPane().getComponent(i);
            if (!(component instanceof DockableBar)) continue;
            Element element3 = document.createElement(NODE_DOCKABLE_BAR);
            element.appendChild(element3);
            DockableBarPersistenceUtils.writeDockableBar(document, element3, (DockableBar)component, save);
        }
    }

    private static void writeDockableBarContainer(Document document, Element element, DockableBarContainer dockableBarContainer, PersistenceUtilsCallback.Save save) {
        element.setAttribute(ATTRIBUTE_SIDE, "" + dockableBarContainer.getSide());
        DockableBarListList dockableBarListList = dockableBarContainer.getDockableBarList();
        for (Object e : dockableBarListList) {
            if (!(e instanceof DockableBarList) || ((DockableBarList)e).size() <= 0) continue;
            Element element2 = document.createElement(NODE_DOCKABLE_BAR_LIST);
            element.appendChild(element2);
            for (Object e2 : (DockableBarList)e) {
                if (!(e2 instanceof DockableBarItem)) continue;
                Element element3 = document.createElement(NODE_DOCKABLE_BAR_ITEM);
                element2.appendChild(element3);
                element3.setAttribute(ATTRIBUTE_START, "" + ((DockableBarItem)e2).getStart());
                Component component = ((DockableBarItem)e2).getComponent();
                if (!(component instanceof DockableBar)) continue;
                Element element4 = document.createElement(NODE_DOCKABLE_BAR);
                element3.appendChild(element4);
                DockableBarPersistenceUtils.writeDockableBar(document, element4, (DockableBar)component, save);
            }
        }
        if (save != null) {
            save.save(document, element, dockableBarContainer);
        }
    }

    private static void writeDockableBar(Document document, Element element, DockableBar dockableBar, PersistenceUtilsCallback.Save save) {
        element.setAttribute(ATTRIBUTE_KEY, dockableBar.getKey());
        if (dockableBar instanceof CommandBar) {
            element.setAttribute(ATTRIBUTE_PREFERRED_ROW_COUNT, "" + ((CommandBar)dockableBar).getPreferredRowCount());
        }
        if (save != null) {
            save.save(document, element, dockableBar);
        }
    }

    private static void writeAllContexts(Document document, Element element, DefaultDockableBarManager defaultDockableBarManager, PersistenceUtilsCallback.Save save) {
        Map<String, DockableBarContext> map = defaultDockableBarManager.getAllContexts();
        Set<String> set = map.keySet();
        for (String string : set) {
            Element element2;
            DockableBarContext dockableBarContext = map.get(string);
            Element element3 = document.createElement(NODE_CONTEXT);
            element.appendChild(element3);
            element3.setAttribute(ATTRIBUTE_KEY, string);
            element3.setAttribute(ATTRIBUTE_DOCK_ID, "" + dockableBarContext.getDockID());
            element3.setAttribute(ATTRIBUTE_INIT_SIDE, "" + dockableBarContext.getInitSide());
            element3.setAttribute(ATTRIBUTE_INIT_INDEX, "" + dockableBarContext.getInitIndex());
            element3.setAttribute(ATTRIBUTE_INIT_POSITION, dockableBarContext.isInitPosition() ? "1" : "0");
            element3.setAttribute(ATTRIBUTE_INIT_MODE, "" + dockableBarContext.getInitMode());
            element3.setAttribute(ATTRIBUTE_CURRENT_MODE, "" + dockableBarContext.getCurrentMode());
            element3.setAttribute(ATTRIBUTE_CURRENT_DOCK_SIDE, "" + dockableBarContext.getCurrentDockSide());
            element3.setAttribute(ATTRIBUTE_DOCKED_WIDTH, "" + dockableBarContext.getDockedWidth());
            element3.setAttribute(ATTRIBUTE_DOCKED_HEIGHT, "" + dockableBarContext.getDockedHeight());
            Rectangle rectangle = dockableBarContext.getUndockedBounds();
            if (rectangle != null) {
                element2 = document.createElement(NODE_UNDOCKED_BOUNDS);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
                element2.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
                element2.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
                element2.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
            }
            if (dockableBarContext.getHiddenPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_HIDDEN);
                DockableBarPersistenceUtils.writePreviousState(document, element2, dockableBarContext.getHiddenPreviousState(), save);
            }
            if (dockableBarContext.getClosePreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_CLOSE);
                DockableBarPersistenceUtils.writePreviousState(document, element2, dockableBarContext.getClosePreviousState(), save);
            }
            if (dockableBarContext.getDockPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_DOCK);
                DockableBarPersistenceUtils.writePreviousState(document, element2, dockableBarContext.getDockPreviousState(), save);
            }
            if (dockableBarContext.getFloatPreviousState() != null) {
                element2 = document.createElement(NODE_PREVIOUS_STATE);
                element3.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_FLOAT);
                DockableBarPersistenceUtils.writePreviousState(document, element2, dockableBarContext.getFloatPreviousState(), save);
            }
            if (save == null) continue;
            save.save(document, element3, dockableBarContext);
        }
    }

    private static void writePreviousState(Document document, Element element, PreviousState previousState, PersistenceUtilsCallback.Save save) {
        Element element2;
        element.setAttribute(ATTRIBUTE_MODE, "" + previousState.mode);
        element.setAttribute(ATTRIBUTE_DOCK_ID, "" + previousState.dockID);
        element.setAttribute(ATTRIBUTE_SIDE, "" + previousState.side);
        element.setAttribute(ATTRIBUTE_FC_ID, "" + previousState.fcID);
        element.setAttribute(ATTRIBUTE_START, "" + previousState.start);
        element.setAttribute(ATTRIBUTE_ROW, "" + previousState.row);
        element.setAttribute(ATTRIBUTE_NEW_ROW, previousState.newRow ? "1" : "0");
        Rectangle rectangle = previousState.rcBounds;
        if (rectangle != null) {
            Iterator iterator = document.createElement(NODE_BOUNDS);
            element.appendChild((Node)((Object)iterator));
            iterator.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            iterator.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            iterator.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            iterator.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        if (previousState.fcChildren != null) {
            for (Object e : previousState.fcChildren) {
                element2 = document.createElement(NODE_CHILD);
                element.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + e);
            }
        }
        if (previousState.parentStates != null) {
            for (Object e : previousState.parentStates) {
                if (!(e instanceof PreviousState.ParentState)) continue;
                element2 = document.createElement(NODE_PARENT_STATE);
                element.appendChild(element2);
                element2.setAttribute(ATTRIBUTE_CC_ID, "" + ((PreviousState.ParentState)e).ccID);
                element2.setAttribute(ATTRIBUTE_DOCK_ID, "" + ((PreviousState.ParentState)e).myID);
                element2.setAttribute(ATTRIBUTE_ORIENTATION, "" + ((PreviousState.ParentState)e).orientation);
                if (((PreviousState.ParentState)e).ccChildren == null) continue;
                for (Object e2 : ((PreviousState.ParentState)e).ccChildren) {
                    Element element3 = document.createElement(NODE_CHILD);
                    element2.appendChild(element3);
                    element3.setAttribute(ATTRIBUTE_DOCK_ID, "" + e2);
                }
            }
        }
        if (save != null) {
            save.save(document, element, previousState);
        }
    }

    public static void load(DefaultDockableBarManager defaultDockableBarManager, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(defaultDockableBarManager, inputStream, null);
    }

    public static void load(DefaultDockableBarManager defaultDockableBarManager, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(defaultDockableBarManager, PersistenceUtils.getDocument(inputStream), load);
    }

    public static void load(DefaultDockableBarManager defaultDockableBarManager, String string) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(defaultDockableBarManager, string, null);
    }

    public static void load(DefaultDockableBarManager defaultDockableBarManager, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(defaultDockableBarManager, PersistenceUtils.getDocument(string), load);
    }

    public static void load(final DefaultDockableBarManager defaultDockableBarManager, final Document document, final PersistenceUtilsCallback.Load load) {
        if (SwingUtilities.isEventDispatchThread()) {
            DockableBarPersistenceUtils.internalLoad(defaultDockableBarManager, document, load);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockableBarPersistenceUtils.internalLoad(defaultDockableBarManager, document, load);
                }
            });
        }
    }

    static boolean internalLoad(DefaultDockableBarManager defaultDockableBarManager, Document document, PersistenceUtilsCallback.Load load) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            defaultDockableBarManager.clearLayout();
            Node node = document.getElementsByTagName("LayoutPersistence").item(0);
            Object object6 = null;
            if (node != null) {
                object5 = node.getChildNodes();
                for (int i = 0; i < object5.getLength(); ++i) {
                    object4 = object5.item(i);
                    if (!"DockableBarManager".equals(object4.getNodeName())) continue;
                    object3 = null;
                    NamedNodeMap namedNodeMap = object4.getAttributes();
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        object2 = namedNodeMap.item(j);
                        if (!"persistenceName".equals(object2.getNodeName())) continue;
                        object3 = object2.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(object3, defaultDockableBarManager.getLayoutPersistenceName())) continue;
                    object6 = object4;
                    break;
                }
            }
            if (object6 == null) {
                defaultDockableBarManager.resetToDefault();
                return false;
            }
            object5 = null;
            String string = null;
            object4 = new HiddenDockableBars();
            object3 = object6.getAttributes();
            for (int i = 0; i < object3.getLength(); ++i) {
                Node node2 = object3.item(i);
                if ("version".equals(node2.getNodeName())) {
                    object5 = node2.getNodeValue();
                }
                if (!ATTRIBUTE_FRAME_STATE.equals(node2.getNodeName())) continue;
                string = node2.getNodeValue();
            }
            if (object5 != null) {
                defaultDockableBarManager.setVersion(Short.valueOf((String)object5));
            }
            if (string != null) {
                defaultDockableBarManager._state = Integer.valueOf(string);
            }
            if (defaultDockableBarManager._floatingDockableBars == null) {
                defaultDockableBarManager._floatingDockableBars = new FloatingDockableBars();
            }
            NodeList nodeList = object6.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object2 = nodeList.item(i);
                if (NODE_CONTEXT.equals(object2.getNodeName())) {
                    DockableBarPersistenceUtils.readContext(document, (Node)object2, defaultDockableBarManager.getAllContexts(), load);
                    continue;
                }
                if (NODE_BOUNDS.equals(object2.getNodeName()) && defaultDockableBarManager.isUseFrameBounds()) {
                    defaultDockableBarManager._unmaximizedBounds = DockableBarPersistenceUtils.readBounds((Node)object2);
                    continue;
                }
                if (NODE_DOCKABLE_BAR_CONTAINER.equals(object2.getNodeName())) {
                    object = DockableBarPersistenceUtils.readDockableBarContainer(document, defaultDockableBarManager, (HiddenDockableBars<String>)object4, (Node)object2, load);
                    switch (((DockableBarContainer)object).getSide()) {
                        case 3: {
                            defaultDockableBarManager._eastDockableBarContainer = object;
                            break;
                        }
                        case 7: {
                            defaultDockableBarManager._westDockableBarContainer = object;
                            break;
                        }
                        case 5: {
                            defaultDockableBarManager._southDockableBarContainer = object;
                            break;
                        }
                        case 1: {
                            defaultDockableBarManager._northDockableBarContainer = object;
                        }
                    }
                    continue;
                }
                if (!NODE_FLOATING_BAR_CONTAINER.equals(object2.getNodeName()) || !((object = DockableBarPersistenceUtils.readFloatingContainer(document, defaultDockableBarManager, (HiddenDockableBars<String>)object4, (Node)object2, load)) instanceof FloatingDockableBarContainer)) continue;
                ((Window)object).setVisible(true);
                defaultDockableBarManager._floatingDockableBars.add(object);
            }
            if (load != null && object6 instanceof Element) {
                load.load(document, (Element)object6, defaultDockableBarManager);
            }
            if (defaultDockableBarManager.getAllContexts() != null) {
                Set<String> set = defaultDockableBarManager.getAllContexts().keySet();
                object2 = set.toArray(new String[set.size()]);
                for (String string2 : object2) {
                    DockableBarFactory dockableBarFactory;
                    DockableBar dockableBar = defaultDockableBarManager.getDockableBar(string2);
                    if (dockableBar == null && (dockableBarFactory = defaultDockableBarManager.getDockableBarFactory()) != null) {
                        dockableBar = dockableBarFactory.create(string2);
                        defaultDockableBarManager.addDockableBar(dockableBar);
                    }
                    if (dockableBar != null) {
                        dockableBar.setContext(defaultDockableBarManager.getAllContexts().get(string2));
                    }
                    defaultDockableBarManager._hiddenDockableBars.add(string2);
                }
            }
            defaultDockableBarManager._hiddenDockableBars.removeAll((Collection<?>)object4);
            if (defaultDockableBarManager._eastDockableBarContainer == null) {
                defaultDockableBarManager._eastDockableBarContainer = defaultDockableBarManager.createDockableBarContainer();
                defaultDockableBarManager._eastDockableBarContainer.setSide(3);
                defaultDockableBarManager._eastDockableBarContainer.invalidate();
            }
            if (defaultDockableBarManager._southDockableBarContainer == null) {
                defaultDockableBarManager._southDockableBarContainer = defaultDockableBarManager.createDockableBarContainer();
                defaultDockableBarManager._southDockableBarContainer.setSide(5);
                defaultDockableBarManager._southDockableBarContainer.invalidate();
            }
            if (defaultDockableBarManager._westDockableBarContainer == null) {
                defaultDockableBarManager._westDockableBarContainer = defaultDockableBarManager.createDockableBarContainer();
                defaultDockableBarManager._westDockableBarContainer.setSide(7);
                defaultDockableBarManager._westDockableBarContainer.invalidate();
            }
            if (defaultDockableBarManager._northDockableBarContainer == null) {
                defaultDockableBarManager._northDockableBarContainer = defaultDockableBarManager.createDockableBarContainer();
                defaultDockableBarManager._northDockableBarContainer.setSide(1);
                defaultDockableBarManager._northDockableBarContainer.invalidate();
            }
            defaultDockableBarManager.getContentContainer().add((Component)defaultDockableBarManager._eastDockableBarContainer, "East");
            defaultDockableBarManager.getContentContainer().add((Component)defaultDockableBarManager._southDockableBarContainer, "South");
            defaultDockableBarManager.getContentContainer().add((Component)defaultDockableBarManager._westDockableBarContainer, "West");
            defaultDockableBarManager.getContentContainer().add((Component)defaultDockableBarManager._northDockableBarContainer, "North");
            for (int i = defaultDockableBarManager._hiddenDockableBars.size() - 1; i >= 0; --i) {
                object2 = (String)defaultDockableBarManager._hiddenDockableBars.get(i);
                object = defaultDockableBarManager.getDockableBar((String)object2);
                if (object == null || ((DockableBar)object).isHidden()) continue;
                defaultDockableBarManager.showDockableBar((DockableBar)object);
            }
            defaultDockableBarManager.setBoundsState();
            defaultDockableBarManager.setRealized(true);
            return true;
        }
        catch (Exception exception) {
            defaultDockableBarManager.resetToDefault();
            return false;
        }
    }

    private static FloatingDockableBarContainer readFloatingContainer(Document document, DockableBarManager dockableBarManager, HiddenDockableBars<String> hiddenDockableBars, Node node, PersistenceUtilsCallback.Load load) {
        FloatingDockableBarContainer floatingDockableBarContainer = dockableBarManager.getRootPaneContainer() instanceof Dialog ? dockableBarManager.createFloatingDockableBarContainer((Dialog)((Object)dockableBarManager.getRootPaneContainer())) : (dockableBarManager.getRootPaneContainer() instanceof Applet ? dockableBarManager.createFloatingDockableBarContainer(JideSwingUtilities.getFrame((Applet)((Object)dockableBarManager.getRootPaneContainer()))) : dockableBarManager.createFloatingDockableBarContainer((Frame)((Object)dockableBarManager.getRootPaneContainer())));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (NODE_DOCKABLE_BAR.equals(node2.getNodeName())) {
                DockableBar dockableBar = DockableBarPersistenceUtils.readDockableBar(document, dockableBarManager, hiddenDockableBars, node2, load);
                floatingDockableBarContainer.getContentPane().add(dockableBar);
                dockableBar.setOrientation(0);
                if (dockableBar.isHidden()) continue;
                try {
                    dockableBar.setFloating();
                }
                catch (PropertyVetoException propertyVetoException) {}
                continue;
            }
            if (!NODE_BOUNDS.equals(node2.getNodeName())) continue;
            floatingDockableBarContainer.setBounds(PortingUtils.overlapWithScreenBounds(floatingDockableBarContainer, DockableBarPersistenceUtils.readBounds(node2)));
        }
        if (floatingDockableBarContainer.getContentPane().getComponentCount() == 0) {
            floatingDockableBarContainer.dispose();
            return null;
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, floatingDockableBarContainer);
        }
        return floatingDockableBarContainer;
    }

    private static DockableBarContainer readDockableBarContainer(Document document, DefaultDockableBarManager defaultDockableBarManager, HiddenDockableBars<String> hiddenDockableBars, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        DockableBarContainer dockableBarContainer = defaultDockableBarManager.createDockableBarContainer();
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (!ATTRIBUTE_SIDE.equals(object.getNodeName())) continue;
            string = object.getNodeValue();
        }
        if (string != null) {
            dockableBarContainer.setSide(Integer.valueOf(string));
        }
        NodeList nodeList = node.getChildNodes();
        object = new DockableBarListList(dockableBarContainer);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!NODE_DOCKABLE_BAR_LIST.equals(node2.getNodeName())) continue;
            DockableBarList dockableBarList = new DockableBarList((DockableBarListList)object);
            ((ArrayList)object).add(dockableBarList);
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                if (!NODE_DOCKABLE_BAR_ITEM.equals(node3.getNodeName())) continue;
                String string2 = null;
                DockableBar dockableBar = null;
                NamedNodeMap namedNodeMap2 = node3.getAttributes();
                for (int k = 0; k < namedNodeMap2.getLength(); ++k) {
                    Node node4 = namedNodeMap2.item(k);
                    if (!ATTRIBUTE_START.equals(node4.getNodeName())) continue;
                    string2 = node4.getNodeValue();
                }
                NodeList nodeList3 = node3.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Node node5 = nodeList3.item(k);
                    if (!NODE_DOCKABLE_BAR.equals(node5.getNodeName())) continue;
                    dockableBar = DockableBarPersistenceUtils.readDockableBar(document, defaultDockableBarManager, hiddenDockableBars, node5, load);
                }
                if (string2 == null || dockableBar == null) continue;
                try {
                    if (dockableBarContainer.getOrientation() == 0) {
                        dockableBar.setHoriDocked();
                    } else {
                        dockableBar.setVertDocked();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                DockableBarItem dockableBarItem = new DockableBarItem(dockableBar, Integer.valueOf(string2));
                dockableBarList.add(dockableBarItem);
            }
        }
        dockableBarContainer.setDockableBarList((DockableBarListList)object);
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, dockableBarContainer);
        }
        return dockableBarContainer;
    }

    private static DockableBar readDockableBar(Document document, DockableBarManager dockableBarManager, HiddenDockableBars<String> hiddenDockableBars, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        String string = null;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_PREFERRED_ROW_COUNT.equals(object.getNodeName())) continue;
            string2 = object.getNodeValue();
        }
        if (string == null) {
            return null;
        }
        DockableBar dockableBar = dockableBarManager.getDockableBar(string);
        if (dockableBar != null) {
            object = dockableBarManager.getDockableBarContextOf(string);
            if (object != null) {
                dockableBar.setContext((DockableBarContext)object);
                if (((DockableBarContext)object).isVertDocked()) {
                    dockableBar.setOrientation(1);
                } else {
                    dockableBar.setOrientation(0);
                }
            } else {
                System.err.println("DockableBarContext shouldn't be null");
            }
            if (!dockableBar.isHidden()) {
                hiddenDockableBars.add(string);
            }
            dockableBar.setVisible(!dockableBar.isHidden());
            if (dockableBar instanceof CommandBar && string2 != null) {
                ((CommandBar)dockableBar).setPreferredRowCount(Integer.valueOf(string2));
            }
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, dockableBar);
            }
        }
        return dockableBar;
    }

    private static Rectangle readBounds(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_X.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_Y.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(node2.getNodeName())) continue;
            string4 = node2.getNodeValue();
        }
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            rectangle.x = Integer.valueOf(string);
        }
        if (string2 != null) {
            rectangle.y = Integer.valueOf(string2);
        }
        if (string3 != null) {
            rectangle.width = Integer.valueOf(string3);
        }
        if (string4 != null) {
            rectangle.height = Integer.valueOf(string4);
        }
        return rectangle;
    }

    private static String readContext(Document document, Node node, Map<String, DockableBarContext> map, PersistenceUtilsCallback.Load load) {
        DockableBarContext dockableBarContext;
        DockableBarContext dockableBarContext2 = new DockableBarContext();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_SIDE.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_INDEX.equals(node2.getNodeName())) {
                string4 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_POSITION.equals(node2.getNodeName())) {
                string5 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_MODE.equals(node2.getNodeName())) {
                string6 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_MODE.equals(node2.getNodeName())) {
                string7 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_DOCK_SIDE.equals(node2.getNodeName())) {
                string8 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_WIDTH.equals(node2.getNodeName())) {
                string9 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_DOCKED_HEIGHT.equals(node2.getNodeName())) continue;
            string10 = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (NODE_UNDOCKED_BOUNDS.equals(node3.getNodeName())) {
                dockableBarContext2.setUndockedBounds(DockableBarPersistenceUtils.readBounds(node3));
                continue;
            }
            if (!NODE_PREVIOUS_STATE.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_TYPE.equals(node4.getNodeName())) continue;
                String string11 = node4.getNodeValue();
                if (PREVIOUS_STATE_HIDDEN.equals(string11)) {
                    dockableBarContext2.setHiddenPreviousState(DockableBarPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_DOCK.equals(string11)) {
                    dockableBarContext2.setDockPreviousState(DockableBarPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (PREVIOUS_STATE_CLOSE.equals(string11)) {
                    dockableBarContext2.setClosePreviousState(DockableBarPersistenceUtils.readPreviousState(document, node3, load));
                    continue;
                }
                if (!PREVIOUS_STATE_FLOAT.equals(string11)) continue;
                dockableBarContext2.setFloatPreviousState(DockableBarPersistenceUtils.readPreviousState(document, node3, load));
            }
        }
        if (string2 != null) {
            dockableBarContext2.setDockID(Integer.valueOf(string2));
        }
        if (string3 != null) {
            dockableBarContext2.setInitSide(Integer.valueOf(string3));
        }
        if (string4 != null) {
            dockableBarContext2.setInitIndex(Integer.valueOf(string4));
        }
        dockableBarContext2.setInitPosition("1".equals(string5));
        if (string6 != null) {
            dockableBarContext2.setInitMode(Integer.valueOf(string6));
        }
        if (string7 != null) {
            dockableBarContext2.setCurrentMode(Integer.valueOf(string7));
        }
        if (string8 != null) {
            dockableBarContext2.setCurrentDockSide(Integer.valueOf(string8));
        }
        if (string9 != null) {
            dockableBarContext2.setDockedWidth(Integer.valueOf(string9));
        }
        if (string10 != null) {
            dockableBarContext2.setDockedHeight(Integer.valueOf(string10));
        }
        if ((dockableBarContext = map.remove(string)) instanceof DockableBarContext) {
            dockableBarContext2.setInitIndex(dockableBarContext.getInitIndex());
            dockableBarContext2.setInitMode(dockableBarContext.getInitMode());
            dockableBarContext2.setInitSide(dockableBarContext.getInitSide());
            dockableBarContext2.setInitSubindex(dockableBarContext.getInitSubindex());
        }
        map.put(string, dockableBarContext2);
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, dockableBarContext2);
        }
        return string;
    }

    private static PreviousState readPreviousState(Document document, Node node, PersistenceUtilsCallback.Load load) {
        PreviousState previousState = new PreviousState();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_MODE.equals(node2.getNodeName())) {
                previousState.mode = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                previousState.dockID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_START.equals(node2.getNodeName())) {
                previousState.start = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_SIDE.equals(node2.getNodeName())) {
                previousState.side = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_ROW.equals(node2.getNodeName())) {
                previousState.row = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_NEW_ROW.equals(node2.getNodeName())) {
                previousState.newRow = "1".equals(node2.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_FC_ID.equals(node2.getNodeName())) continue;
            previousState.fcID = Integer.valueOf(node2.getNodeValue());
        }
        previousState.fcChildren = new ArrayList();
        previousState.parentStates = new ArrayList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (NODE_BOUNDS.equals(node3.getNodeName())) {
                previousState.rcBounds = DockableBarPersistenceUtils.readBounds(node3);
                continue;
            }
            if (NODE_CHILD.equals(node3.getNodeName())) {
                NamedNodeMap namedNodeMap2 = node3.getAttributes();
                for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                    Node node4 = namedNodeMap2.item(j);
                    if (!ATTRIBUTE_DOCK_ID.equals(node4.getNodeName())) continue;
                    previousState.fcChildren.add(Integer.valueOf(node4.getNodeValue()));
                }
                continue;
            }
            if (!NODE_PARENT_STATE.equals(node3.getNodeName())) continue;
            previousState.parentStates.add(DockableBarPersistenceUtils.readParentState(node3));
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, previousState);
        }
        return previousState;
    }

    private static PreviousState.ParentState readParentState(Node node) {
        PreviousState.ParentState parentState = new PreviousState.ParentState();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_CC_ID.equals(node2.getNodeName())) {
                parentState.ccID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(node2.getNodeName())) {
                parentState.myID = Integer.valueOf(node2.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_ORIENTATION.equals(node2.getNodeName())) continue;
            parentState.orientation = Integer.valueOf(node2.getNodeValue());
        }
        parentState.ccChildren = new ArrayList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_CHILD.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_DOCK_ID.equals(node4.getNodeName())) continue;
                parentState.ccChildren.add(Integer.valueOf(node4.getNodeValue()));
            }
        }
        return parentState;
    }
}

