/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.Dockable;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.event.DockableBarEvent;
import com.jidesoft.action.event.DockableBarListener;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuBar;
import javax.swing.SwingConstants;
import org.w3c.dom.Element;

public abstract class DockableBar
extends JMenuBar
implements Dockable,
SwingConstants,
Alignable {
    private static final Logger LOGGER_EVENT;
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_STRETCH = "stretch";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_HORI_DOCKED = "horiDocked";
    public static final String PROPERTY_VERT_DOCKED = "vertDocked";
    public static final String PROPERTY_FLOATED = "floating";
    public static final String PROPERTY_INIT_SIDE = "initSide";
    public static final String PROPERTY_INIT_MODE = "initMode";
    public static final String PROPERTY_INIT_INDEX = "initIndex";
    public static final String PROPERTY_INIT_SUBINDEX = "initSubindex";
    public static final String PROPERTY_ALLOWED_DOCK_SIDES = "allowedDockSides";
    public static final String PROPERTY_UNDOCKED_BOUNDS = "undockedBounds";
    private String _key;
    private String _title;
    private DockableBarContext _context;
    private DockableBarManager _dockableBarManager;
    private boolean _floatable = true;
    private boolean _hidable = true;
    private boolean _rearrangeable = true;
    private boolean _stretch = false;
    private int _allowedDockSides = 15;
    protected int _orientation = 0;
    private boolean _duringLayout;
    public static final String PROPERTY_CHEVRON_ALWAYS_VISIBLE = "chevronAlwaysVisible";
    private boolean _chevronAlwaysVisible = true;
    private boolean _paintBackground = true;
    public static final String PROPERTY_PAINT_BACKGROUND = "paintBackground";
    private boolean _menuBar;
    public static final String PROPERTY_MENU_BAR = "menuBar";
    public static final String PROPERTY_AVAILABLE = "available";

    public DockableBar() {
        this("", "");
    }

    public DockableBar(String string) {
        this(string, string);
    }

    public DockableBar(String string, String string2) {
        this.setTitle(string2);
        this._key = string;
        this._context = new DockableBarContext();
    }

    public DockableBarContext getContext() {
        return this._context;
    }

    public void setContext(DockableBarContext dockableBarContext) {
        this._context = dockableBarContext;
        if (this._context.isFloating()) {
            this.firePropertyChange(PROPERTY_FLOATED, false, true);
        } else if (this._context.isHoriDocked()) {
            this.firePropertyChange(PROPERTY_HORI_DOCKED, false, true);
        } else if (this._context.isVertDocked()) {
            this.firePropertyChange(PROPERTY_VERT_DOCKED, false, true);
        } else if (this._context.isHidden()) {
            this.firePropertyChange(PROPERTY_HIDDEN, false, true);
        }
    }

    public void setKey(String string) {
        String string2 = this._key;
        this._key = string;
        this.firePropertyChange(PROPERTY_KEY, string2, this._key);
        if (this._title == null) {
            this.firePropertyChange(PROPERTY_TITLE, string2, string);
        }
    }

    public String getKey() {
        return this._key;
    }

    public void setTitle(String string) {
        String string2 = this._title;
        if (!JideSwingUtilities.equals(string, this._title)) {
            this._title = string;
            this.firePropertyChange(PROPERTY_TITLE, string2, this._title);
        }
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this.getKey();
    }

    @Override
    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    @Override
    public void setDockableBarManager(DockableBarManager dockableBarManager) {
        this._dockableBarManager = dockableBarManager;
        if (this._dockableBarManager != null) {
            this.fireDockableBarEvent(4999);
        }
    }

    public boolean isHidden() {
        return this.getContext().isHidden();
    }

    public void setHidden() throws PropertyVetoException {
        Boolean bl = this.getContext().isHidden() ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(PROPERTY_HIDDEN, bl, Boolean.TRUE);
        this.getContext().setCurrentMode(0);
        this.firePropertyChange(PROPERTY_HIDDEN, bl, Boolean.TRUE);
        this.setVisible(false);
        this.fireDockableBarEvent(5002);
    }

    public boolean isFloating() {
        return this.getContext().isFloating();
    }

    public void setFloating() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_FLOATED, Boolean.FALSE, Boolean.TRUE);
        boolean bl = this.getContext().isHidden();
        this.getContext().setCurrentMode(1);
        if (bl) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5005);
        this.firePropertyChange(PROPERTY_FLOATED, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isVertDocked() {
        return this.getContext().isVertDocked();
    }

    public void setVertDocked() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_VERT_DOCKED, Boolean.FALSE, Boolean.TRUE);
        boolean bl = this.getContext().isHidden();
        this.getContext().setCurrentMode(3);
        if (bl) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5004);
        this.firePropertyChange(PROPERTY_VERT_DOCKED, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isHoriDocked() {
        return this.getContext().isHoriDocked();
    }

    public void setHoriDocked() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_HORI_DOCKED, Boolean.FALSE, Boolean.TRUE);
        boolean bl = this.getContext().isHidden();
        this.getContext().setCurrentMode(2);
        if (bl) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5003);
        this.firePropertyChange(PROPERTY_HORI_DOCKED, Boolean.FALSE, Boolean.TRUE);
    }

    public void addDockableBarListener(DockableBarListener dockableBarListener) {
        this.listenerList.add(DockableBarListener.class, dockableBarListener);
        this.enableEvents(0L);
    }

    public void removeDockableBarListener(DockableBarListener dockableBarListener) {
        this.listenerList.remove(DockableBarListener.class, dockableBarListener);
    }

    public DockableBarListener[] getDockableBarListeners() {
        return (DockableBarListener[])this.listenerList.getListeners(DockableBarListener.class);
    }

    protected void fireDockableBarEvent(int n) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 4999: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is added");
                    break;
                }
                case 5000: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is removed");
                    break;
                }
                case 5003: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is horizontally docked");
                    break;
                }
                case 5004: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is vertically docked");
                    break;
                }
                case 5005: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is floating");
                    break;
                }
                case 5001: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is shown");
                    break;
                }
                case 5002: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is hidden");
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block18: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DockableBarListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DockableBarEvent(this, n);
            }
            switch (aWTEvent.getID()) {
                case 4999: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarAdded((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5000: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarRemoved((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5003: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarHoriDocked((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5004: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarVertDocked((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5005: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarFloating((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5001: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarShown((DockableBarEvent)aWTEvent);
                    continue block18;
                }
                case 5002: {
                    ((DockableBarListener)objectArray[i + 1]).dockableBarHidden((DockableBarEvent)aWTEvent);
                    continue block18;
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this.getContext().getDockID();
    }

    @Override
    public void setDockID(int n) {
        this.getContext().setDockID(n);
    }

    @Override
    public void resetDockID() {
        this.getContext().resetDockID();
        this.getContext().setInitPosition(false);
    }

    public boolean isFloatable() {
        return this._floatable;
    }

    public void setFloatable(boolean bl) {
        if (this._floatable != bl) {
            boolean bl2 = this._floatable;
            this._floatable = bl;
            this.firePropertyChange(PROPERTY_FLOATABLE, bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRearrangable() {
        return this._rearrangeable;
    }

    public void setRearrangable(boolean bl) {
        if (this._rearrangeable != bl) {
            boolean bl2 = this._rearrangeable;
            this._rearrangeable = bl;
            this.firePropertyChange(PROPERTY_REARRANGABLE, bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isHidable() {
        return this._hidable;
    }

    public void setHidable(boolean bl) {
        if (this._hidable != bl) {
            boolean bl2 = this._hidable;
            this._hidable = bl;
            this.firePropertyChange(PROPERTY_HIDABLE, bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public Rectangle getUndockedBounds() {
        Rectangle rectangle = this._context.getUndockedBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX() + 10, this.getY() + 10, 0, 0);
            this._context.setUndockedBounds(rectangle);
        }
        return rectangle;
    }

    public void setUndockedBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getContext().getUndockedBounds();
        if (!rectangle.equals(rectangle2)) {
            this.getContext().setUndockedBounds(rectangle);
            this.firePropertyChange(PROPERTY_UNDOCKED_BOUNDS, rectangle2, rectangle);
        }
    }

    public boolean isStretch() {
        return this._stretch;
    }

    public void setStretch(boolean bl) {
        if (this._stretch != bl) {
            boolean bl2 = this._stretch;
            this._stretch = bl;
            this.firePropertyChange(PROPERTY_STRETCH, bl2, bl);
        }
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public void setOrientation(int n) {
        this.checkOrientation(n);
        if (this._orientation != n) {
            int n2 = this._orientation;
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        LayoutManager layoutManager2 = this.getLayout();
        if (layoutManager2 instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)layoutManager2));
        }
        super.setLayout(layoutManager);
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    protected void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public int getAllowedDockSides() {
        return this._allowedDockSides;
    }

    public void setAllowedDockSides(int n) {
        int n2 = this._allowedDockSides;
        if (n2 != n) {
            this._allowedDockSides = n;
            this.firePropertyChange(PROPERTY_ALLOWED_DOCK_SIDES, n2, n);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        JideSwingUtilities.setOrientationOf(component, this.getOrientation());
        super.addImpl(component, object, n);
    }

    boolean isDuringLayout() {
        return this._duringLayout;
    }

    void setDuringLayout(boolean bl) {
        this._duringLayout = bl;
    }

    public int getInitMode() {
        return this.getContext().getInitMode();
    }

    public void setInitMode(int n) {
        int n2 = this.getContext().getInitMode();
        if (n2 != n) {
            this.getContext().setInitMode(n);
            this.firePropertyChange(PROPERTY_INIT_MODE, n2, n);
        }
    }

    public int getInitSide() {
        return this.getContext().getInitSide();
    }

    public void setInitSide(int n) {
        int n2 = this.getContext().getInitSide();
        if (n2 != n) {
            this.getContext().setInitSide(n);
            this.firePropertyChange(PROPERTY_INIT_SIDE, n2, n);
        }
    }

    public int getInitIndex() {
        return this.getContext().getInitIndex();
    }

    public void setInitIndex(int n) {
        int n2 = this.getContext().getInitIndex();
        if (n2 != n) {
            this.getContext().setInitIndex(n);
            this.firePropertyChange(PROPERTY_INIT_INDEX, n2, n);
        }
    }

    public int getInitSubindex() {
        return this.getContext().getInitSubindex();
    }

    public void setInitSubindex(int n) {
        int n2 = this.getContext().getInitSubindex();
        if (n2 != n) {
            this.getContext().setInitSubindex(n);
            this.firePropertyChange(PROPERTY_INIT_SUBINDEX, n2, n);
        }
    }

    public void readElement(Element element) {
    }

    public void adjustChildrenOrientation(int n) {
        JideSwingUtilities.setChildrenOrientationOf(this, n);
    }

    public boolean isAvailable() {
        return this.getContext().isAvailable();
    }

    public void setAvailable(boolean bl) {
        if (bl != this.isAvailable()) {
            boolean bl2 = this.isAvailable();
            this.getContext().setAvailable(bl);
            this.firePropertyChange(PROPERTY_AVAILABLE, bl2, bl);
        }
    }

    public boolean isChevronAlwaysVisible() {
        return this._chevronAlwaysVisible;
    }

    public void setChevronAlwaysVisible(boolean bl) {
        boolean bl2 = this._chevronAlwaysVisible;
        if (bl != this._chevronAlwaysVisible) {
            this._chevronAlwaysVisible = bl;
            this.firePropertyChange(PROPERTY_CHEVRON_ALWAYS_VISIBLE, bl2, this._chevronAlwaysVisible);
        }
    }

    public boolean isPaintBackground() {
        return this._paintBackground;
    }

    public void setPaintBackground(boolean bl) {
        boolean bl2 = this._paintBackground;
        if (bl != bl2) {
            this._paintBackground = bl;
            this.firePropertyChange(PROPERTY_PAINT_BACKGROUND, bl2, bl);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.setPaintBackground(bl);
    }

    public boolean isMenuBar() {
        return this._menuBar;
    }

    public void setMenuBar(boolean bl) {
        boolean bl2 = this._menuBar;
        if (bl != bl2) {
            this._menuBar = bl;
            this.firePropertyChange(PROPERTY_MENU_BAR, bl2, bl);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16)) {
            Lm.showInvalidProductMessage(DockableBar.class.getName(), 16);
        }
        LOGGER_EVENT = Logger.getLogger(DockableBarEvent.class.getName());
    }
}

