/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarBorderListener;
import com.jidesoft.action.CommandBarLayout;
import com.jidesoft.action.CommandBarSeparator;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.CommandBarUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;

public class CommandBar
extends DockableBar
implements SwingConstants,
TopLevelMenuContainer {
    private static final String uiClassID = "CommandBarUI";
    private boolean _paintBorder = true;
    private Insets _margin = null;
    private CommandBarBorderListener _borderListener;
    private int _preferredRowCount;
    private List<Component> _hiddenComponents = new ArrayList<Component>();
    protected CommandBarContainerListener _commandBarContainerListener;
    protected boolean _changingContainer;
    static boolean sUseScreenMenuBar = false;

    public CommandBar() {
        this(0);
    }

    public CommandBar(int n) {
        this("", null, n);
    }

    public CommandBar(String string) {
        this(string, null, 0);
    }

    public CommandBar(String string, String string2) {
        this(string, string2, 0);
    }

    public CommandBar(String string, String string2, int n) {
        super(string, string2);
        this.setOpaque(false);
        this.setPaintBackground(true);
        this.checkOrientation(n);
        this._orientation = n;
        DefaultCommandBarLayout defaultCommandBarLayout = new DefaultCommandBarLayout(n);
        this.setLayout(defaultCommandBarLayout);
        this.addPropertyChangeListener(defaultCommandBarLayout);
        this._borderListener = this.createBorderListener();
        this.addMouseListener(this._borderListener);
        this.addMouseMotionListener(this._borderListener);
        this._commandBarContainerListener = new CommandBarContainerListener();
        this.addContainerListener(this._commandBarContainerListener);
        this.updateUI();
    }

    private CommandBarBorderListener createBorderListener() {
        return new CommandBarBorderListener(this);
    }

    @Override
    public MenuBarUI getUI() {
        return (CommandBarUI)this.ui;
    }

    @Override
    public void updateUI() {
        CommandBarUI commandBarUI;
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
        if (!CommandBar.isScreenMenuBar(this) && (commandBarUI = (CommandBarUI)this.getUI()) != null) {
            Component[] componentArray;
            Component component;
            Component component2 = commandBarUI.getGripper();
            if (component2 != null) {
                component2.addMouseListener(this._borderListener);
                component2.addMouseMotionListener(this._borderListener);
            }
            if ((component = commandBarUI.getTitleBar()) != null) {
                component.addMouseListener(this._borderListener);
                component.addMouseMotionListener(this._borderListener);
            }
            for (Component component3 : componentArray = this.getHiddenComponents()) {
                if (!(component3 instanceof JComponent)) continue;
                ((JComponent)component3).updateUI();
            }
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setMargin(Insets insets) {
        Insets insets2 = this._margin;
        this._margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Insets getMargin() {
        if (this._margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this._margin;
    }

    @Override
    public boolean isBorderPainted() {
        return this._paintBorder;
    }

    @Override
    public void setBorderPainted(boolean bl) {
        if (this._paintBorder != bl) {
            boolean bl2 = this._paintBorder;
            this._paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public void setChangingContainer(boolean bl) {
        if (this._changingContainer == bl) {
            return;
        }
        this._changingContainer = bl;
        if (!bl) {
            this.validateWindowIfFloating();
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().invalidate();
            }
            if (this.getParent() != null && this.getParent().getParent() != null) {
                this.getParent().getParent().invalidate();
                this.getParent().getParent().validate();
            } else if (this.getParent() != null) {
                this.getParent().validate();
            } else {
                this.validate();
            }
        }
    }

    public void validateWindowIfFloating() {
        if (this._changingContainer) {
            return;
        }
        if (!this.isFloating()) {
            return;
        }
        JWindow jWindow = (JWindow)SwingUtilities.getAncestorOfClass(JWindow.class, this);
        if (jWindow != null) {
            this.invalidate();
            jWindow.getRootPane().validate();
        }
    }

    public void addSeparator() {
        CommandBarSeparator commandBarSeparator = new CommandBarSeparator();
        this.add(commandBarSeparator);
    }

    public void addSeparator(Dimension dimension) {
        CommandBarSeparator commandBarSeparator = new CommandBarSeparator();
        this.add(commandBarSeparator);
    }

    public JComponent add(Action action) {
        JComponent jComponent = this.createActionComponent(action);
        this.add(jComponent);
        return jComponent;
    }

    protected JComponent createActionComponent(Action action) {
        return this.createButton(action);
    }

    private JComponent createButton(Action action) {
        String string = action != null ? (String)action.getValue("Name") : null;
        Icon icon = action != null ? (Icon)action.getValue("SmallIcon") : null;
        boolean bl = action == null || action.isEnabled();
        String string2 = action != null ? (String)action.getValue("ShortDescription") : null;
        JideButton jideButton = new JideButton(string, icon){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = CommandBar.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        if (icon != null) {
            jideButton.putClientProperty("hideActionText", Boolean.TRUE);
        }
        jideButton.setHorizontalTextPosition(0);
        jideButton.setVerticalTextPosition(3);
        jideButton.setEnabled(bl);
        jideButton.setToolTipText(string2);
        jideButton.setAction(action);
        return jideButton;
    }

    protected PropertyChangeListener createActionChangeListener(JComponent jComponent) {
        return null;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof UIResource) {
            super.addImpl(component, object, n);
        } else if (!(this.isDuringLayout() || this._hiddenComponents.size() == 0 || n != -1 && n < this.getMenuCount())) {
            if (n == -1) {
                this.addHiddenComponent(component);
            } else {
                this.addHiddenComponent(component, n - this.getMenuCount());
            }
        } else if (n < 0) {
            super.addImpl(component, object, n);
        } else {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            for (Component component2 : componentArray) {
                if (!(component2 instanceof UIResource)) break;
                ++n2;
            }
            super.addImpl(component, object, n + n2);
        }
        if (component instanceof JButton) {
            ((JButton)component).setDefaultCapable(false);
        }
    }

    public static boolean isScreenMenuBar(JMenuBar jMenuBar) {
        if (sUseScreenMenuBar) {
            Container container;
            if (jMenuBar instanceof CommandMenuBar) {
                return true;
            }
            MenuBarUI menuBarUI = jMenuBar.getUI();
            if (menuBarUI instanceof CommandBarUI && (container = jMenuBar.getTopLevelAncestor()) instanceof JFrame) {
                boolean bl;
                MenuBar menuBar = ((JFrame)container).getMenuBar();
                boolean bl2 = bl = ((JFrame)container).getJMenuBar() == jMenuBar;
                if (menuBar == null) {
                    return bl;
                }
                return menuBar.getClass().getName().endsWith("ScreenMenuBar") && bl;
            }
        }
        return false;
    }

    void purposeBounds(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.isFloating()) {
            DefaultCommandBarLayout defaultCommandBarLayout = (DefaultCommandBarLayout)this.getLayout();
            Rectangle rectangle = null;
            if (n3 == -1 && n7 != n8) {
                rectangle = n2 == this.getY() ? defaultCommandBarLayout.getActualSize(this, n, n2, n3, n4, 1, true, n7 > n8) : defaultCommandBarLayout.getActualSize(this, n, n2, n3, n4, 1, false, n7 < n8);
            } else if (n5 != n6 && n4 == -1) {
                rectangle = n == this.getX() ? defaultCommandBarLayout.getActualSize(this, n, n2, n3, n4, 0, true, n5 > n6) : defaultCommandBarLayout.getActualSize(this, n, n2, n3, n4, 0, false, n5 < n6);
            }
            if (rectangle != null) {
                n = rectangle.x;
                n2 = rectangle.y;
                n3 = rectangle.width;
                n4 = rectangle.height;
            }
        }
        if (n3 == -1) {
            n3 = this.getWidth();
        }
        if (n4 == -1) {
            n4 = this.getHeight();
        }
        super.setBounds(n, n2, n3, n4);
    }

    public int getPreferredRowCount() {
        return this._preferredRowCount;
    }

    public void setPreferredRowCount(int n) {
        if (this._preferredRowCount != n) {
            this.invalidate();
        }
        this._preferredRowCount = n;
    }

    public Component[] getHiddenComponents() {
        if (this._hiddenComponents == null) {
            return new Component[0];
        }
        return this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()]);
    }

    void addHiddenComponent(Component component) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    boolean isComponentHidden(Component component) {
        return this._hiddenComponents != null && this._hiddenComponents.contains(component);
    }

    void addHiddenComponent(Component component, int n) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(n, component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    @Override
    public void remove(Component component) {
        Component[] componentArray = this.getComponents();
        boolean bl = false;
        for (Component component2 : componentArray) {
            if (component2 != component) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.remove(component);
        } else if (this._hiddenComponents.contains(component)) {
            this._hiddenComponents.remove(component);
        }
    }

    @Override
    public void removeAll() {
        Component[] componentArray;
        this._hiddenComponents.clear();
        for (Component component : componentArray = this.getComponents()) {
            if (component instanceof UIResource) continue;
            this.remove(component);
        }
    }

    void removeHiddenComponent(Component component) {
        if (this._hiddenComponents.contains(component)) {
            this._hiddenComponents.remove(component);
        }
        if (component.getParent() != this) {
            this.add(component);
        }
    }

    public void removeAllHiddenComponents() {
        Component[] componentArray;
        for (Component component : componentArray = this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()])) {
            this.removeHiddenComponent(component);
        }
    }

    @Override
    public int getMenuCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (Component component : componentArray) {
            if (component instanceof UIResource) continue;
            ++n;
        }
        return n;
    }

    @Override
    public JMenu getMenu(int n) {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof UIResource) continue;
            if (n == n2) {
                return super.getMenu(i);
            }
            ++n2;
        }
        return null;
    }

    public void addExpansion() {
        this.add(new Expansion());
    }

    @Override
    public void adjustChildrenOrientation(int n) {
        Component[] componentArray;
        super.adjustChildrenOrientation(n);
        for (Component component : componentArray = this.getHiddenComponents()) {
            JideSwingUtilities.setOrientationOf(component, n);
        }
    }

    static {
        if (SystemInfo.isMacOSX()) {
            String[] stringArray = new String[]{""};
            boolean bl = false;
            try {
                stringArray[0] = SecurityUtils.getProperty("apple.laf.useScreenMenuBar", null);
                if (stringArray[0] != null && stringArray[0].equals("true")) {
                    bl = true;
                } else {
                    stringArray[0] = SecurityUtils.getProperty("com.apple.macos.useScreenMenuBar", null);
                    if (stringArray[0] != null && stringArray[0].equals("true")) {
                        System.err.println("com.apple.macos.useScreenMenuBar has been deprecated. Please switch to apple.laf.useScreenMenuBar");
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println("Problem in Menu Bar static initializer! :  " + throwable);
                throwable.printStackTrace();
            }
            sUseScreenMenuBar = bl;
        }
    }

    public static class Expansion
    extends Box.Filler
    implements Alignable {
        private int _orientation;

        public Expansion() {
            super(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        }

        @Override
        public boolean supportVerticalOrientation() {
            return true;
        }

        @Override
        public boolean supportHorizontalOrientation() {
            return true;
        }

        @Override
        public int getOrientation() {
            return this._orientation;
        }

        @Override
        public void setOrientation(int n) {
            this._orientation = n;
        }
    }

    protected class CommandBarContainerListener
    implements ContainerListener {
        protected CommandBarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            CommandBar.this.validateWindowIfFloating();
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            CommandBar.this.validateWindowIfFloating();
        }
    }

    public class DefaultCommandBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        CommandBarLayout lm;

        DefaultCommandBarLayout(int n) {
            this.lm = n == 1 ? new CommandBarLayout(CommandBar.this, 3) : new CommandBarLayout(CommandBar.this, 2);
            CommandBar.this.addPropertyChangeListener(this);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.lm.addLayoutComponent(string, component);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.lm.addLayoutComponent(component, object);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.lm.removeLayoutComponent(component);
            this.lm.invalidateLayout(CommandBar.this);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.lm.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.lm.minimumLayoutSize(container);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            if (this.lm != null) {
                return this.lm.maximumLayoutSize(container);
            }
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void layoutContainer(Container container) {
            this.lm.layoutContainer(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            if (this.lm != null) {
                return this.lm.getLayoutAlignmentX(container);
            }
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            if (this.lm != null) {
                return this.lm.getLayoutAlignmentY(container);
            }
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
            if (this.lm != null) {
                this.lm.invalidateLayout(container);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("floating")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (string.equals("horiDocked")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (string.equals("vertDocked")) {
                this.lm.invalidateLayout(CommandBar.this);
            } else if (string.equals("orientation")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                this.lm = n == 1 ? new CommandBarLayout(CommandBar.this, 3) : new CommandBarLayout(CommandBar.this, 2);
            }
        }

        public Rectangle getActualSize(Container container, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
            return this.lm.getActualSize(container, n, n2, n3, n4, n5, bl, bl2);
        }

        public boolean isRespectMinimumSizeWhenNecessary() {
            return this.lm.isRespectMinimumSizeWhenNecessary();
        }

        public void setRespectMinimumWhenNecessary(boolean bl) {
            this.lm.setRespectMinimumSizeWhenNecessary(bl);
        }
    }
}

