/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;

public class KeyboardShortcut
extends Shortcut {
    private List<KeyStroke> \u0104 = new Vector<KeyStroke>();

    public KeyboardShortcut() {
    }

    public KeyboardShortcut(KeyStroke keyStroke) {
        this(keyStroke, null);
    }

    public KeyboardShortcut(KeyStroke keyStroke, String string) {
        this.addKeyStroke(keyStroke);
        this.setContext(string);
    }

    public KeyboardShortcut(KeyStroke[] keyStrokeArray) {
        this(keyStrokeArray, null);
    }

    public KeyboardShortcut(KeyStroke[] keyStrokeArray, String string) {
        for (KeyStroke keyStroke : keyStrokeArray) {
            this.addKeyStroke(keyStroke);
        }
        this.setContext(string);
    }

    public KeyboardShortcut(KeyEvent keyEvent) {
        this(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()), null);
    }

    public KeyStroke[] getKeyStrokes() {
        return this.\u0104.toArray(new KeyStroke[this.\u0104.size()]);
    }

    public void addKeyStroke(KeyStroke keyStroke) {
        this.\u0104.add(keyStroke);
    }

    public void removeLastKeyStroke() {
        if (this.\u0104.size() > 0) {
            this.\u0104.remove(this.\u0104.size() - 1);
        }
    }

    public void clear() {
        this.\u0104.clear();
    }

    public int getCount() {
        return this.\u0104.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.\u0101()) {
            for (int i2 = 0; i2 < this.\u0104.size(); ++i2) {
                KeyStroke keyStroke = this.\u0104.get(i2);
                if (keyStroke == null) continue;
                int n2 = keyStroke.getKeyCode();
                int n3 = keyStroke.getModifiers();
                String string = KeyEvent.getKeyModifiersText(n3);
                stringBuffer.append(string);
                if ("".equals(string)) {
                    stringBuffer.append(KeyEvent.getKeyText(n2));
                } else {
                    switch (n2) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 65406: {
                            stringBuffer.append("+");
                        }
                    }
                    stringBuffer.append("+").append(KeyEvent.getKeyText(n2));
                }
                if (i2 == this.\u0104.size() - 1) continue;
                stringBuffer.append(", ");
            }
        }
        if (this.getContext() != null) {
            stringBuffer.append(" (").append(this.getContext()).append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyboardShortcut)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)object;
        return !(this.\u0104 == null ? keyboardShortcut.\u0104 != null : !this.\u0104.equals(keyboardShortcut.\u0104));
    }

    @Override
    public int hashCode() {
        return this.\u0104 != null ? this.\u0104.hashCode() : 0;
    }

    @Override
    boolean \u0101() {
        if (this.\u0104 == null || this.\u0104.size() == 0) {
            return true;
        }
        for (KeyStroke keyStroke : this.\u0104) {
            if (keyStroke == null) continue;
            return false;
        }
        return true;
    }

    public static KeyStroke parseKeyStroke(String string) {
        return KeyStroke.getKeyStroke(string);
    }

    public static String getKeyStrokeString(KeyStroke keyStroke) {
        String string = keyStroke.toString();
        int n2 = string.lastIndexOf(" ");
        return KeyboardShortcut.\u0101(keyStroke.getModifiers()) + string.substring(++n2);
    }

    static String \u0101(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 0x40) != 0) {
            stringBuffer.append("shift ");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append("control ");
        }
        if ((n2 & 0x100) != 0) {
            stringBuffer.append("meta ");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append("alt ");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("altGraph ");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append("button1 ");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append("button2 ");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("button3 ");
        }
        return stringBuffer.toString();
    }

    public Shortcut convertToMacOSX() {
        boolean bl = false;
        KeyboardShortcut keyboardShortcut = new KeyboardShortcut();
        for (KeyStroke keyStroke : this.\u0104) {
            String string = KeyboardShortcut.getKeyStrokeString(keyStroke);
            String string2 = KeyboardShortcut.convertToMacOSX(string);
            if (!string2.equals(string)) {
                bl = true;
            }
            keyboardShortcut.addKeyStroke(KeyStroke.getKeyStroke(string2));
        }
        if (!bl) {
            return null;
        }
        keyboardShortcut.setName(this.getName());
        keyboardShortcut.setIcon(this.getIcon());
        keyboardShortcut.setContext(this.getContext());
        return keyboardShortcut;
    }

    public static String convertToMacOSX(String string) {
        if (string.indexOf("control ") != -1) {
            if (SystemInfo.isJdk15Above()) {
                return string.replace("control ", "meta ");
            }
            return Pattern.compile("control ", 16).matcher(string).replaceAll("meta ");
        }
        return string;
    }

    public static String convertFromMacOSX(String string) {
        if (string.indexOf("meta ") != -1) {
            if (SystemInfo.isJdk15Above()) {
                return string.replace("meta ", "control ");
            }
            return Pattern.compile("meta ", 16).matcher(string).replaceAll("control ");
        }
        return string;
    }
}

