/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableInputListener;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.SizeSequence;

public class GroupTableHeader
extends AutoFilterTableHeader {
    private static final Insets \u1e8b = new Insets(3, 1, 3, 1);
    private final GroupTableInputListener \u1e91;
    private final SizeSequence \u1e90 = new SizeSequence();
    public static final String PROPERTY_MARGIN = "margin";
    public static final String PROPERTY_VERTICAL_INDENTION = "verticalIndention";
    public static final String PROPERTY_CONNECTION_LINE_VISIBLE = "connectionLineVisible";
    public static final String PROPERTY_GROUP_HEADER_ENABLED = "groupHeaderEnabled";
    public static final String PROPERTY_GROUP_AREA_BACKGROUND = "groupAreaBackground";
    public static final String PROPERTY_GROUP_AREA_FOREGROUND = "groupAreaForeground";
    public static final String PROPERTY_GROUP_AREA_LABEL_FONT = "groupAreaLabelFont";
    static final int \u1e8f = -2;
    private Insets \u1e98 = \u1e8b;
    private int \u1e8d = -1;
    private int \u1e8a = -1;
    private int \u1e97 = -1;
    private Font \u1e8c;
    private Color \u1e96;
    private Color \u1e94 = Color.GRAY;
    private boolean \u1e92 = true;
    private boolean \u1e8e;
    private static final String \u1e93 = "GroupTableHeaderUI";
    private static final String \u1e95 = "TableHeader.groupTableHeaderUIDelegate";

    public GroupTableHeader(JTable jTable) {
        super(jTable);
        this.\u1e91 = this.createGroupTableInputListener();
    }

    @Override
    public String getActualUIClassID() {
        return \u1e93;
    }

    @Override
    public String getUIDelegateClassID() {
        return \u1e95;
    }

    @Override
    public void setTable(JTable jTable) {
        if (jTable == null || TableModelWrapperUtils.getActualTableModel(jTable.getModel(), GroupModelProvider.class) == null) {
            // empty if block
        }
        super.setTable(jTable);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        Component component = this.getDefaultRenderer().getTableCellRendererComponent(this.getTable(), "", false, false, -1, -1);
        component.applyComponentOrientation(componentOrientation);
        this.repaint();
    }

    public Color getGroupAreaBackground() {
        return this.\u1e96;
    }

    public void setGroupAreaBackground(Color color) {
        Color color2 = this.\u1e96;
        if (color2 != color) {
            this.\u1e96 = color;
            this.firePropertyChange(PROPERTY_GROUP_AREA_BACKGROUND, color2, this.\u1e96);
        }
    }

    public Color getGroupAreaForeground() {
        return this.\u1e94;
    }

    public void setGroupAreaForeground(Color color) {
        Color color2 = this.\u1e94;
        if (color2 != color) {
            this.\u1e94 = color;
            this.firePropertyChange(PROPERTY_GROUP_AREA_FOREGROUND, color2, this.\u1e94);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u1e91.\u0105()) {
            this.\u1e91.\u0101(graphics);
        }
    }

    private int \u02e4() {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        return bl ? this.getMargin().left : this.getMargin().right;
    }

    public int getActualHeaderHeight() {
        return this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate ? ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).getActualHeaderHeight() : super.getPreferredSize().height;
    }

    @Override
    public int getActualHeaderY() {
        if (!this.isGroupHeaderEnabled()) {
            return 0;
        }
        return this.getHeight() - this.getActualHeaderHeight();
    }

    GroupModelProvider \u037a() {
        return (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), GroupModelProvider.class));
    }

    @Override
    public Rectangle getHeaderRect(int n2) {
        Rectangle rectangle = super.getHeaderRect(n2);
        if (!this.isGroupHeaderEnabled()) {
            return rectangle;
        }
        rectangle.y = this.getActualHeaderY();
        rectangle.height = this.getActualHeaderHeight();
        return rectangle;
    }

    @Override
    public int columnAtPoint(Point point) {
        if (!this.isGroupHeaderEnabled()) {
            return super.columnAtPoint(point);
        }
        int n2 = this.getActualHeaderY();
        if (point.y >= n2) {
            return super.columnAtPoint(point);
        }
        return -1;
    }

    public int groupedColumnAtPoint(Point point) {
        if (this.isGroupHeaderEnabled() && point.y < this.getActualHeaderY() - this.getMargin().bottom) {
            int n2;
            int n3 = point.x;
            if (!this.getComponentOrientation().isLeftToRight()) {
                n3 = this.getWidth() - n3;
            }
            if (n3 > this.\u1e90.getPosition(n2 = this.\u1e90.getSizes().length) + this.\u1e90.getSize(n2)) {
                return -1;
            }
            return this.\u1e90.getIndex(n3 - this.\u02e4());
        }
        return -1;
    }

    public Rectangle getGroupedHeaderRect(int n2) {
        GroupModelProvider groupModelProvider = this.\u037a();
        if (!this.isGroupHeaderEnabled() || groupModelProvider == null) {
            return new Rectangle();
        }
        if (n2 >= groupModelProvider.getGroupColumnCount()) {
            return new Rectangle();
        }
        boolean bl = this.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = new Rectangle();
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
            BasicGroupTableHeaderUIDelegate basicGroupTableHeaderUIDelegate = (BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate();
            rectangle.x = this.\u02e4();
            rectangle.y = this.getMargin() == null ? 0 : this.getMargin().top;
            rectangle.width = basicGroupTableHeaderUIDelegate.getActualModelPreferredWidth(groupModelProvider.getGroupColumnAt(n2));
            rectangle.height = basicGroupTableHeaderUIDelegate.getGroupColumnPreferredHeight(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                rectangle.x += basicGroupTableHeaderUIDelegate.getActualModelPreferredWidth(groupModelProvider.getGroupColumnAt(i2)) + this.getMargin().left + this.getMargin().right;
                rectangle.y += this.\u0151(i2 + 1);
            }
        } else {
            rectangle.height = this.getActualHeaderHeight();
            rectangle.y = this.getMargin().top + n2 * this.\u0386();
            int n3 = groupModelProvider.getGroupColumnCount();
            if (n2 < 0) {
                rectangle.x = this.\u02e4();
            } else {
                boolean bl2;
                boolean bl3 = bl2 = n2 >= n3;
                if (bl2) {
                    n2 = n3 - 1;
                }
                rectangle.x = this.\u1e90.getPosition(n2) + this.\u02e4();
                rectangle.width = this.\u1e90.getSize(n2) - this.getMargin().left - this.getMargin().right;
                if (bl2) {
                    rectangle.x += rectangle.width + this.getMargin().left + this.getMargin().right;
                    rectangle.width = 0;
                }
            }
        }
        if (!bl) {
            rectangle.x = this.getWidth() - rectangle.x - rectangle.width;
        }
        return rectangle;
    }

    public void setGroupedWidths(int[] nArray) {
        this.\u1e90.setSizes(nArray);
    }

    protected GroupTableInputListener createGroupTableInputListener() {
        return new GroupTableInputListener(this);
    }

    public void setMargin(Insets insets) {
        if (this.\u1e98 != insets) {
            Insets insets2 = this.\u1e98;
            this.\u1e98 = insets;
            this.firePropertyChange(PROPERTY_MARGIN, insets2, this.\u1e98);
        }
    }

    public Insets getMargin() {
        return this.\u1e98;
    }

    public int getRollOverGroupColumn() {
        return this.\u1e8d;
    }

    void \u0152(int n2) {
        if (n2 != this.\u1e8d) {
            int n3 = this.\u1e8d;
            this.\u1e8d = n2;
            if (n3 != -1) {
                this.repaint(this.getGroupedHeaderRect(n3));
            }
            if (n2 != -1) {
                this.repaint(this.getGroupedHeaderRect(n2));
            }
        }
    }

    protected int toggleSortOrder(int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return -1;
        }
        return 1;
    }

    public String getResourceString(String string) {
        return GridResource.getResourceBundle(this.getLocale()).getString(string);
    }

    private int \u0151(int n2) {
        if (this.getVerticalIndention() < 0 && this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
            return ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).getGroupColumnPreferredHeight(n2) / 2;
        }
        return this.getVerticalIndention();
    }

    private int \u0386() {
        if (this.getVerticalIndention() < 0) {
            return this.getActualHeaderHeight() / 2;
        }
        return this.getVerticalIndention();
    }

    public int getVerticalIndention() {
        return this.\u1e8a;
    }

    public void setVerticalIndention(int n2) {
        if (this.\u1e8a != n2) {
            int n3 = this.\u1e8a;
            this.\u1e8a = n2;
            this.firePropertyChange(PROPERTY_VERTICAL_INDENTION, n3, this.\u1e8a);
            this.revalidate();
            this.repaint();
            if (this.getParent() != null) {
                this.getParent().invalidate();
                this.getParent().repaint();
            }
        }
    }

    public boolean isConnectionLineVisible() {
        return this.\u1e92;
    }

    public void setConnectionLineVisible(boolean bl) {
        if (this.\u1e92 != bl) {
            boolean bl2 = this.\u1e92;
            this.\u1e92 = bl;
            this.firePropertyChange(PROPERTY_CONNECTION_LINE_VISIBLE, bl2, this.\u1e92);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isGroupHeaderEnabled() {
        return this.\u1e8e;
    }

    public void setGroupHeaderEnabled(boolean bl) {
        if (this.\u1e8e != bl) {
            boolean bl2 = this.\u1e8e;
            this.\u1e8e = bl;
            if (this.\u1e8e) {
                JideSwingUtilities.insertMouseListener(this, this.\u1e91, 0);
                JideSwingUtilities.insertMouseMotionListener(this, this.\u1e91, 0);
            } else {
                this.removeMouseListener(this.\u1e91);
                this.removeMouseListener(this.\u1e91);
            }
            this.firePropertyChange(PROPERTY_GROUP_HEADER_ENABLED, bl2, this.\u1e8e);
            this.revalidate();
            this.repaint();
            if (this.getParent() != null) {
                this.getParent().invalidate();
                this.getParent().repaint();
            }
        }
    }

    public int getLabelHeight() {
        return this.\u1e97;
    }

    public void setLabelHeight(int n2) {
        if (this.\u1e97 == n2) {
            return;
        }
        this.\u1e97 = n2;
        this.invalidate();
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
        }
    }

    public Font getLabelFont() {
        return this.\u1e8c;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.\u1e8c;
        if (font2 != font) {
            this.\u1e8c = font;
            this.firePropertyChange(PROPERTY_GROUP_AREA_LABEL_FONT, font2, this.\u1e8c);
        }
    }
}

