/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleCustomizer;
import com.jidesoft.grid.EditableColumnTableModel;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TextFieldCellEditor;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EditableTableHeader
extends SortableTableHeader
implements CellEditorListener {
    private static final String \u1e76 = "EditableTableHeaderUI";
    private static final String \u1e75 = "TableHeader.editableTableHeaderUIDelegate";
    public final int HEADER_ROW = -1;
    protected transient int _editingColumn = -1;
    protected transient TableCellEditor _cellEditor = null;
    protected transient Component _editorComp;
    protected TableCellEditor _defaultEditor;
    private PropertyChangeListener \u1e7a = null;
    private boolean \u1e77 = false;
    private MouseMotionListener \u1e79;
    private boolean \u1e78 = true;

    public EditableTableHeader(JTable jTable) {
        this(jTable.getColumnModel());
        this.setTable(jTable);
    }

    public EditableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.updateUI();
        this.setDefaultEditor(this.createDefaultEditor());
    }

    @Override
    public String getUIDelegateClassID() {
        return \u1e75;
    }

    @Override
    public String getActualUIClassID() {
        return \u1e76;
    }

    public boolean isRolloverEnabled() {
        return this.\u1e77;
    }

    public void setRolloverEnabled(boolean bl) {
        this.\u1e77 = bl;
    }

    @Override
    public void resizeAndRepaint() {
        this.stopEditing();
        super.resizeAndRepaint();
    }

    void \u02e1() {
        super.resizeAndRepaint();
    }

    public void stopEditing() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    protected TableCellEditor createDefaultEditor() {
        return new TextFieldCellEditor(String.class){
            private static final long \u04e7 = 7000472489985396150L;

            @Override
            protected JTextField createTextField() {
                JTextField jTextField = new JTextField();
                jTextField.registerKeyboardAction(new AbstractAction(){
                    private static final long \u0102 = 1237176950615312409L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.cancelCellEditing();
                    }
                }, KeyStroke.getKeyStroke(27, 0), 0);
                return jTextField;
            }
        };
    }

    public void setDefaultEditor(TableCellEditor tableCellEditor) {
        this._defaultEditor = tableCellEditor;
    }

    public TableCellEditor getDefaultEditor() {
        return this._defaultEditor;
    }

    public boolean editCellAt(int n2) {
        return this.editCellAt(n2, null);
    }

    @Override
    public void setDraggedColumn(TableColumn tableColumn) {
        if (tableColumn == null && this.getDraggedColumn() != null && !this.isRolloverEnabled()) {
            this.stopEditing();
        }
        super.setDraggedColumn(tableColumn);
    }

    public boolean editCellAt(int n2, EventObject eventObject) {
        Object object;
        if (this._cellEditor != null && !this._cellEditor.stopCellEditing()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.getColumnModel().getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n2)) {
            return false;
        }
        if (this.\u1e7a == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.\u1e7a = new A((KeyboardFocusManager)object);
            ((KeyboardFocusManager)object).addPropertyChangeListener("permanentFocusOwner", this.\u1e7a);
        }
        if ((object = this.getCellEditor(n2)) != null && object.isCellEditable(eventObject)) {
            this._editorComp = this.prepareEditor((TableCellEditor)object, n2);
            this.customizeEditorComponent(this._editorComp, this.getRowCount() - 1, n2);
            this._editorComp.setBounds(this.getHeaderRect(n2));
            this.\u0108(this._editorComp);
            this.add(this._editorComp);
            this._editorComp.validate();
            if (this.isAutoRequestFocus()) {
                this._editorComp.requestFocusInWindow();
            }
            this.setCellEditor((TableCellEditor)object);
            this.setEditingColumn(n2);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    protected void customizeEditorComponent(Component component, int n2, int n3) {
        CellStyleCustomizer[] cellStyleCustomizerArray;
        if (component == null) {
            return;
        }
        component.applyComponentOrientation(this.getComponentOrientation());
        CellStyle cellStyle = this.getCellStyleAt(n2, n3);
        if (cellStyle == null) {
            return;
        }
        Color color = cellStyle.getBackground();
        Color color2 = cellStyle.getForeground();
        if (!(color == null || color.equals(component.getBackground()) && color.equals(component.getBackground()))) {
            component.setBackground(color);
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
            }
        }
        if (!(color2 == null || color2.equals(component.getForeground()) && color2.equals(component.getForeground()))) {
            component.setForeground(color2);
        }
        if (!(cellStyle.getFont() == null || cellStyle.getFont().equals(component.getFont()) && cellStyle.getFont().equals(component.getFont()))) {
            component.setFont(cellStyle.getFont());
        } else if (cellStyle.getFontStyle() != -1 && cellStyle.getFontStyle() != (component.getFont() == null ? 0 : component.getFont().getStyle()) && (cellStyleCustomizerArray = component.getFont()) != null) {
            int n4 = cellStyle.getFontStyle();
            Font font = cellStyleCustomizerArray.deriveFont(n4);
            component.setFont(font);
        }
        if (cellStyle.getBorder() != null && component instanceof JComponent && !cellStyle.getBorder().equals(((JComponent)component).getBorder())) {
            ((JComponent)component).setBorder(cellStyle.getBorder());
        }
        if (component instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                ((JLabel)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JLabel)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((JLabel)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                ((JLabel)component).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                ((JLabel)component).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
        } else if (component instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                ((AbstractButton)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AbstractButton)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AbstractButton)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                ((AbstractButton)component).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                ((AbstractButton)component).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
        } else if (component instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JTextField)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
        } else if (component instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (cellStyle.getToolTipText() != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(cellStyle.getToolTipText());
        }
        if (this.getCellStyleCustomizers() != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this.getCellStyleCustomizers()) {
                cellStyleCustomizer.customizeEditorComponent(n2, n3, component, cellStyle);
            }
        }
    }

    private void \u0109(Component component) {
        if (this.\u1e79 != null) {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                @Override
                public void action(Component component) {
                    if (JideSwingUtilities.isListenerRegistered(component, MouseMotionListener.class, (EventListener)EditableTableHeader.this.\u1e79)) {
                        component.removeMouseMotionListener(EditableTableHeader.this.\u1e79);
                    }
                }

                @Override
                public void postAction(Component component) {
                }

                @Override
                public boolean condition(Component component) {
                    return true;
                }
            });
            this.\u1e79 = null;
        }
    }

    private void \u0108(Component component) {
        if (this.\u1e79 == null) {
            this.\u1e79 = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, EditableTableHeader.this);
                }
            };
        }
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

            @Override
            public void action(Component component) {
                if (!JideSwingUtilities.isListenerRegistered(component, MouseMotionListener.class, (EventListener)EditableTableHeader.this.\u1e79)) {
                    component.addMouseMotionListener(EditableTableHeader.this.\u1e79);
                }
            }

            @Override
            public void postAction(Component component) {
            }

            @Override
            public boolean condition(Component component) {
                return true;
            }
        });
    }

    public boolean isCellEditable(int n2) {
        TableColumn tableColumn = this.columnModel.getColumn(n2);
        int n3 = tableColumn.getModelIndex();
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), EditableColumnTableModel.class);
        return tableModel == null || ((EditableColumnTableModel)((Object)tableModel)).isColumnHeaderEditable(n3);
    }

    public TableCellEditor getCellEditor(int n2) {
        TableColumn tableColumn = this.columnModel.getColumn(n2);
        int n3 = tableColumn.getModelIndex();
        TableCellEditor tableCellEditor = null;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), EditableColumnTableModel.class);
        if (tableModel != null) {
            tableCellEditor = ((EditableColumnTableModel)((Object)tableModel)).getColumnHeaderCellEditor(n3);
        }
        return tableCellEditor == null ? this.getDefaultEditor() : tableCellEditor;
    }

    protected void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this._cellEditor;
        this._cellEditor = tableCellEditor;
        if (tableCellEditor2 != null) {
            tableCellEditor2.removeCellEditorListener(this);
        }
        if (tableCellEditor != null) {
            tableCellEditor.addCellEditorListener(this);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n2) {
        Object object = this.columnModel.getColumn(n2).getHeaderValue();
        boolean bl = true;
        int n3 = -1;
        JTable jTable = this.getTable();
        return tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n3, n2);
    }

    public TableCellEditor getCellEditor() {
        return this._cellEditor;
    }

    public Component getEditorComponent() {
        return this._editorComp;
    }

    public void setEditingColumn(int n2) {
        this._editingColumn = n2;
    }

    public int getEditingColumn() {
        return this._editingColumn;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.\u1e7a);
        this.\u1e7a = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            this.\u0109(this._editorComp);
            this.remove(this._editorComp);
            int n2 = this.getEditingColumn();
            Rectangle rectangle = this.getHeaderRect(n2);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this._editorComp = null;
            this.repaint(rectangle);
        }
    }

    public boolean isEditing() {
        return this._cellEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            int n2 = this.getEditingColumn();
            if (n2 >= 0 && n2 < this.columnModel.getColumnCount()) {
                this.columnModel.getColumn(n2).setHeaderValue(object);
                if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate) {
                    ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).invalidateCache(true);
                }
            }
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.\u1e7a);
        this.\u1e7a = null;
        super.removeNotify();
    }

    public boolean isClickToStartEditing() {
        return this.\u1e78;
    }

    public void setClickToStartEditing(boolean bl) {
        this.\u1e78 = bl;
    }

    protected boolean isAutoRequestFocus() {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(EditableTableHeader.class.getName(), 4);
        }
    }

    class A
    implements PropertyChangeListener {
        KeyboardFocusManager \u0102;

        public A(KeyboardFocusManager keyboardFocusManager) {
            this.\u0102 = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (!EditableTableHeader.this.isEditing()) {
                return;
            }
            if (SystemInfo.isJdk15Above()) {
                try {
                    object2 = MouseInfo.getPointerInfo();
                    if (object2 != null) {
                        object = ((PointerInfo)object2).getLocation();
                        SwingUtilities.convertPointFromScreen((Point)object, EditableTableHeader.this);
                        if (EditableTableHeader.this.contains((Point)object)) {
                            return;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((object = EditableTableHeader.this.getCellEditor()) != null) {
                for (object2 = this.\u0102.getPermanentFocusOwner(); object2 != null; object2 = ((Component)object2).getParent()) {
                    if (object2 == EditableTableHeader.this) {
                        return;
                    }
                    if (!(object2 instanceof Window) && (!(object2 instanceof Applet) || ((Component)object2).getParent() != null)) continue;
                    if (object2 != SwingUtilities.getRoot(EditableTableHeader.this) || object.stopCellEditing()) break;
                    object.cancelCellEditing();
                    break;
                }
            }
        }
    }
}

