/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.B;
import com.jidesoft.document.CloneableDocumentComponent;
import com.jidesoft.document.D;
import com.jidesoft.document.DefaultStringConverter;
import com.jidesoft.document.DialogFloatingDocumentContainer;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentComponentFactory;
import com.jidesoft.document.DocumentPanePersistenceUtils;
import com.jidesoft.document.E;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.FrameFloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.document.PopupMenuCustomizer;
import com.jidesoft.document.TdiGroup;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class DocumentPane
extends JideSplitPane
implements SwingConstants,
IDocumentPane,
ChangeListener,
PropertyChangeListener {
    private final Map<String, DocumentComponent> \u01b4 = new HashMap<String, DocumentComponent>();
    private final Map<Component, String> \u01c6 = new HashMap<Component, String>();
    private final List<String> \u01be = new ArrayList<String>();
    final List<FloatingDocumentContainer> \u01bc = new ArrayList<FloatingDocumentContainer>();
    private Border \u01af;
    protected int _tabPlacement = 1;
    private String \u01b0;
    private PopupMenuCustomizer \u01bb;
    private StringConverter \u01c7;
    private static final StringConverter \u01b2;
    private boolean \u01ba = true;
    private boolean \u01b6 = true;
    private boolean \u01b1 = true;
    private boolean \u01a9 = true;
    private boolean \u01c0 = true;
    public static final int TABBED_DOCUMENT_INTERFACE = 1;
    private static final int \u01c4 = 2;
    private TabbedPaneCustomizer \u01c1;
    private int \u01ae = 1;
    private boolean \u01b9 = true;
    private AbstractLayoutPersistence \u01ab = new A();
    private B \u01b8 = new B(this);
    private PropertyChangeListener \u01b5;
    private boolean \u01c5 = true;
    String \u01a8 = null;
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    public static final String PROPERTY_MAXIMUM_GROUP_COUNT = "maximumGroupCount";
    private boolean \u01c3 = false;
    private int \u01b3 = 0;
    private boolean \u01b7 = true;
    private int \u01c2;
    private DocumentTabColorProvider \u01bf;
    private int \u01aa = 1;
    public static final String PROPERTY_FLOATING_CONTAINER_TYPE = "floatingContainerType";
    public static final String CONTEXT_MENU_CLOSE = "DocumentPane.close";
    public static final String CONTEXT_MENU_CLOSE_OTHERS = "DocumentPane.closeOthers";
    public static final String CONTEXT_MENU_CLOSE_ALL = "DocumentPane.closeAll";
    public static final String CONTEXT_MENU_NEXT = "DocumentPane.next";
    public static final String CONTEXT_MENU_PREVIOUS = "DocumentPane.previous";
    public static final String CONTEXT_MENU_NEW_HORIZONTAL_GROUP = "DocumentPane.newHorizontalGroup";
    public static final String CONTEXT_MENU_NEW_VERTICAL_GROUP = "DocumentPane.newVerticalGroup";
    public static final String CONTEXT_MENU_SPLIT_HORIZONTALLY = "DocumentPane.splitHorizontally";
    public static final String CONTEXT_MENU_SPLIT_VERTICALLY = "DocumentPane.splitVertically";
    public static final String CONTEXT_MENU_MOVE_TO_NEXT = "DocumentPane.moveToNext";
    public static final String CONTEXT_MENU_MOVE_TO_PREVIOUS = "DocumentPane.moveToPrevious";
    public static final String CONTEXT_MENU_MOVE_TO_THIS = "DocumentPane.moveToThis";
    public static final String CONTEXT_MENU_CHANGE_ORIENTATION = "DocumentPane.changeOrientation";
    public static final String CONTEXT_MENU_FLOATING = "DocumentPane.floating";
    public static final String CONTEXT_MENU_DOCKING = "DocumentPane.docking";
    public static final String CONTEXT_MENU_CANCEL = "DocumentPane.cancel";
    private boolean \u01bd = true;
    List<DocumentComponent> \u01ad;
    private DocumentComponentFactory \u01ac;

    public DocumentPane() {
        this.\u0112();
    }

    @Override
    public Color getBackground() {
        return UIDefaultsLookup.getColor("Workspace.background");
    }

    @Override
    public void openDocument(DocumentComponent documentComponent) {
        this.openDocument(documentComponent, false);
    }

    public void openDocument(final DocumentComponent documentComponent, final boolean bl) {
        if (documentComponent == null) {
            throw new IllegalArgumentException("The document that passed in is null.");
        }
        if (this.\u01b4.get(documentComponent.getName()) != null) {
            throw new IllegalArgumentException("The document with name \"" + documentComponent.getName() + "\" has been opened. Please specify a new name for this document.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(documentComponent, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0101(documentComponent, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0101(DocumentComponent documentComponent, boolean bl) {
        documentComponent.setDocumentPane(this);
        this.\u0101(documentComponent);
        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
        if (bl) {
            IDocumentGroup iDocumentGroup = this.createDocumentGroup();
            this.add((Component)((Object)iDocumentGroup), "flexible");
            iDocumentGroup.addDocument(documentComponent);
            this.floatDocument(documentComponent.getName());
            documentComponent.\u0101(5999);
        } else {
            IDocumentGroup iDocumentGroup;
            if (this.getComponentCount() == 0) {
                iDocumentGroup = this.createDocumentGroup();
                this.add((Component)((Object)iDocumentGroup), "flexible");
            } else {
                String string = this.getActiveDocumentName();
                if (string != null && !this.isDocumentFloating(string)) {
                    iDocumentGroup = this.getDocumentGroup(string);
                } else if (this.getPaneCount() > 0) {
                    iDocumentGroup = (IDocumentGroup)((Object)this.getPaneAt(0));
                } else {
                    iDocumentGroup = this.createDocumentGroup();
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                }
                if (iDocumentGroup == null) {
                    Component component = this.getComponent(0);
                    if (component instanceof IDocumentGroup) {
                        iDocumentGroup = (IDocumentGroup)((Object)this.getComponent(0));
                    } else {
                        throw new RuntimeException("Invalid component in DocumentPane. Except TabbedPane, get " + component.getClass().getName());
                    }
                }
            }
            iDocumentGroup.addDocument(documentComponent);
            documentComponent.\u0101(5999);
        }
    }

    @Override
    public boolean isDocumentOpened(String string) {
        return this.\u01b4.get(string) != null;
    }

    void \u0101(DocumentComponent documentComponent) {
        this.\u0101(documentComponent, -1);
    }

    private void \u0101(DocumentComponent documentComponent, int n2) {
        this.\u01b4.put(documentComponent.getName(), documentComponent);
        this.\u01c6.put(documentComponent.getComponent(), documentComponent.getName());
        if (n2 < 0) {
            this.\u01be.add(documentComponent.getName());
        } else {
            this.\u01be.add(n2, documentComponent.getName());
        }
        documentComponent.addPropertyChangeListener(this);
    }

    private void \u0101(String string, Component component) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            documentComponent.removePropertyChangeListener(this);
        }
        this.\u01b4.remove(string);
        if (component != null) {
            this.\u01c6.remove(component);
            this.\u01be.remove(string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        IDocumentGroup iDocumentGroup;
        if ("component".equals(propertyChangeEvent.getPropertyName())) {
            TdiGroup tdiGroup;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent && (tdiGroup = (TdiGroup)E.\u0101((Component)propertyChangeEvent.getOldValue(), this)) != null) {
                DocumentComponent documentComponent = (DocumentComponent)object;
                tdiGroup.updateComponent(documentComponent, (Component)propertyChangeEvent.getOldValue());
                this.\u0101(documentComponent.getName(), (Component)propertyChangeEvent.getOldValue());
                this.\u0101(documentComponent);
            }
        } else if ("title".equals(propertyChangeEvent.getPropertyName()) || "tooltip".equals(propertyChangeEvent.getPropertyName()) || "background".equals(propertyChangeEvent.getPropertyName()) || "foreground".equals(propertyChangeEvent.getPropertyName()) || "icon".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent) {
                String string = ((DocumentComponent)object).getName();
                this.updateDocument(string);
            }
        } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent) {
                String string = ((DocumentComponent)object).getName();
                this.updateDocument(string);
            }
        } else if ("closable".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof DocumentComponent && (iDocumentGroup = this.getDocumentGroup(((DocumentComponent)propertyChangeEvent.getSource()).getName())) instanceof JideTabbedPane) {
            ((JideTabbedPane)((Object)iDocumentGroup)).updateUI();
        }
    }

    @Override
    public void activateGroup(IDocumentGroup iDocumentGroup) {
        String string = this.getActiveDocumentName();
        IDocumentGroup iDocumentGroup2 = this.getDocumentGroup(string);
        if (iDocumentGroup != null && iDocumentGroup.equals(iDocumentGroup2)) {
            if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab")) {
                if (iDocumentGroup2 instanceof JideTabbedPane) {
                    ((JideTabbedPane)((Object)iDocumentGroup2)).setBoldActiveTab(true);
                }
                for (int i2 = 0; i2 < this.getDocumentGroupCount(); ++i2) {
                    IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(i2);
                    if (iDocumentGroup3 == iDocumentGroup2 || !(iDocumentGroup3 instanceof JideTabbedPane)) continue;
                    ((JideTabbedPane)((Object)iDocumentGroup3)).setBoldActiveTab(false);
                }
            }
            if (this.\u01b0 != null && this.getDocument(this.\u01b0) != null && iDocumentGroup.getDocumentCount() > 0) {
                iDocumentGroup.setSelectedDocument(this.getDocument(this.\u01b0).getComponent());
            }
            return;
        }
        if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab") && iDocumentGroup2 instanceof JideTabbedPane) {
            ((JideTabbedPane)((Object)iDocumentGroup2)).setBoldActiveTab(false);
        }
        if (iDocumentGroup != null) {
            this.setActiveDocument(this.getNameOf(iDocumentGroup.getSelectedDocument()));
            if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab") && iDocumentGroup instanceof JideTabbedPane) {
                ((JideTabbedPane)((Object)iDocumentGroup)).setBoldActiveTab(true);
            }
        }
    }

    protected IDocumentGroup createDocumentGroup() {
        switch (this.\u01ae) {
            case 2: {
                return null;
            }
        }
        final TdiGroup tdiGroup = this.createTdiGroup();
        tdiGroup.setTabPlacement(this.getTabPlacement());
        tdiGroup.setBorder(this.\u01af);
        tdiGroup.setCloseAction(new AbstractAction(){
            private static final long \u0103 = -730159551624518149L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof Component) {
                    DocumentPane.this.closeSingleDocument(DocumentPane.this.getNameOf((Component)actionEvent.getSource()));
                } else {
                    DocumentPane.this.closeSingleDocument(DocumentPane.this.getNameOf(tdiGroup.getSelectedDocument()));
                }
            }
        });
        tdiGroup.setShowTabButtons(true);
        tdiGroup.setShowIconsOnTab(true);
        tdiGroup.setUseDefaultShowIconsOnTab(false);
        tdiGroup.setUseDefaultShowCloseButtonOnTab(true);
        tdiGroup.getModel().addChangeListener(this);
        tdiGroup.setStringConverter(this.getTitleConverter());
        if (this.\u01b5 == null) {
            this.\u01b5 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof Integer && propertyChangeEvent.getSource() instanceof JideTabbedPane) {
                        int n2 = (Integer)propertyChangeEvent.getNewValue();
                        String string = ((JideTabbedPane)propertyChangeEvent.getSource()).getTitleAt(n2);
                        String string2 = DocumentPane.this.getNameOf(((JideTabbedPane)propertyChangeEvent.getSource()).getComponentAt(n2));
                        DocumentComponent documentComponent = DocumentPane.this.getDocument(string2);
                        if (documentComponent != null) {
                            documentComponent.setTitle(string);
                        }
                    }
                }
            };
        }
        tdiGroup.addPropertyChangeListener("indexForTitle", this.\u01b5);
        if (this.\u01c1 != null) {
            this.\u01c1.customize(tdiGroup);
        }
        return tdiGroup;
    }

    @Override
    public IDocumentGroup getDocumentGroup(String string) {
        IDocumentGroup iDocumentGroup;
        DocumentComponent documentComponent;
        if (string != null && (documentComponent = this.getDocument(string)) != null && (iDocumentGroup = (IDocumentGroup)((Object)SwingUtilities.getAncestorOfClass(IDocumentGroup.class, documentComponent.getComponent()))) != null) {
            return iDocumentGroup;
        }
        return null;
    }

    protected TdiGroup createTdiGroup() {
        return new TdiGroup();
    }

    @Override
    public void closeDocument(String string) {
        this.\u0103(string, false);
    }

    private void \u0103(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(string, this.\u01bd, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPane.this.\u0101(string, DocumentPane.this.\u01bd, bl);
                }
            });
        }
    }

    private void \u0101(String string, boolean bl, boolean bl2) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (!documentComponent.isClosable() && !bl2) {
            return;
        }
        documentComponent.setAllowClosing(true);
        documentComponent.\u0101(6000);
        if (documentComponent.allowClosing()) {
            JComponent jComponent = documentComponent.getComponent();
            int n2 = this.getDocumentGroupCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(i2);
                for (int i3 = 0; i3 < iDocumentGroup.getDocumentCount(); ++i3) {
                    Component component = iDocumentGroup.getDocumentAt(i3);
                    if (!component.equals(jComponent)) continue;
                    this.\u0101(iDocumentGroup, i3, string, jComponent, documentComponent, bl);
                    return;
                }
            }
        }
    }

    private void \u0101(final IDocumentGroup iDocumentGroup, final int n2, final String string, final Component component, final DocumentComponent documentComponent, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(documentComponent, iDocumentGroup, n2, string, component, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0101(documentComponent, iDocumentGroup, n2, string, component, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
        documentComponent.\u0101(6001);
    }

    private void \u0101(DocumentComponent documentComponent, IDocumentGroup iDocumentGroup, int n2, String string, Component component, boolean bl) {
        if (documentComponent == null || iDocumentGroup == null) {
            return;
        }
        DocumentComponent documentComponent2 = this.getActiveDocument();
        if (documentComponent2 != null && documentComponent2.equals(documentComponent)) {
            this.setActiveDocument(null, false);
        }
        documentComponent.cleanup();
        iDocumentGroup.removeDocument(n2);
        this.\u0101(iDocumentGroup);
        this.\u0101(string, component);
        if (bl) {
            this.\u0102(iDocumentGroup);
        }
        this.repaint();
    }

    private void \u0102(IDocumentGroup iDocumentGroup) {
        if (iDocumentGroup != null && iDocumentGroup.getDocumentCount() > 0) {
            this.\u0102(this.getNameOf(iDocumentGroup.getSelectedDocument()), true);
        } else if (this.getDocumentGroupCount() > 0) {
            this.activateGroup(this.getDocumentGroupAt(0));
        } else {
            this.\u01b0 = null;
        }
    }

    @Override
    public void closeSingleDocument(String string) {
        this.closeDocument(string);
    }

    @Override
    public void closeAll() {
        this.closeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(boolean bl) {
        Set<String> set = this.\u01b4.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        this.\u01bd = false;
        this.\u01a8 = null;
        try {
            for (String string : stringArray) {
                if (bl) {
                    this.\u0103(string, bl);
                    continue;
                }
                this.closeDocument(string);
            }
        }
        finally {
            this.\u01bd = true;
        }
    }

    @Override
    public void closeAllButThis(String string) {
        String[] stringArray;
        Set<String> set = this.\u01b4.keySet();
        for (String string2 : stringArray = set.toArray(new String[set.size()])) {
            if (string.equals(string2)) continue;
            this.closeDocument(string2);
        }
    }

    @Override
    public void setActiveDocument(String string) {
        this.setActiveDocument(string, true);
    }

    @Override
    public void setActiveDocument(final String string, final boolean bl) {
        if (string != null && string.equals(this.\u01b0) && !bl) {
            return;
        }
        if (bl) {
            this.\u01a8 = string;
        }
        if (string != null && !this.isDocumentOpened(string)) {
            throw new IllegalArgumentException("Document \"" + string + "\" is not opened.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0102(string, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0102(string, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0102(String string, boolean bl) {
        if (!JideSwingUtilities.equals(this.\u01b0, string)) {
            DocumentComponent documentComponent = this.getActiveDocument();
            TdiGroup tdiGroup = null;
            if (documentComponent != null) {
                tdiGroup = (TdiGroup)E.\u0101(documentComponent.getComponent(), this);
                documentComponent.\u0101(6003);
            }
            this.\u01b0 = string;
            DocumentComponent documentComponent2 = this.getActiveDocument();
            IDocumentGroup iDocumentGroup = null;
            if (documentComponent2 != null) {
                documentComponent2.\u0101(6002);
                iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent2.getComponent(), this));
            }
            if (tdiGroup != null && this.isUpdateTitle()) {
                tdiGroup.updateTitle(documentComponent);
            }
            if (iDocumentGroup != null) {
                iDocumentGroup.setSelectedDocument(documentComponent2.getComponent());
                this.activateGroup(iDocumentGroup);
                if (this.isUpdateTitle()) {
                    iDocumentGroup.updateTitle(documentComponent2);
                }
            } else {
                this.activateGroup(null);
            }
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPane.this.requestFocusForActiveDocument();
                }
            });
        }
    }

    protected void requestFocusForActiveDocument() {
        DocumentComponent documentComponent = this.getActiveDocument();
        if (documentComponent != null) {
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
            if (documentComponent.getLastFocusedComponent() != null || documentComponent.getDefaultFocusComponent() != null) {
                documentComponent.refocusLastFocusedComponent();
            } else if (iDocumentGroup instanceof TdiGroup && ((TdiGroup)iDocumentGroup).getLastFocusedComponent(iDocumentGroup.getSelectedDocument()) == null) {
                ((TdiGroup)iDocumentGroup).requestFocus();
            } else {
                documentComponent.refocusLastFocusedComponent();
            }
        }
    }

    @Override
    public DocumentComponent getActiveDocument() {
        return this.getDocument(this.getActiveDocumentName());
    }

    @Override
    public String getActiveDocumentName() {
        return this.\u01b0;
    }

    @Override
    public void nextDocument() {
        if (this.\u01b0 != null) {
            DocumentComponent documentComponent = this.getDocument(this.\u01b0);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) < iDocumentGroup.getDocumentCount() - 1) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) + 1);
                iDocumentGroup.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else if (this.getDocumentGroupCount() > 1 && this.indexOfDocumentGroup(iDocumentGroup) < this.getDocumentGroupCount() - 1) {
                IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(this.indexOfPane((Component)((Object)iDocumentGroup)) + 1);
                Component component = iDocumentGroup2.getDocumentAt(0);
                iDocumentGroup2.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else {
                IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(0);
                if (iDocumentGroup3 != null) {
                    Component component = iDocumentGroup3.getDocumentAt(0);
                    iDocumentGroup3.setSelectedDocument(component);
                    this.setActiveDocument(this.getNameOf(component));
                }
            }
        }
    }

    @Override
    public void prevDocument() {
        if (this.\u01b0 != null) {
            DocumentComponent documentComponent = this.getDocument(this.\u01b0);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) > 0) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) - 1);
                iDocumentGroup.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else if (this.getDocumentGroupCount() > 1 && this.indexOfDocumentGroup(iDocumentGroup) > 0) {
                IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(this.indexOfDocumentGroup(iDocumentGroup) - 1);
                Component component = iDocumentGroup2.getDocumentAt(iDocumentGroup2.getDocumentCount() - 1);
                iDocumentGroup2.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else {
                IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(this.getDocumentGroupCount() - 1);
                if (iDocumentGroup3 != null) {
                    Component component = iDocumentGroup3.getDocumentAt(iDocumentGroup3.getDocumentCount() - 1);
                    iDocumentGroup3.setSelectedDocument(component);
                    this.setActiveDocument(this.getNameOf(component));
                }
            }
        }
    }

    public String getNextDocument(String string) {
        if (string != null) {
            DocumentComponent documentComponent = this.getDocument(string);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) < iDocumentGroup.getDocumentCount() - 1) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) + 1);
                return this.getNameOf(component);
            }
            if (this.getPaneCount() > 1 && this.indexOfPane((Component)((Object)iDocumentGroup)) >= 0 && this.indexOfPane((Component)((Object)iDocumentGroup)) < this.getPaneCount() - 1) {
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(this.indexOfPane((Component)((Object)iDocumentGroup)) + 1));
                Component component = iDocumentGroup2.getDocumentAt(0);
                return this.getNameOf(component);
            }
        } else if (this.getDocumentGroupCount() > 0 && this.getDocumentGroupAt(0) != null && this.getDocumentGroupAt(0).getDocumentCount() > 0) {
            return this.getNameOf(this.getDocumentGroupAt(0).getDocumentAt(0));
        }
        return null;
    }

    public String getPreviousDocument(String string) {
        if (string != null) {
            DocumentComponent documentComponent = this.getDocument(string);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) > 0) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) - 1);
                return this.getNameOf(component);
            }
            if (this.getPaneCount() > 1 && this.indexOfPane((Component)((Object)iDocumentGroup)) > 0) {
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(this.indexOfPane((Component)((Object)iDocumentGroup)) - 1));
                Component component = iDocumentGroup2.getDocumentAt(iDocumentGroup2.getDocumentCount() - 1);
                return this.getNameOf(component);
            }
        } else if (this.getDocumentGroupCount() > 0 && this.getDocumentGroupAt(this.getDocumentGroupCount() - 1) != null && this.getDocumentGroupAt(this.getDocumentGroupCount() - 1).getDocumentCount() > 0) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(this.getDocumentGroupCount() - 1);
            return this.getNameOf(iDocumentGroup.getDocumentAt(iDocumentGroup.getDocumentCount() - 1));
        }
        return null;
    }

    @Override
    public void moveDocument(String string, int n2) {
        this.moveDocument(string, n2, -1);
    }

    @Override
    public void moveDocument(String string, final int n2, final int n3) {
        if (n2 != 0 && !this.isGroupsAllowed()) {
            return;
        }
        if (n2 < 0 || n2 >= this.getPaneCount()) {
            throw new IllegalArgumentException("Group index out of bound " + n2 + " " + this.getComponentCount());
        }
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            throw new IllegalArgumentException("Document with name \"" + string + "\" doesn't exist. Call openDocument first to open it first.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0102(documentComponent, n2, n3);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0102(documentComponent, n2, n3);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0102(DocumentComponent documentComponent, int n2, int n3) {
        IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.getDocumentGroupCount()) {
            n2 = this.getDocumentGroupCount() - 1;
        }
        IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(n2));
        documentComponent.\u0101(6004);
        if (documentComponent.allowMoving()) {
            if (!iDocumentGroup.equals(iDocumentGroup2)) {
                iDocumentGroup.removeDocument(documentComponent);
                iDocumentGroup2.addDocument(documentComponent);
                this.\u0101(iDocumentGroup);
            }
            iDocumentGroup2.setSelectedDocument(documentComponent.getComponent());
            if (n3 != -1) {
                iDocumentGroup2.moveSelectedDocumentTo(n3);
            }
            this.\u0102(documentComponent.getName(), true);
            documentComponent.\u0101(6005);
        }
    }

    private void \u0101(IDocumentGroup iDocumentGroup) {
        Container container;
        if (this.isDocumentGroupEmpty(iDocumentGroup) && (container = ((Component)((Object)iDocumentGroup)).getParent()) != null) {
            JideSwingUtilities.removeFromParentWithFocusTransfer((Component)((Object)iDocumentGroup));
            if (iDocumentGroup instanceof TdiGroup) {
                ((TdiGroup)iDocumentGroup).uninstallListeners();
            }
        }
    }

    protected boolean isDocumentGroupEmpty(IDocumentGroup iDocumentGroup) {
        return iDocumentGroup.getDocumentCount() == 0;
    }

    @Override
    public void newDocumentGroup(final String string, final int n2, final int n3) {
        if (!this.isGroupsAllowed()) {
            return;
        }
        if (!this.isMoreDocumentGroupAllowed()) {
            return;
        }
        if (string == null) {
            return;
        }
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(documentComponent, n2, n3);
            this.activateGroup(this.getDocumentGroup(string));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0101(documentComponent, n2, n3);
                        DocumentPane.this.activateGroup(DocumentPane.this.getDocumentGroup(string));
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0101(DocumentComponent documentComponent, int n2, int n3) {
        if (this.isMoreDocumentGroupAllowed()) {
            documentComponent.\u0101(6004);
            if (documentComponent.allowMoving()) {
                if (n3 != this.getOrientation()) {
                    this.setOrientation(n3);
                }
                IDocumentGroup iDocumentGroup = this.createDocumentGroup();
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)E.\u0101(documentComponent.getComponent(), this));
                iDocumentGroup2.removeDocument(documentComponent);
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > this.getDocumentGroupCount()) {
                    n2 = this.getDocumentGroupCount();
                }
                if (n2 * 2 > this.getComponentCount()) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    this.add((Component)((Object)iDocumentGroup), "flexible", n2 * 2);
                }
                iDocumentGroup.addDocument(documentComponent);
                this.remove((Component)((Object)iDocumentGroup));
                if (n2 * 2 > this.getComponentCount()) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    this.add((Component)((Object)iDocumentGroup), "flexible", n2 * 2);
                }
                this.\u0101(iDocumentGroup2);
                documentComponent.\u0101(6005);
            }
        }
    }

    protected boolean isMoreDocumentGroupAllowed() {
        return this.getMaximumGroupCount() <= 0 || this.getDocumentGroupCount() < this.getMaximumGroupCount();
    }

    @Override
    public String getNameOf(Component component) {
        if (component == null) {
            return null;
        }
        return this.\u01c6.get(component);
    }

    @Override
    public DocumentComponent getDocument(String string) {
        return this.\u01b4.get(string);
    }

    @Override
    public DocumentComponent getDocumentAt(int n2) {
        String string = this.getDocumentNameAt(n2);
        return this.getDocument(string);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        String string = this.getActiveDocumentName();
        IDocumentGroup iDocumentGroup = this.getDocumentGroup(string);
        if (iDocumentGroup instanceof JideTabbedPane && ((JideTabbedPane)((Object)iDocumentGroup)).getModel() == changeEvent.getSource()) {
            Component component = iDocumentGroup.getSelectedDocument();
            if (component != null) {
                String string2 = this.getNameOf(component);
                this.setActiveDocument(string2, false);
            } else {
                this.setActiveDocument(null);
            }
        }
    }

    public final void customizePopupMenu(JPopupMenu jPopupMenu, String string, IDocumentGroup iDocumentGroup, boolean bl) {
        PopupMenuCustomizer popupMenuCustomizer = this.getPopupMenuCustomizer();
        if (popupMenuCustomizer != null) {
            popupMenuCustomizer.customizePopupMenu(jPopupMenu, this, string, iDocumentGroup, bl);
        }
    }

    @Override
    public StringConverter getTitleConverter() {
        if (this.\u01c7 != null) {
            return this.\u01c7;
        }
        return \u01b2;
    }

    @Override
    public void setTitleConverter(StringConverter stringConverter) {
        this.\u01c7 = stringConverter;
    }

    @Override
    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.\u01bb;
    }

    @Override
    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.\u01bb = popupMenuCustomizer;
    }

    @Override
    public boolean isGroupsAllowed() {
        return this.\u01ba;
    }

    @Override
    public void setGroupsAllowed(boolean bl) {
        this.\u01ba = bl;
    }

    @Override
    public boolean isReorderAllowed() {
        return this.\u01b6;
    }

    @Override
    public void setReorderAllowed(boolean bl) {
        this.\u01b6 = bl;
    }

    public boolean isRearrangeAllowed() {
        return this.\u01b1;
    }

    public void setRearrangeAllowed(boolean bl) {
        this.\u01b1 = bl;
    }

    public boolean isFloatingAllowed() {
        return this.\u01a9;
    }

    public void setFloatingAllowed(boolean bl) {
        this.\u01a9 = bl;
    }

    @Override
    public int getDocumentCount() {
        return this.\u01be.size();
    }

    @Override
    public String getDocumentNameAt(int n2) {
        if (n2 < 0 || n2 > this.getDocumentCount() - 1) {
            throw new IllegalArgumentException("Index out of bound.");
        }
        return this.\u01be.get(n2);
    }

    @Override
    public String[] getDocumentNames() {
        return this.\u01be.toArray(new String[this.\u01be.size()]);
    }

    @Override
    public int indexOfDocument(String string) {
        JComponent jComponent;
        IDocumentGroup iDocumentGroup;
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null && (iDocumentGroup = (IDocumentGroup)((Object)E.\u0101(jComponent = documentComponent.getComponent(), this))) != null) {
            return iDocumentGroup.indexOfDocument(jComponent);
        }
        return -1;
    }

    int \u0103(String string) {
        if (string != null) {
            for (int i2 = 0; i2 < this.getDocumentCount(); ++i2) {
                if (!string.equals(this.getDocumentAt(i2).getName())) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int groupIndexOfDocument(String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            JComponent jComponent = this.getDocument(string).getComponent();
            TdiGroup tdiGroup = (TdiGroup)E.\u0101(jComponent, this);
            return this.indexOfDocumentGroup(tdiGroup);
        }
        return -1;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.\u01af = UIDefaultsLookup.getBorder("DocumentPane.groupBorder") != null ? UIDefaultsLookup.getBorder("DocumentPane.groupBorder") : BorderFactory.createLineBorder(Color.gray);
        for (int i2 = 0; i2 < this.getPaneCount(); ++i2) {
            JComponent jComponent = (JComponent)this.getPaneAt(i2);
            jComponent.setBorder(this.\u01af);
        }
        if (this.getActiveDocumentName() != null) {
            this.updateDocument(this.getActiveDocumentName());
        }
    }

    public int getTabPlacement() {
        return this._tabPlacement;
    }

    public void setTabPlacement(int n2) {
        if (n2 != 1 && n2 != 3 && n2 != 2 && n2 != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT or RIGHT.");
        }
        if (this._tabPlacement != n2) {
            int n3 = this._tabPlacement;
            this._tabPlacement = n2;
            for (int i2 = 0; i2 < this.getPaneCount(); ++i2) {
                JComponent jComponent = (JComponent)this.getPaneAt(i2);
                if (!(jComponent instanceof JideTabbedPane)) continue;
                ((JideTabbedPane)jComponent).setTabPlacement(this._tabPlacement);
            }
            this.firePropertyChange("tabPlacement", n3, n2);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isDragPassUnmovableAllowed() {
        return this.\u01c0;
    }

    public void setDragPassUnmovableAllowed(boolean bl) {
        this.\u01c0 = bl;
    }

    public DocumentTabColorProvider getTabColorProvider() {
        return this.\u01bf;
    }

    public void setTabColorProvider(DocumentTabColorProvider documentTabColorProvider) {
        this.\u01bf = documentTabColorProvider;
    }

    public TabbedPaneCustomizer getTabbedPaneCustomizer() {
        return this.\u01c1;
    }

    public void setTabbedPaneCustomizer(TabbedPaneCustomizer tabbedPaneCustomizer) {
        this.\u01c1 = tabbedPaneCustomizer;
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u010f();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u010f();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u010f() {
        JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof TdiGroup;
            }

            @Override
            public void action(Component component) {
                DocumentPane.this.\u01c1.customize((TdiGroup)component);
            }

            @Override
            public void postAction(Component component) {
            }
        });
        this.validate();
        this.repaint();
    }

    @Override
    public void updateDocument(String string) {
        TdiGroup tdiGroup;
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null && (tdiGroup = (TdiGroup)E.\u0101(documentComponent.getComponent(), this)) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.\u0101(tdiGroup, documentComponent);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DocumentPane.this.\u0101(tdiGroup, documentComponent);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
                }
            }
        }
    }

    private void \u0101(IDocumentGroup iDocumentGroup, DocumentComponent documentComponent) {
        iDocumentGroup.updateTitle(documentComponent);
    }

    @Override
    public void renameDocument(String string, String string2) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            throw new IllegalArgumentException("Document \"" + string + "\" is not opened.");
        }
        int n2 = this.\u01be.indexOf(string);
        this.\u0101(string, documentComponent.getComponent());
        documentComponent.setName(string2);
        this.\u0101(documentComponent, n2);
        if (this.getActiveDocumentName() != null && this.getActiveDocumentName().equals(string)) {
            this.\u01b0 = string2;
        }
    }

    private void \u0112() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        AbstractAction abstractAction = new AbstractAction("nextDocument"){
            private static final long \u0102 = 8776435163544111997L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentPane.this.nextDocument();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("prevDocument"){
            private static final long \u0102 = 1011492280119136975L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentPane.this.prevDocument();
            }
        };
        Object object = abstractAction2.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(37, 512), object);
        actionMap.put(object, abstractAction2);
        Object object2 = abstractAction.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(39, 512), object2);
        actionMap.put(object2, abstractAction);
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isUpdateTitle() {
        return this.\u01b9;
    }

    public void setUpdateTitle(boolean bl) {
        this.\u01b9 = bl;
    }

    public int getDocumentGroupIndexAt(Point point) {
        Component component = SwingUtilities.getDeepestComponentAt(this, point.x, point.y);
        if ((component = E.\u0101(component, this)) == null) {
            return -1;
        }
        return this.indexOfPane(component);
    }

    @Override
    public int getDocumentGroupCount() {
        return this.getPaneCount() + this.\u01bc.size();
    }

    @Override
    public IDocumentGroup getDocumentGroupAt(int n2) {
        int n3 = this.getPaneCount();
        if (n2 < n3) {
            return (IDocumentGroup)((Object)this.getPaneAt(n2));
        }
        return this.\u01bc.get(n2 - n3).getDocumentGroup();
    }

    public int indexOfDocumentGroup(IDocumentGroup iDocumentGroup) {
        int n2 = this.getDocumentGroupCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(i2);
            if (iDocumentGroup2 != iDocumentGroup) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getSelectedIndexAtGroupIndex(int n2) {
        if (n2 >= 0 && n2 < this.getDocumentGroupCount()) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(n2);
            if (iDocumentGroup != null) {
                return iDocumentGroup.getSelectedIndex();
            }
            return -1;
        }
        throw new IndexOutOfBoundsException(n2 + " is outside the range [0, " + (this.getDocumentGroupCount() - 1) + "].");
    }

    @Override
    public void setOpenedDocuments(List<DocumentComponent> list) {
        this.\u01ad = new ArrayList<DocumentComponent>();
        for (DocumentComponent documentComponent : list) {
            this.\u01ad.add(documentComponent);
        }
    }

    void \u0110() {
        if (this.\u01ad != null) {
            this.\u01ad.clear();
            this.\u01ad = null;
        }
    }

    DocumentComponent \u0101(String string) {
        for (DocumentComponent documentComponent : this.\u01ad) {
            if (documentComponent == null || !documentComponent.getName().equals(string)) continue;
            return documentComponent;
        }
        return null;
    }

    @Override
    public void setDocumentEnabled(String string, boolean bl) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        JComponent jComponent = documentComponent.getComponent();
        for (int i2 = 0; i2 < this.getDocumentGroupCount(); ++i2) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(i2);
            if (!(iDocumentGroup instanceof JideTabbedPane)) continue;
            for (int i3 = 0; i3 < iDocumentGroup.getDocumentCount(); ++i3) {
                Component component = iDocumentGroup.getDocumentAt(i3);
                if (!component.equals(jComponent)) continue;
                if (((JideTabbedPane)((Object)iDocumentGroup)).isEnabledAt(i3) != bl) {
                    ((JideTabbedPane)((Object)iDocumentGroup)).setEnabledAt(i3, bl);
                    documentComponent.firePropertyChange("enabled", !bl, bl);
                }
                return;
            }
        }
    }

    public DocumentComponentFactory getDocumentComponentFactory() {
        return this.\u01ac;
    }

    public void setDocumentComponentFactory(DocumentComponentFactory documentComponentFactory) {
        this.\u01ac = documentComponentFactory;
    }

    @Override
    public LayoutPersistence getLayoutPersistence() {
        return this.\u01ab;
    }

    static String \u0101(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readInt();
        if (n2 > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again.");
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = dataInputStream.readChar();
        }
        return new String(cArray);
    }

    static void \u0101(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                dataOutputStream.writeChar(string.charAt(i2));
            }
        }
    }

    @Override
    public void dispose() {
        this.\u01b8.\u0103();
        this.\u01b8 = null;
    }

    B \u0111() {
        return this.\u01b8;
    }

    public boolean isShowContextMenu() {
        return this.\u01c5;
    }

    public void setShowContextMenu(boolean bl) {
        this.\u01c5 = bl;
    }

    @Override
    protected JideSplitPaneDivider createSplitPaneDivider() {
        JideSplitPaneDivider jideSplitPaneDivider = super.createSplitPaneDivider();
        jideSplitPaneDivider.setOpaque(true);
        return jideSplitPaneDivider;
    }

    @Override
    public boolean isHeavyweightComponentEnabled() {
        return this.\u01c3;
    }

    @Override
    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this.\u01c3;
        if (this.\u01c3 != bl) {
            this.\u01c3 = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this.\u01c3);
        }
        if (this.isHeavyweightComponentEnabled()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
    }

    public int getMaximumGroupCount() {
        return this.\u01b3;
    }

    public void setMaximumGroupCount(int n2) {
        int n3 = this.\u01b3;
        if (n3 != n2) {
            this.\u01b3 = n2;
            this.firePropertyChange(PROPERTY_MAXIMUM_GROUP_COUNT, new Integer(n3), new Integer(n2));
        }
    }

    protected int getNextAvailableIndex(String string) {
        int n2 = 2;
        while (this.isDocumentOpened(string + ":" + n2)) {
            ++n2;
        }
        return n2;
    }

    public void splitDocument(String string, int n2, int n3) {
        DocumentComponent documentComponent;
        if (this.isMoreDocumentGroupAllowed() && (documentComponent = this.getDocument(string)) instanceof CloneableDocumentComponent) {
            try {
                Object object = ((CloneableDocumentComponent)((Object)documentComponent)).clone();
                if (object instanceof DocumentComponent) {
                    DocumentComponent documentComponent2 = (DocumentComponent)object;
                    documentComponent2.setName(documentComponent.getName() + ":" + this.getNextAvailableIndex(documentComponent.getName()));
                    this.openDocument(documentComponent2);
                    this.newDocumentGroup(documentComponent2.getName(), n2, n3);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public boolean isUseGlassPaneEnabled() {
        return this.\u01b7;
    }

    public void setUseGlassPaneEnabled(boolean bl) {
        this.\u01b7 = bl;
    }

    public void populateContextMenu(JPopupMenu jPopupMenu) {
        if (this.getActiveDocument() != null) {
            this.populateContextMenu(jPopupMenu, this.getActiveDocument().getComponent(), null, null, true);
        }
    }

    protected void populateContextMenu(JPopupMenu jPopupMenu, Component component, TdiGroup tdiGroup, TdiGroup tdiGroup2, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (bl) {
            if (tdiGroup2 == null) {
                tdiGroup2 = (TdiGroup)E.\u0101(component, this);
            }
            tdiGroup = tdiGroup2;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.isMoreDocumentGroupAllowed()) {
            if (this.getComponentCount() == 1) {
                bl2 = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
            } else if (this.getOrientation() == 0) {
                bl2 = true;
                bl4 = true;
            } else {
                bl3 = true;
                bl5 = true;
            }
        }
        if (tdiGroup.getTabCount() == 1) {
            bl3 = false;
            bl2 = false;
        }
        if ((string = this.getNameOf(component)) == null) {
            return;
        }
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (bl) {
            String string2;
            JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE));
            jMenuItem.setName(CONTEXT_MENU_CLOSE);
            jMenuItem.setMnemonic(this.getResourceString("DocumentPane.close.mnemonic").charAt(0));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DocumentPane.this.closeSingleDocument(string);
                }
            });
            jMenuItem.setEnabled(documentComponent.isClosable());
            jPopupMenu.add(jMenuItem);
            if (!this.isDocumentFloating(string) && this.getDocumentCount() > 1) {
                boolean bl6 = false;
                boolean bl7 = false;
                for (int i2 = 0; !(i2 >= this.getDocumentCount() || bl6 && bl7); ++i2) {
                    object2 = this.getDocumentAt(i2);
                    boolean bl8 = ((DocumentComponent)object2).isClosable();
                    if (bl8) {
                        bl6 = true;
                    }
                    if (object2 == documentComponent || !bl8) continue;
                    bl7 = true;
                }
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE_OTHERS));
                jMenuItem.setName(CONTEXT_MENU_CLOSE_OTHERS);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.closeOthers.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.closeAllButThis(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
                jMenuItem.setEnabled(bl7);
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE_ALL));
                jMenuItem.setName(CONTEXT_MENU_CLOSE_ALL);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.closeAll.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.closeAll();
                    }
                });
                jPopupMenu.add(jMenuItem);
                jMenuItem.setEnabled(bl6);
            }
            if ((string2 = this.getNextDocument(string)) != null) {
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEXT));
                jMenuItem.setName(CONTEXT_MENU_NEXT);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.next.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setActiveDocument(string2);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            if ((object = this.getPreviousDocument(string)) != null) {
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_PREVIOUS));
                jMenuItem.setName(CONTEXT_MENU_PREVIOUS);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.previous.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener((String)object){
                    final /* synthetic */ String \u0102;
                    {
                        this.\u0102 = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setActiveDocument(this.\u0102);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
        }
        final int n2 = this.indexOfPane(tdiGroup2);
        if (this.isGroupsAllowed() && this.isRearrangeAllowed() && n2 != -1) {
            boolean bl9 = false;
            if (jPopupMenu.getComponentCount() == 0) {
                bl9 = true;
            }
            if (bl2) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEW_HORIZONTAL_GROUP), UIDefaultsLookup.getIcon("DocumentPane.newHorizontalGroupIcon"));
                ((Component)object).setName(CONTEXT_MENU_NEW_HORIZONTAL_GROUP);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.newHorizontalGroup.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.newDocumentGroup(string, n2 + 1, 0);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl3) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEW_VERTICAL_GROUP), UIDefaultsLookup.getIcon("DocumentPane.newVerticalGroupIcon"));
                ((Component)object).setName(CONTEXT_MENU_NEW_VERTICAL_GROUP);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.newVerticalGroup.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.newDocumentGroup(string, n2 + 1, 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl4 && this.getDocument(string) instanceof CloneableDocumentComponent) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_SPLIT_HORIZONTALLY));
                ((Component)object).setName(CONTEXT_MENU_SPLIT_HORIZONTALLY);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.splitHorizontally.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.splitDocument(string, n2 + 1, 0);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl5 && this.getDocument(string) instanceof CloneableDocumentComponent) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_SPLIT_VERTICALLY));
                ((Component)object).setName(CONTEXT_MENU_SPLIT_VERTICALLY);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.splitVertically.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.splitDocument(string, n2 + 1, 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (tdiGroup.equals(tdiGroup2)) {
                if (n2 < this.getPaneCount() - 1) {
                    object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_NEXT));
                    ((Component)object).setName(CONTEXT_MENU_MOVE_TO_NEXT);
                    ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToNext.mnemonic").charAt(0));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.moveDocument(string, n2 + 1);
                        }
                    });
                    if (!bl9) {
                        jPopupMenu.addSeparator();
                        bl9 = true;
                    }
                    jPopupMenu.add((JMenuItem)object);
                }
                if (n2 > 0) {
                    object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_PREVIOUS));
                    ((Component)object).setName(CONTEXT_MENU_MOVE_TO_PREVIOUS);
                    ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToPrevious.mnemonic").charAt(0));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.moveDocument(string, n2 - 1);
                        }
                    });
                    if (!bl9) {
                        jPopupMenu.addSeparator();
                        bl9 = true;
                    }
                    jPopupMenu.add((JMenuItem)object);
                }
            } else {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_THIS));
                ((Component)object).setName(CONTEXT_MENU_MOVE_TO_THIS);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToThis.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.moveDocument(string, n2);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (this.getPaneCount() > 1) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_CHANGE_ORIENTATION));
                ((Component)object).setName(CONTEXT_MENU_CHANGE_ORIENTATION);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.changeOrientation.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setOrientation(DocumentPane.this.getOrientation() == 1 ? 0 : 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        if (this.isFloatingAllowed()) {
            JideSwingUtilities.addSeparatorIfNecessary(jPopupMenu);
            if (this.isDocumentFloating(string)) {
                JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_DOCKING));
                jMenuItem.setName(CONTEXT_MENU_DOCKING);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.docking.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.dockDocument(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            boolean bl10 = true;
            int n3 = this.\u01bc.size();
            FloatingDocumentContainer floatingDocumentContainer = null;
            if (this.isDocumentFloating(string)) {
                --n3;
                floatingDocumentContainer = (FloatingDocumentContainer)((Object)SwingUtilities.getAncestorOfClass(FloatingDocumentContainer.class, this.getDocument(string).getComponent()));
                if (floatingDocumentContainer != null && floatingDocumentContainer.getDocumentGroup().getDocumentCount() <= 1) {
                    bl10 = false;
                }
            }
            if (bl10) {
                object2 = new JMenuItem(this.getResourceString(CONTEXT_MENU_FLOATING));
                ((Component)object2).setName(CONTEXT_MENU_FLOATING);
                ((AbstractButton)object2).setMnemonic(this.getResourceString("DocumentPane.floating.mnemonic").charAt(0));
                ((AbstractButton)object2).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.floatDocument(string, false);
                    }
                });
                jPopupMenu.add((JMenuItem)object2);
            }
            if (n3 > 0) {
                object2 = new JMenu(this.getResourceString("DocumentPane.floatingTo"));
                ((AbstractButton)object2).setMnemonic(this.getResourceString("DocumentPane.floatingTo.mnemonic").charAt(0));
                for (FloatingDocumentContainer floatingDocumentContainer2 : this.\u01bc) {
                    if (floatingDocumentContainer2 == floatingDocumentContainer) continue;
                    final FloatingDocumentContainer floatingDocumentContainer3 = floatingDocumentContainer2;
                    JMenuItem jMenuItem = new JMenuItem(floatingDocumentContainer3.getTitle());
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.floatDocument(floatingDocumentContainer3, string);
                        }
                    });
                    ((Container)object2).add(jMenuItem);
                }
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        if (!bl && jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CANCEL));
            jMenuItem.setName(CONTEXT_MENU_CANCEL);
            jPopupMenu.add(jMenuItem);
        }
    }

    protected String getResourceString(String string) {
        return com.jidesoft.document.A.\u0101(this.getLocale()).getString(string);
    }

    @Override
    public void floatDocument(String string) {
        this.floatDocument(string, true);
    }

    public void floatDocument(final String string, final boolean bl) {
        if (this.\u01b4.get(string) == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(string, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0101(string, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0101(String string, boolean bl) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            Container container;
            Object object;
            this.activateGroup(null);
            D d2 = D.\u0101(documentComponent);
            if (!this.isDocumentFloating(string)) {
                documentComponent.setFloatPreviousState(d2);
            }
            D d3 = documentComponent.getDockPreviousState();
            FloatingDocumentContainer floatingDocumentContainer = null;
            if (bl && d3 != null && (object = D.\u0101(this, d3, string)) != null && (container = ((JComponent)object).getTopLevelAncestor()) instanceof FloatingDocumentContainer) {
                floatingDocumentContainer = (FloatingDocumentContainer)((Object)container);
            }
            if (floatingDocumentContainer == null) {
                floatingDocumentContainer = this.createFloatingDocumentContainer();
                try {
                    object = this.adjustNextFloatingDocumentLocation(documentComponent, this.getLocationOnScreen(), d3 == null ? null : d3.\u0102.getLocation());
                    floatingDocumentContainer.setLocation((Point)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.\u01bc.add(floatingDocumentContainer);
            }
            object = documentComponent.getComponent().getParent();
            if (d3 != null) {
                int n2 = D.\u0101(this, floatingDocumentContainer.getDocumentGroup(), d3, string);
                floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent, n2);
            } else {
                floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent);
            }
            if (object instanceof IDocumentGroup) {
                IDocumentGroup iDocumentGroup = (IDocumentGroup)object;
                this.\u0101(iDocumentGroup);
            }
            Dimension dimension = this.adjustNextFloatingDocumentSize(documentComponent, d3 == null ? null : d3.\u0102.getSize());
            floatingDocumentContainer.setPreferredSize(dimension.width == 0 || dimension.height == 0 ? this.getSize() : dimension);
            floatingDocumentContainer.pack();
            floatingDocumentContainer.setVisible(true);
            documentComponent.\u0101(6007);
            this.\u0102(string, true);
        }
    }

    protected Dimension adjustNextFloatingDocumentSize(DocumentComponent documentComponent, Dimension dimension) {
        return documentComponent.getComponent().getSize();
    }

    protected Point adjustNextFloatingDocumentLocation(DocumentComponent documentComponent, Point point, Point point2) {
        if (point2 != null) {
            return point2;
        }
        point.x += 20;
        point.y += 20;
        boolean bl = false;
        do {
            boolean bl2 = false;
            for (FloatingDocumentContainer floatingDocumentContainer : this.\u01bc) {
                if (point.x != floatingDocumentContainer.getX() || point.y != floatingDocumentContainer.getY()) continue;
                point.x += 20;
                point.y += 20;
                bl2 = true;
                bl = true;
                break;
            }
            if (bl2) continue;
            bl = false;
        } while (bl);
        return point;
    }

    @Override
    public void floatDocument(final FloatingDocumentContainer floatingDocumentContainer, final String string) {
        if (this.\u01b4.get(string) == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0101(floatingDocumentContainer, string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0101(floatingDocumentContainer, string);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0101(FloatingDocumentContainer floatingDocumentContainer, String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            D d2 = D.\u0101(documentComponent);
            if (!this.isDocumentFloating(string)) {
                documentComponent.setFloatPreviousState(d2);
            }
            Container container = documentComponent.getComponent().getParent();
            floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent);
            if (container instanceof IDocumentGroup) {
                IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)container);
                this.\u0101(iDocumentGroup);
                List<FloatingDocumentContainer> list = this.getFloatingContainers();
                for (FloatingDocumentContainer floatingDocumentContainer2 : list) {
                    if (floatingDocumentContainer2 == floatingDocumentContainer || floatingDocumentContainer2 == null || floatingDocumentContainer2.getDocumentGroup() != container) continue;
                    floatingDocumentContainer2.updateTitle();
                    break;
                }
            }
            documentComponent.\u0101(6007);
            this.activateGroup(floatingDocumentContainer.getDocumentGroup());
            floatingDocumentContainer.toFront();
            floatingDocumentContainer.updateTitle();
        }
    }

    protected FloatingDocumentContainer createFloatingDocumentContainer() {
        Window window = this.getFloatingContainerType() == 0 ? new DialogFloatingDocumentContainer(this) : new FrameFloatingDocumentContainer(this);
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame && window instanceof Frame) {
            ((Frame)window).setIconImage(((Frame)container).getIconImage());
            if (SystemInfo.isJdk6Above()) {
                ((Frame)window).setIconImages(((Frame)container).getIconImages());
            }
        }
        window.addWindowListener(new WindowAdapter((FloatingDocumentContainer)((Object)window)){
            final /* synthetic */ FloatingDocumentContainer \u0102;
            {
                this.\u0102 = floatingDocumentContainer;
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DocumentPane.this.\u0101(this.\u0102);
            }
        });
        return window;
    }

    void \u0101(FloatingDocumentContainer floatingDocumentContainer) {
        this.\u01bc.remove(floatingDocumentContainer);
    }

    @Override
    public void dockDocument(final String string) {
        if (this.\u01b4.get(string) == null) {
            return;
        }
        if (!this.isDocumentFloating(string)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0102(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.\u0102(string);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void \u0102(String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            D d2 = D.\u0101(documentComponent);
            documentComponent.setDockPreviousState(d2);
            D d3 = documentComponent.getFloatPreviousState();
            IDocumentGroup iDocumentGroup = null;
            if (d3 != null) {
                iDocumentGroup = D.\u0101(this, d3, string);
            }
            boolean bl = false;
            int n2 = -1;
            if (iDocumentGroup == null) {
                if (this.getPaneCount() == 0) {
                    iDocumentGroup = this.createDocumentGroup();
                    bl = true;
                } else if (!this.isGroupsAllowed()) {
                    iDocumentGroup = this.getDocumentGroupAt(0);
                    n2 = 0;
                } else {
                    int n3 = n2 = d3 != null ? D.\u0102(this, d3, string) : -1;
                    if (n2 != -1) {
                        iDocumentGroup = this.createDocumentGroup();
                        bl = true;
                    } else {
                        iDocumentGroup = this.getDocumentGroupAt(0);
                    }
                }
            }
            if (d3 != null) {
                int n4 = D.\u0101(this, iDocumentGroup, d3, string);
                iDocumentGroup.addDocument(documentComponent, n4);
            } else {
                iDocumentGroup.addDocument(documentComponent);
            }
            if (bl) {
                if (n2 == -1) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    n2 = Math.min(n2, this.getPaneCount());
                    this.add((Component)((Object)iDocumentGroup), "flexible", n2);
                }
            }
            documentComponent.\u0101(6006);
            this.\u0102(string, true);
        }
    }

    @Override
    public void dockDocuments(FloatingDocumentContainer floatingDocumentContainer) {
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        for (int i2 = iDocumentGroup.getDocumentCount() - 1; i2 >= 0; --i2) {
            this.dockDocument(this.\u01c6.get(iDocumentGroup.getDocumentAt(i2)));
        }
    }

    @Override
    public void closeDocuments(FloatingDocumentContainer floatingDocumentContainer) {
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        for (int i2 = iDocumentGroup.getDocumentCount() - 1; i2 >= 0; --i2) {
            this.closeDocument(this.\u01c6.get(iDocumentGroup.getDocumentAt(i2)));
        }
    }

    @Override
    public boolean isDocumentFloating(String string) {
        JComponent jComponent;
        DocumentComponent documentComponent = this.getDocument(string);
        Container container = jComponent = documentComponent.getComponent();
        do {
            if (!(container instanceof DocumentPane)) continue;
            return false;
        } while ((container = container.getParent()) != null);
        return jComponent.getTopLevelAncestor() instanceof FloatingDocumentContainer;
    }

    @Override
    public List<FloatingDocumentContainer> getFloatingContainers() {
        return this.\u01bc;
    }

    @Override
    public int getFloatingContainerCloseAction() {
        return this.\u01c2;
    }

    @Override
    public void setFloatingContainerCloseAction(int n2) {
        this.\u01c2 = n2;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            for (FloatingDocumentContainer floatingDocumentContainer : this.\u01bc) {
                if (!(floatingDocumentContainer instanceof Frame)) continue;
                ((Frame)((Object)floatingDocumentContainer)).setIconImage(((Frame)container).getIconImage());
                if (!SystemInfo.isJdk6Above()) continue;
                ((Frame)((Object)floatingDocumentContainer)).setIconImages(((Frame)container).getIconImages());
            }
        }
        for (FloatingDocumentContainer floatingDocumentContainer : this.\u01bc) {
            floatingDocumentContainer.setVisible(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (FloatingDocumentContainer floatingDocumentContainer : this.\u01bc) {
            floatingDocumentContainer.setVisible(false);
        }
    }

    protected String getFloatingContainerTitle(TdiGroup tdiGroup) {
        int n2 = tdiGroup.getSelectedIndex();
        if (n2 != -1) {
            String string = tdiGroup.getDisplayTitleAt(n2);
            int n3 = tdiGroup.getTabCount();
            return string + (n3 > 1 ? " (" + n3 + ")" : "");
        }
        return null;
    }

    @Override
    public int getFloatingContainerType() {
        String string = SecurityUtils.getProperty("documentPane.floatingContainerType", null);
        if (string != null) {
            if ("dialog".equals(string)) {
                return 0;
            }
            if ("frame".equals(string)) {
                return 1;
            }
        }
        return this.\u01aa;
    }

    @Override
    public void setFloatingContainerType(int n2) {
        int n3 = this.\u01aa;
        if (n3 != n2) {
            this.\u01aa = n2;
            this.firePropertyChange(PROPERTY_FLOATING_CONTAINER_TYPE, n3, this.\u01aa);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(DocumentPane.class.getName(), 2);
        }
        \u01b2 = new DefaultStringConverter(30, 14);
    }

    public static interface DocumentTabColorProvider {
        public Color getBackgroundAt(int var1);

        public Color getForegroundAt(int var1);

        public float getGradientRatio(int var1);
    }

    private class A
    extends AbstractLayoutPersistence {
        private boolean \u0a10 = true;

        private A() {
        }

        @Override
        public void beginLoadLayoutData() {
        }

        @Override
        public boolean loadLayoutFrom(Document document) {
            this.\u0a10 = DocumentPanePersistenceUtils.\u0101(DocumentPane.this, document, this.getLoadCallback());
            return this.\u0a10;
        }

        @Override
        public boolean loadLayoutFrom(InputStream inputStream) {
            Object object;
            this.\u0a10 = false;
            if (inputStream == null) {
                this.resetToDefault();
                return this.\u0a10;
            }
            InputStream inputStream2 = inputStream;
            if (this.isNeedFormatCheck()) {
                try {
                    object = PersistenceUtils.bufferStreamToArray(inputStream);
                }
                catch (IOException iOException) {
                    this.resetToDefault();
                    return this.\u0a10;
                }
                inputStream2 = new ByteArrayInputStream((byte[])object);
                if (PersistenceUtils.isXmlFormat((byte[])object)) {
                    try {
                        DocumentPanePersistenceUtils.load(DocumentPane.this, inputStream2, this.getLoadCallback());
                    }
                    catch (Exception exception) {
                        this.resetToDefault();
                        return this.\u0a10;
                    }
                    return true;
                }
            }
            try {
                int n2;
                Object object2;
                Object object3;
                int n3;
                int n4;
                object = new DataInputStream(inputStream2);
                int n5 = ((DataInputStream)object).readInt();
                if (!this.isVersionCompatible(n5)) {
                    this.resetToDefault();
                    return this.\u0a10;
                }
                if (DocumentPane.this.\u01ad == null) {
                    DocumentPane.this.\u01ad = new ArrayList<DocumentComponent>();
                    for (n4 = 0; n4 < DocumentPane.this.getDocumentCount(); ++n4) {
                        DocumentPane.this.\u01ad.add(DocumentPane.this.getDocumentAt(n4));
                    }
                }
                DocumentPane.this.closeAll(true);
                n4 = ((DataInputStream)object).readInt();
                boolean bl = (n4 & 0x10) != 0;
                DocumentPane.this.setOrientation(n4 & 1);
                String string = DocumentPane.\u0101((DataInputStream)object);
                int n6 = ((DataInputStream)object).readInt();
                for (n3 = 0; n3 < n6; ++n3) {
                    Dimension dimension = new Dimension();
                    dimension.width = ((DataInputStream)object).readInt();
                    dimension.height = ((DataInputStream)object).readInt();
                    int n7 = ((DataInputStream)object).readInt();
                    JComponent jComponent = null;
                    object3 = DocumentPane.this.createDocumentGroup();
                    int n8 = ((DataInputStream)object).readInt();
                    for (int i2 = 0; i2 < n8; ++i2) {
                        String string2 = DocumentPane.\u0101((DataInputStream)object);
                        if (string2 == null || string2.length() <= 0) continue;
                        DocumentComponent documentComponent = DocumentPane.this.\u0101(string2);
                        if (documentComponent == null && (object2 = DocumentPane.this.getDocumentComponentFactory()) != null && (documentComponent = object2.create(string2)) != null) {
                            DocumentPane.this.\u01ad.add(documentComponent);
                        }
                        if (documentComponent == null) continue;
                        documentComponent.setDocumentPane(DocumentPane.this);
                        DocumentPane.this.\u0101(documentComponent);
                        object3.addDocument(documentComponent);
                        documentComponent.\u0101(5999);
                        documentComponent.\u0101(6006);
                        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
                        if (i2 != n7) continue;
                        jComponent = documentComponent.getComponent();
                    }
                    if (object3.getDocumentCount() <= 0) continue;
                    ((JComponent)object3).setPreferredSize(dimension);
                    DocumentPane.this.add((Component)((JComponent)object3), "flexible");
                    if (jComponent == null) continue;
                    object3.setSelectedDocument(jComponent);
                }
                n3 = 0;
                try {
                    n3 = ((DataInputStream)object).readInt();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    Rectangle rectangle = new Rectangle();
                    rectangle.x = ((DataInputStream)object).readInt();
                    rectangle.y = ((DataInputStream)object).readInt();
                    rectangle.width = ((DataInputStream)object).readInt();
                    rectangle.height = ((DataInputStream)object).readInt();
                    int n9 = ((DataInputStream)object).readInt();
                    object3 = null;
                    FloatingDocumentContainer floatingDocumentContainer = DocumentPane.this.createFloatingDocumentContainer();
                    DocumentPane.this.\u01bc.add(floatingDocumentContainer);
                    IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
                    int n10 = ((DataInputStream)object).readInt();
                    for (int i3 = 0; i3 < n10; ++i3) {
                        DocumentComponent documentComponent;
                        object2 = DocumentPane.\u0101((DataInputStream)object);
                        if (object2 == null || ((String)object2).length() <= 0 || (documentComponent = DocumentPane.this.\u0101((String)object2)) == null) continue;
                        documentComponent.setDocumentPane(DocumentPane.this);
                        DocumentPane.this.\u0101(documentComponent);
                        iDocumentGroup.addDocument(documentComponent);
                        documentComponent.\u0101(5999);
                        documentComponent.\u0101(6007);
                        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
                        if (i3 != n9) continue;
                        object3 = documentComponent.getComponent();
                    }
                    if (iDocumentGroup.getDocumentCount() <= 0) continue;
                    floatingDocumentContainer.pack();
                    floatingDocumentContainer.setBounds(rectangle);
                    floatingDocumentContainer.setVisible(true);
                    if (object3 == null) continue;
                    iDocumentGroup.setSelectedDocument((Component)object3);
                }
                if (bl) {
                    DocumentPane.this.setProportionalLayout(((DataInputStream)object).readBoolean());
                    if (DocumentPane.this.isProportionalLayout()) {
                        DocumentPane.this.setInitiallyEven(((DataInputStream)object).readBoolean());
                        n2 = ((DataInputStream)object).readInt();
                        if (n2 > 0) {
                            double[] dArray = new double[n2];
                            for (int i4 = 0; i4 < dArray.length; ++i4) {
                                dArray[i4] = ((DataInputStream)object).readDouble();
                            }
                            DocumentPane.this.setProportions(dArray);
                        }
                    }
                }
                if (string != null && DocumentPane.this.isDocumentOpened(string)) {
                    DocumentPane.this.setActiveDocument(string);
                }
                DocumentPane.this.\u0110();
                this.\u0a10 = true;
            }
            catch (IOException iOException) {
                this.resetToDefault();
            }
            return this.\u0a10;
        }

        @Override
        public void saveLayoutTo(Document document) throws ParserConfigurationException {
            DocumentPanePersistenceUtils.\u0101(DocumentPane.this, document, this.getSaveCallback());
        }

        @Override
        public void saveLayoutTo(OutputStream outputStream) throws IOException {
            Object object;
            int n2;
            if (this.isXmlFormat()) {
                try {
                    DocumentPanePersistenceUtils.save(DocumentPane.this, outputStream);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this._version);
            int n3 = DocumentPane.this.getOrientation();
            dataOutputStream.writeInt(n3 | 0x10);
            String string = DocumentPane.this.getActiveDocumentName();
            DocumentPane.\u0101(dataOutputStream, string);
            int n4 = DocumentPane.this.getPaneCount();
            dataOutputStream.writeInt(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                IDocumentGroup iDocumentGroup = DocumentPane.this.getDocumentGroupAt(n2);
                object = ((JComponent)((Object)iDocumentGroup)).getPreferredSize();
                dataOutputStream.writeInt(((Dimension)object).width);
                dataOutputStream.writeInt(((Dimension)object).height);
                dataOutputStream.writeInt(iDocumentGroup.getSelectedIndex());
                int n5 = iDocumentGroup.getDocumentCount();
                dataOutputStream.writeInt(n5);
                for (int i2 = 0; i2 < n5; ++i2) {
                    Component component = iDocumentGroup.getDocumentAt(i2);
                    String string2 = DocumentPane.this.getNameOf(component);
                    DocumentPane.\u0101(dataOutputStream, string2);
                }
            }
            n2 = DocumentPane.this.\u01bc.size();
            dataOutputStream.writeInt(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                object = DocumentPane.this.\u01bc.get(i3);
                IDocumentGroup iDocumentGroup = object.getDocumentGroup();
                Rectangle rectangle = object.getBounds();
                dataOutputStream.writeInt(rectangle.x);
                dataOutputStream.writeInt(rectangle.y);
                dataOutputStream.writeInt(rectangle.width);
                dataOutputStream.writeInt(rectangle.height);
                dataOutputStream.writeInt(iDocumentGroup.getSelectedIndex());
                int n6 = iDocumentGroup.getDocumentCount();
                dataOutputStream.writeInt(n6);
                for (int i4 = 0; i4 < n6; ++i4) {
                    Component component = iDocumentGroup.getDocumentAt(i4);
                    String string3 = DocumentPane.this.getNameOf(component);
                    DocumentPane.\u0101(dataOutputStream, string3);
                }
            }
            dataOutputStream.writeBoolean(DocumentPane.this.isProportionalLayout());
            if (DocumentPane.this.isProportionalLayout()) {
                dataOutputStream.writeBoolean(DocumentPane.this.isInitiallyEven());
                double[] dArray = DocumentPane.this.getProportions();
                dataOutputStream.writeInt(dArray == null ? -1 : dArray.length);
                if (dArray != null) {
                    for (Object object2 : (Object)dArray) {
                        dataOutputStream.writeDouble((double)object2);
                    }
                }
            }
        }

        @Override
        public void resetToDefault() {
            if (DocumentPane.this.\u01ad == null) {
                DocumentPane.this.\u01ad = new ArrayList<DocumentComponent>();
                for (int i2 = 0; i2 < DocumentPane.this.getDocumentCount(); ++i2) {
                    DocumentPane.this.\u01ad.add(DocumentPane.this.getDocumentAt(i2));
                }
            }
            DocumentPane.this.closeAll();
            for (DocumentComponent documentComponent : DocumentPane.this.\u01ad) {
                if (DocumentPane.this.isDocumentOpened(documentComponent.getName())) continue;
                DocumentPane.this.openDocument(documentComponent);
            }
            DocumentPane.this.\u0110();
        }

        @Override
        public boolean isLoadDataSuccessful() {
            return this.\u0a10;
        }

        @Override
        public void loadInitialLayout(Document document) {
        }
    }

    public static interface TabbedPaneCustomizer {
        public void customize(JideTabbedPane var1);
    }
}

