/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.CrudRowOperations;
import com.jidesoft.database.DefaultRecord;
import com.jidesoft.database.Record;
import com.jidesoft.database.ResultSetTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetTableModelCrudSupport
implements CrudRowOperations {
    private ResultSetTableModel \u0d05;

    public ResultSetTableModelCrudSupport(ResultSetTableModel resultSetTableModel) {
        this.\u0d05 = resultSetTableModel;
    }

    public ResultSetTableModel getResultSetTableModel() {
        return this.\u0d05;
    }

    public void setResultSetTableModel(ResultSetTableModel resultSetTableModel) {
        this.\u0d05 = resultSetTableModel;
    }

    @Override
    public void insertRow(Record record) throws SQLException {
        if (record != Record.EMPTY && record != null) {
            ResultSet resultSet = this.\u0d05.getResultSet();
            this.\u0101(record);
            resultSet.moveToInsertRow();
            for (int i2 = this.\u0d05.getColumnCount() - 1; i2 >= 0; --i2) {
                String string = this.\u0d05.getColumnName(i2);
                if (record.isEmpty(string)) continue;
                resultSet.updateObject(i2 + 1, record.getValue(string));
            }
            resultSet.insertRow();
            resultSet.moveToCurrentRow();
        }
        this.\u0d05.refreshData();
    }

    @Override
    public Record readRow(int n2) throws SQLException {
        ResultSet resultSet = this.\u0d05.getResultSet();
        int n3 = resultSet.getRow();
        resultSet.absolute(n2 + 1);
        int n4 = this.\u0d05.getColumnCount();
        Record record = this.createRowRecord();
        for (int i2 = 0; i2 < n4; ++i2) {
            record.setValue(this.\u0d05.getColumnName(i2), resultSet.getObject(i2));
        }
        resultSet.absolute(n3);
        return record;
    }

    protected Record createRowRecord() {
        return new DefaultRecord();
    }

    @Override
    public void updateRow(int n2, Record record) throws SQLException {
        ResultSet resultSet = this.\u0d05.getResultSet();
        this.\u0101(record);
        int n3 = resultSet.getRow();
        resultSet.absolute(n2 + 1);
        int n4 = this.\u0d05.getColumnCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = this.\u0d05.getColumnName(i2);
            if (record.isEmpty(string)) continue;
            resultSet.updateObject(i2, record.getValue(string));
        }
        resultSet.updateRow();
        resultSet.absolute(n3);
        this.\u0d05.refreshData();
    }

    @Override
    public void deleteRow(int n2) throws SQLException {
        ResultSet resultSet = this.\u0d05.getResultSet();
        int n3 = resultSet.getRow();
        resultSet.absolute(n2 + 1);
        resultSet.deleteRow();
        if (n3 >= this.\u0d05.getRowCount()) {
            n3 = this.\u0d05.getRowCount() - 1;
        }
        resultSet.absolute(n3);
        this.\u0d05.refreshData();
    }

    private void \u0101(Record record) throws SQLException {
        ResultSet resultSet = this.\u0d05.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            if (resultSetMetaData.isNullable(i2) != 1 || !record.isNull(this.\u0d05.getColumnName(i2 - 1))) continue;
            throw new IllegalArgumentException();
        }
    }
}

