/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.GanttUIDefaultsCustomizer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.PeriodHeaderPainter;
import com.jidesoft.plaf.ScaleAreaUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.scale.DefaultPeriodConverter;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.PeriodConverter;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleAreaResources;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ScaleArea<T>
extends JComponent {
    private static final long \u0104 = -108765377692061814L;
    private static final String \u0109 = "ScaleAreaUI";
    public static final String PROPERTY_SCALE_MODEL = "scaleModel";
    public static final String PROPERTY_VISIBLE_PERIODS = "visiblePeriods";
    public static final String PROPERTY_SCALE_START = "scaleStart";
    public static final String PROPERTY_SCALE_END = "scaleEnd";
    public static final String PROPERTY_PREFERRED_PERIOD_SIZE = "preferredPeriodSize";
    public static final String PROPERTY_VISIBLE_PERIOD_COUNT = "visiblePeriodCount";
    public static final String PROPERTY_PERIOD_MARGIN = "periodMargin";
    public static final String PROPERTY_PERIOD_CONVERTERS = "periodConverters";
    public static final String PROPERTY_PERIOD_HEADER_PAINTER = "periodHeaderPainter";
    public static final String PROPERTY_PERIOD_BACKGROUND_PAINTER = "periodBackgroundPainter";
    public static final String PROPERTY_TREE_TABLE = "treeTable";
    public static final String PROPERTY_TABLE_CELL_RENDERER = "tableCellRenderer";
    public static final int DEFAULT_PERIOD_WIDTH = 27;
    public static final int DEFAULT_PERIOD_HEIGHT = 21;
    private static final int \u0103 = 4;
    private ScaleModel<T> \u010e;
    private List<Period> \u0107 = new ArrayList<Period>();
    private Dimension \u0102;
    private int \u0110 = 20;
    private int \u0111 = 2;
    private int \u010a = 20;
    private T \u010f;
    private T \u0105;
    private PeriodConverter<T> \u0101;
    private final Map<Period, PeriodConverter<T>> \u010d = new HashMap<Period, PeriodConverter<T>>();
    private final List<ScaleAreaPopupMenuCustomizer<T>> \u0106 = new ArrayList<ScaleAreaPopupMenuCustomizer<T>>();
    private PeriodHeaderPainter \u010b;
    private TreeTable \u0108;
    private TableCellRenderer \u010c;

    public ScaleArea() {
        this(null, new DefaultPeriodConverter());
    }

    public ScaleArea(ScaleModel<T> scaleModel, PeriodConverter<T> periodConverter) {
        this.setScaleModel(scaleModel);
        this.setDefaultPeriodConverter(periodConverter);
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setScaleModel(ScaleModel<T> scaleModel) {
        ScaleModel<T> scaleModel2 = this.\u010e;
        this.\u010e = scaleModel;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        if (this.\u010e != null) {
            this.\u010f = scaleModel.getDefaultStart();
            this.\u0105 = scaleModel.getDefaultEnd();
            ArrayList<Period> arrayList2 = new ArrayList<Period>(scaleModel.getPeriods());
            if (arrayList2.isEmpty()) {
                throw new IllegalArgumentException("The ScaleModel must define at least one period!");
            }
            arrayList.addAll(this.\u0107);
            arrayList.retainAll(arrayList2);
            if (arrayList.isEmpty()) {
                arrayList.addAll(arrayList2);
            }
        } else {
            this.\u010f = null;
            this.\u0105 = null;
            arrayList = new ArrayList();
        }
        this.setVisiblePeriods(arrayList.subList(0, Math.min(arrayList.size(), Math.max(1, this.\u0111))), false);
        this.firePropertyChange(PROPERTY_SCALE_MODEL, scaleModel2, scaleModel);
        this.resizeAndRepaint();
    }

    public ScaleModel<T> getScaleModel() {
        return this.\u010e;
    }

    public void setVisiblePeriods(List<? extends Period> list) {
        this.setVisiblePeriods(list, true);
    }

    public void setVisiblePeriods(List<? extends Period> list, boolean bl) {
        if (this.\u010e != null && (!this.\u0107.equals(list) || bl && this.\u0111 != list.size())) {
            if (list == null || list.isEmpty()) {
                throw new IllegalArgumentException("At least one period must be visible!");
            }
            if (!this.\u010e.getPeriods().containsAll(list)) {
                ArrayList<? extends Period> arrayList = new ArrayList<Period>(list);
                arrayList.removeAll(this.\u010e.getPeriods());
                throw new IllegalArgumentException("The following periods are not defined in the scale model!\n" + arrayList);
            }
            List<Period> list2 = this.\u0107;
            this.\u0107 = new ArrayList<Period>(list);
            if (bl) {
                this.\u0111 = this.\u0107.size();
            }
            this.firePropertyChange(PROPERTY_VISIBLE_PERIODS, list2, this.\u0107);
            this.\u0101();
            this.resizeAndRepaint();
        }
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public List<Period> getVisiblePeriods() {
        return Collections.unmodifiableList(this.\u0107);
    }

    public Period getSmallestVisiblePeriod() {
        if (this.\u010e != null && !this.\u0107.isEmpty()) {
            List<Period> list = this.\u010e.getPeriods();
            Period period = this.\u0107.get(0);
            for (int i2 = 1; i2 < this.\u0107.size(); ++i2) {
                Period period2 = this.\u0107.get(i2);
                if (list.indexOf(period2) >= list.indexOf(period)) continue;
                period = period2;
            }
            return period;
        }
        return null;
    }

    public int getVisiblePeriodCount() {
        return this.\u0110;
    }

    public void setVisiblePeriodCount(int n2) {
        if (this.\u0110 != n2) {
            int n3 = this.\u0110;
            this.\u0110 = n2;
            this.firePropertyChange(PROPERTY_VISIBLE_PERIOD_COUNT, n3, this.\u0110);
            this.resizeAndRepaint();
        }
    }

    public int getPeriodMargin() {
        return this.\u010a;
    }

    public void setPeriodMargin(int n2) {
        if (this.\u010a != n2) {
            int n3 = this.\u010a;
            this.\u010a = n2;
            this.firePropertyChange(PROPERTY_PERIOD_MARGIN, n3, this.\u010a);
            this.resizeAndRepaint();
        }
    }

    public void setVisiblePeriodsToFit(T t2, T t3, int n2) {
        if (t2 == null) {
            throw new IllegalArgumentException("start should not be null!");
        }
        if (t3 == null) {
            throw new IllegalArgumentException("end should not be null!");
        }
        ScaleModel<T> scaleModel = this.getScaleModel();
        if (scaleModel != null) {
            int n3;
            int n4;
            Object object;
            this.setStart(t2);
            this.setEnd(t3);
            long l2 = scaleModel.getPosition(t3);
            ArrayList<Period> arrayList = new ArrayList<Period>(scaleModel.getPeriods());
            int n5 = arrayList.size() - 1;
            int n6 = n2 - this.getPeriodMargin() * 2;
            int n7 = Math.max(1, n6 / this.getPreferredPeriodSize().width);
            ScaleAreaUI scaleAreaUI = this.getUI();
            int n8 = n5;
            while (n8 >= 0) {
                object = (Period)arrayList.get(n8);
                n4 = scaleAreaUI != null ? scaleAreaUI.getPreferredPeriodSize((Period)object).width : this.getPreferredPeriodSize().width;
                T t4 = t2;
                int n9 = 0;
                n3 = 0;
                do {
                    t4 = scaleModel.getPeriodEnd((Period)object, t4);
                    ++n3;
                } while (scaleModel.getPosition(t4) < l2 && (n9 += n4) < n6);
                if (n9 >= n6) break;
                n7 = n3;
                n5 = n8--;
            }
            Dimension dimension = scaleAreaUI != null ? scaleAreaUI.getPreferredPeriodSize((Period)arrayList.get(n5)) : this.getPreferredPeriodSize();
            dimension.width = Math.max(4, n6 / n7);
            this.setPreferredPeriodSize(dimension);
            object = new ArrayList<Period>(this.getVisiblePeriods());
            n4 = object.size();
            boolean bl = true;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                n3 = arrayList.indexOf(object2.next());
                if (n3 < n5) {
                    object2.remove();
                    continue;
                }
                if (n3 != n5) continue;
                bl = false;
            }
            if (bl) {
                object2 = (Period)arrayList.get(n5);
                if (object.size() < n4 || object.size() < this.\u0111) {
                    object.add(0, object2);
                } else {
                    object.set(0, object2);
                }
            }
            this.setVisiblePeriods((List<Period>)object, false);
        }
    }

    public void zoomPeriodWidth(double d2) {
        Dimension dimension = this.getPreferredPeriodSize();
        dimension.width = (int)Math.max(4.0, Math.ceil((double)dimension.width * d2));
        Period period = this.getSmallestVisiblePeriod();
        int n2 = this.\u0101(period);
        if (dimension.width < n2) {
            if (d2 > 1.0) {
                this.setPreferredPeriodSize(dimension);
                return;
            }
            List<Period> list = this.getScaleModel().getPeriods();
            ArrayList<Period> arrayList = new ArrayList<Period>(this.getVisiblePeriods());
            int n3 = arrayList.indexOf(period);
            arrayList.remove(period);
            int n4 = list.indexOf(period);
            for (int i2 = n4 + 1; i2 < list.size(); ++i2) {
                Period period2 = list.get(i2);
                if (!arrayList.contains(period2)) {
                    arrayList.add(Math.min(n3, arrayList.size()), period2);
                    break;
                }
                ++n3;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            this.setVisiblePeriods(arrayList, false);
            Period period3 = this.getSmallestVisiblePeriod();
            int n5 = this.\u010e.getPeriodBoundaries(period, this.\u010e.getPeriodStart(period3, this.getStart()), this.\u010e.getPeriodEnd(period3, this.getStart())).size() - 1;
            dimension.width *= n5;
            this.setPreferredPeriodSize(dimension);
        } else {
            Period period4;
            if (d2 < 1.0) {
                this.setPreferredPeriodSize(dimension);
                return;
            }
            boolean bl = dimension.width > this.getVisibleRect().width - this.getPeriodMargin() * 2;
            List<Period> list = this.getScaleModel().getPeriods();
            ArrayList<Period> arrayList = new ArrayList<Period>(this.getVisiblePeriods());
            int n6 = list.indexOf(period);
            if (n6 > 0) {
                period4 = list.get(n6 - 1);
                arrayList.add(0, period4);
                if (arrayList.size() > this.\u0111) {
                    arrayList.remove(arrayList.size() - 1);
                }
            } else {
                if (bl) {
                    return;
                }
                this.setPreferredPeriodSize(dimension);
                return;
            }
            int n7 = this.\u010e.getPeriodBoundaries(period4, this.\u010e.getPeriodStart(period, this.getStart()), this.\u010e.getPeriodEnd(period, this.getStart())).size() - 1;
            int n8 = dimension.width / n7;
            if (n8 >= this.\u0101(period4)) {
                this.setVisiblePeriods(arrayList, false);
                dimension.width = n8;
                this.setPreferredPeriodSize(dimension);
            } else {
                this.setPreferredPeriodSize(dimension);
            }
        }
    }

    private int \u0101(Period period) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null) {
            return scaleAreaUI.getPreferredPeriodSize((Period)period).width;
        }
        return 27;
    }

    public T getStart() {
        return this.\u010f;
    }

    public void setStart(T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("Start instant cannot be null");
        }
        if (!JideSwingUtilities.equals(this.\u010f, t2)) {
            T t3 = this.\u010f;
            this.\u010f = t2;
            this.firePropertyChange(PROPERTY_SCALE_START, t3, this.\u010f);
            this.resizeAndRepaint();
            if (this.\u010e != null && this.\u010e.getPosition(this.\u010f) >= this.\u010e.getPosition(this.\u0105)) {
                this.setEnd(this.\u010e.getPeriodEnd(this.getSmallestVisiblePeriod(), this.\u010f));
            }
        }
    }

    public T getEnd() {
        return this.\u0105;
    }

    public void setEnd(T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("End instant cannot be null");
        }
        if (!JideSwingUtilities.equals(this.\u0105, t2)) {
            T t3 = this.\u0105;
            this.\u0105 = t2;
            this.firePropertyChange(PROPERTY_SCALE_END, t3, this.\u0105);
            this.resizeAndRepaint();
            if (this.\u010e != null && this.\u010e.getPosition(this.\u010f) >= this.\u010e.getPosition(this.\u0105)) {
                this.setStart(this.\u010e.getPeriodStart(this.getSmallestVisiblePeriod(), this.\u0105));
            }
        }
    }

    public T getInstantAt(int n2) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null && this.\u010e != null) {
            long l2 = scaleAreaUI.getPositionAt(n2);
            return this.\u010e.getInstantAt(l2);
        }
        return null;
    }

    public int getX(T t2) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (t2 != null && scaleAreaUI != null && this.\u010e != null) {
            long l2 = this.\u010e.getPosition(t2);
            return scaleAreaUI.getX(l2);
        }
        return 0;
    }

    public Dimension getPreferredPeriodSize() {
        if (this.\u0102 != null) {
            return new Dimension(this.\u0102);
        }
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null) {
            return scaleAreaUI.getPreferredPeriodSize(this.getSmallestVisiblePeriod());
        }
        return new Dimension(27, 21);
    }

    public void setPreferredPeriodSize(Dimension dimension) {
        if (dimension != null && (dimension.width <= 0 || dimension.height <= 0)) {
            throw new IllegalArgumentException("Period sizes should be greater than zero!");
        }
        if (!JideSwingUtilities.equals(this.\u0102, dimension)) {
            Dimension dimension2 = this.\u0102;
            this.\u0102 = new Dimension(dimension);
            this.firePropertyChange(PROPERTY_PREFERRED_PERIOD_SIZE, dimension2, this.\u0102);
            this.\u0101();
            this.resizeAndRepaint();
        }
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.\u0101();
    }

    public boolean isPreferredPeriodSizeSet() {
        return this.\u0102 != null;
    }

    public PeriodConverter<T> getPeriodConverter(Period period) {
        PeriodConverter<T> periodConverter = this.\u010d.get(period);
        if (periodConverter == null) {
            periodConverter = this.getDefaultPeriodConverter();
        }
        return periodConverter;
    }

    public void setPeriodConverter(Period period, PeriodConverter<T> periodConverter) {
        PeriodConverter<T> periodConverter2 = this.\u010d.get(period);
        this.\u010d.put(period, periodConverter);
        this.firePropertyChange(PROPERTY_PERIOD_CONVERTERS, periodConverter2, periodConverter);
        this.repaint();
    }

    public PeriodConverter<T> getDefaultPeriodConverter() {
        return this.\u0101;
    }

    public void setDefaultPeriodConverter(PeriodConverter<T> periodConverter) {
        PeriodConverter<T> periodConverter2 = this.\u0101;
        this.\u0101 = periodConverter;
        this.firePropertyChange(PROPERTY_PERIOD_CONVERTERS, periodConverter2, this.\u0101);
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n2;
        Period period;
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null && this.\u010e != null && (period = scaleAreaUI.getPeriodAt(n2 = mouseEvent.getY())) != null) {
            int n3 = mouseEvent.getX();
            T t2 = this.getInstantAt(n3);
            T t3 = this.\u010e.getPeriodStart(period, t2);
            T t4 = this.\u010e.getPeriodEnd(period, t2);
            return this.getPeriodConverter(period).getDescription(t3, t4);
        }
        return super.getToolTipText();
    }

    public void setPeriodHeaderPainter(PeriodHeaderPainter periodHeaderPainter) {
        PeriodHeaderPainter periodHeaderPainter2 = this.\u010b;
        this.\u010b = periodHeaderPainter;
        this.firePropertyChange(PROPERTY_PERIOD_HEADER_PAINTER, periodHeaderPainter2, this.\u010b);
        this.repaint();
    }

    public PeriodHeaderPainter getPeriodHeaderPainter() {
        return this.\u010b;
    }

    public void setTreeTable(TreeTable treeTable) {
        TreeTable treeTable2 = this.\u0108;
        if (treeTable2 == treeTable) {
            return;
        }
        this.\u0108 = treeTable;
        this.firePropertyChange(PROPERTY_TREE_TABLE, treeTable2, this.\u0108);
        this.\u0101();
    }

    private void \u0101() {
        if (this.\u0108 != null && this.\u0108.getTableHeader() != null) {
            JTableHeader jTableHeader = this.\u0108.getTableHeader();
            jTableHeader.revalidate();
        }
    }

    public TreeTable getTreeTable() {
        return this.\u0108;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.\u010c;
        this.\u010c = tableCellRenderer;
        this.firePropertyChange(PROPERTY_TABLE_CELL_RENDERER, tableCellRenderer2, this.\u010c);
        this.\u0101();
    }

    public TableCellRenderer getTableCellRenderer() {
        if (this.\u010c != null) {
            return this.\u010c;
        }
        return null;
    }

    public List<ScaleAreaPopupMenuCustomizer<T>> getPopupMenuCustomizers() {
        return Collections.unmodifiableList(this.\u0106);
    }

    public void addPopupMenuCustomizer(ScaleAreaPopupMenuCustomizer<T> scaleAreaPopupMenuCustomizer) {
        this.\u0106.add(scaleAreaPopupMenuCustomizer);
    }

    public void removePopupMenuCustomizer(ScaleAreaPopupMenuCustomizer<T> scaleAreaPopupMenuCustomizer) {
        this.\u0106.remove(scaleAreaPopupMenuCustomizer);
    }

    protected void setUI(ScaleAreaUI scaleAreaUI) {
        super.setUI(scaleAreaUI);
    }

    @Override
    public String getUIClassID() {
        return \u0109;
    }

    @Override
    public ScaleAreaUI getUI() {
        return (ScaleAreaUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(\u0109) == null) {
            int n2 = LookAndFeelFactory.getStyle();
            if (n2 >= 0) {
                LookAndFeelFactory.installJideExtension(n2);
            } else {
                LookAndFeelFactory.installJideExtension();
            }
            new GanttUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        this.setUI((ScaleAreaUI)UIManager.getUI(this));
    }

    public String getResourceString(String string) {
        return ScaleAreaResources.getResourceBundle(this.getLocale()).getString(string);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(ScaleArea.class.getName(), 8192);
        }
    }
}

