/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Property;
import com.jidesoft.introspector.BeanIntrospector;
import com.jidesoft.introspector.BeanProperty;
import com.jidesoft.introspector.Introspector;
import com.jidesoft.introspector.IntrospectorContext;
import com.jidesoft.introspector.IntrospectorManager;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BasicTableModel<T>
extends AbstractTableModel
implements ContextSensitiveTableModel,
PropertyChangeListener {
    private List<T> \u0eaa;
    private Introspector \u0ead;
    private String[] \u0ea5;
    private transient Property[] \u0eab;
    private Method \u0ea7;
    private boolean \u0ea2 = false;
    private Method \u0e9f;
    private boolean \u0ea3 = false;
    private boolean \u0ea1 = true;
    private PropertyChangeSupport \u0e9d;
    public static final String PROPERTY_EDITABLE = "editable";
    private static final long \u0e9e = -4884343983492377717L;

    public BasicTableModel() {
        this(new ArrayList(), Object.class);
    }

    public BasicTableModel(List<T> list, Class<?> clazz) {
        this(list, IntrospectorManager.getIntrospector(clazz));
    }

    public BasicTableModel(List<T> list, Class<?> clazz, IntrospectorContext introspectorContext) {
        this(list, IntrospectorManager.getIntrospector(clazz, introspectorContext));
    }

    public BasicTableModel(List<T> list, Class<?> clazz, String[] stringArray) throws IntrospectionException {
        this(list, new BeanIntrospector(clazz, stringArray, 2));
    }

    public BasicTableModel(List<T> list, Introspector introspector) {
        this.\u0eaa = list;
        this.\u0ead = introspector;
        this.\u0ea5 = this.\u0ead.getPropertyNames();
    }

    @Override
    public int getRowCount() {
        return this.\u0eaa.size();
    }

    public T getObject(int n2) {
        return n2 >= 0 && n2 < this.\u0eaa.size() ? (T)this.\u0eaa.get(n2) : null;
    }

    public void setObject(T t2, int n2) {
        if (n2 >= 0 && n2 < this.\u0eaa.size()) {
            T t3 = this.\u0eaa.set(n2, t2);
            if (t3 != t2) {
                try {
                    if (this.isEditable()) {
                        this.uninstallListener(t3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.isEditable()) {
                        this.installListener(t2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    public int indexOf(T t2) {
        return this.\u0eaa != null ? this.\u0eaa.indexOf(t2) : -1;
    }

    public void addObject(T t2) {
        this.\u0101(-1, t2, true);
    }

    public void addObject(int n2, T t2) {
        this.\u0101(n2, t2, true);
    }

    private void \u0101(int n2, T t2, boolean bl) {
        if (n2 == -1) {
            this.\u0eaa.add(t2);
        } else {
            this.\u0eaa.add(n2, t2);
        }
        try {
            if (this.isEditable()) {
                this.installListener(t2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            if (n2 == -1) {
                this.fireTableRowsInserted(this.\u0eaa.size() - 1, this.\u0eaa.size() - 1);
            } else {
                this.fireTableRowsInserted(n2, n2);
            }
        }
    }

    public void removeObject(T t2) {
        int n2 = this.indexOf(t2);
        if (n2 != -1) {
            this.removeObject(n2);
        }
    }

    public void removeObject(int n2) {
        if (n2 != -1) {
            T t2 = this.\u0eaa.remove(n2);
            try {
                if (this.isEditable()) {
                    this.uninstallListener(t2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    public void addObjects(List<T> list) {
        int n2 = this.getRowCount();
        for (T t2 : list) {
            this.\u0101(-1, t2, false);
        }
        int n3 = this.getRowCount();
        if (n3 > n2) {
            this.fireTableRowsInserted(n2, n3 - 1);
        }
    }

    public void clear() {
        int n2 = this.getRowCount();
        if (n2 > 0) {
            try {
                this.unbind(this.\u0eaa);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.\u0eaa.clear();
            this.fireTableRowsDeleted(0, n2 - 1);
        }
    }

    @Override
    public int getColumnCount() {
        return this.\u0ead.getPropertyCount();
    }

    public Property getPropertyAt(int n2) {
        Property property;
        if (this.\u0eab == null) {
            this.\u0eab = new Property[this.getColumnCount()];
        }
        if ((property = this.\u0eab[n2]) == null) {
            this.\u0eab[n2] = property = this.\u0ead.getProperty(this.\u0ea5[n2]);
        }
        return property;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Property property = this.getPropertyAt(n3);
        this.prepareProperty(property, n2, n3);
        return property.getValue();
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        Property property = this.getPropertyAt(n3);
        this.prepareProperty(property, n2, n3);
        property.setValue(object);
        this.fireTableCellUpdated(n2, n3);
    }

    protected void prepareProperty(Property property, int n2, int n3) {
        if (property instanceof BeanProperty) {
            ((BeanProperty)property).setInstance(this.getObject(n2));
        }
    }

    @Override
    public String getColumnName(int n2) {
        Property property = this.getPropertyAt(n2);
        String string = property.getDisplayName();
        return string != null ? string : this.\u0ea5[n2];
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        Property property = this.getPropertyAt(n2);
        return property.getType();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        if (!this.isEditable()) {
            return false;
        }
        Property property = this.getPropertyAt(n3);
        return property.isEditable();
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        Property property = this.getPropertyAt(n3);
        return property.getConverterContext();
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        Property property = this.getPropertyAt(n3);
        return property.getEditorContext();
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        return this.getColumnClass(n3);
    }

    public void bind(List<T> list) throws Exception {
        for (T t2 : list) {
            this.installListener(t2);
        }
    }

    public void unbind(List<T> list) throws Exception {
        for (T t2 : list) {
            this.uninstallListener(t2);
        }
    }

    protected void installListener(T t2) throws Exception {
        if (t2 != null) {
            if (!this.\u0ea2 && this.\u0ea7 == null) {
                this.\u0ea2 = true;
                this.\u0ea7 = t2.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            }
            if (this.\u0ea7 != null) {
                this.\u0ea7.invoke(t2, this);
            }
        }
    }

    protected void uninstallListener(T t2) throws Exception {
        if (t2 != null) {
            if (!this.\u0ea3 && this.\u0e9f == null) {
                this.\u0ea3 = true;
                this.\u0e9f = t2.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            }
            if (this.\u0e9f != null) {
                this.\u0e9f.invoke(t2, this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n2 = this.indexOf(propertyChangeEvent.getSource());
        if (n2 != -1) {
            for (int i2 = 0; i2 < this.\u0ea5.length; ++i2) {
                String string = this.\u0ea5[i2];
                if (!string.equalsIgnoreCase(propertyChangeEvent.getPropertyName())) continue;
                this.fireTableCellUpdated(n2, i2);
                break;
            }
        }
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        this.\u0eab = null;
    }

    public boolean isEditable() {
        return this.\u0ea1;
    }

    public void setEditable(boolean bl) {
        if (this.\u0ea1 != bl) {
            boolean bl2 = this.\u0ea1;
            this.\u0ea1 = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, bl2, this.\u0ea1);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.\u0e9d;
        if (propertyChangeSupport == null || object == object2) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.\u0e9d == null) {
            this.\u0e9d = new PropertyChangeSupport(this);
        }
        this.\u0e9d.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.\u0e9d == null) {
            return;
        }
        this.\u0e9d.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(BasicTableModel.class.getName(), 4);
        }
    }
}

