/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Conflict;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.TableDiffPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;

public class DiffDivider
extends JPanel {
    private RowConverter \u0102;
    private RowConverter \u0108;
    private List<Difference> \u0109;
    private Difference \u0104;
    private int \u010d;
    private int \u0103;
    private int \u0105;
    private int \u010b;
    private int \u010a;
    private int \u0107;
    private Color \u010e;
    private Color \u0101;
    private Color \u010f;
    private Color \u0106;
    private boolean \u010c;
    public static final String PROPERTY_SELECTED_DIFFERENCE = "selectedDifference";

    public DiffDivider() {
    }

    public DiffDivider(RowConverter rowConverter, RowConverter rowConverter2) {
        this.\u0102 = rowConverter;
        this.\u0108 = rowConverter2;
    }

    public DiffDivider(RowConverter rowConverter, RowConverter rowConverter2, List<Difference> list) {
        this(rowConverter, rowConverter2);
        this.setDifferences(list);
    }

    public RowConverter getFirstConverter() {
        return this.\u0102;
    }

    public void setFirstConverter(RowConverter rowConverter) {
        this.\u0102 = rowConverter;
    }

    public RowConverter getSecondConverter() {
        return this.\u0108;
    }

    public void setSecondConverter(RowConverter rowConverter) {
        this.\u0108 = rowConverter;
    }

    public Color getInsertedColor() {
        if (this.\u010e == null) {
            this.\u010e = UIDefaultsLookup.getColor("DiffMerge.inserted");
        }
        return this.\u010e;
    }

    public void setInsertedColor(Color color) {
        this.\u010e = color;
        this.repaint();
    }

    public Color getChangedColor() {
        if (this.\u0101 == null) {
            this.\u0101 = UIDefaultsLookup.getColor("DiffMerge.changed");
        }
        return this.\u0101;
    }

    public void setChangedColor(Color color) {
        this.\u0101 = color;
        this.repaint();
    }

    public Color getDeletedColor() {
        if (this.\u010f == null) {
            this.\u010f = UIDefaultsLookup.getColor("DiffMerge.deleted");
        }
        return this.\u010f;
    }

    public void setDeletedColor(Color color) {
        this.\u010f = color;
        this.repaint();
    }

    public Color getConflictedColor() {
        if (this.\u0106 == null) {
            this.\u0106 = UIDefaultsLookup.getColor("DiffMerge.conflicted");
        }
        return this.\u0106;
    }

    public void setConflictedColor(Color color) {
        this.\u0106 = color;
        this.repaint();
    }

    public List<Difference> getDifferences() {
        return this.\u0109;
    }

    public void setDifferences(List<Difference> list) {
        this.\u0109 = list;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 30);
    }

    public int getFirstOffsetY() {
        return this.\u010d;
    }

    public void setFirstOffsetY(int n2) {
        this.\u010d = n2;
    }

    public int getSecondOffsetY() {
        return this.\u0103;
    }

    public void setSecondOffsetY(int n2) {
        this.\u0103 = n2;
    }

    public int getFirstTopMargin() {
        return this.\u0105;
    }

    public void setFirstTopMargin(int n2) {
        this.\u0105 = n2;
    }

    public int getSecondTopMargin() {
        return this.\u010b;
    }

    public void setSecondTopMargin(int n2) {
        this.\u010b = n2;
    }

    public int getFirstBottomMargin() {
        return this.\u010a;
    }

    public void setFirstBottomMargin(int n2) {
        this.\u010a = n2;
    }

    public int getSecondBottomMargin() {
        return this.\u0107;
    }

    public void setSecondBottomMargin(int n2) {
        this.\u0107 = n2;
    }

    public boolean isOpposite() {
        return this.\u010c;
    }

    public void setOpposite(boolean bl) {
        this.\u010c = bl;
    }

    public void setSelectedDifference(Difference difference) {
        if (this.\u0104 != difference) {
            Difference difference2 = this.\u0104;
            this.\u0104 = difference;
            this.firePropertyChange(PROPERTY_SELECTED_DIFFERENCE, difference2, this.\u0104);
            this.repaint();
        }
    }

    public Difference getSelectedDifference() {
        return this.\u0104;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u0109 != null) {
            Rectangle rectangle = graphics.getClipBounds();
            int n2 = rectangle.y;
            int n3 = rectangle.y + rectangle.height;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JideSwingUtilities.setupShapeAntialiasing(graphics2D);
            JideSwingUtilities.setupAntialiasing(this, graphics2D);
            int n4 = this.getFirstOffsetY();
            int n5 = this.getSecondOffsetY();
            int n6 = this.getWidth();
            int n7 = this.getHeight();
            Polygon polygon = new Polygon(new int[]{0, n6, n6, 0}, new int[]{this.getFirstTopMargin(), this.getSecondTopMargin(), n7 - this.getFirstBottomMargin(), n7 - this.getSecondBottomMargin()}, 4);
            graphics2D.setClip(polygon);
            int n8 = 0;
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof TableDiffPane)) continue;
                n8 = 0;
                break;
            }
            for (Difference difference : this.\u0109) {
                Color color;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13 = this.isOpposite() ? difference.getDeletedStart() : difference.getAddedStart();
                int n14 = this.isOpposite() ? difference.getDeletedEnd() : difference.getAddedEnd();
                int n15 = this.isOpposite() ? difference.getAddedStart() : difference.getDeletedStart();
                int n16 = this.isOpposite() ? difference.getAddedEnd() : difference.getDeletedEnd();
                boolean bl = false;
                boolean bl2 = false;
                if (n16 == -1) {
                    bl = true;
                } else if (n14 == -1) {
                    bl2 = true;
                }
                if (bl) {
                    n11 = n12 = this.\u0102.indexToY(n15) + n4 + n8;
                    n10 = this.\u0108.indexToY(n13) + n5 + n8;
                    n9 = this.\u0108.indexToY(n14 + 1) + n5 + n8;
                } else if (bl2) {
                    n12 = this.\u0102.indexToY(n15) + n4 + n8;
                    n11 = this.\u0102.indexToY(n16 + 1) + n4 + n8;
                    n9 = n10 = this.\u0108.indexToY(n13) + n5 + n8;
                } else {
                    n12 = this.\u0102.indexToY(n15) + n4 + n8;
                    n11 = this.\u0102.indexToY(n16 + 1) + n4 + n8;
                    n10 = this.\u0108.indexToY(n13) + n5 + n8;
                    n9 = this.\u0108.indexToY(n14 + 1) + n5 + n8;
                }
                if (n2 > n12 && n2 > n10 && n2 > n9 && n2 > n11) continue;
                if (n3 <= n12 && n3 <= n10 && n3 <= n9 && n3 <= n11) break;
                Polygon polygon2 = new Polygon(new int[]{0, n6, n6, 0}, new int[]{n12, n10, n9, n11}, 4);
                Color color2 = difference.\u0101() ? this.getConflictedColor() : (bl ? this.getInsertedColor() : (color = bl2 ? this.getDeletedColor() : this.getChangedColor()));
                if (this.\u0104 != null) {
                    if (this.\u0104 == difference) {
                        color = this.getSelectedColor(color);
                    } else if (!this.\u010c && this.\u0104.getAddedStart() == difference.getAddedStart() && this.\u0104.getAddedEnd() == difference.getAddedEnd() && this.\u0104.getDeletedStart() == difference.getDeletedStart() && this.\u0104.getDeletedEnd() == difference.getDeletedEnd()) {
                        color = this.getSelectedColor(color);
                    } else if (this.\u010c && this.\u0104 instanceof Conflict && this.\u0104.getAddedStart() == difference.getAddedStart() && this.\u0104.getAddedEnd() == difference.getAddedEnd() && ((Conflict)this.\u0104).getDeleted2Start() == difference.getDeletedStart() && ((Conflict)this.\u0104).getDeleted2End() == difference.getDeletedEnd()) {
                        color = this.getSelectedColor(color);
                    }
                }
                graphics2D.setColor(color);
                graphics2D.fillPolygon(polygon2);
                graphics2D.setColor(Color.GRAY);
                graphics2D.drawLine(0, n12, n6, n10);
                graphics2D.drawLine(0, n11, n6, n9);
            }
            graphics2D.dispose();
        }
    }

    protected Color getSelectedColor(Color color) {
        return color.darker();
    }

    private int \u0101(int n2, int n3) {
        return n3 == -1 ? 0 : n3 - n2 + 1;
    }

    protected int getSecondMatchLine(int n2, int n3) {
        int n4;
        int n5 = n4 = n3 + n2 / 4;
        if (this.\u0109 != null) {
            for (Difference difference : this.\u0109) {
                if (n4 < difference.getDeletedStart()) break;
                if ((n5 -= this.\u0101(difference.getDeletedStart(), difference.getDeletedEnd()) - this.\u0101(difference.getAddedStart(), difference.getAddedEnd())) > 0) continue;
                return difference.getAddedStart();
            }
            return Math.max(0, n5 - n2 / 4);
        }
        return n3;
    }

    protected int getFirstMatchLine(int n2, int n3) {
        int n4;
        int n5 = n4 = n3 + n2 / 4;
        if (this.\u0109 != null) {
            for (Difference difference : this.\u0109) {
                if (n4 < difference.getAddedStart()) break;
                if ((n5 -= this.\u0101(difference.getAddedStart(), difference.getAddedEnd()) - this.\u0101(difference.getDeletedStart(), difference.getDeletedEnd())) > 0) continue;
                return difference.getDeletedStart();
            }
            return Math.max(0, n5 - n2 / 4);
        }
        return n3;
    }

    protected void adjustFirstVerticalOffset(int n2, int n3) {
        this.setFirstOffsetY(n3 + n2);
        this.setFirstTopMargin(n3);
    }

    protected void adjustSecondVerticalOffset(int n2, int n3) {
        this.setSecondOffsetY(n3 + n2);
        this.setSecondTopMargin(n3);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16384)) {
            Lm.showInvalidProductMessage(DiffDivider.class.getName(), 16384);
        }
    }

    public static interface RowConverter {
        public int indexToY(int var1);
    }
}

