/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ListSelectionModel;

public class RaisedPieSegmentRenderer
extends AbstractPieSegmentRenderer {
    private double \u012d = -0.035;
    private double \u012c = -0.035;

    public double getHighlightCenterOffsetX() {
        return this.\u012d;
    }

    public void setHighlightCenterOffsetX(double d2) {
        this.\u012d = d2;
    }

    public double getHighlightCenterOffsetY() {
        return this.\u012c;
    }

    public void setHighlightCenterOffsetY(double d2) {
        this.\u012c = d2;
    }

    @Override
    public void renderSegments(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int[] nArray) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = chart == null || chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = 2 * n2;
        int n6 = (int)(0.2 * (double)n2);
        int n7 = n3 - n2;
        int n8 = n4 - n2;
        float f2 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object object2;
            object = chartModel.getPoint(i2);
            Positionable positionable = object.getX();
            Highlight highlight = null;
            if (object instanceof Highlightable) {
                highlight = ((Highlightable)object).getHighlight();
            }
            if (highlight == null && positionable instanceof ChartCategory) {
                object2 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object2).getHighlight();
            }
            Object object3 = (object2 = chart.getHighlightStyle(highlight)) == null ? chartStyle : object2;
            boolean bl = chart.isRolloverEnabled() && object.equals(chart.getCurrentChartPoint());
            graphics2D.setPaint(this.\u0101((ChartStyle)object3, bl, point, n2));
            float f3 = f2 + (float)nArray[i2] / 2.0f;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i2);
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n6 * Math.cos(Math.toRadians(f3))) : 0;
            int n10 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n6 * Math.sin(Math.toRadians(f3)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n9, n10);
            graphics2D.transform(affineTransform);
            Arc2D.Double double_ = new Arc2D.Double(n7, n8, n5, n5, f2, nArray[i2], 2);
            PointDescriptor pointDescriptor = new PointDescriptor((Chartable)object, i2, chartModel);
            this.recordSegment(affineTransform.createTransformedShape(double_), pointDescriptor);
            Rectangle2D rectangle2D = double_.getBounds2D();
            if (rectangle2D.getHeight() > 0.5 && rectangle2D.getWidth() > 0.5) {
                graphics2D.fill(double_);
            }
            f2 += (float)nArray[i2];
            graphics2D.translate(-n9, -n10);
        }
        f2 = 0.0f;
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines(false, graphics2D, chart, chartModel, point, n2, nArray, chartStyle);
        }
        this.renderOutlines(true, graphics2D, chart, chartModel, point, n2, nArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            object = (Graphics2D)this.getLabelGraphics();
            pieLabelRenderer.renderLabels((Graphics)(object == null ? graphics : object), chart, chartModel, point, n5, n5, nArray, chartStyle);
        }
    }

    private Paint \u0101(ChartStyle chartStyle, boolean bl, Point point, int n2) {
        Paint paint;
        int n3 = point.x;
        int n4 = point.y;
        Paint paint2 = chartStyle.getBarPaint();
        if (bl) {
            if (paint2 instanceof Color) {
                paint2 = ColorFactory.intensify2((Color)paint2, 50);
            } else if (paint2 instanceof TexturePaint) {
                paint2 = this.modify((TexturePaint)paint2);
            }
        }
        if (paint2 instanceof Color) {
            Color color = (Color)paint2;
            Color color2 = ColorUtils.getDerivedColor(color, 0.25f);
            Color color3 = ColorUtils.getDerivedColor(color, 0.57f);
            Color color4 = ColorUtils.getDerivedColor(color, 0.63f);
            color = ColorUtils.getDerivedColor(color, 0.5f);
            paint = JideSwingUtilities.getRadialGradientPaint(new Point2D.Double((double)n3 + this.\u012d * (double)n2, (double)n4 + this.\u012c * (double)n2), n2, new float[]{0.2f, 0.6f, 0.8f, 1.0f}, new Color[]{color4, color3, color, color2});
        } else {
            paint = paint2;
        }
        return paint;
    }
}

