/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractPieLabelRenderer;
import com.jidesoft.chart.render.DefaultPointLabeler;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListSelectionModel;

public class LinePieLabelRenderer
extends AbstractPieLabelRenderer
implements PieLabelRenderer2D {
    private Chart \u0110;
    private int \u010a = 20;
    private int \u010c = 3;
    private Color \u0111 = Color.darkGray;
    private Stroke \u0113 = new BasicStroke(1.0f);
    private PointLabeler \u010b = new DefaultPointLabeler();
    private int \u010f = 10;
    private int \u010e = 12;
    private int \u010d = 5;
    private boolean \u0112 = false;

    @Override
    public PointLabeler getPointLabeler() {
        return this.\u010b;
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        this.\u010b = pointLabeler;
    }

    @Override
    public int getTickLength() {
        return this.\u010f;
    }

    @Override
    public void setTickLength(int n2) {
        this.\u010f = n2;
    }

    public int getSegmentControlPointDistance() {
        return this.\u010e;
    }

    public void setSegmentControlPointDistance(int n2) {
        this.\u010e = n2;
    }

    public int getLabelControlPointDistance() {
        return this.\u010d;
    }

    public void setLabelControlPointDistance(int n2) {
        this.\u010d = n2;
    }

    public int getLabelLineGapSize() {
        return this.\u010c;
    }

    public void setLabelLineGapSize(int n2) {
        this.\u010c = n2;
    }

    public Color getLineColor() {
        return this.\u0111;
    }

    public void setLineColor(Color color) {
        this.\u0111 = color;
    }

    protected Color createLineColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLineColor();
    }

    protected Color createLabelColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelColor();
    }

    protected Font createLabelFont(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelFont();
    }

    public Stroke getLineStroke() {
        return this.\u0113;
    }

    public void setLineStroke(Stroke stroke) {
        this.\u0113 = stroke;
    }

    public int getLabelXOffset() {
        return this.\u010a;
    }

    public void setLabelXOffset(int n2) {
        this.\u010a = n2;
    }

    public boolean isShowAllLabels() {
        return this.\u0112;
    }

    public void setShowAllLabels(boolean bl) {
        this.\u0112 = bl;
    }

    @Override
    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int n3, int[] nArray, ChartStyle chartStyle) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.renderLabels((Graphics2D)graphics, chart, chartModel, (Point2D)point, (double)n2, (double)n3, fArray, chartStyle);
    }

    @Override
    public void renderLabels(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d2, double d3, float[] fArray, ChartStyle chartStyle) {
        this.\u0110 = chart;
        Pair<List<A>, List<A>> pair = this.\u0101(graphics2D, chart, chartModel, point2D, d2, d3, fArray, chartStyle);
        List<A> list = pair.getFirst();
        List<A> list2 = pair.getSecond();
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1));
        for (A a2 : list) {
            if (!a2.\u0108()) continue;
            a2.draw(graphics2D);
        }
        for (A a2 : list2) {
            if (!a2.\u0108()) continue;
            a2.draw(graphics2D);
        }
    }

    Pair<List<A>, List<A>> \u0101(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d2, double d3, float[] fArray, ChartStyle chartStyle) {
        Object object;
        double d4 = chartStyle.getPieOffsetAngle();
        ArrayList<Chartable> arrayList = new ArrayList<Chartable>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Chartable> arrayList4 = new ArrayList<Chartable>();
        ArrayList<Float> arrayList5 = new ArrayList<Float>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            object = chartModel.getPoint(i2);
            double d5 = d4 + (double)(fArray[i2] / 2.0f);
            if (Math.cos(Math.toRadians(d5)) >= 0.0) {
                arrayList6.add(i2);
                arrayList5.add(Float.valueOf((float)d5));
                arrayList4.add((Chartable)object);
            } else {
                arrayList3.add(i2);
                arrayList2.add(Float.valueOf((float)d5));
                arrayList.add((Chartable)object);
            }
            d4 += (double)fArray[i2];
        }
        List<A> list = this.\u0101(graphics2D, chart, chartModel, point2D, d2, d3, -1, arrayList2, arrayList3, arrayList, chartStyle);
        object = this.\u0101(graphics2D, chart, chartModel, point2D, d2, d3, 1, arrayList5, arrayList6, arrayList4, chartStyle);
        return new Pair<List<A>, Object>(list, object);
    }

    private List<A> \u0101(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d2, double d3, int n2, List<Float> list, List<Integer> list2, List<Chartable> list3, ChartStyle chartStyle) {
        double d4;
        Serializable serializable;
        int n3;
        double d5 = point2D.getX();
        double d6 = point2D.getY();
        Insets insets = chart.getInsets();
        Dimension dimension = chart.getSize();
        double d7 = dimension == null ? d3 : dimension.getHeight();
        ArrayList<A> arrayList = new ArrayList<A>();
        int n4 = list3.size();
        List<Integer> list4 = LinePieLabelRenderer.reorder(n4);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Font> arrayList3 = new ArrayList<Font>();
        ArrayList<B> arrayList4 = new ArrayList<B>();
        double d8 = 0.0;
        for (int i2 = 0; i2 < list4.size() && d8 < d7; ++i2) {
            int n5 = list4.get(i2);
            Chartable chartable = list3.get(n5);
            Font font = this.createLabelFont(chart, chartModel, chartable);
            if (font == null) {
                font = graphics2D.getFont();
            }
            arrayList3.add(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            d8 += (double)fontMetrics.getHeight();
            if (!(d8 < d7)) continue;
            arrayList2.add(n5);
        }
        double d9 = d2 / 2.0;
        int n6 = (int)(0.2 * d9);
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            int n7 = (Integer)arrayList2.get(i3);
            int n8 = list2.get(n7);
            float f2 = list.get(n7).floatValue();
            double d10 = (double)this.getTickLength() / 2.0;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            n3 = listSelectionModel != null && listSelectionModel.isSelectedIndex(n8) ? 1 : 0;
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || n3 != 0 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n6 * Math.cos(Math.toRadians(f2))) : 0;
            int n10 = chartStyle.isPieSegmentsAlwaysExploded() || n3 != 0 && chart.isSelectionShowsExplodedSegments() ? (int)(-((double)n6 * Math.sin(Math.toRadians(f2)))) : 0;
            double d11 = d6 - (d3 / 2.0 - d10) * Math.sin(Math.toRadians(f2));
            serializable = (Font)arrayList3.get(i3);
            B b2 = new B(n7, (Font)serializable, d11 + (double)n10, n9, n10);
            arrayList4.add(b2);
        }
        Collections.sort(arrayList4);
        double d12 = 0.0;
        Font font = graphics2D.getFont();
        for (B b3 : arrayList4) {
            font = b3.\u0104();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n11 = fontMetrics.getDescent();
            b3.\u0101(d12 += (double)fontMetrics.getAscent());
            d12 += (double)n11;
        }
        while ((d4 = this.\u0101(graphics2D, 0.0, d7 - (double)font.getSize(), arrayList4)) > 1.0) {
        }
        for (B b4 : arrayList4) {
            int n12;
            int n13;
            n3 = b4.\u0105();
            double d13 = list.get(n3).floatValue();
            Chartable chartable = list3.get(n3);
            String string = this.\u010b == null ? null : this.\u010b.getDisplayText(chartable);
            font = b4.\u0104();
            serializable = graphics2D.getFontMetrics(font);
            int n14 = ((FontMetrics)serializable).getDescent();
            int n15 = n13 = string == null ? 0 : ((FontMetrics)serializable).stringWidth(string);
            if (n2 > 0) {
                n12 = (int)(d5 + d2 / 2.0 + (double)this.\u010a);
                if ((n12 -= insets.right) + n13 > chart.getWidth()) {
                    n12 = chart.getWidth() - n13 - insets.right;
                }
            } else {
                n12 = (int)(d5 - d2 / 2.0 - (double)n13) - this.\u010a;
                if ((n12 += insets.left) < insets.left) {
                    n12 = insets.left;
                }
            }
            double d14 = (double)this.getTickLength() / 2.0;
            double d15 = d5 + (d2 / 2.0 - d14) * Math.cos(Math.toRadians(d13));
            double d16 = d6 - (d3 / 2.0 - d14) * Math.sin(Math.toRadians(d13));
            double d17 = d5 + (d2 / 2.0 + d14) * Math.cos(Math.toRadians(d13));
            double d18 = d6 - (d3 / 2.0 + d14) * Math.sin(Math.toRadians(d13));
            double d19 = d5 + (d2 / 2.0 + (double)this.\u010e) * Math.cos(Math.toRadians(d13));
            double d20 = d6 - (d3 / 2.0 + (double)this.\u010e) * Math.sin(Math.toRadians(d13));
            Point2D.Double double_ = new Point2D.Double(d15, d16);
            Point2D.Double double_2 = new Point2D.Double(d17, d18);
            Point2D.Double double_3 = new Point2D.Double(d19, d20);
            A a2 = new A(chartModel, chartable, string, n12, (int)b4.\u0101(), double_, double_2, double_3, n2, n13, ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getDescent(), n14, ((FontMetrics)serializable).getAscent(), b4.\u0103(), b4.\u0108());
            arrayList.add(a2);
        }
        return arrayList;
    }

    private double \u0101(Graphics2D graphics2D, double d2, double d3, List<B> list) {
        double d4 = -1.0;
        B b2 = null;
        for (B b3 : list) {
            double d5 = this.\u0101(graphics2D, d2, d3, b3, list, false);
            if (!(d5 > d4)) continue;
            d4 = d5;
            b2 = b3;
        }
        if (b2 != null) {
            this.\u0101(graphics2D, d2, d3, b2, list, true);
        }
        return d4;
    }

    private double \u0101(Graphics2D graphics2D, double d2, double d3, B b2, List<B> list, boolean bl) {
        double d4;
        int n2 = list.indexOf(b2);
        int n3 = (int)Math.round(Math.signum(b2.\u0107()));
        if (n3 == 0) {
            return 0.0;
        }
        int n4 = n2 + n3;
        if (n4 < 0) {
            d4 = d2;
        } else if (n4 >= list.size()) {
            d4 = d3;
        } else {
            B b3 = list.get(n4);
            d4 = n3 < 0 ? b3.\u0101(graphics2D) + (double)b2.\u0104(graphics2D) : b3.\u0103(graphics2D) - (double)b2.\u0102(graphics2D);
        }
        assert (d4 <= d3);
        double d5 = b2.\u0106();
        double d6 = d5 > d4 && d5 < b2.\u0101() || d5 < d4 && d5 > b2.\u0101() ? d5 : (b2.\u0101() + d4) / 2.0;
        double d7 = Math.abs(d6 - b2.\u0101());
        if (bl) {
            b2.\u0101(d6);
        }
        return d7;
    }

    public static List<Integer> reorder(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
        if (n2 == 0) {
            return arrayList;
        }
        if (n2 == 1) {
            arrayList.add(0);
            return arrayList;
        }
        boolean[] blArray = new boolean[n2];
        double d2 = (double)n2 - 1.0;
        do {
            for (double d3 = 0.0; d3 < (double)n2; d3 += d2) {
                int n3 = (int)d3;
                if (blArray[n3]) continue;
                blArray[n3] = true;
                arrayList.add(n3);
            }
            d2 /= 2.0;
        } while (arrayList.size() < n2);
        return arrayList;
    }

    class A
    implements Drawable,
    Comparable<A> {
        private ChartModel \u01e9;
        private Chartable \u01e7;
        private Point2D \u01f4;
        private Point2D \u01f0;
        private Point2D \u01e6;
        int \u01ed;
        int \u01ec;
        int \u01f3;
        int \u01f1;
        int \u01ee;
        int \u01ea;
        int \u01ef;
        int \u01fa;
        int \u01eb;
        private String \u01f5;
        private boolean \u01e8 = true;
        private boolean \u01e5 = false;

        public A(int n2, int n3) {
            this.\u01ed = n2;
            this.\u01ec = n3;
        }

        public A(ChartModel chartModel, Chartable chartable, String string, int n2, int n3, Point2D point2D, Point2D point2D2, Point2D point2D3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            this.\u01e9 = chartModel;
            this.\u01e7 = chartable;
            this.\u01f4 = point2D;
            this.\u01f0 = point2D2;
            this.\u01e6 = point2D3;
            this.\u01ed = n2;
            this.\u01ec = n3;
            this.\u01f3 = n4;
            this.\u01f1 = n5;
            this.\u01ee = n6;
            this.\u01ea = n7;
            this.\u01ef = n8;
            this.\u01fa = n9;
            this.\u01eb = n10;
            this.\u01f5 = string;
        }

        public A(A a2) {
            this.\u01e9 = a2.\u01e9;
            this.\u01e7 = a2.\u01e7;
            this.\u01f4 = a2.\u01f4;
            this.\u01f0 = a2.\u01f0;
            this.\u01e6 = a2.\u01e6;
            this.\u01ed = a2.\u01ed;
            this.\u01ec = a2.\u01ec;
            this.\u01f3 = a2.\u01f3;
            this.\u01f1 = a2.\u01f1;
            this.\u01ee = a2.\u01ee;
            this.\u01ea = a2.\u01ea;
            this.\u01ef = a2.\u01ef;
            this.\u01fa = a2.\u01fa;
            this.\u01eb = a2.\u01eb;
            this.\u01f5 = a2.\u01f5;
        }

        public boolean \u0108() {
            return this.\u01e8;
        }

        public void \u0103(boolean bl) {
            this.\u01e8 = bl;
        }

        public boolean \u0107() {
            return this.\u01e5;
        }

        public void \u0102(boolean bl) {
            this.\u01e5 = bl;
        }

        public String toString() {
            return String.format("#<PieLabel label=%s x=%d y=%d>", this.\u01f5, this.\u01ed, this.\u01ec);
        }

        public int \u0101(A a2) {
            if (this.\u01ec == a2.\u01ec) {
                if (this.\u01ed < a2.\u01ed) {
                    return -1;
                }
                if (this.\u01ed > a2.\u01ed) {
                    return 1;
                }
                return 0;
            }
            if (this.\u01ec < a2.\u01ec) {
                return -1;
            }
            return 1;
        }

        @Override
        public void draw(Graphics graphics) {
            Serializable serializable;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.\u01f5 == null) {
                return;
            }
            Color color = LinePieLabelRenderer.this.createLineColor(LinePieLabelRenderer.this.\u0110, this.\u01e9, this.\u01e7);
            int n2 = Math.max(this.\u01ed + this.\u01fa, 0);
            if (n2 + this.\u01f1 > LinePieLabelRenderer.this.\u0110.getXEnd()) {
                n2 = LinePieLabelRenderer.this.\u0110.getXEnd() - this.\u01f1;
            }
            int n3 = n2 + this.\u01f1;
            if (this.\u01f3 < 0 && n2 < 0) {
                n2 = 0;
                n3 = this.\u01f1;
            } else if (this.\u01f3 > 0 && n2 + this.\u01f1 > LinePieLabelRenderer.this.\u0110.getXEnd()) {
                n3 = n2 = LinePieLabelRenderer.this.\u0110.getXEnd() - this.\u01f1;
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(LinePieLabelRenderer.this.getLineStroke());
            if (this.\u01f3 == 1) {
                if (this.\u01f0.getX() < (double)n2) {
                    serializable = new CubicCurve2D.Double(this.\u01f4.getX() + (double)this.\u01fa, this.\u01f4.getY() + (double)this.\u01eb, this.\u01e6.getX() + (double)this.\u01fa, this.\u01e6.getY() + (double)this.\u01eb, n2 - LinePieLabelRenderer.this.\u010c - LinePieLabelRenderer.this.\u010d, this.\u01ec, n2 - LinePieLabelRenderer.this.\u010c, this.\u01ec);
                    graphics2D.draw((Shape)((Object)serializable));
                }
            } else if ((double)n3 < this.\u01f0.getX()) {
                serializable = new CubicCurve2D.Double(this.\u01f4.getX() + (double)this.\u01fa, this.\u01f4.getY() + (double)this.\u01eb, this.\u01f0.getX() + (double)this.\u01fa, this.\u01f0.getY() + (double)this.\u01eb, n3 + LinePieLabelRenderer.this.\u010c + LinePieLabelRenderer.this.\u010d, this.\u01ec, n3 + LinePieLabelRenderer.this.\u010c, this.\u01ec);
                graphics2D.draw((Shape)((Object)serializable));
            }
            if (this.\u01f5 != null) {
                serializable = LinePieLabelRenderer.this.createLabelFont(LinePieLabelRenderer.this.\u0110, this.\u01e9, this.\u01e7);
                if (serializable != null) {
                    graphics2D.setFont((Font)serializable);
                }
                graphics2D.setColor(LinePieLabelRenderer.this.createLabelColor(LinePieLabelRenderer.this.\u0110, this.\u01e9, this.\u01e7));
                graphics2D.drawString(this.\u01f5, n2, this.\u01ec + this.\u01ea);
            }
            graphics2D.dispose();
        }
    }

    static class B
    implements Comparable<B> {
        private final double \u0103;
        private double \u0106;
        private final Font \u0101;
        private final int \u0105;
        private final int \u0102;
        private final int \u0104;

        public B(int n2, Font font, Number number, int n3, int n4) {
            this.\u0105 = n2;
            this.\u0101 = font;
            this.\u0106 = this.\u0103 = number.doubleValue();
            this.\u0102 = n3;
            this.\u0104 = n4;
        }

        public int \u0105() {
            return this.\u0105;
        }

        public void \u0101(double d2) {
            this.\u0106 = d2;
        }

        public double \u0106() {
            return this.\u0103;
        }

        public double \u0101() {
            return this.\u0106;
        }

        public Font \u0104() {
            return this.\u0101;
        }

        public int \u0109() {
            return this.\u0101.getSize();
        }

        public int \u0104(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.\u0101);
            return fontMetrics.getAscent();
        }

        public int \u0102(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.\u0101);
            return fontMetrics.getDescent();
        }

        public double \u0103(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.\u0101);
            return this.\u0106 - (double)fontMetrics.getAscent();
        }

        public double \u0101(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.\u0101);
            return this.\u0106 + (double)fontMetrics.getDescent();
        }

        public double \u0107() {
            return this.\u0103 - this.\u0106;
        }

        public double \u0102() {
            double d2 = this.\u0107();
            return d2 * d2;
        }

        public int \u0103() {
            return this.\u0102;
        }

        public int \u0108() {
            return this.\u0104;
        }

        public int \u0101(B b2) {
            double d2 = this.\u0103 + (double)this.\u0108();
            double d3 = b2.\u0106() + (double)b2.\u0108();
            return Double.compare(d2, d3);
        }

        public String toString() {
            return "PieLabelLocator{expectedPosition=" + this.\u0103 + ", actualPosition=" + this.\u0106 + ", modelIndex=" + this.\u0105 + '}';
        }
    }
}

