/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.channels;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.channels.AbstractSocketChannel;
import com.vertica.support.channels.IHostNameValidator;
import com.vertica.support.channels.SocketChannelMessageKey;
import com.vertica.support.exceptions.ErrorException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class HostNameValidator
implements IHostNameValidator {
    @Override
    public void enableHostnameValidation(SSLEngine sslEngine, ILogger log) throws ErrorException {
        try {
            SSLParameters sslParams = new SSLParameters();
            Method setEndpointIdAlgorithm = sslParams.getClass().getMethod("setEndpointIdentificationAlgorithm", String.class);
            setEndpointIdAlgorithm.invoke((Object)sslParams, "HTTPS");
            sslEngine.setSSLParameters(sslParams);
        }
        catch (NoSuchMethodException e) {
            LogUtilities.logError(e, log);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VALIDATION_ERR_JVM_NOT_CAPABLE.name(), e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LogUtilities.logError(e, log);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VALIDATION_ERR_JVM_NOT_CAPABLE.name(), e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LogUtilities.logError(e, log);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VERIFICATION_ERR_JVM_PREVENTING_ACCESS.name(), e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LogUtilities.logError(e, log);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VERIFICATION_ERR.name(), e.getMessage(), (Throwable)e);
        }
    }
}

