/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ErrorException;
import java.util.BitSet;

public abstract class DSISimpleResultSet
implements IResultSet {
    private int m_fetchSize = 0;
    private boolean m_hasStartedFetch = false;
    private boolean m_isClosed = false;
    private long m_currentRow = 0L;
    private IWarningListener m_warningListener = null;
    private BitSet m_needsData = new BitSet();

    protected DSISimpleResultSet() {
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            try {
                this.closeCursor();
            }
            catch (ErrorException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        this.doCloseCursor();
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public boolean getDataNeeded(int column) {
        return this.m_needsData.get(column);
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        return this.doMoveToNextRow();
    }

    @Override
    public void onFinishRowUpdate() throws ErrorException {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        this.m_warningListener = listener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setDataNeeded(int column, boolean isDataNeeded) {
        this.m_needsData.set(column, isDataNeeded);
    }

    @Override
    public void setFetchSize(int fetchSize) throws ErrorException {
        this.m_fetchSize = fetchSize;
    }

    @Override
    public boolean writeData(int column, DataWrapper data, long offset, boolean isDefault) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public boolean supportsHasMoreRows() {
        return true;
    }

    protected abstract void doCloseCursor() throws ErrorException;

    protected abstract boolean doMoveToNextRow() throws ErrorException;

    protected int getCurrentRow() {
        return (int)this.m_currentRow;
    }
}

