/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EXADriver
implements Driver {
    private static final String DRIVER_NAME = "EXASolution JDBC Driver";
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 64;
    public static final int MAX_CONNECTION_POOL_SIZE = 8192;
    public static int connectionPoolSize = 64;
    private static Map versionInfo = null;
    private DebugLog debug = null;
    private static EXADriver registeredDriver;

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Exasol JDBC driver, version " + EXADriver.getEXADriverMajorVersion() + "." + EXADriver.getEXADriverMinorVersion() + "." + EXADriver.getEXADriverVersionInc());
        System.out.println("Build for JRE 6 or higher");
    }

    public static void debugError(String string, Throwable throwable, DebugLog debugLog) {
        String string2 = "JDBC Exception - " + string;
        if (null == debugLog || null == throwable) {
            return;
        }
        if (null != string) {
            debugLog.log(string2);
        }
        if (null != throwable) {
            StackTraceElement[] stackTraceElementArray;
            StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
            if (null != stackTraceElementArray2 && stackTraceElementArray2.length > 0) {
                debugLog.log(throwable.getClass() + ": " + throwable.getMessage());
                stackTraceElementArray = stackTraceElementArray2;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
            for (stackTraceElementArray = throwable.getCause(); null != stackTraceElementArray; stackTraceElementArray = stackTraceElementArray.getCause()) {
                StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray.getStackTrace();
                if (null == stackTraceElementArray3 || stackTraceElementArray3.length <= 0) continue;
                debugLog.log("Caused by:");
                debugLog.log(stackTraceElementArray.getClass() + ": " + stackTraceElementArray.getMessage());
                for (StackTraceElement stackTraceElement : stackTraceElementArray3) {
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
        }
    }

    @Override
    public boolean acceptsURL(String string) {
        return string.startsWith("jdbc:exa:") || string.startsWith("jdbc:exa-debug:") || string.startsWith("exa:") || string.startsWith("exa-debug:") || string.startsWith("jdbc:exa-worker:") || string.startsWith("jdbc:exa-worker-debug:") || string.startsWith("exa-worker:") || string.startsWith("exa-worker-debug:");
    }

    public static void register() throws SQLException {
        if (EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        EXADriver eXADriver = new EXADriver();
        DriverManager.registerDriver(eXADriver);
        registeredDriver = eXADriver;
    }

    public static void deregister() throws SQLException {
        if (!EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using EXADriver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Vector vector = null;
        if (null == string) {
            throw new SQLException(Translator.Driver_URL_can_t_be_null());
        }
        if (0 == string.length()) {
            throw new SQLException(Translator.Driver_URL_can_t_be_an_empty_string());
        }
        EXAConnection eXAConnection = null;
        try {
            ParserResult parserResult = this.parseURL8(string);
            if (parserResult != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(parserResult.params.getProperty("connectionPoolSize"));
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n > 8192 || n < 0) {
                    throw new SQLException("Connection pool size can be between 1 and 8192");
                }
                if (n != 0) {
                    if (connectionPoolSize != 64 && n != connectionPoolSize) {
                        throw new SQLException("Connection pool size can be changed only one time in the driver.");
                    }
                    connectionPoolSize = n;
                }
                if ("1".equals(parserResult.params.getProperty("TestConnectionStringOnly"))) {
                    parserResult = this.expandDNSPool(parserResult);
                }
                vector = new Vector();
                for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
                    if (!((ClusterNode)parserResult.clusterNodes.get(i)).isValid()) continue;
                    vector.add(parserResult.clusterNodes.get(i));
                }
                if (vector.size() < 1) {
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts(), "HY000");
                }
                if (properties != null) {
                    parserResult.params.putAll((Map<?, ?>)properties);
                }
                if ("1".equals(parserResult.params.getProperty("debug"))) {
                    this.openLog(parserResult.params.getProperty("logdir"));
                }
                String string2 = parserResult.params.getProperty("user");
                String string3 = parserResult.params.getProperty("password");
                String string4 = parserResult.params.getProperty("authmethod");
                String string5 = parserResult.params.getProperty("validateservercertificate");
                this.log("Java Version  : " + System.getProperty("java.version"));
                this.log("Driver Version: " + EXADriver.getVersionInfo());
                this.log("Connection Url: " + string);
                for (int i = 0; i < vector.size(); ++i) {
                    if (0 == ((ClusterNode)vector.get(i)).GetPort()) {
                        ((ClusterNode)vector.get(i)).SetPort(8563);
                    }
                    this.log("Server:Port: " + ((ClusterNode)vector.get(i)).GetHostAndPort());
                }
                this.log("Username...: " + string2);
                if (string3 != null && string3 != "") {
                    this.log("Password...: *****");
                }
                if (string4 != null && string4 != "") {
                    this.log("AuthMethod...: " + string4);
                }
                if (string5 != null && string5 != "") {
                    this.log("validateServerCertificate: " + string5);
                }
                if (vector.size() < 1) {
                    this.log(Translator.Error_in_connection_string_no_valid_hosts());
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts());
                }
                eXAConnection = new EXAConnection(vector, string2, string3, this.debug, parserResult.params);
            }
            return eXAConnection;
        }
        catch (SQLException sQLException) {
            this.log(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMajorVersion() {
        return EXADriver.getEXADriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return EXADriver.getEXADriverMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return EXAConnection.getDefaultProperties();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private void openLog(String string) {
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debug = new DebugLog(string, "utf8");
        }
        catch (IOException iOException) {
            System.err.println("Cannot create logfile in " + string);
            this.debug = null;
        }
    }

    protected static int getEXADriverMajorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MAJOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    protected static int getEXADriverMinorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MINOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static int getEXADriverVersionInc() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_INC_jdbc")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static String getEXADriverName() {
        return DRIVER_NAME;
    }

    public static String getCompilationInfo() {
        try {
            Class<?> clazz = Class.forName("com.exasol.jdbc.EXADriver");
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/timestamp");
            StringBuffer stringBuffer = new StringBuffer();
            int n = inputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            Pattern pattern = Pattern.compile("Revision:");
            String[] stringArray = pattern.split(stringBuffer.toString());
            if (stringArray.length > 1) {
                return stringArray[1].trim();
            }
            return Translator.No_info_available();
        }
        catch (Exception exception) {
            return Translator.No_info_available();
        }
    }

    private String GetNextWord(InputStream inputStream) throws IOException {
        String string = "";
        try {
            int n = inputStream.read();
            while (n != 44 && n != 58 && n != -1) {
                string = string + (char)n;
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals("")) {
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParserResult parseURL8(String string) throws SQLException {
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2 = TextUtil.split(";", string);
        String[] stringArray3 = TextUtil.split(":", stringArray2[0]);
        if (stringArray3 == null) {
            return null;
        }
        if (0 != stringArray3[0].compareToIgnoreCase("jdbc")) {
            return null;
        }
        if (!("exa".equals(stringArray3[1]) || "exa-debug".equals(stringArray3[1]) || "exa-worker".equals(stringArray3[1]) || "exa-worker-debug".equals(stringArray3[1]))) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 2; i < stringArray3.length; ++i) {
            if (stringArray3[i].contains("/")) {
                n2 = i;
                ++n3;
            }
            if (n3 <= 1 && stringArray3[i].chars().filter(n -> n == 47).count() <= 1L) continue;
            throw new SQLException("[ERROR] More than one fingerprint was provided.");
        }
        String[] stringArray4 = null;
        String string2 = null;
        if (n3 == 1) {
            stringArray4 = TextUtil.split("/", stringArray3[n2]);
        }
        if (stringArray4 != null && stringArray4.length == 2) {
            stringArray = TextUtil.split(",", stringArray4[1]);
            string2 = stringArray.length > 1 ? (stringArray[0].contains(":") ? stringArray[0].substring(0, stringArray[0].indexOf(":")) : stringArray[0]) : (stringArray[0].contains(":") ? stringArray[0].substring(0, stringArray[0].indexOf(":")) : stringArray[0].substring(0));
            if (string2.length() == 0) {
                string2 = null;
                stringArray3[n2] = stringArray4[0] + stringArray4[1];
            } else {
                stringArray3[n2] = stringArray4[0] + stringArray4[1].replaceAll(string2, "");
            }
            if (string.contains("/" + string2)) {
                string = string.replace("/" + string2, "");
            }
        } else if (stringArray4 != null && stringArray4.length > 0) {
            stringArray3[n2] = stringArray4[0];
        }
        stringArray = new ParserResult();
        stringArray.params.setProperty("url", string);
        if (System.getProperty("com.exasol.jdbc.debug") != null && System.getProperty("com.exasol.jdbc.debug").equalsIgnoreCase("true") || "exa-debug".equals(stringArray3[1]) || "exa-worker-debug".equals(stringArray3[1])) {
            stringArray.params.setProperty("debug", "1");
        }
        if ("exa-worker".equals(stringArray3[1]) || "exa-worker-debug".equals(stringArray3[1])) {
            stringArray.params.setProperty("worker", "1");
        }
        if (stringArray3.length < 3) {
            throw new SQLException(Translator.Error_reading_the_hosts_form_cluster_string());
        }
        String string3 = "";
        if (stringArray3[2].startsWith("//")) {
            void var13_19;
            void var13_17;
            object2 = stringArray3[2].toCharArray();
            char[] cArray = new char[((Object)object2).length - 2];
            int n4 = 2;
            while (var13_17 < ((Object)object2).length) {
                cArray[var13_17 - 2] = (char)object2[var13_17];
                ++var13_17;
            }
            stringArray3[2] = new String(cArray);
            String string4 = "";
            for (int i = 2; i < stringArray3.length; ++i) {
                String string5 = (String)var13_19 + stringArray3[i];
            }
            try {
                File file = new File((String)var13_19);
                file.canRead();
                FileInputStream fileInputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                void var13_22;
                if (1 != stringArray3[2].length()) throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + (String)var13_19 + ". " + iOException.toString());
                String string6 = "";
                stringArray3[2] = stringArray3[2] + ":";
                for (int i = 2; i < stringArray3.length; ++i) {
                    String string7 = (String)var13_22 + stringArray3[i];
                }
                try {
                    File file = new File((String)var13_22);
                    file.canRead();
                    FileInputStream fileInputStream = new FileInputStream(file);
                }
                catch (IOException iOException2) {
                    throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + (String)var13_22 + ". " + iOException2.toString());
                }
            }
        } else {
            object2 = "";
            for (int i = 2; i < stringArray3.length; ++i) {
                object2 = (String)object2 + stringArray3[i];
                if (i >= stringArray3.length - 1) continue;
                object2 = (String)object2 + ":";
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object2).getBytes());
        }
        int n5 = 0;
        try {
            void var10_37;
            int n6;
            while (-1 != (n6 = var10_37.read())) {
                if (n6 == 0 || n6 == 10 || n6 == 13 || n6 == 32) continue;
                if (!(n6 == 58 || n6 == 44 || n6 == 46 || n6 == 45 || n6 >= 97 && n6 <= 122 || n6 >= 65 && n6 <= 90 || n6 >= 48 && n6 <= 57 || n6 == 95) && n6 > 32) throw new SQLException(Translator.Invalid_character_in_cluster_string());
                if (n5 == 46 && n6 == 46) {
                    string3 = string3 + '#';
                    n5 = 0;
                    continue;
                }
                if (n5 == 46 && n6 != 46) {
                    if (n6 <= 32) {
                        string3 = string3 + (char)n5;
                    } else {
                        string3 = string3 + (char)n5;
                        string3 = string3 + (char)n6;
                    }
                } else if (n6 != 46 && n6 > 32) {
                    string3 = string3 + (char)n6;
                }
                n5 = n6;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(Translator.Error_interpreting_the_cluster_string() + iOException.toString());
        }
        String[] stringArray5 = TextUtil.split("#", string3);
        try {
            if (stringArray5.length > 1) {
                string3 = "";
                for (int i = 0; i < stringArray5.length - 1; ++i) {
                    int n7 = 1;
                    boolean bl = false;
                    String string8 = "";
                    object = "";
                    String string9 = "";
                    int n8 = 0;
                    int n9 = 0;
                    char c = '\u0000';
                    do {
                        if ((c = stringArray5[i].charAt(stringArray5[i].length() - n7)) < '0' || c > '9') continue;
                        object = (String)object + c;
                    } while (++n7 <= stringArray5[i].length() && c >= '0' && c <= '9');
                    if (((String)object).length() == 0) {
                        throw new SQLException(Translator.A_range_must_be_between_numbers());
                    }
                    byte[] byArray = ((String)object).getBytes();
                    object = "";
                    for (int j = byArray.length - 1; j >= 0; --j) {
                        object = (String)object + (char)byArray[j];
                    }
                    n8 = Integer.parseInt((String)object);
                    boolean bl2 = bl = 0 < ((String)object).length() - Integer.toString(n8).length();
                    while (n7 <= stringArray5[i].length() && c != ',' && c != ':') {
                        string8 = string8 + c;
                        c = stringArray5[i].charAt(stringArray5[i].length() - n7);
                        ++n7;
                    }
                    if (stringArray5[i].length() - n7 < 0) {
                        string8 = string8 + stringArray5[i].charAt(0);
                    } else if (string8.length() > 0 && c != ',' && c != ':' && c != '.') {
                        string8 = string8 + c;
                    }
                    byte[] byArray2 = string8.getBytes();
                    string8 = "";
                    if (byArray2.length > 0) {
                        for (int j = byArray2.length - 1; j >= 0; --j) {
                            string8 = string8 + (char)byArray2[j];
                        }
                    }
                    n7 = 0;
                    do {
                        if ((c = stringArray5[i + 1].charAt(n7)) < '0' || c > '9') continue;
                        string9 = string9 + c;
                    } while (++n7 < stringArray5[i + 1].length() && c >= '0' && c <= '9');
                    if (string9.length() == 0) {
                        throw new SQLException(Translator.A_range_must_be_between_numbers());
                    }
                    n9 = Integer.parseInt(string9);
                    string3 = string3 + stringArray5[i];
                    if (n8 > n9) {
                        throw new SQLException(Translator.A_range_must_begin_with_the_smaller_number());
                    }
                    String string10 = "";
                    if (n7 < stringArray5[i + 1].length()) {
                        while (n7 <= stringArray5[i + 1].length() && c != ',' && c != ':') {
                            string10 = string10 + c;
                            if (n7 < stringArray5[i + 1].length()) {
                                c = stringArray5[i + 1].charAt(n7);
                            }
                            ++n7;
                        }
                    }
                    string3 = string3 + string10;
                    if (n8 >= n9) continue;
                    for (n7 = n8 + 1; n7 < n9; ++n7) {
                        string3 = bl ? string3 + "," + string8 + this.FormatNumWithLeadingNulls(((String)object).length(), n7) + string10 : string3 + "," + string8 + n7 + string10;
                    }
                    string3 = string3 + "," + string8;
                }
                string3 = string3 + stringArray5[stringArray5.length - 1];
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(Translator.Error_parsing_a_range_in_the_cluster_string() + numberFormatException.toString());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        boolean bl = false;
        Vector vector = stringArray.clusterNodes;
        int n10 = 0;
        object = new Long(0L);
        try {
            String string11;
            while (null != (string11 = this.GetNextWord(byteArrayInputStream))) {
                boolean bl3 = true;
                try {
                    object = new Long(string11);
                }
                catch (NumberFormatException numberFormatException) {
                    bl3 = false;
                }
                if (bl3) {
                    if (bl) {
                        if (n10 == 0) {
                            throw new SQLException(Translator.A_port_was_that_cannot_be_assigned_to_any_host());
                        }
                        if (n10 > 1) {
                            throw new SQLException(Translator.Cartesian_product_hosts_ports_found());
                        }
                        if (vector.size() <= 0) throw new SQLException(Translator.A_port_was_that_cannot_be_assigned_to_any_host());
                        vector.add(new ClusterNode(((ClusterNode)vector.get(vector.size() - 1)).GetHost(), new Long(string11).intValue()));
                    } else {
                        for (int i = vector.size() - 1; i >= vector.size() - n10; --i) {
                            ((ClusterNode)vector.get(i)).SetPort(((Long)object).intValue());
                        }
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    n10 = 0;
                }
                vector.add(new ClusterNode(string11, 0));
                ++n10;
                bl = false;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(Translator.Error_reading_the_hosts_form_cluster_string() + iOException.toString());
        }
        if (string2 != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ((ClusterNode)vector.get(i)).setFingerprint(string2);
            }
        }
        for (int i = 1; i < stringArray2.length; ++i) {
            String[] stringArray6 = TextUtil.split("=", stringArray2[i]);
            if (stringArray6 == null || stringArray6.length != 2) {
                this.log("Cannot parse option: " + stringArray2[i]);
                throw new SQLException(Translator.Cannot_parse_option() + stringArray2[i] + " from URL: " + string);
            }
            stringArray.params.put(stringArray6[0], stringArray6[1]);
        }
        return stringArray;
    }

    private ParserResult expandDNSPool(ParserResult parserResult) {
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = (ClusterNode)parserResult.clusterNodes.get(i);
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(clusterNode.GetHost());
                if (inetAddressArray.length > 1) {
                    ParserResult parserResult3 = new ParserResult();
                    for (int j = 0; j < inetAddressArray.length; ++j) {
                        ClusterNode clusterNode2 = new ClusterNode(inetAddressArray[j].getHostAddress(), clusterNode.GetPort());
                        parserResult3.clusterNodes.add(clusterNode2);
                    }
                    ParserResult parserResult4 = this.sortNodesByHostAndPort(parserResult3);
                    int n = parserResult2.clusterNodes.size();
                    for (int j = 0; j < parserResult4.clusterNodes.size(); ++j) {
                        parserResult2.clusterNodes.add(parserResult4.clusterNodes.get(j));
                    }
                    continue;
                }
                parserResult2.clusterNodes.add(clusterNode);
                continue;
            }
            catch (Exception exception) {
                parserResult2.clusterNodes.add(clusterNode);
            }
        }
        return parserResult2;
    }

    private ParserResult sortNodesByHostAndPort(ParserResult parserResult) throws ConnectionException {
        Object[] objectArray = new String[parserResult.clusterNodes.size()];
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            objectArray[i] = ((ClusterNode)parserResult.clusterNodes.get(i)).GetHostAndPort();
        }
        Arrays.sort(objectArray);
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = new ClusterNode((String)objectArray[i]);
            parserResult2.clusterNodes.add(clusterNode);
        }
        return parserResult2;
    }

    private String FormatNumWithLeadingNulls(int n, int n2) {
        String string = "";
        for (int i = 0; i < n - Integer.toString(n2).length(); ++i) {
            string = string + "0";
        }
        string = string + Integer.toString(n2);
        return string;
    }

    private void log(Object object) {
        if (this.debug != null) {
            this.debug.log(object.toString());
        }
    }

    public static int getProtocolVersion() {
        return EXAConnection.getProtocolVersion();
    }

    public static String getVersionInfo() {
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MAJOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MINOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_INC_jdbc"));
            return stringBuffer.toString();
        }
        return Translator.No_info_available();
    }

    protected static void readVersionRC() {
        try {
            Pattern pattern = Pattern.compile("^\\s*versioninfo\\((.*),(.*)\\)\\s*$");
            Matcher matcher = null;
            ClassLoader classLoader = Class.forName("com.exasol.jdbc.EXADriver").getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/version.res");
            if (inputStream == null) {
                throw new Exception("File version.res missing.");
            }
            versionInfo = new HashMap();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                matcher = pattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    versionInfo.put(string2, TextUtil.stripQuotes(string3));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println("Error when reading file version number: " + exception.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new EXADriver());
            EXADriver.readVersionRC();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

