/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant;

import com.yworks.yguard.common.ShrinkBag;
import com.yworks.yguard.common.ant.AttributesSection;
import com.yworks.yguard.common.ant.EntryPointJar;
import com.yworks.yguard.common.ant.EntryPointsSection;
import com.yworks.yguard.common.ant.Exclude;
import com.yworks.yguard.common.ant.PatternMatchedSection;
import com.yworks.yguard.common.ant.TypePatternSet;
import com.yworks.yguard.common.ant.YGuardBaseTask;
import com.yworks.yguard.obf.Version;
import com.yworks.yshrink.YShrink;
import com.yworks.yshrink.ant.AntLogger;
import com.yworks.yshrink.ant.ClassSection;
import com.yworks.yshrink.ant.FieldSection;
import com.yworks.yshrink.ant.MethodSection;
import com.yworks.yshrink.ant.ResourceCpResolver;
import com.yworks.yshrink.ant.filters.AttributeFilter;
import com.yworks.yshrink.ant.filters.ClassFilter;
import com.yworks.yshrink.ant.filters.EntryPointFilters;
import com.yworks.yshrink.ant.filters.EntryPointJarFilter;
import com.yworks.yshrink.ant.filters.FieldFilter;
import com.yworks.yshrink.ant.filters.MethodFilter;
import com.yworks.yshrink.util.Logger;
import com.yworks.yshrink.util.XmlLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;

public class ShrinkTask
extends YGuardBaseTask {
    private File logFile = new File("yshrinklog.xml");
    private boolean createStubs = false;
    private String digests = "SHA-1,MD5";
    private EntryPointsSection entryPointsSection;

    public ShrinkTask() {
    }

    public ShrinkTask(boolean mode) {
        super(mode);
    }

    public void execute() throws BuildException {
        List<AttributesSection> attributesSections;
        this.getProject().log((Task)this, "yGuard Shrinker v" + Version.getVersion() + " - http://www.yworks.com/products/yguard", 2);
        super.execute();
        XmlLogger xmlLogger = new XmlLogger(this.getLogWriter());
        AntLogger antLogger = new AntLogger(this.getProject(), this);
        EntryPointFilters epfs = new EntryPointFilters();
        List<AttributesSection> list = attributesSections = this.entryPointsSection != null ? this.entryPointsSection.getAttributesSections() : this.attributesSections;
        if (this.entryPointsSection != null) {
            AttributesSection as;
            epfs.setExclude(this.entryPointsSection);
            List<MethodSection> methodSections = this.entryPointsSection.getMethodSections();
            List<FieldSection> fieldSections = this.entryPointsSection.getFieldSections();
            List<ClassSection> list2 = this.entryPointsSection.getClassSections();
            if (methodSections.size() > 0) {
                MethodFilter mf = new MethodFilter(this.getProject());
                for (MethodSection ms : methodSections) {
                    mf.addMethodSection(ms);
                }
                epfs.addEntryPointFilter(mf);
            }
            if (fieldSections.size() > 0) {
                FieldFilter ff = new FieldFilter(this.getProject());
                Iterator<PatternMatchedSection> iterator = fieldSections.iterator();
                while (iterator.hasNext()) {
                    FieldSection fs = (FieldSection)iterator.next();
                    ff.addFieldSection(fs);
                }
                epfs.addEntryPointFilter(ff);
            }
            if (list2.size() > 0) {
                ClassFilter cf = new ClassFilter(this.getProject());
                for (ClassSection cs : list2) {
                    cf.addClassSection(cs);
                }
                epfs.addEntryPointFilter(cf);
            }
            AttributeFilter attributeFilter = new AttributeFilter(this.getProject());
            if (this.entryPointsSection.isRiAnn()) {
                as = new AttributesSection();
                as.setName("RuntimeInvisibleAnnotations");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isRiPann()) {
                as = new AttributesSection();
                as.setName("RuntimeInvisibleParameterAnnotations");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isRvAnn()) {
                as = new AttributesSection();
                as.setName("RuntimeVisibleAnnotations");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isRvPann()) {
                as = new AttributesSection();
                as.setName("RuntimeVisibleParameterAnnotations");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isSource()) {
                as = new AttributesSection();
                as.setName("SourceFile");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isLtable()) {
                as = new AttributesSection();
                as.setName("LineNumberTable");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isLttable()) {
                as = new AttributesSection();
                as.setName("LocalVariableTypeTable");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isVtable()) {
                as = new AttributesSection();
                as.setName("LocalVariableTable");
                attributeFilter.addAttributesSection(as);
            }
            if (this.entryPointsSection.isDebugExtension()) {
                as = new AttributesSection();
                as.setName("SourceDebug");
                attributeFilter.addAttributesSection(as);
            }
            epfs.addEntryPointFilter(attributeFilter);
            ClassFilter classFilter = new ClassFilter(this.getProject());
            ClassSection classSection = new ClassSection();
            PatternSet patternSet = new PatternSet();
            patternSet.setIncludes("**/package-info");
            classSection.addPatternSet(patternSet, TypePatternSet.Type.NAME);
            classFilter.addClassSection(classSection);
            epfs.addEntryPointFilter(classFilter);
        }
        if (null != attributesSections && attributesSections.size() > 0) {
            AttributeFilter af = new AttributeFilter(this.getProject());
            for (AttributesSection attributesSection : attributesSections) {
                af.addAttributesSection(attributesSection);
            }
            epfs.addEntryPointFilter(af);
        }
        if (this.pairs == null) {
            throw new BuildException("no files to shrink");
        }
        boolean containsInOutPair = false;
        boolean containsEntryPointJar = false;
        for (ShrinkBag shrinkBag : this.pairs) {
            if (shrinkBag.isEntryPointJar()) {
                EntryPointJarFilter epjf = new EntryPointJarFilter((EntryPointJar)shrinkBag);
                epfs.addEntryPointFilter(epjf);
                containsEntryPointJar = true;
                continue;
            }
            containsInOutPair = true;
        }
        if (!containsInOutPair) {
            throw new BuildException("no files to shrink");
        }
        if (!containsEntryPointJar && null == this.entryPointsSection) {
            Logger.log("no entrypoints given - using class access public and protected on all inoutpairs.");
            this.entryPointsSection = new EntryPointsSection(this);
            ClassFilter classFilter = new ClassFilter(this.getProject());
            ClassSection cs = new ClassSection();
            cs.setAccess("protected");
            classFilter.addClassSection(cs);
            epfs.addEntryPointFilter(classFilter);
            epfs.setExclude(this.entryPointsSection);
        }
        ResourceCpResolver resolver = null;
        if (this.resourceClassPath != null) {
            resolver = new ResourceCpResolver(this.resourceClassPath, this);
        }
        if (this.properties.containsKey("digests")) {
            this.setDigests((String)this.properties.get("digests"));
        }
        YShrink yShrink = new YShrink(this.createStubs, this.digests);
        try {
            yShrink.doShrinkPairs(this.pairs, epfs, resolver);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage() != null) {
                Logger.err(runtimeException.getMessage(), runtimeException);
            }
            throw new BuildException("yShrink encountered an unknown problem!", (Throwable)runtimeException);
        }
        catch (Throwable throwable) {
            if (throwable.getMessage() != null) {
                Logger.err(throwable.getMessage(), throwable);
            } else {
                Logger.err(throwable.getClass().getName(), throwable);
            }
            throw new BuildException("yShrink encountered an unknown severe problem!", throwable);
        }
        finally {
            try {
                resolver.close();
            }
            catch (Exception exception) {}
            ((Logger)xmlLogger).close();
            ((Logger)antLogger).close();
        }
    }

    private PrintWriter getLogWriter() {
        PrintWriter log;
        block5: {
            log = null;
            if (this.logFile != null) {
                try {
                    if (this.logFile.getName().endsWith(".gz")) {
                        log = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.logFile)))));
                        break block5;
                    }
                    log = new PrintWriter(new BufferedWriter(new FileWriter(this.logFile)));
                }
                catch (IOException ioe) {
                    this.getProject().log((Task)this, "Could not create logfile: " + ioe, 0);
                    log = new PrintWriter(System.out);
                }
            } else {
                log = new PrintWriter(System.out);
            }
        }
        return log;
    }

    public boolean getCreateStubs() {
        return this.createStubs;
    }

    public void setCreateStubs(boolean createStubs) {
        this.createStubs = createStubs;
    }

    public String getDigests() {
        return this.digests;
    }

    public void setDigests(String digests) {
        this.digests = digests;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public EntryPointsSection createEntryPoints() {
        if (this.entryPointsSection != null) {
            throw new IllegalArgumentException("Only one entrypoints or expose element allowed!");
        }
        this.entryPointsSection = new EntryPointsSection(this);
        return this.entryPointsSection;
    }

    public void setEntryPointsExternally(EntryPointsSection eps) {
        this.entryPointsSection = eps;
    }

    public EntryPointsSection createExpose() {
        return this.createEntryPoints();
    }

    @Override
    public Exclude createKeep() {
        return this.createExpose();
    }

    @Override
    public void addAttributesSections(List<AttributesSection> attributesSections) {
        if (null != this.entryPointsSection) {
            for (AttributesSection attributesSection : attributesSections) {
                this.entryPointsSection.addConfiguredAttribute(attributesSection);
            }
        } else if (null != this.attributesSections) {
            this.attributesSections.addAll(attributesSections);
        } else {
            this.attributesSections = attributesSections;
        }
    }

    public void addConfiguredEntrypointjar(EntryPointJar entrypointjar) {
        if (this.pairs == null) {
            this.pairs = new ArrayList();
        }
        this.pairs.add(entrypointjar);
    }
}

