/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ClassCpInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.CpInfo;
import com.yworks.yguard.obf.classfile.NameAndTypeCpInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class RefCpInfo
extends CpInfo {
    private int u2classIndex;
    private int u2nameAndTypeIndex;

    protected RefCpInfo(int tag) {
        super(tag);
    }

    protected int getClassIndex() {
        return this.u2classIndex;
    }

    protected int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    protected void setNameAndTypeIndex(int index) {
        this.u2nameAndTypeIndex = index;
    }

    @Override
    protected void markNTRefs(ConstantPool pool) {
        pool.incRefCount(this.u2nameAndTypeIndex);
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2classIndex = din.readUnsignedShort();
        this.u2nameAndTypeIndex = din.readUnsignedShort();
    }

    @Override
    protected void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2classIndex);
        dout.writeShort(this.u2nameAndTypeIndex);
    }

    @Override
    public void dump(PrintWriter pw, ClassFile cf, int index) {
        pw.println("  Ref " + Integer.toString(index) + ": " + ((Utf8CpInfo)cf.getCpEntry(((ClassCpInfo)cf.getCpEntry(this.u2classIndex)).getNameIndex())).getString() + " " + ((Utf8CpInfo)cf.getCpEntry(((NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex)).getNameIndex())).getString() + " " + ((Utf8CpInfo)cf.getCpEntry(((NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex)).getDescriptorIndex())).getString());
    }
}

