-- Copyright (c) DbVis Software AB. All Rights Reserved.
CREATE OR REPLACE PROCEDURE SAKILA.CUSTOMER_REPORT 
    ()
BEGIN
    DECLARE line VARCHAR(256);
    FOR v1 
AS 
    c1 CURSOR FOR
    SELECT
        cu.customer_id                             AS ID,
        cu.first_name||' '||cu.last_name           AS name,
        a.address                                  AS address,
        a.postal_code                              AS zip_code,
        a.phone                                    AS phone,
        city.city                                  AS city,
        country.country                            AS country
    FROM 
        customer cu
    JOIN
        address a
    ON
        cu.address_id = a.address_id
    JOIN
        city
    ON
        a.city_id = city.city_id
    JOIN
        country
    ON
        city.country_id = country.country_id
    WHERE 
        cu.active = 1
    ORDER BY 
        name DO SET line = name || ': ' || address || ', ' || zip_code || ' ' || city || ', ' || country;
     
    CALL DBMS_OUTPUT.PUT_LINE(line);
END FOR;
END 
/

@call SAKILA.CUSTOMER_REPORT();
