/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.optionsProcessing;

import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.GeneratePureQueryXml;
import com.ibm.db2.cmx.tools.ManageRepository;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.PrintWriter;
import java.util.EnumMap;

public enum Help {
    ARGS("-help", "-h", "-?");

    private final String[] a;
    private static final String usageInitialBeginning;
    private static final String usageAlternateBeginning;
    private static final String javaCommand = "java ";
    private static final String indentForLongVersionUsageDescription = "    ";
    private static final String indentForLongVersionHelpMessage = "        ";
    private static final String indentForCommand = "           ";
    private static final String indentForShortVersionUsageDescription = "               ";
    private static final PrintWriter defaultPrintWriter_;
    private static final EnumMap<Tool, String> commandLineCommand;

    private Help(String ... stringArray) {
        this.a = stringArray;
    }

    public String defaultArgumentName() {
        return this.a[0];
    }

    public boolean isHelpRequest(String string) {
        for (int i10 = 0; i10 < this.a.length; ++i10) {
            if (!this.a[i10].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String usageDescription() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i10 = 0; i10 < this.a.length - 1; ++i10) {
            stringBuffer.append(this.a[i10] + " | ");
        }
        stringBuffer.append(this.a[this.a.length - 1] + "]");
        return stringBuffer.toString();
    }

    public static void displayHelp(Tool tool, PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = defaultPrintWriter_;
        }
        printWriter.println();
        printWriter.println(usageInitialBeginning + "  " + commandLineCommand.get((Object)tool));
        if (Tool.DATA_VERSION == tool) {
            for (DataVersion.DataVersionPossibleArgs object : DataVersion.DataVersionPossibleArgs.values()) {
                printWriter.print(Help.helpOptionDescriptionShortVersion(object.usageDescription()));
            }
        } else {
            for (PossibleArgs possibleArgs : PossibleArgs.getValues(tool)) {
                if (!possibleArgs.documentInHelp(tool)) continue;
                printWriter.print(Help.helpOptionDescriptionShortVersion(possibleArgs.usageDescription(tool)));
            }
        }
        printWriter.println(usageAlternateBeginning + "  " + commandLineCommand.get((Object)tool));
        printWriter.println(Messages.getMultiLine(ARGS.usageDescription(), indentForShortVersionUsageDescription, null, true));
        printWriter.println();
        printWriter.println(Messages.getText("MSG_OPT_ARE", new Object[0]));
        if (Tool.DATA_VERSION == tool) {
            for (DataVersion.DataVersionPossibleArgs dataVersionPossibleArgs : DataVersion.DataVersionPossibleArgs.values()) {
                printWriter.print(Help.helpOptionDescriptionFullVersion(dataVersionPossibleArgs.usageDescription(), dataVersionPossibleArgs.helpMessage()));
            }
        } else {
            for (PossibleArgs possibleArgs : PossibleArgs.getValues(tool)) {
                if (!possibleArgs.documentInHelp(tool)) continue;
                printWriter.print(Help.helpOptionDescriptionFullVersion(possibleArgs.usageDescription(tool), possibleArgs.helpMessage(tool)));
            }
        }
        printWriter.println(Messages.getMultiLine(ARGS.usageDescription(), indentForLongVersionUsageDescription, null, true));
        printWriter.println(Messages.getMultiLine(Messages.getText("MSG_DISP_USAGE", new Object[0]), indentForLongVersionHelpMessage, null, true));
        printWriter.println();
        if (Tool.MANAGE_REPOSITORY == tool) {
            printWriter.println(Messages.getMultiLine(Messages.getText("MSG_DATA_MANAGEMENT_INFO_CENTER_HELP", new Object[0]), "", null, true));
        }
    }

    private static String helpOptionDescriptionShortVersion(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentForShortVersionUsageDescription).append(string).append('\n');
        return stringBuilder.toString();
    }

    private static String helpOptionDescriptionFullVersion(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentForLongVersionUsageDescription).append(string).append('\n');
        stringBuilder.append(Messages.getMultiLine(string2, indentForLongVersionHelpMessage, null, true) + "\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    static {
        usageInitialBeginning = Messages.getText("MSG_USAGE2", new Object[0]);
        usageAlternateBeginning = Messages.getText("MSG_OR", new Object[0]);
        defaultPrintWriter_ = new PrintWriter(System.out, true);
        commandLineCommand = new EnumMap(Tool.class);
        commandLineCommand.put(Tool.GENERATOR, "java org.eclipse.core.launcher.Main\n           -application com.ibm.db2.cmx.tools.Generator");
        commandLineCommand.put(Tool.BINDER, "java com.ibm.db2.cmx.tools.StaticBinder");
        commandLineCommand.put(Tool.CONFIGURE, "java com.ibm.db2.cmx.tools.Configure");
        commandLineCommand.put(Tool.METADATAREPLACER, "java com.ibm.db2.cmx.tools.MetaDataReplacer");
        commandLineCommand.put(Tool.DATA_VERSION, "java com.ibm.db2.cmx.tools.DataVersion");
        commandLineCommand.put(Tool.MERGE, "java com.ibm.db2.cmx.tools.Merge");
        commandLineCommand.put(Tool.VALIDATOR, "java com.ibm.db2.cmx.tools.SchemaValidator");
        commandLineCommand.put(Tool.MANAGE_REPOSITORY, javaCommand + ManageRepository.class.getCanonicalName());
        commandLineCommand.put(Tool.GENERATE_PUREQUERYXML, javaCommand + GeneratePureQueryXml.class.getCanonicalName());
    }
}

