/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AccessRuleViolation;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DependencyException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.InvalidSessionID;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.PolicyException;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.QueueServerException;
import com.exasol.jdbc.RollbackException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLSyntaxErrorException;

public abstract class ExceptionFactory {
    public static SQLException createSQLException(EXASQLException eXASQLException, EXAConnection eXAConnection) {
        return ExceptionFactory.createSQLException(eXASQLException.getMessage(), eXASQLException.getSQLCode(), eXAConnection);
    }

    public static SQLException mergeSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return new SQLException(sQLException.toString() + "; " + sQLException2.getSQLState() + " " + sQLException2.toString(), sQLException.getSQLState());
    }

    public static SQLException createSQLException(String string, String string2, EXAConnection eXAConnection) {
        if (string2.startsWith("22")) {
            return new SQLDataException(string, string2);
        }
        if (string2.startsWith("27") || string.toLowerCase().contains("constraint violation")) {
            return new SQLIntegrityConstraintViolationException(string, string2);
        }
        if (string.toLowerCase().contains("syntax error")) {
            return new SQLSyntaxErrorException(string, string2);
        }
        if (string2.startsWith("08")) {
            if ("08003".equals(string2)) {
                return new InvalidSessionID(string);
            }
            if ("08004".equals(string2)) {
                return new SQLInvalidAuthorizationSpecException(string, string2);
            }
            if ("08X00".equals(string2)) {
                return new SQLInvalidAuthorizationSpecException(string, string2);
            }
            if ("08005".equals(string2)) {
                return new ConnectRefused(string);
            }
            if ("08006".equalsIgnoreCase(string2)) {
                return new ConnectionLost(string, eXAConnection.getSessionID());
            }
            if ("08007".equals(string2)) {
                return new ProtocolException(string);
            }
            return new ConnectionException(string, string2);
        }
        if (string2.startsWith("42P")) {
            if ("42P01".equals(string2)) {
                return new PolicyException(string);
            }
            if ("42P02".equals(string2)) {
                return new DependencyException(string);
            }
            return new QueueServerException(string, string2);
        }
        if (string2.startsWith("425")) {
            return new AccessRuleViolation(string, string2);
        }
        if (string2.startsWith("X0")) {
            return new LoaderException(string, string2);
        }
        if (string2.startsWith("02")) {
            return new NoResultException(string, string2);
        }
        if (string2.startsWith("400")) {
            if ("40001".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40002".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40003".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40004".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40005".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40007".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40008".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40009".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40010".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40011".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40017".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40018".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40019".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40020".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40021".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40022".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40021".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40022".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("00000".equals(string2) && eXAConnection.isWorkerConnection()) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40023".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40024".equals(string2)) {
                return new ConnectionLost(string, string2, eXAConnection.getSessionID());
            }
            if ("40025".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40026".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40027".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40028".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40029".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40030".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40031".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40032".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("40033".equals(string2)) {
                return new RollbackException(string, string2);
            }
            if ("R0007".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0008".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0009".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0010".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0011".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0012".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0013".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0014".equals(string2)) {
                return new SQLException(string, string2);
            }
            if ("R0033".equals(string2)) {
                return new SQLException(string, string2);
            }
        }
        return new SQLException(string, string2);
    }
}

