/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.dbinfo.drivertype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.db.dbinfo.drivertype.DriverTypePropertyChoice;
import com.onseven.dbvis.db.dbinfo.n;
import com.onseven.dbvis.eb.b;
import com.onseven.dbvis.util.d.c.c;
import com.onseven.dbvis.util.d.c.e;
import com.onseven.dbvis.util.d.c.f;
import java.security.GeneralSecurityException;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DriverTypeProperty
implements n {
    private static final Logger LOG = Logger.getLogger(DriverTypeProperty.class.getName());
    @JacksonXmlProperty(localName="key", isAttribute=true)
    private String key;
    @JacksonXmlProperty(localName="label", isAttribute=true)
    private String label;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="description")
    private String description;
    @JacksonXmlProperty(localName="showAsOptionIf", isAttribute=true)
    private String showAsOptionIf;
    @JacksonXmlElementWrapper(localName="Choices")
    @JacksonXmlProperty(localName="Choice")
    private List<DriverTypePropertyChoice> choices = new ArrayList<DriverTypePropertyChoice>();
    @JacksonXmlProperty(localName="isUserDefined", isAttribute=true)
    private boolean isUserDefined = false;
    @JacksonXmlProperty(localName="required", isAttribute=true)
    private boolean required = false;
    @JacksonXmlProperty(localName="isPassword", isAttribute=true)
    private Boolean isPassword = false;
    @JacksonXmlProperty(localName="belongsToWizardUrl", isAttribute=true)
    private String belongsToWizardUrl;
    @JacksonXmlProperty(localName="category", isAttribute=true)
    private String category;
    @JsonIgnore
    private boolean isValueChanged = false;
    @JsonProperty(value="driverDefault")
    private String driverDefault;
    @JsonIgnore
    private boolean driverValueExisted = false;
    @JsonIgnore
    private String templateDefault;
    @JsonIgnore
    private boolean templateValueExisted = false;
    @JsonIgnore
    private boolean userDriverValueExisted = false;
    @JsonIgnore
    private String userDriverDefault;
    @JsonIgnore
    private _b origin = _b.e;

    public DriverTypeProperty(DriverTypeProperty driverTypeProperty) {
        this.key = driverTypeProperty.key;
        this.label = driverTypeProperty.label;
        this.value = driverTypeProperty.value;
        this.description = driverTypeProperty.description;
        this.driverDefault = driverTypeProperty.driverDefault;
        this.templateDefault = driverTypeProperty.templateDefault;
        this.showAsOptionIf = driverTypeProperty.showAsOptionIf;
        if (driverTypeProperty.getChoices() != null && driverTypeProperty.getChoices().size() > 0) {
            for (DriverTypePropertyChoice driverTypePropertyChoice : driverTypeProperty.getChoices()) {
                this.choices.add(new DriverTypePropertyChoice(driverTypePropertyChoice));
            }
        }
        this.isUserDefined = driverTypeProperty.isUserDefined;
        this.isValueChanged = false;
        this.origin = driverTypeProperty.origin;
        this.required = driverTypeProperty.required;
        this.driverValueExisted = driverTypeProperty.driverValueExisted;
        this.templateValueExisted = driverTypeProperty.templateValueExisted;
        this.userDriverValueExisted = driverTypeProperty.userDriverValueExisted;
        this.userDriverDefault = driverTypeProperty.userDriverDefault;
        this.isPassword = driverTypeProperty.isPassword;
        this.belongsToWizardUrl = driverTypeProperty.belongsToWizardUrl;
        this.category = driverTypeProperty.category;
    }

    public DriverTypeProperty(DriverPropertyInfo driverPropertyInfo) {
        this.key = driverPropertyInfo.name;
        this.value = driverPropertyInfo.value;
        this.label = driverPropertyInfo.name;
        this.description = driverPropertyInfo.description;
        this.required = driverPropertyInfo.required;
        this.isValueChanged = false;
        if (driverPropertyInfo.choices != null) {
            for (String string : driverPropertyInfo.choices) {
                this.choices.add(new DriverTypePropertyChoice(string, null, false));
            }
        }
        this.driverDefault = driverPropertyInfo.value;
        this.required = driverPropertyInfo.required;
        this.isPassword = false;
        this.belongsToWizardUrl = null;
        this.showAsOptionIf = null;
        this.category = null;
        this.origin = _b.d;
        this.driverValueExisted = true;
    }

    public static DriverTypeProperty newUserDefinedForDriver(String string, String string2, String string3) {
        DriverTypeProperty driverTypeProperty = DriverTypeProperty.newUserDefined(string, string2, string3);
        driverTypeProperty.setOrigin(_b.e);
        driverTypeProperty.setUserDriverValueExisted(true);
        driverTypeProperty.setUserDriverDefault(string2);
        return driverTypeProperty;
    }

    public static DriverTypeProperty newUserDefinedForConnection(String string, String string2, String string3) {
        DriverTypeProperty driverTypeProperty = DriverTypeProperty.newUserDefined(string, string2, string3);
        driverTypeProperty.setOrigin(_b.f);
        return driverTypeProperty;
    }

    private static DriverTypeProperty newUserDefined(String string, String string2, String string3) {
        DriverTypeProperty driverTypeProperty = new DriverTypeProperty();
        driverTypeProperty.setKey(string);
        driverTypeProperty.setTheValueRaw(string2);
        driverTypeProperty.setUserDefined(true);
        driverTypeProperty.setDescription(string3);
        driverTypeProperty.setUserDefined(true);
        driverTypeProperty.setIsPassword(false);
        return driverTypeProperty;
    }

    @JsonCreator
    public DriverTypeProperty() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDriverDefault() {
        return this.driverDefault;
    }

    public void setDriverDefault(String string) {
        this.driverDefault = string;
    }

    public String getDefaultValue() {
        return this.value != null ? this.value : this.driverDefault;
    }

    public String getDisplayValue() {
        if (this.isPassword()) {
            return this.value != null ? "***" : "";
        }
        return this.value != null ? this.value : this.driverDefault;
    }

    public boolean shouldValueBeInConnect() {
        if (this.choices != null && this.value != null) {
            for (DriverTypePropertyChoice driverTypePropertyChoice : this.choices) {
                if (!Objects.equals(driverTypePropertyChoice.getValue(), this.value) || !driverTypePropertyChoice.isNotSet()) continue;
                return false;
            }
        }
        return true;
    }

    @JsonIgnore
    public boolean isPassword() {
        if (this.isPassword == null) {
            return false;
        }
        return this.isPassword;
    }

    public void setIsPassword(boolean bl) {
        this.isPassword = bl;
    }

    public String getShowAsOptionIf() {
        if (this.showAsOptionIf == null) {
            return "false";
        }
        return this.showAsOptionIf;
    }

    @JsonGetter(value="showAsOptionIf")
    public String getShowAsOptionIfRaw() {
        return this.showAsOptionIf;
    }

    public void setShowAsOptionIf(String string) {
        this.showAsOptionIf = string;
    }

    public String getBelongsToWizardUrl() {
        return this.belongsToWizardUrl;
    }

    public void setBelongsToWizardUrl(String string) {
        this.belongsToWizardUrl = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public List<DriverTypePropertyChoice> getChoices() {
        return this.choices;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setChoices(List<DriverTypePropertyChoice> list) {
        this.choices = list;
    }

    public String getValue() {
        return this.value;
    }

    public void setTheValueRaw(String string) {
        this.value = string;
    }

    @JsonSetter(value="value")
    public void setFromDeserialize(String string) {
        this.value = this.isPassword != false && string != null ? this.decryptWithStaticPassword(string) : string;
    }

    @JsonGetter(value="value")
    public String getToSerialize() {
        if (this.isPassword.booleanValue() && this.value != null) {
            return this.encryptWithStaticPassword(this.value);
        }
        return this.value;
    }

    @JsonIgnore
    public boolean isUserEdited(boolean bl) {
        if (bl) {
            return this.getOrigin() == _b.f;
        }
        return this.getOrigin() == _b.e;
    }

    @JsonIgnore
    public boolean isUserDefined(boolean bl) {
        if (bl) {
            return this.isUserDefined && !this.userDriverValueExisted;
        }
        return this.isUserDefined && this.origin == _b.e;
    }

    public void setValue(String string) {
        this.setValue(string, false);
    }

    public void setValue(String string, boolean bl) {
        boolean bl2;
        if (this.isPassword()) {
            String string2 = string != null ? string : "";
            try {
                b b2 = e.c();
                if (e.b(b2)) {
                    string = e.b(string2, b2);
                }
            }
            catch (c c2) {
                return;
            }
        }
        boolean bl3 = this.showAsOptionIf != null && Boolean.valueOf(this.showAsOptionIf) != false;
        boolean bl4 = bl2 = Objects.equals(string, this.getDriverDefault()) && !bl3;
        if (bl2) {
            this.revertValue();
        } else if (string != null || !bl) {
            this.origin = bl ? _b.f : _b.e;
            this.isValueChanged = true;
            this.value = string;
        }
    }

    @JsonIgnore
    public boolean isValueChanged() {
        return this.isValueChanged;
    }

    public void revertValue() {
        if (this.userDriverValueExisted) {
            this.value = this.userDriverDefault;
            this.origin = _b.e;
            this.isValueChanged = !this.isValueChanged;
        } else if (this.templateValueExisted) {
            this.value = this.templateDefault;
            this.origin = _b.b;
            this.isValueChanged = !this.isValueChanged;
        } else if (this.driverValueExisted) {
            this.value = this.driverDefault;
            this.origin = _b.d;
            this.isValueChanged = !this.isValueChanged;
        }
    }

    @JsonIgnore
    public boolean isSameAsAnyDefault() {
        return this.driverValueExisted && Objects.equals(this.driverDefault, this.value) || this.templateValueExisted && Objects.equals(this.templateDefault, this.value);
    }

    public _b getOrigin() {
        return this.origin;
    }

    public void setOrigin(_b _b2) {
        this.origin = _b2;
    }

    public String getTemplateDefault() {
        return this.templateDefault;
    }

    public void setTemplateDefault(String string) {
        this.templateDefault = string;
    }

    @JsonIgnore
    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public void setUserDefined(boolean bl) {
        this.isUserDefined = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean driverValueExisted() {
        return this.driverValueExisted;
    }

    public void setDriverValueExisted(boolean bl) {
        this.driverValueExisted = bl;
    }

    public boolean templateValueExisted() {
        return this.templateValueExisted;
    }

    public void setTemplateValueExisted(boolean bl) {
        this.templateValueExisted = bl;
    }

    public boolean isUserDriverValueExisted() {
        return this.userDriverValueExisted;
    }

    public void setUserDriverValueExisted(boolean bl) {
        this.userDriverValueExisted = bl;
    }

    public void setUserDriverDefault(String string) {
        this.userDriverDefault = string;
    }

    @Override
    public boolean areSame(Object object) {
        boolean bl;
        if (!(object instanceof DriverTypeProperty)) {
            return false;
        }
        DriverTypeProperty driverTypeProperty = (DriverTypeProperty)object;
        if (this == driverTypeProperty) {
            return true;
        }
        boolean bl2 = bl = Objects.equals(this.showAsOptionIf, driverTypeProperty.showAsOptionIf) && Objects.equals(this.key, driverTypeProperty.key) && Objects.equals(this.label, driverTypeProperty.label) && Objects.equals(this.value, driverTypeProperty.value) && this.required == driverTypeProperty.required && Objects.equals(this.description, driverTypeProperty.description) && Objects.equals(this.isUserDefined, driverTypeProperty.isUserDefined) && Objects.equals(this.isPassword, driverTypeProperty.isPassword) && Objects.equals(this.category, driverTypeProperty.category) && Objects.equals(this.belongsToWizardUrl, driverTypeProperty.belongsToWizardUrl);
        if (bl) {
            if (this.choices == null && driverTypeProperty.choices == null) {
                return true;
            }
            if (this.choices == null || driverTypeProperty.choices == null) {
                return false;
            }
            if (this.choices != null && this.choices.size() != driverTypeProperty.choices.size()) {
                return false;
            }
            int n2 = 0;
            for (DriverTypePropertyChoice driverTypePropertyChoice : this.choices) {
                if (!driverTypePropertyChoice.areSame(driverTypeProperty.choices.get(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getKey() + " " + (Object)((Object)this.getOrigin()) + " value=" + this.getValue() + " userProp=" + this.isValueChanged + " userDef:" + this.isUserDefined + " isPassword=" + this.isPassword + " belongsToWizardUrl=" + this.belongsToWizardUrl + " category=" + this.category;
    }

    private String encryptWithStaticPassword(String string) {
        String string2 = string;
        try {
            string2 = f.b(string);
            if (string2 != null) {
                string2 = string == null || "".equals(string) ? "" : string2;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.log(Level.WARNING, "Error during encrypt of password for variable: " + this.key, generalSecurityException);
        }
        return string2;
    }

    private String decryptWithStaticPassword(String string) {
        String string2 = string;
        try {
            String string3 = f.c(string);
            if (string3 != null) {
                string2 = string3;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return string2;
    }

    public static enum _b {
        d,
        b,
        e,
        f;

    }
}

