/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.tooltip.C;
import com.jidesoft.tooltip.E;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public abstract class ExpandedTip<S extends JComponent> {
    public static final String CLIENT_PROPERTY_EXPANDED_TIP = "ExpandedTip";
    protected final S _component;
    private final B \u0107;
    private final B \u0103;
    private E \u0106;
    private E \u0101;
    private int \u0105 = -1;
    private Rectangle \u0102;
    private BufferedImage \u0109;
    private BufferedImage \u0104;
    private A \u0108;

    protected ExpandedTip(S s2) {
        this._component = s2;
        this.\u0107 = new B(true);
        this.\u0103 = new B(false);
        this.\u0108 = new A();
        ((Component)this._component).addMouseListener(this.\u0108);
        ((Component)this._component).addMouseMotionListener(this.\u0108);
        ((Component)this._component).addFocusListener(this.\u0108);
        ((Component)this._component).addComponentListener(this.\u0108);
        ((Component)this._component).addHierarchyBoundsListener(this.\u0108);
        ((Component)this._component).addHierarchyListener(this.\u0108);
        this.\u0101((JComponent)this._component, this);
    }

    public static ExpandedTip getExpandedTip(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_EXPANDED_TIP);
        if (object instanceof ExpandedTip) {
            return (ExpandedTip)object;
        }
        return null;
    }

    public void uninstall() {
        if (this.\u0108 != null) {
            ((Component)this._component).removeMouseListener(this.\u0108);
            ((Component)this._component).removeMouseMotionListener(this.\u0108);
            ((Component)this._component).removeFocusListener(this.\u0108);
            ((Component)this._component).removeComponentListener(this.\u0108);
            ((Component)this._component).removeHierarchyBoundsListener(this.\u0108);
            ((Component)this._component).removeHierarchyListener(this.\u0108);
            ((JComponent)this._component).putClientProperty(CLIENT_PROPERTY_EXPANDED_TIP, null);
        }
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.\u0105, true);
    }

    private void \u0101(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent, true);
    }

    private void \u0101(MouseEvent mouseEvent, boolean bl) {
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        if (bl || !JideSwingUtilities.equals(this.\u0105, n2)) {
            this.handleSelectionChange(n2, true);
        }
    }

    protected void handleSelectionChange(int n2) {
        this.handleSelectionChange(n2, false);
    }

    protected void handleSelectionChange(int n2, boolean bl) {
        this.\u0101(n2, bl);
    }

    void \u0101(int n2, boolean bl) {
        if (n2 == -1 || !((Component)this._component).isShowing() || !((Component)this._component).isFocusOwner() && !bl) {
            this.hideTip();
            return;
        }
        if (!JideSwingUtilities.equals(this.\u0105, n2)) {
            this.hideTip();
        }
        this.\u0105 = n2;
        this.showTip();
    }

    void \u0101(int n2) {
        this.\u0105 = n2;
    }

    public void showTip() {
        Point point = this.createToolTipImage(this.\u0105, true);
        Point point2 = this.createToolTipImage(this.\u0105, false);
        if (point == null && point2 == null) {
            this.hideTip();
        } else {
            if (point != null && this.\u0106 == null) {
                this.\u0103(point);
            } else if (point != null) {
                this.\u0101(point);
            }
            if (point2 != null && this.\u0101 == null) {
                this.\u0102(point2);
            } else if (point2 != null) {
                this.\u0104(point2);
            }
        }
    }

    public void hideTip() {
        if (this.\u0106 != null) {
            this.\u0106.\u0102();
            this.\u0106 = null;
            this.\u0101();
        }
        if (this.\u0101 != null) {
            this.\u0101.\u0102();
            this.\u0101 = null;
            this.\u0101();
        }
        this.\u0105 = -1;
    }

    private void \u0103(Point point) {
        if (this.\u0109 == null) {
            this.createToolTipImage(this.\u0105, true);
        }
        if (!((Component)this._component).isShowing()) {
            return;
        }
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray.length > 0) {
            return;
        }
        if (this.\u0109 != null) {
            this.\u0106 = new C(this.\u0107, false){

                @Override
                protected void \u0101(JWindow jWindow) {
                    ExpandedTip.this.setWindowShape(jWindow, true);
                }
            };
            this.\u0106.\u0101((JComponent)this._component, point.x, point.y, (JComponent)this._component);
        }
        this.\u0101();
    }

    private void \u0102(Point point) {
        if (this.\u0104 == null) {
            this.createToolTipImage(this.\u0105, false);
        }
        if (!((Component)this._component).isShowing()) {
            return;
        }
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray.length > 0) {
            return;
        }
        if (this.\u0104 != null) {
            this.\u0101 = new C(this.\u0103, false){

                @Override
                protected void \u0101(JWindow jWindow) {
                    ExpandedTip.this.setWindowShape(jWindow, false);
                }
            };
            this.\u0101.\u0101((JComponent)this._component, point.x, point.y, (JComponent)this._component);
        }
        this.\u0101();
    }

    protected void setWindowShape(JWindow jWindow, boolean bl) {
        if (this._component instanceof NavigationComponent) {
            try {
                GeneralPath generalPath = new GeneralPath();
                if (bl) {
                    generalPath.moveTo(0.0f, 0.0f);
                    generalPath.lineTo(jWindow.getWidth() - 2, 0.0f);
                    generalPath.quadTo(jWindow.getWidth() - 1, 1.0f, jWindow.getWidth(), 2.0f);
                    generalPath.lineTo(jWindow.getWidth(), jWindow.getHeight() - 2);
                    generalPath.quadTo(jWindow.getWidth() - 1, jWindow.getHeight() - 1, jWindow.getWidth() - 2, jWindow.getHeight());
                    generalPath.lineTo(0.0f, jWindow.getHeight());
                } else {
                    generalPath.moveTo(jWindow.getWidth(), 0.0f);
                    generalPath.lineTo(jWindow.getWidth(), jWindow.getHeight());
                    generalPath.lineTo(1.0f, jWindow.getHeight());
                    generalPath.quadTo(1.0f, jWindow.getHeight() - 1, 0.0f, jWindow.getHeight() - 2);
                    generalPath.lineTo(0.0f, 2.0f);
                    generalPath.quadTo(1.0f, 1.0f, 2.0f, 0.0f);
                    generalPath.lineTo(jWindow.getWidth(), 0.0f);
                }
                generalPath.closePath();
                JideSwingUtilities.setWindowShape(jWindow, generalPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void \u0101(Point point) {
        if (this.\u0106 != null && this.\u0105 != -1 && ((Component)this._component).isShowing()) {
            this.\u0106.\u0101(new com.jidesoft.tooltip.B((Component)this._component, point));
            this.\u0107.repaint();
            this.\u0101();
        }
    }

    private void \u0104(Point point) {
        if (this.\u0101 != null && this.\u0105 != -1 && ((Component)this._component).isShowing()) {
            this.\u0101.\u0101(new com.jidesoft.tooltip.B((Component)this._component, point));
            this.\u0103.repaint();
            this.\u0101();
        }
    }

    private void \u0101() {
        if (this.\u0102 != null) {
            ((JComponent)this._component).repaint(this.\u0102);
        }
    }

    protected Point createToolTipImage(int n2, boolean bl) {
        Component component = this.getComponent(n2);
        if (!(component instanceof JComponent)) {
            return null;
        }
        this.\u0102 = this.getRowBounds(n2);
        if (this.\u0102 == null) {
            return null;
        }
        Rectangle rectangle = this.\u0102;
        Rectangle rectangle2 = this.getVisibleRect(n2);
        int n3 = bl ? rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width) : rectangle2.x - rectangle.x;
        int n4 = rectangle.height;
        if (n3 <= 0 || n4 <= 0) {
            return null;
        }
        if (rectangle.y < rectangle2.y) {
            return null;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            return null;
        }
        int n5 = SystemInfo.getDisplayScale();
        BufferedImage bufferedImage = this.createImage(n3 * n5, n4 * n5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(n5, n5);
        graphics2D.setClip(null);
        this.fillBackground(graphics2D, n3, n4);
        if (bl) {
            graphics2D.translate(-(rectangle2.x + rectangle2.width - rectangle.x), 0);
        }
        this.paintTipImage(graphics2D, component, rectangle, n2, n5);
        if (this.shouldDrawBorder()) {
            int n6;
            graphics2D.setColor(Color.GRAY);
            int n7 = n5 == 1 ? n3 - 1 : n3;
            int n8 = n6 = n5 == 1 ? n4 - 1 : n4;
            if (bl) {
                graphics2D.translate(rectangle2.x + rectangle2.width - rectangle.x, 0);
                graphics2D.drawLine(0, 0, n7, 0);
                graphics2D.drawLine(n7, 0, n7, n6);
                graphics2D.drawLine(0, n6, n7, n6);
            } else {
                graphics2D.drawLine(0, 0, n7, 0);
                graphics2D.drawLine(0, 0, 0, n6);
                graphics2D.drawLine(0, n6, n3, n6);
            }
        }
        if (bl) {
            this.\u0109 = bufferedImage;
        } else {
            this.\u0104 = bufferedImage;
        }
        graphics2D.dispose();
        return bl ? new Point(rectangle2.x + rectangle2.width, rectangle.y) : new Point(rectangle.x, rectangle.y);
    }

    protected boolean shouldDrawBorder() {
        return !(this._component instanceof NavigationComponent);
    }

    protected BufferedImage createImage(int n2, int n3) {
        return new BufferedImage(n2, n3, 1);
    }

    protected void fillBackground(Graphics2D graphics2D, int n2, int n3) {
        graphics2D.setColor(((Component)this._component).getBackground());
        graphics2D.fillRect(0, 0, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTipImage(Graphics2D graphics2D, Component component, Rectangle rectangle, int n2, int n3) {
        BufferedImage bufferedImage = IconsFactory.createImage(component, rectangle, 1, n3);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(0, 0, rectangle.width, rectangle.height);
        try {
            graphics2D2.scale(1.0 / (double)n3, 1.0 / (double)n3);
            graphics2D2.drawImage((Image)bufferedImage, 0, 0, (ImageObserver)this._component);
        }
        finally {
            graphics2D2.dispose();
        }
    }

    protected Rectangle getVisibleRect(int n2) {
        return ((JComponent)this._component).getVisibleRect();
    }

    public S getComponent() {
        return this._component;
    }

    protected Component getComponent(int n2) {
        return this._component;
    }

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    private void \u0101(JComponent jComponent, ExpandedTip expandedTip) {
        if (jComponent != null) {
            Object object = ((JComponent)this._component).getClientProperty(CLIENT_PROPERTY_EXPANDED_TIP);
            if (object instanceof ExpandedTip) {
                ((ExpandedTip)object).uninstall();
            }
            jComponent.putClientProperty(CLIENT_PROPERTY_EXPANDED_TIP, expandedTip);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(ExpandedTip.class.getName(), 2);
        }
    }

    private class B
    extends JComponent {
        final boolean \u0102;

        private B(boolean bl) {
            this.\u0102 = bl;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n2 = SystemInfo.getDisplayScale();
            return this.\u0102 ? new Dimension(ExpandedTip.this.\u0109.getWidth() / n2, ExpandedTip.this.\u0109.getHeight() / n2) : new Dimension(ExpandedTip.this.\u0104.getWidth() / n2, ExpandedTip.this.\u0104.getHeight() / n2);
        }

        @Override
        public void paint(Graphics graphics) {
            int n2 = SystemInfo.getDisplayScale();
            ((Graphics2D)graphics).scale(1.0 / (double)n2, 1.0 / (double)n2);
            graphics.drawImage(this.\u0102 ? ExpandedTip.this.\u0109 : ExpandedTip.this.\u0104, 0, 0, null);
        }
    }

    private class A
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    ComponentListener,
    HierarchyBoundsListener,
    HierarchyListener {
        private A() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ExpandedTip.this.\u0101(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ExpandedTip.this.\u0101(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 0) {
                ExpandedTip.this.\u0101(mouseEvent, false);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ExpandedTip.this.hideTip();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.updateCurrentSelection();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ExpandedTip.this.hideTip();
        }
    }
}

