/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.CascadedTable;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.IntColumn;
import com.jidesoft.thirdparty.prefuse.data.util.RowManager;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntTreeMap;

public class FilteredRowManager
extends RowManager {
    protected IntColumn m_childToParent;
    protected IntIntSortedMap m_parentToChild;

    public FilteredRowManager(Table table) {
        super(table);
        this.m_childToParent = new IntColumn(table.getRowCount());
        this.m_parentToChild = new IntIntTreeMap(false);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_parentToChild.clear();
        for (int i2 = 0; i2 < this.m_childToParent.getRowCount(); ++i2) {
            this.m_childToParent.setInt(-1, i2);
        }
    }

    public int addRow(int n2) {
        int n3 = super.addRow();
        this.put(n3, n2);
        return n3;
    }

    @Override
    public boolean releaseRow(int n2) {
        if (super.releaseRow(n2)) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public int getColumnRow(int n2, int n3) {
        return ((CascadedTable)this.m_table).getParentTable().getColumnRow(this.getParentRow(n2), n3);
    }

    @Override
    public int getTableRow(int n2, int n3) {
        return this.getChildRow(n2);
    }

    public int getParentRow(int n2) {
        if (n2 >= this.m_childToParent.getRowCount()) {
            return -1;
        }
        return this.m_childToParent.getInt(n2);
    }

    public int getChildRow(int n2) {
        int n3 = this.m_parentToChild.get(n2);
        return n3 == Integer.MIN_VALUE ? -1 : n3;
    }

    public void put(int n2, int n3) {
        if (n2 >= this.m_childToParent.getRowCount()) {
            this.m_childToParent.setMaximumRow(n2 + 1);
        }
        this.m_childToParent.setInt(n3, n2);
        this.m_parentToChild.put(n3, n2);
    }

    public void remove(int n2) {
        int n3 = this.m_childToParent.getInt(n2);
        this.m_childToParent.setInt(-1, n2);
        this.m_parentToChild.remove(n3);
    }
}

