/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CsvTableUtils {
    public static boolean export(JTable jTable, String string) throws IOException {
        return CsvTableUtils.export(jTable, string, true);
    }

    public static boolean export(JTable jTable, String string, boolean bl) throws IOException {
        return CsvTableUtils.export(jTable, string, bl, null);
    }

    public static boolean export(JTable jTable, String string, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableUtils.export(jTable, string, bl, valueConverter, null);
    }

    public static boolean export(JTable jTable, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, 0, 0, -1, -1, string, bl, valueConverter, stringConverter);
    }

    public static boolean export(JTable jTable, int n2, int n3, int n4, int n5, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, n2, n3, n4, n5, string, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(JTable jTable, int n2, int n3, int n4, int n5, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvTableUtils.\u0101(jTable, fileOutputStream, n2, n3, n4, n5, bl, valueConverter, stringConverter, c2, Charset.defaultCharset().name());
        fileOutputStream.close();
        return true;
    }

    public static boolean export(JTable jTable, String string, CsvTableExportConfig csvTableExportConfig) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvTableUtils.\u0101(jTable, fileOutputStream, csvTableExportConfig);
        fileOutputStream.close();
        return true;
    }

    private static void \u0101(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c2, String string) {
        int n6;
        int n7;
        StringBuffer stringBuffer = new StringBuffer();
        TableModel tableModel = jTable.getModel();
        if (n5 == -1) {
            n5 = jTable.getColumnCount();
        }
        if (n4 == -1) {
            n4 = jTable.getRowCount();
        }
        if (bl) {
            if (jTable.getTableHeader() instanceof NestedTableHeader) {
                NestedTableHeader nestedTableHeader = (NestedTableHeader)jTable.getTableHeader();
                n7 = nestedTableHeader.getRowCount();
                for (n6 = 0; n6 < n7; ++n6) {
                    for (int i2 = 0; i2 < n5 && n3 + i2 < jTable.getColumnCount(); ++i2) {
                        String string2 = n6 == n7 - 1 ? jTable.getColumnName(n3 + i2) : "" + nestedTableHeader.getHeaderValueAt(n2 + n6, n3 + i2);
                        StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel(string2);
                        if (styledLabel != null) {
                            string2 = styledLabel.getText();
                        }
                        CsvTableUtils.addCellValue(stringBuffer, stringConverter != null ? stringConverter.convert(string2) : string2, c2);
                    }
                    CsvTableUtils.addLineBreak(stringBuffer);
                }
            } else {
                for (int i3 = 0; i3 < n5 && n3 + i3 < jTable.getColumnCount(); ++i3) {
                    String string3 = jTable.getColumnName(n3 + i3);
                    StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel(string3);
                    if (styledLabel != null) {
                        string3 = styledLabel.getText();
                    }
                    CsvTableUtils.addCellValue(stringBuffer, stringConverter != null ? stringConverter.convert(string3) : string3, c2);
                }
                CsvTableUtils.addLineBreak(stringBuffer);
            }
        }
        for (int i4 = 0; i4 < n4 && n2 + i4 < jTable.getRowCount(); ++i4) {
            for (n7 = 0; n7 < n5 && n3 + n7 < jTable.getColumnCount(); ++n7) {
                Object object;
                n6 = jTable.convertColumnIndexToModel(n3 + n7);
                if (n6 == -1) continue;
                if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(n2 + i4, n3 + n7)) {
                    object = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(n2 + i4, n3 + n7, valueConverter);
                } else {
                    object = tableModel.getValueAt(n2 + i4, n6);
                    if (valueConverter != null) {
                        object = valueConverter.convert(jTable, object, i4, n3 + n7);
                    }
                }
                CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c2);
            }
            CsvTableUtils.addLineBreak(stringBuffer);
        }
        try {
            outputStream.write(stringBuffer.toString().getBytes(string));
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void \u0101(JTable jTable, OutputStream outputStream, CsvTableExportConfig csvTableExportConfig) {
        int n2 = csvTableExportConfig.getFirstRow();
        int n3 = csvTableExportConfig.getFirstColumn();
        int n4 = csvTableExportConfig.getNumOfRows();
        int n5 = csvTableExportConfig.getNumOfColumns();
        boolean bl = csvTableExportConfig.isHeaderIncluded();
        ValueConverter valueConverter = csvTableExportConfig.getCellValueConverter();
        StringConverter stringConverter = csvTableExportConfig.getColumnNameConverter();
        char c2 = csvTableExportConfig.getSeparator();
        String string = csvTableExportConfig.getCharsetName();
        CsvTableUtils.\u0101(jTable, outputStream, n2, n3, n4, n5, bl, valueConverter, stringConverter, c2, string);
    }

    public static void addCellValue(StringBuffer stringBuffer, String string, char c2) {
        if (string.contains("" + c2) || string.contains("\"") || string.contains("\r\n")) {
            String string2 = string.replaceAll("\"", "\"\"");
            stringBuffer.append("\"").append(string2).append("\"").append(c2);
        } else {
            stringBuffer.append(string).append(c2);
        }
    }

    public static void addLineBreak(StringBuffer stringBuffer) {
        stringBuffer.append("\r\n");
    }

    public static boolean export(JTable jTable, OutputStream outputStream) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, true);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, bl, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, bl, valueConverter, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, 0, 0, -1, -1, bl, valueConverter, stringConverter);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, n2, n3, n4, n5, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n2, int n3, int n4, int n5, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c2) throws IOException {
        CsvTableUtils.\u0101(jTable, outputStream, n2, n3, n4, n5, bl, valueConverter, stringConverter, c2, Charset.defaultCharset().name());
        return true;
    }

    public static boolean export(JTable jTable, OutputStream outputStream, CsvTableExportConfig csvTableExportConfig) throws IOException {
        CsvTableUtils.\u0101(jTable, outputStream, csvTableExportConfig);
        return true;
    }

    public static class CsvTableExportConfig {
        private boolean \u0106 = true;
        private ValueConverter \u0107 = null;
        private StringConverter \u0103 = null;
        private int \u0104 = 0;
        private int \u0109 = 0;
        private int \u0102 = -1;
        private int \u0105 = -1;
        private char \u0108 = (char)44;
        private String \u0101 = Charset.defaultCharset().name();

        public boolean isHeaderIncluded() {
            return this.\u0106;
        }

        public void setHeaderIncluded(boolean bl) {
            this.\u0106 = bl;
        }

        public ValueConverter getCellValueConverter() {
            return this.\u0107;
        }

        public void setCellValueConverter(ValueConverter valueConverter) {
            this.\u0107 = valueConverter;
        }

        public StringConverter getColumnNameConverter() {
            return this.\u0103;
        }

        public void setColumnNameConverter(StringConverter stringConverter) {
            this.\u0103 = stringConverter;
        }

        public int getFirstRow() {
            return this.\u0104;
        }

        public void setFirstRow(int n2) {
            this.\u0104 = n2;
        }

        public int getFirstColumn() {
            return this.\u0109;
        }

        public void setFirstColumn(int n2) {
            this.\u0109 = n2;
        }

        public int getNumOfRows() {
            return this.\u0102;
        }

        public void setNumOfRows(int n2) {
            this.\u0102 = n2;
        }

        public int getNumOfColumns() {
            return this.\u0105;
        }

        public void setNumOfColumns(int n2) {
            this.\u0105 = n2;
        }

        public char getSeparator() {
            return this.\u0108;
        }

        public void setSeparator(char c2) {
            this.\u0108 = c2;
        }

        public String getCharsetName() {
            return this.\u0101;
        }

        public void setCharsetName(String string) {
            this.\u0101 = string;
        }
    }
}

