/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.gauge.LineLabelPlacement;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LineIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private double \u012a = 0.75;
    private double \u0129 = 0.1;
    private Border \u0127 = null;
    private LineLabelPlacement \u0128 = LineLabelPlacement.ABOVE;
    private BufferedImage \u0125 = null;
    private double \u0126 = 0.5;

    public double getBreadth() {
        return this.\u012a;
    }

    public void setBreadth(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.\u012a = d2;
    }

    public double getLength() {
        return this.\u0129;
    }

    public void setLength(double d2) {
        this.\u0129 = d2;
    }

    public Border getBorder() {
        return this.\u0127;
    }

    public void setBorder(Border border) {
        this.\u0127 = border;
    }

    public LineLabelPlacement getLabelPlacement() {
        return this.\u0128;
    }

    public void setLabelPlacement(LineLabelPlacement lineLabelPlacement) {
        this.\u0128 = lineLabelPlacement;
    }

    public double getLinePosition() {
        return this.\u0126;
    }

    public void setLinePosition(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("The linePosition property must be a value between 0 and 1");
        }
        this.\u0126 = d2;
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d2) {
        if (d2 == null) {
            return null;
        }
        BulletAxis bulletAxis = bullet.getAxis();
        Point2D point2D = bullet.calculatePixelPoint2D(bulletAxis, (double)d2);
        Rectangle2D.Double double_ = null;
        if (point2D != null) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8 = bullet.getMidY();
            double d9 = bullet.getMidX();
            double d10 = bullet.getBulletBreadth();
            double d11 = this.\u012a * d10;
            double d12 = d11 * this.\u0129;
            Orientation orientation = bullet.getOrientation();
            if (orientation == Orientation.horizontal) {
                d7 = d8 + (this.\u0126 - 0.5) * d10;
                d6 = point2D.getX() - d12 / 2.0;
                d5 = d7 - d11 / 2.0;
                d4 = d12;
                d3 = d11;
            } else {
                d7 = d9 + (this.\u0126 - 0.5) * d10;
                d6 = d7 - d11 / 2.0;
                d5 = point2D.getY() - d12 / 2.0;
                d4 = d11;
                d3 = d12;
            }
            int n2 = (int)Math.floor(d6);
            int n3 = (int)Math.floor(d5);
            int n4 = (int)Math.ceil(d4);
            int n5 = (int)Math.ceil(d3);
            double_ = new Rectangle2D.Double(n2, n3, n4, n5);
        }
        return double_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        try {
            Rectangle rectangle = shape.getBounds();
            double d2 = this.\u012a * bullet.getBulletBreadth();
            Object object = graphics2D2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Paint paint = indicatorStyle.getFill();
            if (paint != null) {
                graphics2D2.setPaint(paint);
                graphics2D2.fill(rectangle);
                graphics2D2.draw(rectangle);
            }
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            if (this.\u0127 == null) {
                Color color = indicatorStyle.getOutline();
                if (color != null) {
                    float f2 = indicatorStyle.getOutlineWidth();
                    float f3 = (float)((double)f2 * d2 / 100.0);
                    if (f3 < 1.0f) {
                        f3 = 1.0f;
                    }
                    BasicStroke basicStroke = new BasicStroke(f3);
                    Stroke stroke = graphics2D2.getStroke();
                    graphics2D2.setStroke(basicStroke);
                    graphics2D2.setColor(color);
                    graphics2D2.draw(rectangle);
                    graphics2D2.setStroke(stroke);
                }
            } else {
                this.\u0127.paintBorder(bullet, graphics2D2, rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
            }
        }
        finally {
            if (graphics2D2 != null) {
                graphics2D2.dispose();
            }
        }
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d2, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d2);
        if (string != null && this.\u0128 != null && this.labelVisible) {
            BulletAxis bulletAxis = bullet.getAxis();
            Point2D point2D = bullet.calculatePixelPoint2D(bulletAxis, (double)d2);
            double d3 = this.\u012a * bullet.getBulletBreadth();
            double d4 = d3 * this.\u0129;
            Orientation orientation = bullet.getOrientation();
            double d5 = orientation == Orientation.horizontal ? point2D.getX() - d4 / 2.0 : point2D.getX() - d3 / 2.0;
            double d6 = orientation == Orientation.horizontal ? point2D.getY() - d3 / 2.0 : point2D.getY() - d4 / 2.0;
            double d7 = orientation == Orientation.horizontal ? d4 : d3;
            double d8 = orientation == Orientation.horizontal ? d3 : d4;
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n2 = fontMetrics.stringWidth(string);
            int n3 = fontMetrics.charWidth('o');
            graphics2D.setColor(this.getLabelColor());
            graphics2D.setFont(font2);
            Float f2 = null;
            Float f3 = null;
            if (this.\u0128 == LineLabelPlacement.ABOVE) {
                f2 = Float.valueOf((float)(d5 + d7 / 2.0 - (double)n2 / 2.0));
                f3 = Float.valueOf((float)(d6 - (double)fontMetrics.getDescent()));
            } else if (this.\u0128 == LineLabelPlacement.BELOW) {
                f2 = Float.valueOf((float)(d5 + d7 / 2.0 - (double)n2 / 2.0));
                f3 = Float.valueOf((float)(d6 + d8 + (double)fontMetrics.getAscent()));
            } else if (this.\u0128 == LineLabelPlacement.LEFT) {
                f2 = Float.valueOf((float)(d5 - (double)n3 / 2.0 - (double)n2));
                f3 = Float.valueOf((float)(d6 + d8 / 2.0 + (double)fontMetrics.getAscent() / 2.0));
            } else if (this.\u0128 == LineLabelPlacement.RIGHT) {
                f2 = Float.valueOf((float)(d5 + d7 + (double)n3 / 2.0));
                f3 = Float.valueOf((float)(d6 + d8 / 2.0 + (double)fontMetrics.getAscent() / 2.0));
            }
            if (f2 != null && f3 != null) {
                Color color = this.getLabelColor();
                graphics2D.setColor(color == null ? Color.BLACK : color);
                graphics2D.setFont(font2);
                graphics2D.drawString(string, f2.floatValue(), f3.floatValue());
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n2, int n3) {
        Object object;
        Rectangle rectangle;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Paint paint = indicatorStyle.getFill();
        graphics2D.setPaint(paint);
        int n4 = n3 - 4;
        int n5 = n2 - 4;
        if (bullet.getOrientation() == Orientation.horizontal) {
            n5 = n4 / 4;
            rectangle = new Rectangle(n2 / 2 - n5 / 2, 2, n5, n4);
        } else {
            n4 = n5 / 4;
            rectangle = new Rectangle(3, n3 / 2 - n4 / 2, n5 - 2, n4);
        }
        graphics2D.fill(rectangle);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            float f2 = indicatorStyle.getOutlineWidth();
            object = new BasicStroke(f2);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color);
            graphics2D.draw(rectangle);
        }
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            object = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage((Image)object, 0, 0, bullet);
        }
        graphics.drawImage(bufferedImage, 0, 0, bullet);
        graphics2D.dispose();
        return null;
    }
}

