/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AverageChartModel
extends AbstractDelegatingChartModel {
    private List<Chartable> \u01bb = new ArrayList<Chartable>();

    public AverageChartModel(AnnotatedChartModel[] annotatedChartModelArray) {
        super(annotatedChartModelArray);
        assert (annotatedChartModelArray.length > 0);
        this.update();
    }

    public AverageChartModel(String string, AnnotatedChartModel[] annotatedChartModelArray) {
        super(annotatedChartModelArray);
        this.setName(string);
        assert (annotatedChartModelArray.length > 0);
        this.update();
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public Annotation getAnnotation(int n2) {
        return null;
    }

    @Override
    protected void update() {
        HashMap<Positionable, ArrayList<Double>> hashMap = new HashMap<Positionable, ArrayList<Double>>();
        HashMap<Positionable, ArrayList<Highlight>> hashMap2 = new HashMap<Positionable, ArrayList<Highlight>>();
        for (Iterable<Chartable> iterable : this.getDelegates()) {
            for (Chartable chartable : iterable) {
                ArrayList<Double> arrayList;
                Positionable positionable = chartable.getX();
                Positionable positionable2 = chartable.getY();
                Double d2 = positionable2 == null ? Double.NaN : positionable2.position();
                Highlight highlight = null;
                if (chartable instanceof Highlightable) {
                    highlight = ((Highlightable)((Object)chartable)).getHighlight();
                }
                if ((arrayList = (ArrayList<Double>)hashMap.get(positionable)) == null) {
                    arrayList = new ArrayList<Double>();
                }
                arrayList.add(d2);
                hashMap.put(positionable, arrayList);
                ArrayList<Highlight> arrayList2 = (ArrayList<Highlight>)hashMap2.get(positionable);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Highlight>();
                }
                arrayList2.add(highlight);
                hashMap2.put(positionable, arrayList2);
            }
        }
        if (this.\u01bb == null) {
            this.\u01bb = new ArrayList<Chartable>();
        } else {
            this.\u01bb.clear();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Chartable chartable;
            Iterable<Chartable> iterable;
            Positionable positionable = (Positionable)entry.getKey();
            iterable = (List)hashMap2.get(positionable);
            Highlight highlight = AverageChartModel.\u0103((List<Highlight>)iterable);
            chartable = new ChartPoint(positionable, (double)AverageChartModel.average((List)entry.getValue()), highlight);
            this.\u01bb.add(chartable);
        }
        Collections.sort(this.\u01bb);
    }

    public static Double average(List<Double> list) {
        if (list == null) {
            return Double.NaN;
        }
        double d2 = 0.0;
        int n2 = 0;
        for (Double d3 : list) {
            if (d3 == null || Double.isNaN(d3)) continue;
            d2 += d3.doubleValue();
            ++n2;
        }
        return d2 / (double)n2;
    }

    @Override
    public Chartable getPoint(int n2) {
        return this.\u01bb.get(n2);
    }

    @Override
    public int getPointCount() {
        return this.\u01bb.size();
    }

    @Override
    public boolean isAnnotationsVisible() {
        return false;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }
}

