/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.utils.SecurityUtils;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;

public final class SystemInfo {
    private static boolean \u0105 = false;
    private static boolean \u010c = false;
    private static boolean \u0107 = false;
    private static boolean \u0101 = false;
    private static boolean \u0110 = false;
    private static boolean \u010e = false;
    private static boolean \u010f = false;
    private static boolean \u0111 = false;
    private static boolean \u0104 = false;
    private static boolean \u0103 = false;
    private static boolean \u0102 = false;
    private static boolean \u010d = false;
    private static boolean \u0108 = false;
    private static boolean \u0106 = false;
    private static boolean \u010a = false;
    private static boolean \u0109 = false;
    private static JavaVersion \u010b;

    private SystemInfo() {
    }

    public static String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static String getJavaClassVersion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static boolean supportsTray() {
        return \u0102;
    }

    public static void setSupportsTray(boolean bl) {
        \u0102 = bl;
    }

    public static boolean isWindows() {
        return \u0105;
    }

    public static boolean isClassicWindows() {
        return \u0111;
    }

    public static boolean isWindowsNTor2000() {
        return \u010c;
    }

    public static boolean isWindowsXP() {
        return \u0107;
    }

    public static boolean isWindowsVista() {
        return \u0101;
    }

    public static boolean isWindows7() {
        return \u0110;
    }

    public static boolean isWindows8() {
        return \u010e;
    }

    public static boolean isWindowsVistaAbove() {
        return \u0101 || \u0110 || \u010e;
    }

    public static boolean isWindows95() {
        return \u0104;
    }

    public static boolean isWindows98() {
        return \u0103;
    }

    public static boolean isWindows2003() {
        return \u010f;
    }

    public static boolean isMacClassic() {
        return \u010d;
    }

    public static boolean isMacOSX() {
        return \u0108;
    }

    public static boolean isAnyMac() {
        return \u010d || \u0108;
    }

    public static boolean isSolaris() {
        return \u010a;
    }

    public static boolean isLinux() {
        return \u0106;
    }

    public static boolean isBSD() {
        return \u0109;
    }

    public static boolean isUnix() {
        return \u0106 || \u010a || \u0109;
    }

    private static void \u0101() {
        if (\u010b == null) {
            \u010b = new JavaVersion(SystemInfo.getJavaVersion());
        }
    }

    public static boolean isJdk13Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.3, 0, 0) >= 0;
    }

    public static boolean isJdk142Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.4, 2, 0) >= 0;
    }

    public static boolean isJdk14Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.4, 0, 0) >= 0;
    }

    public static boolean isJdk15Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.5, 0, 0) >= 0;
    }

    public static boolean isJdk6Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJdk6u10Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.6, 0, 10) >= 0;
    }

    public static boolean isJdk6u14Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.6, 0, 14) >= 0;
    }

    public static boolean isJdk6u25Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.6, 0, 25) >= 0;
    }

    public static boolean isJdk7Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.7, 0, 0) >= 0;
    }

    public static boolean isJdk7u40Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.7, 0, 40) >= 0;
    }

    public static boolean isJdk8Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(1.8, 0, 0) >= 0;
    }

    public static boolean isJdk9Above() {
        SystemInfo.\u0101();
        return \u010b.compareVersion(9.0, 0, 0) >= 0;
    }

    public static boolean isJdkVersion(double d2, int n2, int n3) {
        SystemInfo.\u0101();
        return \u010b.compareVersion(d2, n2, n3) == 0;
    }

    public static boolean isJdkVersionAbove(double d2, int n2, int n3) {
        SystemInfo.\u0101();
        return \u010b.compareVersion(d2, n2, n3) >= 0;
    }

    public static boolean isJdkVersionBelow(double d2, int n2, int n3) {
        SystemInfo.\u0101();
        return \u010b.compareVersion(d2, n2, n3) <= 0;
    }

    public static boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    public static int getDisplayScale() {
        if (GraphicsEnvironment.isHeadless()) {
            return 1;
        }
        if (SystemInfo.isJdk7u40Above()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            try {
                Field field = graphicsDevice.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object object = field.get(graphicsDevice);
                    if (object instanceof Integer) {
                        return (Integer)object;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    public static boolean isMnemonicHidden() {
        boolean bl = true;
        if (UIManager.getBoolean("Button.showMnemonics")) {
            bl = false;
        }
        return bl;
    }

    static {
        String string = SecurityUtils.getProperty("os.name", "Windows XP");
        \u0105 = string.indexOf("Windows") != -1;
        try {
            String string2 = SecurityUtils.getProperty("os.version", "5.0");
            Float f2 = Float.valueOf(string2);
            \u0111 = (double)f2.floatValue() <= 4.0;
        }
        catch (NumberFormatException numberFormatException) {
            \u0111 = false;
        }
        if (string.indexOf("Windows XP") != -1 || string.indexOf("Windows NT") != -1 || string.indexOf("Windows 2000") != -1) {
            \u010c = true;
        }
        if (string.indexOf("Windows XP") != -1) {
            \u0107 = true;
        }
        if (string.indexOf("Windows Vista") != -1) {
            \u0101 = true;
        }
        if (string.indexOf("Windows 7") != -1) {
            \u0110 = true;
        }
        if (string.indexOf("Windows 8") != -1) {
            \u010e = true;
        }
        if (string.indexOf("Windows 2003") != -1) {
            \u010f = true;
            \u0107 = true;
        }
        if (string.indexOf("Windows 95") != -1) {
            \u0104 = true;
        }
        if (string.indexOf("Windows 98") != -1) {
            \u0103 = true;
        }
        if (\u0105) {
            \u0102 = true;
        }
        \u010a = string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1;
        \u0109 = string.endsWith("BSD");
        boolean bl = \u0106 = string.indexOf("Linux") != -1;
        if (string.startsWith("Mac OS")) {
            if (string.endsWith("X")) {
                \u0108 = true;
            } else {
                \u010d = true;
            }
        }
    }

    public static class JavaVersion {
        private static Pattern \u0106 = Pattern.compile("(\\d+(?:\\.\\d+)?)(\\.(\\d+))?(_([^-]+))?(.*)");
        private static Pattern \u0103 = Pattern.compile("(\\d+(?:\\.\\d+)?)(\\.(\\d+))?(.*)");
        private double \u0101;
        private int \u0105;
        private int \u0104;
        private String \u0102;

        public JavaVersion(String string) {
            block13: {
                this.\u0101 = 1.4;
                this.\u0105 = 0;
                this.\u0104 = 0;
                try {
                    Matcher matcher = \u0106.matcher(string);
                    if (matcher.matches()) {
                        String string2;
                        int n2 = matcher.groupCount();
                        this.\u0101 = Double.parseDouble(matcher.group(1));
                        if (n2 >= 3 && matcher.group(3) != null) {
                            this.\u0105 = Integer.parseInt(matcher.group(3));
                        }
                        if (n2 >= 5 && matcher.group(5) != null) {
                            try {
                                this.\u0104 = Integer.parseInt(matcher.group(5));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.\u0102 = matcher.group(5);
                            }
                        }
                        if (n2 >= 6 && matcher.group(6) != null && (string2 = matcher.group(6)) != null && string2.trim().length() > 0) {
                            this.\u0102 = string2;
                        }
                        break block13;
                    }
                    int[] nArray = JdkSpecificClass.getVersions();
                    if (nArray != null) {
                        this.\u0101 = nArray[0];
                        this.\u0105 = nArray[1];
                        this.\u0104 = nArray[2];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Matcher matcher = \u0103.matcher(string);
                        if (matcher.matches()) {
                            int n3 = matcher.groupCount();
                            this.\u0101 = Double.parseDouble(matcher.group(1));
                            if (n3 >= 3 && matcher.group(3) != null) {
                                this.\u0105 = Integer.parseInt(matcher.group(3));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException2) {
                        System.err.println("Please check the installation of your JDK. The version number " + string + " is not right.");
                    }
                }
            }
        }

        public JavaVersion(double d2, int n2, int n3) {
            this.\u0101 = d2;
            this.\u0105 = n2;
            this.\u0104 = n3;
        }

        public int compareVersion(double d2, int n2, int n3) {
            double d3 = this.\u0101 - d2;
            if (d3 != 0.0) {
                return d3 < 0.0 ? -1 : 1;
            }
            int n4 = this.\u0105 - n2;
            if (n4 != 0) {
                return n4;
            }
            return this.\u0104 - n3;
        }

        public double getMajorVersion() {
            return this.\u0101;
        }

        public int getMinorVersion() {
            return this.\u0105;
        }

        public int getBuildNumber() {
            return this.\u0104;
        }

        public String getPatch() {
            return this.\u0102;
        }
    }
}

