/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.shapes.RoundedRectangularShape;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;

public class RoundedRectangularBalloonShape
implements BalloonShape {
    protected int _cornerSize = 18;
    protected double _balloonSizeRatio = 0.75;
    protected double _arrowLeftRatio = 0.5;
    protected double _arrowRightRatio = 0.25;
    protected double _vertexPosition = 0.25;
    private int \u0101 = 1;

    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        GeneralPath generalPath;
        int n2 = dimension.width;
        int n3 = dimension.height;
        switch (this.\u0101) {
            case 3: {
                generalPath = this.\u0101(dimension, this.getRoundedCornerSize());
                AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(180.0), n2 / 2, n3 / 2);
                generalPath.transform(affineTransform);
                break;
            }
            case 2: {
                generalPath = this.\u0102(dimension, this.getRoundedCornerSize());
                break;
            }
            case 4: {
                generalPath = this.\u0102(dimension, this.getRoundedCornerSize());
                AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(180.0), n2 / 2, n3 / 2);
                generalPath.transform(affineTransform);
                break;
            }
            default: {
                generalPath = this.\u0101(dimension, this.getRoundedCornerSize());
            }
        }
        return generalPath;
    }

    protected int getRoundedCornerSize() {
        return this.getCornerSize();
    }

    private GeneralPath \u0101(Dimension dimension, int n2) {
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (int)((double)n4 * this.getBalloonSizeRatio());
        int n6 = (int)((double)n3 * this.getArrowLeftRatio());
        int n7 = (int)((double)n3 * this.getArrowRightRatio());
        int n8 = (int)((double)n3 * this.getVertexPosition());
        int n9 = 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n2, n9);
        generalPath.lineTo(n3 - n2 - n9, n9);
        generalPath.curveTo(n3 - n2 - n9, n9, n3 - n9, n9, n3 - n9, n2);
        generalPath.lineTo(n3 - n9, n5 - n2 - n9);
        generalPath.curveTo(n3 - n9, n5 - n2 - n9, n3 - n9, n5 - n9, n3 - n2 - n9, n5 - n9);
        generalPath.lineTo(n3 - n7, n5 - n9);
        generalPath.lineTo(n8, n4 - n9);
        generalPath.lineTo(n6, n5 - n9);
        generalPath.lineTo(n2, n5 - n9);
        generalPath.curveTo(n2, n5 - n9, n9, n5 - n9, n9, n5 - n2 - n9);
        generalPath.lineTo(n9, n2 - n9);
        generalPath.curveTo(n9, n2 - n9, n9, n9, n2 - n9, n9);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath \u0102(Dimension dimension, int n2) {
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (int)((double)n3 * this.getBalloonSizeRatio());
        int n6 = (int)((double)n4 * this.getArrowLeftRatio());
        int n7 = (int)((double)n4 * this.getArrowRightRatio());
        int n8 = (int)((double)n4 * this.getVertexPosition());
        int n9 = 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n2, n9);
        generalPath.lineTo(n5 - n2 - n9, n9);
        generalPath.curveTo(n5 - n2 - n9, n9, n5 - n9, n9, n5 - n9, n2);
        generalPath.lineTo(n5 - n9, n6);
        generalPath.lineTo(n3 - n9, n8);
        generalPath.lineTo(n5 - n9, n4 - n7);
        generalPath.lineTo(n5 - n9, n4 - n2);
        generalPath.curveTo(n5 - n9, n4 - n2, n5 - n9, n4, n5 - n2, n4 - n9);
        generalPath.lineTo(n2, n4 - n9);
        generalPath.curveTo(n2, n4 - n9, n9, n4 - n9, n9, n4 - n2 - n9);
        generalPath.lineTo(n9, n2 - n9);
        generalPath.curveTo(n9, n2 - n9, n9, n9, n2 - n9, n9);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        Point point;
        int n2 = dimension.width;
        int n3 = dimension.height;
        switch (this.\u0101) {
            case 1: {
                int n4 = (int)((double)n2 * this.getVertexPosition());
                point = new Point(n4, n3);
                break;
            }
            case 3: {
                int n5 = (int)((double)n2 * (1.0 - this.getVertexPosition()));
                point = new Point(n5, 0);
                break;
            }
            case 2: {
                int n6 = (int)((double)n3 * this.getVertexPosition());
                point = new Point(n2, n6);
                break;
            }
            case 4: {
                int n7 = (int)((double)n3 * (1.0 - this.getVertexPosition()));
                point = new Point(0, n7);
                break;
            }
            default: {
                int n8 = (int)((double)n2 * this.getVertexPosition());
                point = new Point(n8, n3);
            }
        }
        return point;
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        Insets insets;
        int n2 = 2 * this.getCornerSize() + dimension.height;
        double d2 = (1.0 - this.getBalloonSizeRatio()) / this.getBalloonSizeRatio();
        int n3 = (int)((double)n2 * d2) + this.getCornerSize();
        int n4 = 2 * this.getCornerSize() + dimension.width;
        double d3 = (1.0 - this.getBalloonSizeRatio()) / this.getBalloonSizeRatio();
        int n5 = (int)((double)n4 * d3) + this.getCornerSize();
        switch (this.\u0101) {
            case 1: {
                insets = new Insets(this.getCornerSize(), this.getCornerSize(), n3, this.getCornerSize());
                break;
            }
            case 3: {
                insets = new Insets(n3, this.getCornerSize(), this.getCornerSize(), this.getCornerSize());
                break;
            }
            case 2: {
                insets = new Insets(this.getCornerSize(), this.getCornerSize(), this.getCornerSize(), n5);
                break;
            }
            case 4: {
                insets = new Insets(this.getCornerSize(), n5, this.getCornerSize(), this.getCornerSize());
                break;
            }
            default: {
                insets = new Insets(n3, this.getCornerSize(), this.getCornerSize(), this.getCornerSize());
            }
        }
        return insets;
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        Dimension dimension = balloonTip.getBalloonSize();
        int n2 = point.x;
        int n3 = point.y;
        int n4 = dimension.width;
        int n5 = dimension.height;
        double d2 = 0.0;
        switch (this.\u0101) {
            case 1: {
                int n6 = (int)((double)n5 * this.getBalloonSizeRatio());
                int n7 = (int)((double)n4 * this.getArrowLeftRatio());
                int n8 = (int)((double)n4 * this.getArrowRightRatio());
                int n9 = (int)((double)n4 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n4, n6);
                if (n3 < n6 - this.getCornerSize()) {
                    d2 = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                    break;
                }
                if (n3 < n6) {
                    if (n2 <= n7 || n2 >= n4 - n8) {
                        d2 = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                        break;
                    }
                    d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n7, n6), new Point(n4 - n8, n6), new Point(n9, n5), this.getCornerSize(), true);
                    break;
                }
                d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n7, n6), new Point(n4 - n8, n6), new Point(n9, n5), this.getCornerSize(), false);
                break;
            }
            case 3: {
                int n10 = (int)((double)n5 * this.getBalloonSizeRatio());
                int n11 = (int)((double)n4 * this.getArrowRightRatio());
                int n12 = (int)((double)n4 * this.getArrowLeftRatio());
                int n13 = n4 - (int)((double)n4 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n4, n10);
                int n14 = n5 - n10 + 1;
                if (n3 > n5 + this.getCornerSize() - n10) {
                    d2 = RoundedRectangularShape.getDistance(new Point(n2, n3 - n14), rectangle, this.getCornerSize());
                    break;
                }
                if (n3 > n5 - n10) {
                    if (n2 <= n11 || n2 >= n4 - n12) {
                        d2 = RoundedRectangularShape.getDistance(new Point(n2, n3 - n14), rectangle, this.getCornerSize());
                        break;
                    }
                    d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n11, n14), new Point(n4 - n12, n14), new Point(n13, 0), this.getCornerSize(), true);
                    break;
                }
                d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n11, n14), new Point(n4 - n12, n14), new Point(n13, 0), this.getCornerSize(), false);
                break;
            }
            case 2: {
                int n15 = (int)((double)n4 * this.getBalloonSizeRatio());
                int n16 = (int)((double)n5 * this.getArrowLeftRatio());
                int n17 = (int)((double)n5 * this.getArrowRightRatio());
                int n18 = (int)((double)n5 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n15, n5);
                if (n2 < n15 - this.getCornerSize()) {
                    d2 = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                    break;
                }
                if (n2 < n15) {
                    if (n3 <= n16 || n3 >= n5 - n17) {
                        d2 = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                        break;
                    }
                    d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n15, n16), new Point(n15, n5 - n17), new Point(n4, n18), this.getCornerSize(), true);
                    break;
                }
                d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n15, n16), new Point(n15, n5 - n17), new Point(n4, n18), this.getCornerSize(), false);
                break;
            }
            case 4: {
                int n19 = (int)((double)n4 * this.getBalloonSizeRatio());
                int n20 = (int)((double)n5 * this.getArrowRightRatio());
                int n21 = (int)((double)n5 * this.getArrowLeftRatio());
                int n22 = n5 - (int)((double)n5 * this.getVertexPosition());
                int n23 = n4 - n19 + 1;
                Rectangle rectangle = new Rectangle(0, 0, n19, n5);
                if (n2 > n4 + this.getCornerSize() - n19) {
                    d2 = RoundedRectangularShape.getDistance(new Point(n2 - n23, n3), rectangle, this.getCornerSize());
                    break;
                }
                if (n2 > n4 - n19) {
                    if (n3 <= n20 || n3 >= n5 - n21) {
                        d2 = RoundedRectangularShape.getDistance(new Point(n2 - n23, n3), rectangle, this.getCornerSize());
                        break;
                    }
                    d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n23, n20), new Point(n23, n5 - n21), new Point(0, n22), this.getCornerSize(), true);
                    break;
                }
                d2 = RoundedRectangularBalloonShape.getDistance(point, new Point(n23, n20), new Point(n23, n5 - n21), new Point(0, n22), this.getCornerSize(), false);
            }
        }
        return d2;
    }

    public static double getDistance(Point point, Point point2, Point point3, Point point4, int n2, boolean bl) {
        Shape shape;
        int n3 = point.x;
        int n4 = point.y;
        if (!bl) {
            shape = new GeneralPath();
            ((Path2D.Float)shape).moveTo(point3.x, point3.y);
            ((Path2D.Float)shape).lineTo(point4.x, point4.y);
            ((Path2D.Float)shape).lineTo(point2.x, point2.y);
            ((Path2D)shape).closePath();
            if (!((Path2D)shape).contains(n3, n4)) {
                return 0.0;
            }
        }
        shape = new Line2D.Double(point4.x, point4.y, point2.x, point2.y);
        Line2D.Double double_ = new Line2D.Double(point4.x, point4.y, point3.x, point3.y);
        double d2 = ((Line2D)shape).ptSegDist(n3, n4);
        double d3 = double_.ptSegDist(n3, n4);
        double d4 = d2 >= (double)n2 && d3 >= (double)n2 ? (double)(-n2) : (d2 < (double)n2 && d3 >= (double)n2 ? -d2 : (d2 >= (double)n2 && d3 < (double)n2 ? -d3 : -d2 * d3 / (double)n2));
        return d4;
    }

    public int getCornerSize() {
        return this._cornerSize;
    }

    public void setCornerSize(int n2) {
        this._cornerSize = n2;
    }

    public double getBalloonSizeRatio() {
        return this._balloonSizeRatio;
    }

    public void setBalloonSizeRatio(double d2) {
        this._balloonSizeRatio = d2;
    }

    public double getArrowLeftRatio() {
        return this._arrowLeftRatio;
    }

    public void setArrowLeftRatio(double d2) {
        this._arrowLeftRatio = d2;
    }

    public double getArrowRightRatio() {
        return this._arrowRightRatio;
    }

    public void setArrowRightRatio(double d2) {
        this._arrowRightRatio = d2;
    }

    public double getVertexPosition() {
        return this._vertexPosition;
    }

    public void setVertexPosition(double d2) {
        this._vertexPosition = d2;
    }

    public void setPosition(int n2) {
        this.\u0101 = n2;
    }

    public int getPosition() {
        return this.\u0101;
    }
}

