/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.AutoFilterBox;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.AutoFilterTableHeaderEditor;
import com.jidesoft.grid.AutoFilterTableHeaderRenderer;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.EditableTableHeader;
import com.jidesoft.grid.FilterableTableHeaderCellDecorator;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AutoFilterTableHeader
extends EditableTableHeader
implements FilterableTableModelListener,
PropertyChangeListener {
    protected IFilterableTableModel _filterableTableModel;
    protected boolean _autoFilterEnabled = false;
    private boolean \u1e85 = false;
    private boolean \u1e80 = false;
    private boolean \u1e88 = false;
    private boolean \u1e7e = false;
    private boolean \u1e82 = false;
    private boolean \u1e84 = true;
    private boolean \u1e87 = false;
    private boolean \u1e7c = false;
    private TableCellRenderer \u1e7b;
    private TableHeaderCellDecorator \u1e81;
    private boolean \u1e89 = false;
    static final String \u1e7f = "TableHeaderUIDelegate.filterCellDecoratorProperties";
    static final String \u1e7d = "TableHeaderUIDelegate.instance";
    public static final String PROPERTY_ACCEPT_TEXT_INPUT = "acceptTextInput";
    public static final String PROPERTY_USE_NATIVE_CELL_RENDERER = "useNativeCellRenderer";
    public static final String PROPERTY_AUTO_FILTER_ENABLED = "autoFilterEnabled";
    public static final String PROPERTY_FILTER_FACTORY_MANAGER = "filterFactoryManager";
    private static final String \u1e83 = "AutoFilterTableHeaderUI";
    private static final String \u1e86 = "TableHeader.autoFilterTableHeaderUIDelegate";
    public static final String CLIENT_PROPERTY_CUSTOM_FILTER_EDITOR_TYPE = "customFilterEditorType";
    public static final String CUSTOM_FILTER_EDITOR_TYPE_TABLE_CUSTOM_FILTER_EDITOR = "TableCustomFilterEditor";

    protected AutoFilterTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.setRolloverEnabled(true);
        this.setClickToStartEditing(false);
        this.addCellDecorator(0, this.getFilterableTableHeaderCellDecorator());
        this.\u02e2();
    }

    public AutoFilterTableHeader(JTable jTable) {
        super(jTable.getColumnModel());
        this.setRolloverEnabled(true);
        this.setClickToStartEditing(false);
        this.\u02e2();
        this.addCellDecorator(0, this.getFilterableTableHeaderCellDecorator());
        this.setTable(jTable);
    }

    protected TableHeaderCellDecorator createFilterableTableHeaderCellDecorator() {
        return new FilterableTableHeaderCellDecorator();
    }

    public TableHeaderCellDecorator getFilterableTableHeaderCellDecorator() {
        if (this.\u1e81 == null) {
            this.\u1e81 = this.createFilterableTableHeaderCellDecorator();
        }
        return this.\u1e81;
    }

    @Override
    public void setTable(JTable jTable) {
        if (jTable != null) {
            this.initTable(jTable);
        }
        super.setTable(jTable);
    }

    @Override
    public String getUIDelegateClassID() {
        return \u1e86;
    }

    @Override
    public String getActualUIClassID() {
        return \u1e83;
    }

    private void \u02e2() {
        if (this.\u1e7b == null) {
            boolean bl = this._autoFilterEnabled;
            boolean bl2 = this.\u1e85;
            try {
                this.setAutoFilterEnabled(true);
                this.setUseNativeHeaderRenderer(false);
                this.\u1e7b = this.createDefaultRenderer();
            }
            finally {
                this.setAutoFilterEnabled(bl);
                this.setUseNativeHeaderRenderer(bl2);
            }
        }
    }

    public TableCellRenderer getAutoFilterTableHeaderRenderer() {
        return this.isUseNativeHeaderRenderer() ? this.getDefaultRenderer() : this.\u1e7b;
    }

    @Override
    protected TableCellRenderer createDefaultRenderer() {
        if (this.isAutoFilterEnabled() && !this.\u1e85) {
            return new AutoFilterTableHeaderRenderer(){

                @Override
                protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
                    super.customizeAutoFilterBox(autoFilterBox);
                    AutoFilterTableHeader.this.customizeAutoFilterBox(autoFilterBox);
                    autoFilterBox.applyComponentOrientation(AutoFilterTableHeader.this.getComponentOrientation());
                }
            };
        }
        return super.createDefaultRenderer();
    }

    @Override
    protected TableCellEditor createDefaultEditor() {
        if (this.isAutoFilterEnabled() && !this.\u1e85) {
            return new AutoFilterTableHeaderEditor(){
                private static final long \u0105 = 8656928681639076184L;

                @Override
                protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
                    autoFilterBox.applyComponentOrientation(AutoFilterTableHeader.this.getComponentOrientation());
                    super.customizeAutoFilterBox(autoFilterBox);
                    AutoFilterTableHeader.this.customizeAutoFilterBox(autoFilterBox);
                }
            };
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n2) {
        return super.isCellEditable(n2) && !this.isUseNativeHeaderRenderer();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            int n2;
            if (tableCellEditor instanceof AutoFilterTableHeaderEditor) {
                ((AutoFilterTableHeaderEditor)tableCellEditor).\u0101();
            }
            if ((n2 = this.getEditingColumn()) >= 0 && n2 < this.columnModel.getColumnCount() && this.columnModel.getColumn(n2).getHeaderValue() instanceof Icon) {
                this.removeEditor();
                return;
            }
        }
        super.editingStopped(changeEvent);
    }

    protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
        String string;
        autoFilterBox.setShowFilterName(this.isShowFilterName());
        autoFilterBox.setShowFilterNameAsToolTip(this.isShowFilterNameAsToolTip());
        autoFilterBox.setShowFilterIcon(this.isShowFilterIcon());
        autoFilterBox.setShowSortArrow(this.isShowSortArrow());
        autoFilterBox.setAllowMultipleValues(this.isAllowMultipleValues(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setPreferSelectedValues(this.isPreferSelectedValues());
        autoFilterBox.setMultiLineMode(this.isAcceptTextInput());
        autoFilterBox.setAllowCustomFilter(this.\u0150(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setTitleConverter(this.\u014c(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setFilterTitleFormatter(this.\u014e(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setListCellRenderer(this.\u014d(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setUseTableCellRenderer(this.\u014f(autoFilterBox.getTableColumnIndex()));
        if (this.getTable() instanceof JideTable && (string = ((JideTable)this.getTable()).getTableHeaderToolTipText(autoFilterBox.getModelColumnIndex())) != null) {
            autoFilterBox.setToolTipText(string);
        }
    }

    protected void initTable(JTable jTable) {
        if (jTable instanceof GroupTable) {
            this.setPreferSelectedValues(true);
        }
        if (!JideSwingUtilities.isPropertyChangeListenerRegistered(jTable, "model", this)) {
            jTable.addPropertyChangeListener("model", this);
        }
        if (this._filterableTableModel == null || !TableModelWrapperUtils.\u0101(jTable.getModel(), this._filterableTableModel)) {
            this.tableModelChanged(jTable);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (!this.isAcceptTextInput()) {
            super.columnMarginChanged(changeEvent);
        } else {
            this.\u02e1();
            if (this.isEditing()) {
                int n2 = this.getEditingColumn();
                Component component = this.getEditorComponent();
                if (n2 >= 0 && n2 < this.getColumnModel().getColumnCount() && component != null) {
                    component.setBounds(this.getHeaderRect(n2));
                }
            }
        }
    }

    protected void tableModelChanged(JTable jTable) {
        if (this._filterableTableModel != null && TableModelWrapperUtils.\u0101(jTable.getModel(), this._filterableTableModel)) {
            return;
        }
        this.\u1e89 = false;
        if (this._filterableTableModel != null) {
            this._filterableTableModel.removeFilterableTableModelListener(this);
            this._filterableTableModel = null;
        }
        this.\u1e7c = false;
        if (!this.isAutoFilterEnabled() || jTable == null) {
            return;
        }
        TableModel tableModel = jTable.getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class);
        TableModel tableModel3 = this.createFilterableTableModel(tableModel);
        boolean bl = true;
        if (tableModel3 == null) {
            tableModel3 = TableModelWrapperUtils.getActualTableModel(tableModel, IFilterableTableModel.class);
            if (tableModel3 != null) {
                bl = false;
            }
        } else {
            TableModel tableModel4 = TableModelWrapperUtils.getActualTableModel(tableModel, IFilterableTableModel.class);
            while (tableModel4 instanceof IFilterableTableModel && tableModel4 instanceof TableModelWrapper && tableModel4 != tableModel3) {
                tableModel4 = TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel4)).getActualModel(), IFilterableTableModel.class);
            }
            if (tableModel4 == tableModel3) {
                bl = false;
            }
        }
        if (tableModel2 != null && (tableModel3 instanceof FilterableTreeTableModel || tableModel3 != null && TableModelWrapperUtils.getActualTableModel(tableModel2, IFilterableTableModel.class) == tableModel3)) {
            this._filterableTableModel = tableModel3;
        } else if (tableModel2 == null && tableModel3 instanceof IFilterableTableModel) {
            this._filterableTableModel = tableModel3;
        } else {
            this._filterableTableModel = this.createDefaultFilterableTableModel(tableModel);
            boolean bl2 = bl = this._filterableTableModel != null;
        }
        if (bl) {
            jTable.removePropertyChangeListener("model", this);
            jTable.setModel(this._filterableTableModel);
            jTable.addPropertyChangeListener("model", this);
            this.\u1e89 = true;
        }
        if (this._filterableTableModel != null) {
            this.\u1e7c = true;
            this._filterableTableModel.addFilterableTableModelListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof JTable) {
            TableModel tableModel;
            TableModel tableModel2;
            if (this.\u1e89 && (tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel = ((JTable)propertyChangeEvent.getSource()).getModel(), FilterableTableModel.class)) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.\u0101(tableModel2, tableModel) && !TableModelWrapperUtils.\u0101(tableModel, tableModel2)) {
                ((TableModelWrapperImpl)tableModel2).\u0101(null, false);
            }
            this.tableModelChanged((JTable)propertyChangeEvent.getSource());
        }
    }

    @Override
    public void filterableTableModelChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (this.isShowFilterIcon() || this.isShowFilterName() || this.isAcceptTextInput()) {
            this.repaint();
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return null;
    }

    protected IFilterableTableModel createDefaultFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel);
        }
        return new FilterableTableModel(tableModel);
    }

    public IFilterableTableModel getFilterableTableModel() {
        return this._filterableTableModel;
    }

    public void clearFilters() {
        if (this._filterableTableModel != null) {
            for (int i2 = 0; i2 < this._filterableTableModel.getColumnCount(); ++i2) {
                Filter[] filterArray = this._filterableTableModel.getFilters(i2);
                if (filterArray == null) continue;
                for (Filter filter : filterArray) {
                    if (filter instanceof SingleValueFilter) {
                        this._filterableTableModel.removeFilter(i2, filter);
                        continue;
                    }
                    if (filter instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(i2, filter);
                        continue;
                    }
                    if (filter instanceof NotFilter && ((NotFilter)filter).getFilter() instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(i2, filter);
                        continue;
                    }
                    if (filter instanceof DynamicTableFilter) {
                        this._filterableTableModel.removeFilter(i2, filter);
                        continue;
                    }
                    if (filter.getFilterFactory() == null) continue;
                    this._filterableTableModel.removeFilter(i2, filter);
                }
            }
        }
    }

    public boolean isAutoFilterEnabled() {
        return this._autoFilterEnabled;
    }

    public void setAutoFilterEnabled(boolean bl) {
        boolean bl2 = this._autoFilterEnabled;
        if (bl2 != bl) {
            this.stopEditing();
            this.setCursor(Cursor.getDefaultCursor());
            this._autoFilterEnabled = bl;
            JTable jTable = this.getTable();
            if (!this.\u1e7c && jTable != null) {
                String string = TableUtils.getTablePreferenceByName(jTable);
                this.tableModelChanged(jTable);
                TableUtils.setTablePreferenceByName(jTable, string);
            }
            this.\u02e3();
            this.firePropertyChange(PROPERTY_AUTO_FILTER_ENABLED, bl2, this._autoFilterEnabled);
        }
    }

    private void \u02e3() {
        this.removeCellDecorator(this.getSortableTableHeaderCellDecorator());
        if (!this.isUseNativeHeaderRenderer()) {
            this.cancelEditing();
            this.setDefaultRenderer(this.createDefaultRenderer());
            this.setDefaultEditor(this.createDefaultEditor());
            this.updateUI();
        } else {
            this.invalidate();
            this.repaint();
        }
        if ((this.\u1e85 || !this.isAutoFilterEnabled()) && this.isShowSortArrow() && this.getDefaultEditor() == null) {
            this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
        }
    }

    public boolean isShowFilterName() {
        return this.\u1e80;
    }

    public void setShowFilterName(boolean bl) {
        boolean bl2 = this.\u1e80;
        if (bl2 != bl) {
            this.\u1e80 = bl;
            this.\u02e3();
        }
    }

    public boolean isShowFilterNameAsToolTip() {
        return this.\u1e88;
    }

    public void setShowFilterNameAsToolTip(boolean bl) {
        boolean bl2 = this.\u1e88;
        if (bl2 != bl) {
            this.\u1e88 = bl;
            this.\u02e3();
        }
    }

    public boolean isShowFilterIcon() {
        return this.\u1e7e;
    }

    public void setShowFilterIcon(boolean bl) {
        boolean bl2 = this.\u1e7e;
        if (bl2 != bl) {
            this.\u1e7e = bl;
            this.\u02e3();
        }
    }

    @Override
    public void setShowSortArrow(boolean bl) {
        boolean bl2 = this.isShowSortArrow();
        super.setShowSortArrow(bl);
        if (bl2 != bl) {
            this.\u02e3();
        }
    }

    public boolean isAllowMultipleValues(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return this.isAllowMultipleValues();
        }
        return this.isAllowMultipleValues() && this._filterableTableModel != null && (this.getTable() == null || this._filterableTableModel.isAllowMultipleValues(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel)));
    }

    public boolean isAllowMultipleValues() {
        return this.\u1e82;
    }

    public void setAllowMultipleValues(boolean bl) {
        boolean bl2 = this.\u1e82;
        if (bl2 != bl) {
            this.\u1e82 = bl;
            IFilterableTableModel iFilterableTableModel = this.getFilterableTableModel();
            if (iFilterableTableModel != null) {
                iFilterableTableModel.clearFilters();
                if (iFilterableTableModel.isFiltersApplied()) {
                    iFilterableTableModel.setFiltersApplied(true);
                }
            }
            this.\u02e3();
        }
    }

    private boolean \u0150(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return !this.isAllowMultipleValues();
        }
        return this._filterableTableModel != null && (this.getTable() == null || this._filterableTableModel.isAllowCustomFilter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel)));
    }

    public boolean isPreferSelectedValues() {
        return this.\u1e84;
    }

    public void setPreferSelectedValues(boolean bl) {
        this.\u1e84 = bl;
    }

    @Override
    protected boolean isAutoRequestFocus() {
        return false;
    }

    protected IFilterableTableModel getFilterableTableModel(AutoFilterBox autoFilterBox) {
        return this.getFilterableTableModel();
    }

    public boolean isAcceptTextInput() {
        return this.\u1e87 && !this.isUseNativeHeaderRenderer();
    }

    public void setAcceptTextInput(boolean bl) {
        if (this.\u1e87 != bl) {
            boolean bl2 = this.\u1e87;
            this.\u1e87 = bl;
            if (this.isEditing()) {
                this.stopEditing();
            }
            this.\u02e3();
            this.firePropertyChange(PROPERTY_ACCEPT_TEXT_INPUT, bl2, this.\u1e87);
        }
    }

    public boolean isUseNativeHeaderRenderer() {
        return this.\u1e85 && !(this.getDefaultRenderer() instanceof AutoFilterTableHeaderRenderer) && !(this.getDefaultEditor() instanceof AutoFilterTableHeaderEditor);
    }

    public void setUseNativeHeaderRenderer(boolean bl) {
        if (this.\u1e85 != bl) {
            boolean bl2 = this.\u1e85;
            this.\u1e85 = bl;
            if (this.isEditing()) {
                this.stopEditing();
            }
            this.\u02e3();
            this.firePropertyChange(PROPERTY_USE_NATIVE_CELL_RENDERER, bl2, this.\u1e85);
        }
    }

    @Override
    public boolean isRolloverEnabled() {
        return super.isRolloverEnabled() && (!this.isAutoFilterEnabled() || !this.isUseNativeHeaderRenderer());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        Point point;
        int n2;
        if (this.isShowFilterNameAsToolTip() && (n2 = this.columnAtPoint(point = mouseEvent.getPoint())) >= 0 && n2 < this.getColumnModel().getColumnCount() && (string = this.getFormattedColumnName(n2)) != null) {
            return string;
        }
        return super.getToolTipText(mouseEvent);
    }

    public String getFormattedColumnName(int n2) {
        if (this.getTable() == null || n2 < 0 || n2 >= this.getTable().getColumnModel().getColumnCount()) {
            return "";
        }
        Object object = this.table.getColumnModel().getColumn(n2).getHeaderValue();
        if (this._filterableTableModel == null) {
            return null;
        }
        int n3 = this.getTable().convertColumnIndexToModel(n2);
        int n4 = TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), n3, this._filterableTableModel);
        Filter[] filterArray = this._filterableTableModel.getFilters(n4);
        if (filterArray == null || filterArray.length == 0) {
            return null;
        }
        String string = object != null && !(object instanceof Icon) ? "" + object : "";
        StringConverter stringConverter = this.\u014c(n2);
        string = stringConverter != null ? stringConverter.convert(string) : string;
        return this.formatColumnTitle(n3, string, filterArray);
    }

    protected String formatColumnTitle(int n2, String string, Filter[] filterArray) {
        if (this.getTable() == null) {
            return string;
        }
        AutoFilterTableHeaderAdapter.FilterTitleFormatter filterTitleFormatter = this.\u014e(this.getTable().convertColumnIndexToView(n2));
        if (filterTitleFormatter != null) {
            return filterTitleFormatter.formatColumnTitle(string, filterArray);
        }
        if (filterArray == null || filterArray.length == 0) {
            return string;
        }
        if (filterArray[0] instanceof QuickTableFilterField.FieldTableFilter) {
            return string + ": " + ((QuickTableFilterField.FieldTableFilter)filterArray[0]).getSearchingText();
        }
        if (filterArray[0] instanceof NotFilter && ((NotFilter)filterArray[0]).getFilter() instanceof MultipleValuesFilter) {
            return string + ": ~" + ((NotFilter)filterArray[0]).getFilter().getName();
        }
        return string + ": " + filterArray[0].getName();
    }

    protected ImageIcon getFilterIcon(int n2, boolean bl, boolean bl2) {
        return IconsFactory.getImageIcon(AutoFilterTableHeader.class, bl ? (bl2 ? "icons/filterYes_over.png" : "icons/filterNo_over.png") : (bl2 ? "icons/filterYes.png" : "icons/filterNo.png"));
    }

    private StringConverter \u014c(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getTitleConverter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel));
    }

    private AutoFilterTableHeaderAdapter.FilterTitleFormatter \u014e(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getFilterTitleFormatter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel));
    }

    private ListCellRenderer \u014d(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getListCellRenderer(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel));
    }

    private boolean \u014f(int n2) {
        if (n2 < 0 || this.getColumnModel() == null || n2 >= this.getColumnModel().getColumnCount()) {
            return false;
        }
        return this._filterableTableModel != null && this.getTable() != null && this._filterableTableModel.isUseTableCellRenderer(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n2), this._filterableTableModel));
    }

    public void adjustPopupDialogBounds(JDialog jDialog, int n2) {
        jDialog.setLocationRelativeTo(this);
        jDialog.pack();
        Rectangle rectangle = jDialog.getBounds();
        int n3 = n2 >= 0 ? n2 : -n2 + -2;
        Point point = this.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getParent());
        Rectangle rectangle2 = this.getHeaderRect(n3);
        int n4 = rectangle2.x + point.x - (rectangle.width - rectangle2.width) / 2;
        int n5 = Math.max(point.y + this.getHeight() + 5, rectangle.y);
        jDialog.setBounds(new Rectangle(n4, n5, rectangle.width, rectangle.height));
    }

    public void adjustPopupPanelSize(JidePopup jidePopup, PopupPanel popupPanel, int n2) {
        if (popupPanel.isStretchToFit() && popupPanel.getActualPreferredSize().width != this.getHeaderRect((int)n2).width) {
            Insets insets;
            Border border = jidePopup.getPopupBorder();
            int n3 = 0;
            if (border != null && (insets = border.getBorderInsets(popupPanel)) != null) {
                n3 = insets.left + insets.right;
            }
            int n4 = Math.max(popupPanel.getActualPreferredSize().width, this.getHeaderRect((int)n2).width - n3);
            popupPanel.setPreferredSize(new Dimension(n4, popupPanel.getPreferredSize().height));
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(AutoFilterTableHeader.class.getName(), 4);
        }
    }
}

